/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.coldlib;

import net.orbyfied.coldlib.ColdLib;
import net.orbyfied.coldlib.util.Container;
import net.orbyfied.j8.util.logging.EventLog;
import net.orbyfied.j8.util.logging.EventLogs;

public abstract class ColdLibProvider {
    private static final Container<ColdLibProvider> providerContainer = Container.futureImmutable();
    protected ColdLib lib;
    protected EventLogs logGroup = new EventLogs();
    protected EventLog log;

    public static <P extends ColdLibProvider> P setInstance(P provider) {
        if (providerContainer.isSet()) {
            throw new UnsupportedOperationException("A provider instance is already set");
        }
        providerContainer.set(provider);
        return provider;
    }

    public static ColdLibProvider get() {
        return providerContainer.get();
    }

    public static ColdLib getLibrary() {
        ColdLibProvider provider = ColdLibProvider.get();
        if (provider == null) {
            throw new IllegalStateException("No ColdLib provider set");
        }
        return provider.instance();
    }

    protected void init() {
        this.lib = new ColdLib(this);
        this.load();
        this.log = this.logGroup.getOrCreate("ColdLib");
    }

    public ColdLib instance() {
        return this.lib;
    }

    public EventLog getLog() {
        return this.log;
    }

    public EventLogs getLogGroup() {
        return this.logGroup;
    }

    protected void load() {
    }

    protected void enable() {
    }

    protected void unload() {
    }
}

