/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.coldlib.util;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import net.orbyfied.coldlib.util.Throwables;
import net.orbyfied.j8.util.ReflectionUtil;

public interface Container<V> {
    public static <V> Container<V> finalImmutable(final V value) {
        return new Container<V>(){

            @Override
            public V get() {
                return value;
            }

            @Override
            public boolean isSet() {
                return true;
            }

            @Override
            public Container<V> set(V val) {
                throw new UnsupportedOperationException("Container is immutable");
            }

            @Override
            public Mutability mutability() {
                return Mutability.UNSUPPORTED;
            }
        };
    }

    public static <V> Container<V> futureImmutable() {
        return new Container<V>(){
            V value;
            boolean set;

            @Override
            public V get() {
                return this.value;
            }

            @Override
            public boolean isSet() {
                return this.set;
            }

            @Override
            public Container<V> set(V val) {
                if (this.set) {
                    throw new UnsupportedOperationException("This container already has a value set");
                }
                this.value = val;
                this.set = true;
                return this;
            }

            @Override
            public Mutability mutability() {
                return this.set ? Mutability.UNSUPPORTED : Mutability.MODIFY;
            }
        };
    }

    public static <V> Container<V> mutable(final V val) {
        return new Container<V>(){
            V value;
            {
                this.value = val;
            }

            @Override
            public V get() {
                return this.value;
            }

            @Override
            public boolean isSet() {
                return true;
            }

            @Override
            public Container<V> set(V val2) {
                this.value = val2;
                return this;
            }

            @Override
            public Mutability mutability() {
                return Mutability.MODIFY;
            }
        };
    }

    public static <V> Container<V> mutable() {
        return Container.mutable(null);
    }

    public static <V> Container<V> asProtected(final Container<V> container, final Predicate<StackTraceElement> predicate, final boolean protectNew) {
        return new Container<V>(){

            private void checkAccess() {
                StackTraceElement element = ReflectionUtil.getCallerFrame((int)2, element1 -> !element1.getClassName().startsWith("net.orbyfied.coldlib"));
                if (!predicate.test(element)) {
                    throw new SecurityException("Access to container denied");
                }
            }

            @Override
            public V get() {
                this.checkAccess();
                return container.get();
            }

            @Override
            public boolean isSet() {
                this.checkAccess();
                return container.isSet();
            }

            @Override
            public Container<V> set(V val) {
                this.checkAccess();
                Container ret = container.set(val);
                if (ret != container && protectNew) {
                    return Container.asProtected(ret, predicate, true);
                }
                return this;
            }

            @Override
            public Mutability mutability() {
                this.checkAccess();
                return container.mutability();
            }
        };
    }

    public static <V> Container<V> forking(final Container<V> container, final BiFunction<Container<V>, V, Container<V>> forkConstructor) {
        return new Container<V>(){

            @Override
            public V get() {
                return container.get();
            }

            @Override
            public boolean isSet() {
                return container.isSet();
            }

            @Override
            public Container<V> set(V val) {
                return (Container)forkConstructor.apply(container, val);
            }

            @Override
            public Mutability mutability() {
                return Mutability.FORK;
            }
        };
    }

    public static <V> Container<V> awaitable(final Container<V> container) {
        return new Container<V>(){
            final List<CompletableFuture<V>> futures = new ArrayList();

            @Override
            public V get() {
                return container.get();
            }

            @Override
            public boolean isSet() {
                return container.isSet();
            }

            @Override
            public Container<V> set(V val) {
                try {
                    container.set(val);
                    for (CompletableFuture future : this.futures) {
                        future.complete(val);
                    }
                }
                catch (Throwable t) {
                    for (CompletableFuture future : this.futures) {
                        future.completeExceptionally(t);
                    }
                    Throwables.sneakyThrow(t);
                }
                return this;
            }

            @Override
            public Mutability mutability() {
                return container.mutability();
            }

            @Override
            public boolean canAwait() {
                return true;
            }

            @Override
            public CompletableFuture<V> await(boolean listen) {
                CompletableFuture future = new CompletableFuture();
                this.futures.add(future);
                return future;
            }
        };
    }

    public V get();

    default public <T> T getAs(Class<T> tClass) {
        V val = this.get();
        return (T)val;
    }

    public boolean isSet();

    public Container<V> set(V var1);

    public Mutability mutability();

    default public boolean canAwait() {
        return false;
    }

    default public CompletableFuture<V> await(boolean listen) {
        if (!listen && this.isSet()) {
            return CompletableFuture.completedFuture(this.get());
        }
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<V> await() {
        return this.await(false);
    }

    default public Container<V> cloneMutable() {
        return Container.mutable(this.get());
    }

    default public Container<V> asProtected(Predicate<StackTraceElement> predicate, boolean newProtected) {
        return Container.asProtected(this, predicate, newProtected);
    }

    default public Container<V> asForking(BiFunction<Container<V>, V, Container<V>> forkConstructor) {
        return Container.forking(this, forkConstructor);
    }

    public static enum Mutability {
        UNSUPPORTED(true, false),
        FORK(false, false),
        MODIFY(false, true);

        final boolean throwsError;
        final boolean modifiesInstance;

        private Mutability(boolean throwsError, boolean modifiesInstance) {
            this.throwsError = throwsError;
            this.modifiesInstance = modifiesInstance;
        }

        public boolean throwsError() {
            return this.throwsError;
        }

        public boolean modifiesInstance() {
            return this.modifiesInstance;
        }
    }
}

