/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.coldlib;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.orbyfied.coldlib.ColdLibProvider;
import net.orbyfied.coldlib.ColdLibService;
import net.orbyfied.coldlib.util.Container;

public class ColdLib {
    final ColdLibProvider provider;
    final Map<Class<?>, Map<String, Container<ColdLibService>>> serviceMap = new HashMap();
    final List<ColdLibService> services = new ArrayList<ColdLibService>();

    public static ColdLib get() {
        return ColdLibProvider.getLibrary();
    }

    protected ColdLib(ColdLibProvider provider) {
        this.provider = provider;
    }

    public ColdLibProvider provider() {
        return this.provider;
    }

    public List<ColdLibService> getServices() {
        return Collections.unmodifiableList(this.services);
    }

    public <S extends ColdLibService> Container<S> referenceService(Class<S> sClass, String instanceName) {
        Objects.requireNonNull(sClass, "Service class can not be null");
        Map map = this.serviceMap.computeIfAbsent(sClass, __ -> new HashMap());
        return map.computeIfAbsent(instanceName, __ -> Container.awaitable(Container.futureImmutable()));
    }

    public <S extends ColdLibService> Container<S> referenceService(Class<S> sClass) {
        return this.referenceService(sClass, null);
    }

    public <S extends ColdLibService> S getService(Class<S> sClass, String instanceName) {
        return (S)((ColdLibService)this.referenceService(sClass, instanceName).get());
    }

    public <S extends ColdLibService> S getService(Class<S> sClass) {
        return this.getService(sClass, null);
    }

    public <S extends ColdLibService> S withService(S service) {
        Objects.requireNonNull(service, "Service can not be null");
        this.referenceService(service.getClass(), service.getInstanceName()).set(service);
        return service;
    }

    public <S extends ColdLibService> S createService(Class<S> sClass, String instanceName) {
        try {
            Constructor<S> constructor = sClass.getDeclaredConstructor(ColdLib.class, String.class);
            ColdLibService service = (ColdLibService)constructor.newInstance(this, instanceName);
            this.withService(service);
            return (S)service;
        }
        catch (Exception e) {
            this.provider.getLog().newErr("create_service", "Failed to create service from " + sClass + " with instance name '" + instanceName + "'", new Object[0]).withError((Throwable)e).push();
            return null;
        }
    }
}

