/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.j8.util.resource;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import net.orbyfied.j8.util.resource.ClassResourceResolver;
import net.orbyfied.j8.util.resource.ResourceResolver;

public interface ResourceHandle {
    public ResourceResolver getResolver();

    public URL getUrl();

    default public boolean exists() {
        return this.getResolver().existsSafe(this.getUrl());
    }

    default public boolean isDirectory() {
        return this.getResolver().isDirectorySafe(this.getUrl());
    }

    default public InputStream in() throws IOException {
        return this.getUrl().openStream();
    }

    default public OutputStream out() throws IOException {
        return this.getResolver().openOutputStream(this.getUrl());
    }

    public static ResourceHandle ofModuleResource(String path) {
        try {
            throw new Exception();
        }
        catch (Exception e) {
            StackTraceElement[] elem = e.getStackTrace();
            try {
                Class<?> klass = Class.forName(elem[1].getClassName());
                return ResourceHandle.ofModuleResource(klass, path);
            }
            catch (ClassNotFoundException e2) {
                throw new RuntimeException(e2);
            }
        }
    }

    public static ResourceHandle ofModuleResource(Class<?> klass, final String path) {
        final ClassResourceResolver res = new ClassResourceResolver(klass);
        return new ResourceHandle(){
            private final URL url;
            {
                this.url = res.getResourceFromPath(path);
            }

            @Override
            public ResourceResolver getResolver() {
                return res;
            }

            @Override
            public URL getUrl() {
                return this.url;
            }
        };
    }

    public static ResourceHandle ofFile(String path) {
        URL url;
        try {
            url = ResourceResolver.FILE.getResourceFromPath(path);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return new ResourceHandle(){

            @Override
            public ResourceResolver getResolver() {
                return ResourceResolver.FILE;
            }

            @Override
            public URL getUrl() {
                return url;
            }
        };
    }
}

