/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.j8.util.reflect;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.function.Consumer;
import net.orbyfied.j8.util.functional.ThrowableRunnable;
import net.orbyfied.j8.util.functional.ThrowableSupplier;
import net.orbyfied.j8.util.reflect.ErrorInReflectionException;
import net.orbyfied.j8.util.reflect.ReflectorFail;

public class Reflector {
    public static final Consumer<ReflectorFail> FAIL_HANDLER_RETHROW = fail -> {
        if (fail.throwables.length == 0) {
            throw new ErrorInReflectionException(fail.message);
        }
        throw new ErrorInReflectionException(fail.message, fail.throwables[0]);
    };
    static final DateFormat DATE_FORMAT = new SimpleDateFormat("hh:mm:ss.SSSS");
    public static final Consumer<ReflectorFail> FAIL_HANDLER_PRINT = fail -> {
        System.err.println("(" + DATE_FORMAT.format(new Date()) + ") REFLECT FAIL '" + fail.reflector.name + "'" + (String)(fail.message != null ? " - " + fail.message : ""));
        for (Throwable t : fail.throwables) {
            t.printStackTrace();
        }
    };
    final String name;
    Consumer<ReflectorFail> handler = FAIL_HANDLER_RETHROW;
    MethodHandles.Lookup mhLookup = MethodHandles.lookup();

    public Reflector(String name) {
        this.name = name;
    }

    public void fail(ReflectorFail fail) {
        this.handler.accept(fail);
    }

    private <T> T doSafe(String message, ThrowableSupplier<T> supplier) {
        try {
            return supplier.get();
        }
        catch (Throwable t) {
            this.fail(new ReflectorFail(this).withThrowables(t).withMessage("Error: " + message));
            return null;
        }
    }

    private void doSafe(String message, ThrowableRunnable runnable) {
        try {
            runnable.run();
        }
        catch (Throwable t) {
            this.fail(new ReflectorFail(this).withThrowables(t).withMessage("Error: " + message));
        }
    }

    public <T extends AccessibleObject> T accessible(T t) {
        return (T)this.doSafe("set accessible", () -> {
            t.setAccessible(true);
            return t;
        });
    }

    public Class<?> classForName(String name) {
        return this.doSafe("reflect class for name '" + name + "'", () -> Class.forName(name));
    }

    public Class<?> classForName(String name, boolean init, ClassLoader loader) {
        return this.doSafe("reflect class for name '" + name + "'", () -> Class.forName(name, init, loader));
    }

    public MethodHandle virtualMethodHandle(Class<?> klass, String name, Class<?>[] types) {
        return this.doSafe("get method handle '" + name + "' on '" + klass.getName() + "'", () -> this.mhLookup.findVirtual(klass, name, MethodType.methodType(Object.class, types)));
    }

    public MethodHandle staticMethodHandle(Class<?> klass, String name, Class<?>[] types) {
        return this.doSafe("get method handle '" + name + "' on '" + klass.getName() + "'", () -> this.mhLookup.findStatic(klass, name, MethodType.methodType(Object.class, types)));
    }

    public Method reflectMethod(Class<?> klass, String name, Class<?>[] types) {
        return this.doSafe("reflect method '" + name + "' from '" + klass.getName() + "'", () -> klass.getMethod(name, types));
    }

    public Method reflectDeclaredMethod(Class<?> klass, String name, Class<?>[] types) {
        return this.doSafe("reflect method '" + name + "' from '" + klass.getName() + "'", () -> klass.getDeclaredMethod(name, types));
    }

    public Method reflectMethodAccessible(Class<?> klass, String name, Class<?>[] types) {
        return this.accessible(this.reflectMethod(klass, name, types));
    }

    public Method reflectDeclaredMethodAccessible(Class<?> klass, String name, Class<?>[] types) {
        return this.accessible(this.reflectDeclaredMethod(klass, name, types));
    }

    public <T> Constructor<T> reflectConstructor(Class<?> klass, Class<?>[] types) {
        return this.doSafe("reflect constructor for '" + klass.getName() + "'", () -> klass.getConstructor(types));
    }

    public <T> Constructor<T> reflectDeclaredConstructor(Class<?> klass, Class<?>[] types) {
        return this.doSafe("reflect constructor for '" + klass.getName() + "'", () -> klass.getConstructor(types));
    }

    public Field reflectField(Class<?> klass, String name) {
        return this.doSafe("reflect method '" + name + "' from '" + klass.getName() + "'", () -> klass.getField(name));
    }

    public Field reflectDeclaredField(Class<?> klass, String name) {
        return this.doSafe("reflect method '" + name + "' from '" + klass.getName() + "'", () -> klass.getDeclaredField(name));
    }

    public Field reflectFieldAccessible(Class<?> klass, String name) {
        return this.accessible(this.reflectField(klass, name));
    }

    public Field reflectDeclaredFieldAccessible(Class<?> klass, String name) {
        return this.accessible(this.reflectDeclaredField(klass, name));
    }

    public <T> T reflectGetField(Field field, Object on) {
        return (T)this.doSafe("get field '" + field + "'", () -> field.get(on));
    }

    public void reflectSetField(Field field, Object on, Object val) {
        this.doSafe("set field '" + field + "'", () -> field.set(on, val));
    }

    public <T> T reflectInvoke(Method method, Object on, Object ... args) {
        return (T)this.doSafe("invoke method '" + method + "'", () -> method.invoke(on, args));
    }

    public <T> T methodInvoke(MethodHandle method, Object on, Object ... args) {
        return (T)this.doSafe("invoke method '" + method + "'", () -> method.invoke(on, args));
    }
}

