/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.j8.util.logging;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import net.orbyfied.j8.util.logging.LogLevel;
import net.orbyfied.j8.util.logging.LogText;
import net.orbyfied.j8.util.logging.Logger;

public class LogRecord {
    final Logger logger;
    final LogLevel level;
    String stage;
    final List<Object> message;
    final List<Object> misc = new ArrayList<Object>();
    final LogText string;
    final ConcurrentHashMap<String, Object> carry = new ConcurrentHashMap();
    final AtomicBoolean cancelled = new AtomicBoolean(false);
    private AtomicBoolean cancelled1;

    LogRecord(Logger logger, LogLevel level, String stage, LogText string, Object[] message) {
        this.logger = logger;
        this.level = level;
        this.stage = stage;
        this.string = string;
        this.message = new ArrayList<Object>(Arrays.asList(message));
    }

    public LogRecord withMisc(Object t) {
        this.misc.add(t);
        return this;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public LogLevel getLevel() {
        return this.level;
    }

    public LogText getText() {
        return this.string;
    }

    public List<Object> getMessage() {
        return this.message;
    }

    public boolean isCancelled() {
        return this.cancelled.get();
    }

    public LogRecord setCancelled(boolean b) {
        this.cancelled.set(b);
        return this;
    }

    public <T> Map<String, T> carried() {
        return this.carry;
    }

    public <T> void carry(String key, T value) {
        this.carry.put(key, value);
    }

    public <T> T carried(String key) {
        return (T)this.carry.get(key);
    }

    public <T> T uncarry(String key) {
        return (T)this.carry.remove(key);
    }

    public void uncarry(Object o) {
        this.carry.forEach((key, value) -> {
            if (value == o) {
                this.carry.remove(key);
            }
        });
    }
}

