/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.j8.util.logging;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import net.orbyfied.j8.util.logging.LogHandler;
import net.orbyfied.j8.util.logging.LogRecord;

public class LogPipeline {
    ArrayList<LogHandler> handlers = new ArrayList();
    HashMap<String, LogHandler> named = new HashMap();
    Executor asyncExecutor = Executors.newSingleThreadExecutor();

    private void deployAsync(LogHandler h, LogRecord record) {
        if (this.asyncExecutor != null) {
            this.asyncExecutor.execute(() -> h.handle(this, record));
        }
    }

    public void push(LogRecord record) {
        if (this.count() == 0) {
            return;
        }
        int l = this.named.size();
        for (int i = 0; i < l; ++i) {
            LogHandler h = this.handlers.get(i);
            if (!h.async) {
                h.handle(this, record);
                continue;
            }
            this.deployAsync(h, record);
        }
    }

    public int count() {
        return this.named.size();
    }

    public List<LogHandler> all() {
        return Collections.unmodifiableList(this.handlers);
    }

    public LogHandler get(int i) {
        if (i < 0 || i >= this.named.size()) {
            return null;
        }
        return this.handlers.get(i);
    }

    public LogHandler get(String name) {
        return this.named.get(name);
    }

    public LogPipeline remove(String name) {
        return this.remove(this.named.get(name));
    }

    public LogPipeline remove(LogHandler handler) {
        if (handler == null) {
            return this;
        }
        if (handler.name != null) {
            this.named.remove(handler.name);
        }
        this.handlers.remove(handler);
        return this;
    }

    public LogPipeline addLast(LogHandler handler) {
        LogHandler.Priority priority;
        if (handler.name != null) {
            this.named.put(handler.name, handler);
        }
        if ((priority = handler.priority()) != null && priority != LogHandler.Priority.NONE) {
            int ord = priority.ordinal();
            int i = (int)(handler.priority().getPositionApproximation() * (float)this.handlers.size());
            boolean in = false;
            while (i > 0 && i < this.handlers.size()) {
                LogHandler h = this.handlers.get(i);
                if (h.priority == null || h.priority == LogHandler.Priority.NONE) {
                    ++i;
                    continue;
                }
                int ho = h.priority.ordinal();
                if (!in) {
                    if (ho < ord) {
                        ++i;
                        continue;
                    }
                    if (ho > ord) {
                        --i;
                        continue;
                    }
                    in = true;
                    continue;
                }
                if (ho != ord) break;
                ++i;
            }
            this.handlers.add(i, handler);
        } else {
            this.handlers.add(handler);
        }
        return this;
    }

    public LogPipeline addFirst(LogHandler handler) {
        LogHandler.Priority priority;
        if (handler.name != null) {
            this.named.put(handler.name, handler);
        }
        if ((priority = handler.priority()) != null && priority != LogHandler.Priority.NONE) {
            int ord = priority.ordinal();
            int i = (int)(handler.priority().getPositionApproximation() * (float)this.handlers.size());
            boolean in = false;
            while (i > 0 && i < this.handlers.size()) {
                LogHandler h = this.handlers.get(i);
                if (h.priority == null || h.priority == LogHandler.Priority.NONE) {
                    --i;
                    continue;
                }
                int ho = h.priority.ordinal();
                if (!in) {
                    if (ho < ord) {
                        ++i;
                        continue;
                    }
                    if (ho > ord) {
                        --i;
                        continue;
                    }
                    in = true;
                    continue;
                }
                if (ho != ord) break;
                --i;
            }
            this.handlers.add(i, handler);
        } else {
            this.handlers.add(0, handler);
        }
        return this;
    }
}

