/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.j8.util.builder;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.orbyfied.j8.util.builder.Properties;
import net.orbyfied.j8.util.builder.Property;

public class Values {
    final Properties properties;
    final Map<Property<?>, Object> values = new HashMap();
    final Map<String, Map<Property<?>, Object>> marks = new HashMap();

    public Values(Properties properties) {
        this.properties = properties;
    }

    public Properties properties() {
        return this.properties;
    }

    public <T> Property<T> property(String name) {
        return this.properties.get(name);
    }

    public <T> T get(Property<T> property) {
        return (T)this.values.get(property);
    }

    public <T> T get(String name) {
        return (T)this.values.get(this.property(name));
    }

    public <T> Values set(Property<?> property, T val) {
        Class<?> tClass;
        if (val != null && !property.type.isAssignableFrom(tClass = val.getClass())) {
            throw new ClassCastException("Cannot apply value of type " + tClass.getName() + " to property of type " + property.type.getName());
        }
        this.values.put(property, val);
        return this;
    }

    public <T> Values set(String name, T val) {
        return this.set(this.property(name), val);
    }

    public Values unset(Property<?> property) {
        this.values.remove(property);
        return this;
    }

    public Values unset(String name) {
        return this.unset(this.property(name));
    }

    private Map<Property<?>, Object> utilGetMark(String space) {
        return this.marks.computeIfAbsent(space, key -> new HashMap());
    }

    private Values utilUseMark(String space, Consumer<Map<Property<?>, Object>> consumer) {
        consumer.accept(this.utilGetMark(space));
        return this;
    }

    public Values mark(String space, Property<?> property, Object value) {
        return this.utilUseMark(space, map -> map.put(property, value));
    }

    public <T> T marked(String space, Property<?> property) {
        return (T)this.utilGetMark(space).get(property);
    }

    public Values unmark(String space, Property<?> property) {
        return this.utilUseMark(space, map -> map.remove(property));
    }
}

