/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.j8.util.builder;

import java.util.Objects;
import net.orbyfied.j8.util.builder.Builder;

public class Property<T> {
    protected final Class<T> type;
    protected String name;
    protected boolean isDefaulted;
    protected T defaultValue;
    protected boolean isRequired;

    public static <T> Property<T> of(Class<T> t) {
        return new Property<T>(t);
    }

    public static Property<String> ofString() {
        return Property.of(String.class);
    }

    public static Property<Boolean> ofBool() {
        return Property.of(Boolean.class);
    }

    public static Property<Byte> ofByte() {
        return Property.of(Byte.class);
    }

    public static Property<Character> ofChar() {
        return Property.of(Character.class);
    }

    public static Property<Short> ofShort() {
        return Property.of(Short.class);
    }

    public static Property<Integer> ofInt() {
        return Property.of(Integer.class);
    }

    public static Property<Long> ofLong() {
        return Property.of(Long.class);
    }

    public static Property<Float> ofFloat() {
        return Property.of(Float.class);
    }

    public static Property<Double> ofDouble() {
        return Property.of(Double.class);
    }

    Property(Class<T> type) {
        Objects.requireNonNull(type, "type cannot be null");
        this.type = type;
    }

    Property(Builder<Property<?>, ?> builder) {
        this.type = null;
    }

    public Class<T> type() {
        return this.type;
    }

    public String named() {
        return this.name;
    }

    public boolean required() {
        return this.isRequired;
    }

    public boolean defaulted() {
        return this.isDefaulted;
    }

    public T defaultValue() {
        return this.defaultValue;
    }

    public Property<T> named(String name) {
        this.name = name;
        return this;
    }

    public Property<T> defaulted(T val) {
        this.isDefaulted = true;
        this.defaultValue = val;
        return this;
    }

    public Property<T> require(boolean bool) {
        this.isRequired = bool;
        return this;
    }
}

