/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.j8.util.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.orbyfied.j8.util.builder.Builder;
import net.orbyfied.j8.util.builder.Constructor;
import net.orbyfied.j8.util.builder.Properties;
import net.orbyfied.j8.util.builder.Property;

public class BuilderTemplate<T, B extends Builder> {
    private final Class<T> type;
    private final Properties params = new Properties("%");
    private final List<Constructor<T, B>> constructors = new ArrayList<Constructor<T, B>>();

    public BuilderTemplate(Class<T> type) {
        this.type = type;
    }

    public Constructor<T, B> findConstructor(B builder) {
        Constructor<T, B> constructor = null;
        for (Constructor<T, B> c : this.constructors) {
            if (!c.test(builder)) continue;
            constructor = c;
            break;
        }
        return constructor;
    }

    public Class<T> type() {
        return this.type;
    }

    public <V> Property<V> parameter(String name) {
        return this.params.get(name);
    }

    public Properties parameters() {
        return this.params;
    }

    public BuilderTemplate<T, B> parameter(String name, Property<?> property) {
        this.params.add(name, property);
        return this;
    }

    @SafeVarargs
    public final BuilderTemplate<T, B> constructors(Constructor<T, B> ... c) {
        this.constructors.addAll(Arrays.asList(c));
        return this;
    }
}

