/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.j8.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.orbyfied.j8.util.Sequence;

public class Reader<T> {
    private int index = 0;
    private Sequence<T> str;
    private int len;
    private final Predicate<T> ALWAYS = c -> true;

    public Reader(Sequence<T> str, int index) {
        this.str = str;
        this.len = str.size();
        this.index = index;
    }

    public Reader(Sequence<T> str) {
        this(str, 0);
    }

    public int clamp(int index) {
        return Math.min(this.len - 1, Math.max(0, index));
    }

    public T peekAt(int i) {
        return this.str.at(this.clamp(i));
    }

    public T peek(int i) {
        int idx = this.index + i;
        if (idx < 0 || idx >= this.len) {
            return null;
        }
        return this.str.at(idx);
    }

    public T next() {
        if (++this.index >= this.len || this.index < 0) {
            return null;
        }
        return this.str.at(this.index);
    }

    public T next(int a) {
        if ((this.index += a) >= this.len || this.index < 0) {
            return null;
        }
        return this.str.at(this.index);
    }

    public T prev() {
        if (--this.index >= this.len || this.index < 0) {
            return null;
        }
        return this.str.at(this.index);
    }

    public T prev(int a) {
        if ((this.index -= a) >= this.len || this.index < 0) {
            return null;
        }
        return this.str.at(this.index);
    }

    public T current() {
        if (this.index < 0 || this.index >= this.len) {
            return null;
        }
        return this.str.at(this.index);
    }

    public String collect() {
        return this.collect(this.ALWAYS, null);
    }

    public String collect(Predicate<T> pred, int offEnd) {
        String str = this.collect(pred);
        this.next(offEnd);
        return str;
    }

    public String collect(Predicate<T> pred) {
        return this.collect(pred, null);
    }

    public String collect(Predicate<T> pred, Predicate<T> skip, int offEnd) {
        String str = this.collect(pred, skip);
        this.next(offEnd);
        return str;
    }

    public String collect(Predicate<T> pred, Predicate<T> skip) {
        return this.collect(pred, skip, null);
    }

    public String collect(Predicate<T> pred, Predicate<T> skip, Consumer<T> TEval) {
        T c;
        if (pred == null) {
            pred = this.ALWAYS;
        }
        StringBuilder b = new StringBuilder();
        this.prev();
        while ((c = this.next()) != null && pred.test(c)) {
            if (skip != null && skip.test(c)) continue;
            if (TEval != null) {
                TEval.accept(c);
            }
            b.append(c);
        }
        return b.toString();
    }

    public String pcollect(Predicate<T> pred) {
        return this.pcollect(pred, null);
    }

    public String pcollect(Predicate<T> pred, Predicate<T> skip) {
        T c;
        if (pred == null) {
            pred = this.ALWAYS;
        }
        StringBuilder b = new StringBuilder();
        int off = 0;
        while ((c = this.peek(off++)) != null && pred.test(c)) {
            if (skip != null && skip.test(c)) continue;
            b.append(c);
        }
        return b.toString();
    }

    public List<String> split(T ... Ts) {
        ArrayList<String> list = new ArrayList<String>(this.len / 10);
        HashSet TSet = new HashSet();
        for (T c2 : Ts) {
            TSet.add(c2);
        }
        while (this.current() != null) {
            list.add(this.collect(c -> !TSet.contains(c)));
            this.next();
        }
        return list;
    }

    public int index() {
        return this.index;
    }

    public Reader index(int i) {
        this.index = i;
        return this;
    }

    public Sequence<T> getSequence() {
        return this.str;
    }

    public Reader subForward(int from, int len) {
        Reader<T> reader = new Reader<T>(this.str, from);
        reader.len = Math.min(from + len, this.len - from);
        return reader;
    }

    public Reader subFrom(int from, int len) {
        Reader<T> reader = new Reader<T>(this.str, this.index + from);
        reader.len = Math.min(from + len, this.len - from - this.index);
        return reader;
    }

    public Reader branch() {
        return new Reader<T>(this.str, this.index);
    }
}

