/*
 * Decompiled with CFR 0.152.
 */
package net.optionfactory.undertow;

import io.undertow.Handlers;
import io.undertow.Undertow;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.servlet.Servlets;
import io.undertow.servlet.api.DeploymentManager;
import java.io.Closeable;
import javax.servlet.ServletException;
import net.optionfactory.undertow.Deployment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebServer
implements Closeable {
    public static final String ROOT_PATH = "/";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Object monitor = new Object();
    private final String listeningAddress;
    private final int listeningPort;
    private final DeploymentManager deploymentManager;
    private Undertow server;

    public WebServer(String listeningAddress, int listeningPort, Deployment deployment) {
        this.listeningAddress = listeningAddress;
        this.listeningPort = listeningPort;
        this.logger.info("Preparing Undertow for webapp deployment");
        this.deploymentManager = Servlets.defaultContainer().addDeployment(deployment.configuration());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws ServletException {
        Object object = this.monitor;
        synchronized (object) {
            if (this.server != null) {
                return;
            }
            this.deploymentManager.deploy();
            PathHandler httpHandler = Handlers.path().addPrefixPath(ROOT_PATH, this.deploymentManager.start());
            this.server = Undertow.builder().addHttpListener(this.listeningPort, this.listeningAddress).setHandler((HttpHandler)httpHandler).build();
            this.server.start();
            this.logger.info("Started Undertow, listening at {}:{}", (Object)this.listeningAddress, (Object)this.listeningPort);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            Object object = this.monitor;
            synchronized (object) {
                if (this.server == null) {
                    return;
                }
                this.logger.info("Stopping Undertow...");
                this.server.stop();
                this.server = null;
                this.deploymentManager.stop();
                this.deploymentManager.undeploy();
                this.logger.info("Stopped Undertow.");
            }
        }
        catch (ServletException exception) {
            this.logger.error("Error while shutting down web server", (Throwable)exception);
            throw new IllegalStateException(exception);
        }
    }
}

