/*
 * Decompiled with CFR 0.152.
 */
package net.optionfactory.keycloak.remoting;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.optionfactory.keycloak.remoting.BasicHeaderParameterEncoder;
import org.apache.http.NameValuePair;
import org.apache.http.entity.ContentType;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicHeaderElement;
import org.apache.http.message.BasicNameValuePair;

public class FormDataPart {
    private final List<BasicHeader> headers;
    private final Supplier<InputStream> iss;

    public FormDataPart(List<BasicHeader> headers, Supplier<InputStream> iss) {
        this.headers = headers;
        this.iss = iss;
    }

    public InputStream content() {
        return this.iss.get();
    }

    public InputStream marshalled() {
        String joinedHeaders = this.headers.stream().map(BasicHeader::toString).map(h -> h + "\r\n").collect(Collectors.joining()) + "\r\n";
        ByteArrayInputStream headersInputStream = new ByteArrayInputStream(joinedHeaders.getBytes(StandardCharsets.UTF_8));
        ByteArrayInputStream trailer = new ByteArrayInputStream("\r\n".getBytes(StandardCharsets.UTF_8));
        return new SequenceInputStream(Collections.enumeration(List.of(headersInputStream, this.iss.get(), trailer)));
    }

    public static FormDataPart json(String field, String value) {
        BasicHeaderElement cdv = new BasicHeaderElement("form-data", null, new NameValuePair[]{new BasicNameValuePair("name", BasicHeaderParameterEncoder.encode(field))});
        List<BasicHeader> headers = List.of(new BasicHeader("Content-Disposition", cdv.toString()), new BasicHeader("Content-Transfer-Encoding", "8bit"), new BasicHeader("Content-Type", ContentType.APPLICATION_JSON.toString()));
        return new FormDataPart(headers, () -> new ByteArrayInputStream(value.getBytes(StandardCharsets.UTF_8)));
    }

    public static FormDataPart field(String field, String value) {
        BasicHeaderElement cdv = new BasicHeaderElement("form-data", null, new NameValuePair[]{new BasicNameValuePair("name", BasicHeaderParameterEncoder.encode(field))});
        List<BasicHeader> headers = List.of(new BasicHeader("Content-Disposition", cdv.toString()), new BasicHeader("Content-Transfer-Encoding", "8bit"));
        return new FormDataPart(headers, () -> new ByteArrayInputStream(value.getBytes(StandardCharsets.UTF_8)));
    }

    public static FormDataPart file(String field, String filename, ContentType contentType, InputStream value) {
        BasicHeaderElement cdv = new BasicHeaderElement("form-data", null, new NameValuePair[]{new BasicNameValuePair("name", BasicHeaderParameterEncoder.encode(field)), new BasicNameValuePair("filename", BasicHeaderParameterEncoder.encode(filename))});
        List<BasicHeader> headers = List.of(new BasicHeader("Content-Disposition", cdv.toString()), new BasicHeader("Content-Transfer-Encoding", "8bit"), new BasicHeader("Content-Type", contentType.toString()));
        return new FormDataPart(headers, () -> value);
    }
}

