/*
 * Decompiled with CFR 0.152.
 */
package net.optionfactory.keycloak.provisioning.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import net.optionfactory.keycloak.provisioning.api.PageResponse;
import net.optionfactory.keycloak.provisioning.api.UserResponse;
import net.optionfactory.keycloak.provisioning.api.UsersRequest;
import net.optionfactory.keycloak.validation.RequestValidator;
import org.keycloak.connections.jpa.JpaConnectionProvider;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserProvider;
import org.keycloak.services.ServicesLogger;

public class ProvisioningEndpoints {
    private final ServicesLogger logger = ServicesLogger.LOGGER;
    private final ObjectMapper om;
    private final RequestValidator validator;
    private final KeycloakSession session;

    public ProvisioningEndpoints(ObjectMapper om, RequestValidator validator, KeycloakSession session) {
        this.om = om;
        this.validator = validator;
        this.session = session;
    }

    @PUT
    @Path(value="/users")
    @Consumes(value={"application/json"})
    public void provide(UserProvisioningRequest req) {
        this.validator.enforce((Object)req, BadRequestException::new, new Class[0]);
        RealmModel realm = this.session.getContext().getRealm();
        UserProvider users = this.session.users();
        UserModel user = Optional.ofNullable(users.getUserById(realm, req.id)).orElseGet(() -> users.addUser(realm, req.id, req.username, true, true));
        user.setFirstName(req.firstName);
        user.setLastName(req.lastName);
        user.setEnabled(req.enabled);
        user.setEmail(req.username);
        user.setEmailVerified(req.emailVerified);
        for (Map.Entry<String, List<String>> entry : req.attributes.entrySet()) {
            user.setAttribute(entry.getKey(), entry.getValue());
        }
        for (String groupName : req.groups) {
            GroupModel group = this.session.groups().getGroupsStream(realm).filter(g -> g.getName().equals(groupName)).findFirst().orElseGet(() -> this.session.groups().createGroup(realm, groupName));
            user.joinGroup(group);
        }
    }

    @POST
    @Path(value="/users")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public PageResponse<UserResponse> users(@DefaultValue(value="0") @QueryParam(value="offset") int offset, @DefaultValue(value="0") @QueryParam(value="limit") int limit, UsersRequest request) {
        this.validator.enforce((Object)request, BadRequestException::new, new Class[0]);
        EntityManager em = ((JpaConnectionProvider)this.session.getProvider(JpaConnectionProvider.class)).getEntityManager();
        ArrayList<String> conditions = new ArrayList<String>(List.of("1=1"));
        ArrayList<Object> parameters = new ArrayList<Object>();
        Stream.of(ValueFilterSpec.of("id", request.id, String.class), ValueFilterSpec.of("username", request.username, String.class), ValueFilterSpec.of("email", request.email, String.class), ValueFilterSpec.of("first_name", request.firstName, String.class), ValueFilterSpec.of("last_name", request.lastName, String.class), ValueFilterSpec.of("enabled", request.enabled, Boolean.TYPE), ValueFilterSpec.of("email_verified", request.emailVerified, Boolean.TYPE), ValueFilterSpec.of("created_timestamp", request.createdTimestamp, Long.TYPE)).filter(fs -> fs.filter != null).forEach(fs -> {
            String rop = fs.filter.op == UsersRequest.FilterOp.NEQ || fs.filter.op == UsersRequest.FilterOp.NIN ? "not" : "";
            String rendered = fs.filter.op == UsersRequest.FilterOp.IN || fs.filter.op == UsersRequest.FilterOp.NIN ? String.format("%s position(%s in %s) > 0", rop, ProvisioningEndpoints.placeholder(parameters), fs.field) : String.format("%s %s = %s", rop, ProvisioningEndpoints.placeholder(parameters), fs.field);
            conditions.add(rendered);
            if (fs.type == Boolean.TYPE) {
                parameters.add(Boolean.parseBoolean(fs.filter.value));
            } else if (fs.type == Long.TYPE) {
                parameters.add(Long.parseLong(fs.filter.value));
            } else {
                parameters.add(fs.filter.value);
            }
        });
        for (UsersRequest.ValueFilter gf : request.groups) {
            conditions.add(String.format("%s jsonb_exists(groups,%s)", gf.op == UsersRequest.FilterOp.NIN || gf.op == UsersRequest.FilterOp.NEQ ? "not" : "", ProvisioningEndpoints.placeholder(parameters)));
            parameters.add(gf.value);
        }
        for (UsersRequest.KeyValueFilter af : request.attributes) {
            if (af.op == UsersRequest.FilterOp.EQ || af.op == UsersRequest.FilterOp.NEQ) {
                conditions.add(String.format("%s %s = jsonb_object_field_text(attributes, %s)", af.op == UsersRequest.FilterOp.NIN || af.op == UsersRequest.FilterOp.NEQ ? "not" : "", ProvisioningEndpoints.placeholder(parameters), ProvisioningEndpoints.placeholder(parameters)));
                parameters.add(af.value);
                parameters.add(af.key);
                continue;
            }
            conditions.add(String.format("%s position(%s in jsonb_object_field_text(attributes, %s)) > 0", af.op == UsersRequest.FilterOp.NIN || af.op == UsersRequest.FilterOp.NEQ ? "not" : "", ProvisioningEndpoints.placeholder(parameters), ProvisioningEndpoints.placeholder(parameters)));
            parameters.add(af.value);
            parameters.add(af.key);
        }
        String queryTemplate = "select \n    id, username, email, first_name, last_name,\n    enabled, email_verified, created_timestamp, \n    cast(groups as text), cast(attributes as text), total \nfrom(\n    select \n        id, username, email, first_name, last_name, \n        enabled, email_verified, created_timestamp, \n        groups, attributes, count(*) over() as total\n    from user_entity u \n    left join lateral (\n        select jsonb_agg(g.name) as groups from user_group_membership ug \n        inner join keycloak_group g on ug.group_id = g.id\n        where ug.user_id = u.id\n    ) gs on true\n    left join lateral (\n        select jsonb_object_agg(ua.name, ua.value) as attributes from user_attribute ua\n        where ua.user_id = u.id\n    ) at on true\n    where \n        service_account_client_link is null\n        and %s\n) rs";
        String query = String.format("select \n    id, username, email, first_name, last_name,\n    enabled, email_verified, created_timestamp, \n    cast(groups as text), cast(attributes as text), total \nfrom(\n    select \n        id, username, email, first_name, last_name, \n        enabled, email_verified, created_timestamp, \n        groups, attributes, count(*) over() as total\n    from user_entity u \n    left join lateral (\n        select jsonb_agg(g.name) as groups from user_group_membership ug \n        inner join keycloak_group g on ug.group_id = g.id\n        where ug.user_id = u.id\n    ) gs on true\n    left join lateral (\n        select jsonb_object_agg(ua.name, ua.value) as attributes from user_attribute ua\n        where ua.user_id = u.id\n    ) at on true\n    where \n        service_account_client_link is null\n        and %s\n) rs", conditions.stream().collect(Collectors.joining(" and ")));
        Query q = em.createNativeQuery(query);
        for (int i = 0; i < parameters.size(); ++i) {
            q.setParameter(i + 1, parameters.get(i));
        }
        if (offset != 0) {
            q.setFirstResult(offset);
        }
        if (limit != 0) {
            q.setMaxResults(limit);
        }
        AtomicInteger totalAcc = new AtomicInteger();
        List slice = q.getResultStream().map(row -> {
            try {
                totalAcc.set(((Number)row[10]).intValue());
                UserResponse ur = new UserResponse();
                ur.id = (String)row[0];
                ur.username = (String)row[1];
                ur.email = (String)row[2];
                ur.firstName = (String)row[3];
                ur.lastName = (String)row[4];
                ur.enabled = (Boolean)row[5];
                ur.emailVerified = (Boolean)row[6];
                ur.createdTimestamp = row[7] == null ? 0L : ((Number)row[7]).longValue();
                ur.groups = row[8] == null ? List.of() : (List)this.om.readValue((String)row[8], (TypeReference)new TypeReference<List<String>>(){});
                ur.attributes = row[9] == null ? Map.of() : (Map)this.om.readValue((String)row[9], (TypeReference)new TypeReference<Map<String, String>>(){});
                return ur;
            }
            catch (JsonProcessingException ex) {
                throw new IllegalStateException(ex);
            }
        }).collect(Collectors.toList());
        return PageResponse.of(slice, totalAcc.get());
    }

    private static String placeholder(List<Object> params) {
        return String.format("?%d", params.size() + 1);
    }

    public static class UserProvisioningRequest {
        @NotEmpty
        public String id;
        @NotEmpty
        public String username;
        @NotEmpty
        public String firstName;
        @NotEmpty
        public String lastName;
        @NotNull
        public Map<String, List<String>> attributes;
        @NotNull
        public List<String> groups;
        public boolean enabled;
        public boolean emailVerified;
    }

    private static class ValueFilterSpec {
        public String field;
        public UsersRequest.ValueFilter filter;
        public Class<?> type;

        private ValueFilterSpec() {
        }

        public static ValueFilterSpec of(String fieldName, UsersRequest.ValueFilter filter, Class<?> type) {
            ValueFilterSpec f = new ValueFilterSpec();
            f.field = fieldName;
            f.filter = filter;
            f.type = type;
            return f;
        }
    }
}

