/*
 * Decompiled with CFR 0.152.
 */
package net.optionfactory.keycloak.ldap;

import java.util.List;
import org.jboss.logging.Logger;
import org.keycloak.component.ComponentModel;
import org.keycloak.component.ComponentValidationException;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.storage.ldap.LDAPStorageProvider;
import org.keycloak.storage.ldap.idm.model.LDAPObject;
import org.keycloak.storage.ldap.mappers.AbstractLDAPStorageMapper;
import org.keycloak.storage.ldap.mappers.membership.group.GroupLDAPStorageMapper;
import org.keycloak.storage.ldap.mappers.membership.group.GroupLDAPStorageMapperFactory;

public class CachingGroupLDAPStorageMapper
extends GroupLDAPStorageMapper {
    private static final Logger logger = Logger.getLogger(CachingGroupLDAPStorageMapper.class);

    public CachingGroupLDAPStorageMapper(ComponentModel mapperModel, LDAPStorageProvider ldapProvider, GroupLDAPStorageMapperFactory factory) {
        super(mapperModel, ldapProvider, factory);
    }

    public UserModel proxy(LDAPObject ldapUser, UserModel user, RealmModel realm) {
        return new DbCachingLdapUserDelegate(this, realm, user, ldapUser);
    }

    public void onImportUserFromLDAP(LDAPObject ldapUser, UserModel user, RealmModel realm, boolean isCreate) {
        List ldapGroups = this.getLDAPGroupMappings(ldapUser);
        GroupModel ldapGroupsRoot = this.getKcGroupsPathGroup(realm);
        user.getGroupsStream().filter(gm -> ldapGroupsRoot == null || ldapGroupsRoot.equals((Object)gm.getParent())).forEach(gm -> user.leaveGroup(gm));
        for (LDAPObject ldapGroup : ldapGroups) {
            GroupModel kcGroup = this.findKcGroupOrSyncFromLDAP(realm, ldapGroupsRoot, ldapGroup, user);
            if (kcGroup == null) continue;
            logger.debugf("User '%s' joins group '%s' during import from LDAP", (Object)user.getUsername(), (Object)kcGroup.getName());
            user.joinGroup(kcGroup);
        }
    }

    public class DbCachingLdapUserDelegate
    extends GroupLDAPStorageMapper.LDAPGroupMappingsUserDelegate {
        private final UserModel inner;

        public DbCachingLdapUserDelegate(CachingGroupLDAPStorageMapper this$0, RealmModel realm, UserModel user, LDAPObject ldapUser) {
            super((GroupLDAPStorageMapper)this$0, realm, user, ldapUser);
            this.inner = user;
        }

        public void joinGroup(GroupModel group) {
            super.joinGroup(group);
            this.inner.joinGroup(group);
        }

        public void leaveGroup(GroupModel group) {
            super.leaveGroup(group);
            this.inner.leaveGroup(group);
        }
    }

    public static class Factory
    extends GroupLDAPStorageMapperFactory {
        public String getId() {
            return "caching-group-ldap-mapper";
        }

        public String getHelpText() {
            return "Used to map group mappings of groups from some LDAP DN to Keycloak group mappings. This mapper always work in LDAP_ONLY mode but stores group membership in the database.";
        }

        protected AbstractLDAPStorageMapper createMapper(ComponentModel mapperModel, LDAPStorageProvider federationProvider) {
            return new CachingGroupLDAPStorageMapper(mapperModel, federationProvider, this);
        }

        public void validateConfiguration(KeycloakSession session, RealmModel realm, ComponentModel config) throws ComponentValidationException {
            super.validateConfiguration(session, realm, config);
            String mode = (String)config.getConfig().getFirst((Object)"mode");
            if (!"LDAP_ONLY".equals(mode)) {
                throw new ComponentValidationException(String.format("Mode MUST be LDAP_ONLY when using '%s'", this.getId()), new Object[0]);
            }
        }
    }
}

