/*
 * Decompiled with CFR 0.152.
 */
package net.optionfactory.keycloak.apple;

import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Base64;
import java.util.concurrent.atomic.AtomicReference;
import net.optionfactory.keycloak.apple.AppleIdentityProviderConfig;
import net.optionfactory.keycloak.apple.AppleUser;
import org.keycloak.broker.oidc.OIDCIdentityProvider;
import org.keycloak.broker.oidc.OIDCIdentityProviderConfig;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.broker.provider.IdentityProvider;
import org.keycloak.broker.provider.util.SimpleHttp;
import org.keycloak.broker.social.SocialIdentityProvider;
import org.keycloak.common.util.Time;
import org.keycloak.crypto.KeyWrapper;
import org.keycloak.crypto.ServerECDSASignatureSignerContext;
import org.keycloak.crypto.SignatureSignerContext;
import org.keycloak.events.EventBuilder;
import org.keycloak.jose.jws.JWSBuilder;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.representations.JsonWebToken;
import org.keycloak.util.JsonSerialization;

public class AppleIdentityProvider
extends OIDCIdentityProvider
implements SocialIdentityProvider<OIDCIdentityProviderConfig> {
    private final AtomicReference<String> userJsonRef = new AtomicReference();

    public AppleIdentityProvider(KeycloakSession session, AppleIdentityProviderConfig config) {
        super(session, (OIDCIdentityProviderConfig)config);
        config.setAuthorizationUrl("https://appleid.apple.com/auth/authorize?response_mode=form_post");
        config.setTokenUrl("https://appleid.apple.com/auth/token");
    }

    public Object callback(RealmModel realm, IdentityProvider.AuthenticationCallback callback, EventBuilder event) {
        return new AppleOidcEndpoint(callback, realm, event, this.userJsonRef, this);
    }

    public BrokeredIdentityContext getFederatedIdentity(String response) {
        BrokeredIdentityContext context = super.getFederatedIdentity(response);
        String uj = this.userJsonRef.get();
        if (uj != null) {
            try {
                AppleUser user = (AppleUser)JsonSerialization.readValue((String)uj, AppleUser.class);
                context.setEmail(user.email);
                context.setFirstName(user.name.firstName);
                context.setLastName(user.name.lastName);
            }
            catch (IOException e) {
                logger.errorf("Failed to parse userJson [%s]: %s", (Object)uj, (Object)e);
            }
        }
        return context;
    }

    public SimpleHttp authenticateTokenRequest(SimpleHttp tokenRequest) {
        AppleIdentityProviderConfig config = (AppleIdentityProviderConfig)this.getConfig();
        tokenRequest.param("client_id", config.getClientId());
        String base64PrivateKey = config.getClientSecret();
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("EC");
            byte[] pkc8ePrivateKey = Base64.getDecoder().decode(base64PrivateKey);
            PKCS8EncodedKeySpec keySpecPKCS8 = new PKCS8EncodedKeySpec(pkc8ePrivateKey);
            PrivateKey privateKey = keyFactory.generatePrivate(keySpecPKCS8);
            KeyWrapper keyWrapper = new KeyWrapper();
            keyWrapper.setAlgorithm("ES256");
            keyWrapper.setKid(config.getKeyId());
            keyWrapper.setPrivateKey((Key)privateKey);
            ServerECDSASignatureSignerContext signer = new ServerECDSASignatureSignerContext(keyWrapper);
            long currentTime = Time.currentTime();
            JsonWebToken token = new JsonWebToken();
            token.issuer(config.getTeamId());
            token.iat(Long.valueOf(currentTime));
            token.exp(Long.valueOf(currentTime + 900L));
            token.audience(new String[]{"https://appleid.apple.com"});
            token.subject(config.getClientId());
            String clientSecret = new JWSBuilder().jsonContent((Object)token).sign((SignatureSignerContext)signer);
            tokenRequest.param("client_secret", clientSecret);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            logger.errorf("Failed to generate client secret: %s", (Object)e);
        }
        return tokenRequest;
    }

    protected String getDefaultScopes() {
        return "email name";
    }

    public static class AppleOidcEndpoint
    extends OIDCIdentityProvider.OIDCEndpoint {
        private final AtomicReference<String> userJson;

        public AppleOidcEndpoint(IdentityProvider.AuthenticationCallback callback, RealmModel realm, EventBuilder event, AtomicReference<String> userJson, AppleIdentityProvider outer) {
            super(callback, realm, event, (OIDCIdentityProvider)outer);
            this.userJson = userJson;
        }

        @POST
        public Response authResponse(@FormParam(value="state") String state, @FormParam(value="code") String authorizationCode, @FormParam(value="user") String userJson, @FormParam(value="error") String error, @FormParam(value="error_description") String errorDescription) {
            this.userJson.set(userJson);
            return super.authResponse(state, authorizationCode, error, errorDescription);
        }
    }
}

