/*
 * Decompiled with CFR 0.152.
 */
package net.optionfactory.keycloak.email;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.optionfactory.keycloak.email.CidSource;
import org.jboss.logging.Logger;
import org.keycloak.theme.Theme;

public class CidsProvider {
    private static final Map<String, Map<String, CidSource>> THEME_ID_TO_ALLOWED_CIDS_CACHE = new ConcurrentHashMap<String, Map<String, CidSource>>();
    static final Pattern CID_PATTERN = Pattern.compile("([\"'])CID:([A-Z0-9-_.]+)\\1", 2);
    private static final Logger logger = Logger.getLogger(CidsProvider.class);
    private final String themeName;
    private final Map<String, CidSource> allowedCids;
    private static final TypeReference<List<CidSource>> CID_SOURCE_LIST = new TypeReference<List<CidSource>>(){};

    public CidsProvider(Theme theme) {
        this.themeName = theme.getName();
        this.allowedCids = THEME_ID_TO_ALLOWED_CIDS_CACHE.computeIfAbsent(this.themeName, name -> {
            Map map;
            block8: {
                ObjectMapper mapper = new ObjectMapper();
                InputStream is = theme.getResourceAsStream("allowed_cids.json");
                try {
                    Map<Object, Object> map2 = map = is == null ? Map.of() : ((List)mapper.readValue(is, CID_SOURCE_LIST)).stream().collect(Collectors.toMap(c -> c.id, c -> c));
                    if (is == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException ex) {
                        throw new UncheckedIOException(ex);
                    }
                }
                is.close();
            }
            return map;
        });
    }

    public List<CidSource> cids(String htmlBody) {
        Matcher matcher = CID_PATTERN.matcher(htmlBody);
        ArrayList<CidSource> matches = new ArrayList<CidSource>();
        while (matcher.find()) {
            String cid = matcher.group(2);
            CidSource found = this.allowedCids.get(cid);
            if (found == null) {
                logger.infof("in email theme '%s' cid '%s' is referenced in the email but not allowed in allow_cids.json (%s entries)", (Object)this.themeName, (Object)cid, (Object)this.allowedCids.size());
                continue;
            }
            matches.add(found);
        }
        return matches;
    }
}

