/*
 * Decompiled with CFR 0.152.
 */
package net.optionfactory.keycloak.authenticators.notes;

import java.util.Optional;
import net.optionfactory.keycloak.authenticators.notes.Note;
import org.keycloak.models.UserSessionModel;
import org.keycloak.sessions.AuthenticationSessionModel;

public class UserSessionNote<T> {
    private final Note<T> note;
    private final String key;

    public UserSessionNote(String key, Class<T> type) {
        this.key = key;
        this.note = new Note<T>(type);
    }

    public static <T> UserSessionNote<T> of(String key, Class<T> type) {
        return new UserSessionNote<T>(key, type);
    }

    public void store(AuthenticationSessionModel as, T value) {
        as.setUserSessionNote(this.key, this.note.marshal(value));
    }

    public Optional<T> load(AuthenticationSessionModel asm) {
        return Optional.ofNullable(this.note.unmarshal((String)asm.getUserSessionNotes().get(this.key)));
    }

    public Optional<T> load(UserSessionModel usm) {
        return Optional.ofNullable(this.note.unmarshal(usm.getNote(this.key)));
    }
}

