/*
 * Decompiled with CFR 0.152.
 */
package net.optionfactory.keycloak.authenticators.notes;

import java.util.Optional;
import java.util.function.Supplier;
import net.optionfactory.keycloak.authenticators.notes.Note;
import org.keycloak.sessions.AuthenticationSessionModel;

public class AuthNote<T> {
    private final Note<T> note;
    private final String key;

    public AuthNote(String key, Class<T> type) {
        this.note = new Note<T>(type);
        this.key = key;
    }

    public static <T> AuthNote<T> of(String key, Class<T> type) {
        return new AuthNote<T>(key, type);
    }

    public void store(AuthenticationSessionModel as, T value) {
        as.setAuthNote(this.key, this.note.marshal(value));
    }

    public Optional<T> load(AuthenticationSessionModel as) {
        return Optional.ofNullable(this.note.unmarshal(as.getAuthNote(this.key)));
    }

    public Optional<T> load(AuthenticationSessionModel as, T defaultValue) {
        T v = this.note.unmarshal(as.getAuthNote(this.key));
        if (v != null) {
            return Optional.of(v);
        }
        this.store(as, defaultValue);
        return Optional.of(defaultValue);
    }

    public Optional<T> load(AuthenticationSessionModel as, Supplier<T> supplier) {
        T v = this.note.unmarshal(as.getAuthNote(this.key));
        if (v != null) {
            return Optional.of(v);
        }
        T defaultValue = supplier.get();
        this.store(as, defaultValue);
        return Optional.of(defaultValue);
    }

    public boolean exists(AuthenticationSessionModel as) {
        return as.getAuthNote(this.key) != null;
    }

    public void clear(AuthenticationSessionModel as) {
        as.removeAuthNote(this.key);
    }
}

