/*
 * Decompiled with CFR 0.152.
 */
package net.optionfactory.keycloak.authenticators.sms;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HexFormat;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import net.optionfactory.keycloak.authenticators.sms.SmsClient;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.jboss.logging.Logger;

public class SnsSmsClient
implements SmsClient {
    private final Logger logger = Logger.getLogger(SnsSmsClient.class);
    private final String accessKey;
    private final String secretKey;
    private final String region;
    private final String senderIdOrNull;
    private final CloseableHttpClient client;

    public SnsSmsClient(CloseableHttpClient client, String accessKey, String secretKey, String region, String senderIdOrNull) {
        this.client = client;
        this.accessKey = accessKey;
        this.secretKey = secretKey;
        this.region = region.toLowerCase();
        this.senderIdOrNull = senderIdOrNull;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String send(String phoneNumber, String message) {
        this.logger.infof("sending sms to: %s, message: %s", (Object)phoneNumber, (Object)message);
        ArrayList<BasicNameValuePair> ps = new ArrayList<BasicNameValuePair>();
        ps.add(new BasicNameValuePair("Action", "Publish"));
        ps.add(new BasicNameValuePair("Version", "2010-03-31"));
        ps.add(new BasicNameValuePair("PhoneNumber", phoneNumber));
        ps.add(new BasicNameValuePair("Message", message));
        ps.add(new BasicNameValuePair("MessageAttributes.entry.1.Name", "AWS.SNS.SMS.SMSType"));
        ps.add(new BasicNameValuePair("MessageAttributes.entry.1.Value.DataType", "String"));
        ps.add(new BasicNameValuePair("MessageAttributes.entry.1.Value.StringValue", "Transactional"));
        if (this.senderIdOrNull != null) {
            ps.add(new BasicNameValuePair("MessageAttributes.entry.2.Name", "AWS.SNS.SMS.SenderID"));
            ps.add(new BasicNameValuePair("MessageAttributes.entry.2.Value.DataType", "String"));
            ps.add(new BasicNameValuePair("MessageAttributes.entry.2.Value.StringValue", this.senderIdOrNull));
        }
        UrlEncodedFormEntity entity = new UrlEncodedFormEntity(ps, StandardCharsets.UTF_8);
        String uuid = UUID.randomUUID().toString();
        ArrayList<BasicHeader> headers = new ArrayList<BasicHeader>();
        headers.add(new BasicHeader("amz-sdk-invocation-id", uuid));
        headers.add(new BasicHeader("amz-sdk-request", "attempt=1; max=4"));
        headers.add(new BasicHeader("User-Agent", "opfa"));
        headers.addAll(this.authorizationHeaders(entity));
        HttpPost request = new HttpPost("https://sns.%s.amazonaws.com".formatted(this.region));
        request.setEntity((HttpEntity)entity);
        request.setHeaders((Header[])headers.toArray(BasicHeader[]::new));
        try (CloseableHttpResponse response = this.client.execute((HttpUriRequest)request);){
            if (response.getStatusLine().getStatusCode() == 200) {
                String string = uuid;
                return string;
            }
            InputStream is = response.getEntity().getContent();
            try {
                throw new IllegalStateException(String.format("Error sending message: %s", new String(is.readAllBytes(), StandardCharsets.UTF_8)));
            }
            catch (Throwable throwable) {
                if (is == null) throw throwable;
                try {
                    is.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    private List<BasicHeader> authorizationHeaders(UrlEncodedFormEntity entity) {
        ZonedDateTime now = Instant.now().atZone(ZoneId.of("UTC"));
        String isoInstant = DateTimeFormatter.ofPattern("uuuuMMdd'T'HHmmss'Z'").format(now);
        String isoBasicDate = DateTimeFormatter.ofPattern("uuuuMMdd").format(now);
        byte[] dateKey = SnsSmsClient.hmacSha256("AWS4%s".formatted(this.secretKey).getBytes(StandardCharsets.UTF_8), isoBasicDate.getBytes(StandardCharsets.UTF_8));
        byte[] dateRegionKey = SnsSmsClient.hmacSha256(dateKey, this.region.getBytes(StandardCharsets.UTF_8));
        byte[] dateRegionServiceKey = SnsSmsClient.hmacSha256(dateRegionKey, "sns".getBytes(StandardCharsets.UTF_8));
        byte[] signingKey = SnsSmsClient.hmacSha256(dateRegionServiceKey, "aws4_request".getBytes(StandardCharsets.UTF_8));
        String signedHeaders = "host;x-amz-date";
        String canonicalReq = Stream.of("POST", "/", "", "host:sns.%s.amazonaws.com".formatted(this.region), "x-amz-date:%s".formatted(isoInstant), "", "host;x-amz-date", SnsSmsClient.hex(SnsSmsClient.sha256(SnsSmsClient.formToBytes(entity)))).collect(Collectors.joining("\n"));
        String stringToSign = Stream.of("AWS4-HMAC-SHA256", isoInstant, "%s/%s/sns/aws4_request".formatted(isoBasicDate, this.region), SnsSmsClient.hex(SnsSmsClient.sha256(canonicalReq.getBytes(StandardCharsets.UTF_8)))).collect(Collectors.joining("\n"));
        String signature = SnsSmsClient.hex(SnsSmsClient.hmacSha256(signingKey, stringToSign.getBytes(StandardCharsets.UTF_8)));
        String authHeader = "AWS4-HMAC-SHA256 Credential=%s/%s/%s/sns/aws4_request, SignedHeaders=%s, Signature=%s".formatted(this.accessKey, isoBasicDate, this.region, "host;x-amz-date", signature);
        return List.of(new BasicHeader("X-Amz-Date", isoInstant), new BasicHeader("Authorization", authHeader));
    }

    public void close() {
    }

    private static String hex(byte[] data) {
        return HexFormat.of().formatHex(data);
    }

    private static byte[] hmacSha256(byte[] key, byte[] data) {
        try {
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(new SecretKeySpec(key, "HmacSHA256"));
            return mac.doFinal(data);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private static byte[] sha256(byte[] data) {
        try {
            return MessageDigest.getInstance("SHA-256").digest(data);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private static byte[] formToBytes(UrlEncodedFormEntity entity) {
        byte[] byArray;
        block8: {
            InputStream is = entity.getContent();
            try {
                byArray = is.readAllBytes();
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new UncheckedIOException(ex);
                }
            }
            is.close();
        }
        return byArray;
    }
}

