/*
 * Decompiled with CFR 0.152.
 */
package net.optionfactory.keycloak.auth;

import java.util.List;
import java.util.Map;
import org.keycloak.Config;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.AuthenticationFlowError;
import org.keycloak.authentication.AuthenticationFlowException;
import org.keycloak.authentication.authenticators.conditional.ConditionalAuthenticator;
import org.keycloak.authentication.authenticators.conditional.ConditionalAuthenticatorFactory;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.provider.ProviderConfigProperty;

public class ConditionalUserGroupAuthenticator
implements ConditionalAuthenticator {
    public static ConditionalUserGroupAuthenticator SINGLETON = new ConditionalUserGroupAuthenticator();

    public boolean matchCondition(AuthenticationFlowContext context) {
        UserModel user = context.getUser();
        if (user == null) {
            throw new AuthenticationFlowException("Cannot find user for obtaining particular user attributes. Authenticator: ", AuthenticationFlowError.UNKNOWN_USER);
        }
        Map authConfig = context.getAuthenticatorConfig().getConfig();
        String expectedGroup = (String)authConfig.get("group");
        boolean match = user.getGroupsStream().anyMatch(g -> g.getName().equals(expectedGroup));
        boolean negate = Boolean.parseBoolean((String)authConfig.get("negate"));
        return negate ? !match : match;
    }

    public void action(AuthenticationFlowContext context) {
    }

    public boolean requiresUser() {
        return true;
    }

    public void setRequiredActions(KeycloakSession session, RealmModel realm, UserModel user) {
    }

    public void close() {
    }

    public class Factory
    implements ConditionalAuthenticatorFactory {
        public void init(Config.Scope config) {
        }

        public void postInit(KeycloakSessionFactory factory) {
        }

        public void close() {
        }

        public String getId() {
            return "conditional-user-group";
        }

        public String getDisplayType() {
            return "Condition - User Group";
        }

        public boolean isConfigurable() {
            return true;
        }

        public AuthenticationExecutionModel.Requirement[] getRequirementChoices() {
            return new AuthenticationExecutionModel.Requirement[]{AuthenticationExecutionModel.Requirement.REQUIRED, AuthenticationExecutionModel.Requirement.DISABLED};
        }

        public boolean isUserSetupAllowed() {
            return false;
        }

        public String getHelpText() {
            return "Flow is executed only if user is in the given group.";
        }

        public List<ProviderConfigProperty> getConfigProperties() {
            ProviderConfigProperty groupProp = new ProviderConfigProperty();
            groupProp.setType("Group");
            groupProp.setName("group");
            groupProp.setLabel("Group");
            groupProp.setHelpText("Group");
            ProviderConfigProperty negateProp = new ProviderConfigProperty();
            negateProp.setType("boolean");
            negateProp.setName("negate");
            negateProp.setLabel("Negate output");
            negateProp.setHelpText("Apply a NOT to the check result.");
            return List.of(groupProp, negateProp);
        }

        public ConditionalAuthenticator getSingleton() {
            return SINGLETON;
        }
    }
}

