/*
 * Decompiled with CFR 0.152.
 */
package net.optionfactory.keycloak.api.provisioning;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.optionfactory.keycloak.api.provisioning.UserProvisioningRequest;
import net.optionfactory.keycloak.providers.validation.RequestValidator;
import org.keycloak.Config;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserProvider;
import org.keycloak.services.ServicesLogger;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.ext.AdminRealmResourceProvider;
import org.keycloak.services.resources.admin.ext.AdminRealmResourceProviderFactory;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;

public class ProvisioningEndpoints {
    private final ServicesLogger logger = ServicesLogger.LOGGER;
    private final RequestValidator validator;
    private final KeycloakSession session;

    public ProvisioningEndpoints(RequestValidator validator, KeycloakSession session) {
        this.validator = validator;
        this.session = session;
    }

    @DELETE
    @Path(value="/users")
    @Consumes(value={"application/json"})
    public void wipe(List<String> ids) {
        this.validator.enforce(ids, new Class[0]);
        RealmModel realm = this.session.getContext().getRealm();
        UserProvider users = this.session.users();
        for (String id : ids) {
            UserModel user = users.getUserById(realm, id);
            if (user == null) continue;
            users.removeUser(realm, user);
        }
    }

    @PUT
    @Path(value="/users")
    @Consumes(value={"application/json"})
    public void provide(UserProvisioningRequest req) {
        this.validator.enforce((Object)req, new Class[0]);
        RealmModel realm = this.session.getContext().getRealm();
        UserProvider users = this.session.users();
        UserModel user = Optional.ofNullable(users.getUserById(realm, req.id)).orElseGet(() -> users.addUser(realm, req.id, req.username, true, true));
        user.setFirstName(req.firstName);
        user.setLastName(req.lastName);
        user.setEnabled(req.enabled);
        user.setEmail(req.username);
        user.setEmailVerified(req.emailVerified);
        for (Map.Entry<String, List<String>> entry : req.attributes.entrySet()) {
            user.setAttribute(entry.getKey(), entry.getValue());
        }
        for (String requiredAction : req.requiredActions) {
            user.addRequiredAction(requiredAction);
        }
        for (String groupName : req.groups) {
            GroupModel group = this.session.groups().getGroupsStream(realm).filter(g -> g.getName().equals(groupName)).findFirst().orElseGet(() -> this.session.groups().createGroup(realm, groupName));
            user.joinGroup(group);
        }
    }

    public static class Factory
    implements AdminRealmResourceProviderFactory {
        public AdminRealmResourceProvider create(KeycloakSession session) {
            final RequestValidator validator = (RequestValidator)session.getProvider(RequestValidator.class);
            return new AdminRealmResourceProvider(){

                public Object getResource(KeycloakSession ks, RealmModel rm, AdminPermissionEvaluator ape, AdminEventBuilder aeb) {
                    ape.users().requireManage();
                    return new ProvisioningEndpoints(validator, ks);
                }

                public void close() {
                }
            };
        }

        public void init(Config.Scope config) {
        }

        public void postInit(KeycloakSessionFactory factory) {
        }

        public void close() {
        }

        public String getId() {
            return "provisioning";
        }
    }
}

