/*
 * Decompiled with CFR 0.152.
 */
package net.optionfactory.keycloak.api.inspection;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.optionfactory.keycloak.api.inspection.UserResponse;
import net.optionfactory.keycloak.providers.filtering.AllowedFilter;
import net.optionfactory.keycloak.providers.filtering.AttributeFilter;
import net.optionfactory.keycloak.providers.filtering.BooleanFilter;
import net.optionfactory.keycloak.providers.filtering.GroupFilter;
import net.optionfactory.keycloak.providers.filtering.QueryBuilder;
import net.optionfactory.keycloak.providers.filtering.TextFilter;
import net.optionfactory.keycloak.providers.filtering.TimestampFilter;
import net.optionfactory.keycloak.providers.pagination.PageResponse;
import net.optionfactory.keycloak.providers.pagination.SliceResponse;
import org.keycloak.Config;
import org.keycloak.connections.jpa.JpaConnectionProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.services.ServicesLogger;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.ext.AdminRealmResourceProvider;
import org.keycloak.services.resources.admin.ext.AdminRealmResourceProviderFactory;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;

public class InspectionEndpoints {
    private final ServicesLogger logger = ServicesLogger.LOGGER;
    private final ObjectMapper om = new ObjectMapper();
    private final KeycloakSession session;
    private static final QueryBuilder QUERY_TEMPLATE = new QueryBuilder("select\n    id, username, email, first_name, last_name,\n    enabled, email_verified, created_timestamp,\n    groups, attributes {COUNT_OVER_TOTAL}\nfrom\n    user_entity u\n    left join lateral (\n        select jsonb_object_agg(g.name, g.id) as groups from user_group_membership ug\n        inner join keycloak_group g on ug.group_id = g.id\n        where ug.user_id = u.id\n    ) gs on true\n    left join lateral (\n        with ua as (select name, coalesce(long_value, value) as value from user_attribute where user_id = u.id) select jsonb_agg(ua) as attributes from ua\n    ) at on true\nwhere\n    service_account_client_link is null\n    and realm_id = ?\n    {CONDITIONS}\n{ORDER_CLAUSE}\n").filter((AllowedFilter)new TextFilter("id", "id")).filter((AllowedFilter)new TextFilter("username", "username")).filter((AllowedFilter)new TextFilter("email", "email")).filter((AllowedFilter)new TextFilter("firstName", "first_name")).filter((AllowedFilter)new TextFilter("lastName", "last_name")).filter((AllowedFilter)new BooleanFilter("enabled", "enabled")).filter((AllowedFilter)new BooleanFilter("emailVerified", "email_verified")).filter((AllowedFilter)new TimestampFilter("createdAt", "created_timestamp")).filter((AllowedFilter)new GroupFilter("groups", "groups")).filter((AllowedFilter)new AttributeFilter("attributes")).sorter("id", "id").sorter("username", "username").sorter("email", "email").sorter("firstName", "first_name").sorter("lastName", "last_name").sorter("enabled", "enabled").sorter("emailVerified", "email_verified").sorter("createdAt", "created_timestamp");
    private static final TypeReference<Map<String, String>> MAP_TYPE = new TypeReference<Map<String, String>>(){};
    private static final TypeReference<List<Attribute>> ATTRIBUTES_TYPE = new TypeReference<List<Attribute>>(){};

    public InspectionEndpoints(KeycloakSession session) {
        this.session = session;
    }

    @POST
    @Path(value="/users")
    @Consumes(value={"application/json"})
    public Response users(@HeaderParam(value="Accept") MediaType accept, Map<String, String[]> filters, @QueryParam(value="sort") List<String> sort, @DefaultValue(value="0") @QueryParam(value="offset") int offset, @DefaultValue(value="0") @QueryParam(value="limit") int limit) {
        List<UserResponse> sliceData;
        boolean slice = MediaType.valueOf((String)"application/slice+json").equals((Object)accept);
        EntityManager em = ((JpaConnectionProvider)this.session.getProvider(JpaConnectionProvider.class)).getEntityManager();
        Query query = QUERY_TEMPLATE.create(em, filters, sort, !slice, offset, limit == 0 ? 0 : limit + 1, new Object[]{this.session.getContext().getRealm().getId()});
        AtomicInteger totalAcc = new AtomicInteger();
        List<UserResponse> chunk = query.getResultStream().map(row -> {
            try {
                if (!slice) {
                    totalAcc.set(((Number)row[10]).intValue());
                }
                UserResponse ur = new UserResponse();
                ur.id = (String)row[0];
                ur.username = (String)row[1];
                ur.email = (String)row[2];
                ur.firstName = (String)row[3];
                ur.lastName = (String)row[4];
                ur.enabled = (Boolean)row[5];
                ur.emailVerified = (Boolean)row[6];
                ur.createdAt = row[7] == null ? null : Instant.ofEpochMilli(((Number)row[7]).longValue());
                ur.groups = row[8] == null ? Map.of() : (Map)this.om.readValue((String)row[8], MAP_TYPE);
                ur.attributes = row[9] == null ? Map.of() : ((List)this.om.readValue((String)row[9], ATTRIBUTES_TYPE)).stream().collect(Collectors.toMap(attr -> attr.name(), attr -> List.of(attr.value()), (lhs, rhs) -> Stream.concat(lhs.stream(), rhs.stream()).toList()));
                return ur;
            }
            catch (JsonProcessingException ex) {
                throw new IllegalStateException(ex);
            }
        }).toList();
        Response.ResponseBuilder rb = Response.ok().type(slice ? "application/slice+json" : "application/page+json");
        if (!slice) {
            return rb.entity((Object)new PageResponse(chunk, totalAcc.get())).build();
        }
        if (limit == 0) {
            return rb.entity((Object)new SliceResponse(chunk, false)).build();
        }
        return rb.entity((Object)new SliceResponse(sliceData, (sliceData = chunk.subList(0, Math.min(chunk.size(), limit))).size() < limit)).build();
    }

    public record Attribute(String name, String value) {
    }

    public static class Factory
    implements AdminRealmResourceProviderFactory {
        public AdminRealmResourceProvider create(final KeycloakSession session) {
            return new AdminRealmResourceProvider(){

                public Object getResource(KeycloakSession ks, RealmModel rm, AdminPermissionEvaluator ape, AdminEventBuilder aeb) {
                    ape.users().requireView();
                    return new InspectionEndpoints(session);
                }

                public void close() {
                }
            };
        }

        public void init(Config.Scope config) {
        }

        public void postInit(KeycloakSessionFactory factory) {
        }

        public void close() {
        }

        public String getId() {
            return "inspection";
        }
    }
}

