/*
 * Decompiled with CFR 0.152.
 */
package net.optionfactory.keycloak.api.inspection;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.optionfactory.keycloak.api.inspection.UserResponse;
import net.optionfactory.keycloak.providers.ResourceAuthenticator;
import net.optionfactory.keycloak.providers.filtering.AllowedFilter;
import net.optionfactory.keycloak.providers.filtering.AttributeFilter;
import net.optionfactory.keycloak.providers.filtering.BooleanFilter;
import net.optionfactory.keycloak.providers.filtering.GroupFilter;
import net.optionfactory.keycloak.providers.filtering.QueryBuilder;
import net.optionfactory.keycloak.providers.filtering.TextFilter;
import net.optionfactory.keycloak.providers.filtering.TimestampFilter;
import net.optionfactory.keycloak.providers.pagination.PageResponse;
import org.keycloak.Config;
import org.keycloak.connections.jpa.JpaConnectionProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.services.ServicesLogger;
import org.keycloak.services.resource.RealmResourceProvider;
import org.keycloak.services.resource.RealmResourceProviderFactory;

public class InspectionEndpoints {
    private final ServicesLogger logger = ServicesLogger.LOGGER;
    private final ObjectMapper om = new ObjectMapper();
    private final KeycloakSession session;
    private static final QueryBuilder QUERY_TEMPLATE = new QueryBuilder("select\n    id, username, email, first_name, last_name,\n    enabled, email_verified, created_timestamp,\n    groups, attributes, count(*) over() as total\nfrom\n    user_entity u\n    left join lateral (\n        select jsonb_object_agg(g.name, g.id) as groups from user_group_membership ug\n        inner join keycloak_group g on ug.group_id = g.id\n        where ug.user_id = u.id\n    ) gs on true\n    left join lateral (\n        select jsonb_object_agg(ua.name, ua.value) as attributes from user_attribute ua\n        where ua.user_id = u.id\n    ) at on true\nwhere\n    service_account_client_link is null\n    and realm_id = ?\n    {CONDITIONS}\n{ORDER_CLAUSE}\n").filter((AllowedFilter)new TextFilter("id", "id")).filter((AllowedFilter)new TextFilter("username", "username")).filter((AllowedFilter)new TextFilter("email", "email")).filter((AllowedFilter)new TextFilter("firstName", "first_name")).filter((AllowedFilter)new TextFilter("lastName", "last_name")).filter((AllowedFilter)new BooleanFilter("enabled", "enabled")).filter((AllowedFilter)new BooleanFilter("emailVerified", "email_verified")).filter((AllowedFilter)new TimestampFilter("createdAt", "created_timestamp")).filter((AllowedFilter)new GroupFilter("groups", "groups")).filter((AllowedFilter)new AttributeFilter("attributes", "attributes")).sorter("id", "id").sorter("username", "username").sorter("email", "email").sorter("firstName", "first_name").sorter("lastName", "last_name").sorter("enabled", "enabled").sorter("emailVerified", "email_verified").sorter("createdAt", "created_timestamp");
    private static final TypeReference<Map<String, String>> MAP_TYPE = new TypeReference<Map<String, String>>(){};

    public InspectionEndpoints(KeycloakSession session) {
        this.session = session;
    }

    @POST
    @Path(value="/users")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public PageResponse<UserResponse> users(Map<String, String[]> filters, @QueryParam(value="sort") List<String> sort, @DefaultValue(value="0") @QueryParam(value="offset") int offset, @DefaultValue(value="0") @QueryParam(value="limit") int limit) {
        EntityManager em = ((JpaConnectionProvider)this.session.getProvider(JpaConnectionProvider.class)).getEntityManager();
        Query query = QUERY_TEMPLATE.create(em, filters, sort, offset, limit, new Object[]{this.session.getContext().getRealm().getId()});
        AtomicInteger totalAcc = new AtomicInteger();
        List<UserResponse> slice = query.getResultStream().map(row -> {
            try {
                totalAcc.set(((Number)row[10]).intValue());
                UserResponse ur = new UserResponse();
                ur.id = (String)row[0];
                ur.username = (String)row[1];
                ur.email = (String)row[2];
                ur.firstName = (String)row[3];
                ur.lastName = (String)row[4];
                ur.enabled = (Boolean)row[5];
                ur.emailVerified = (Boolean)row[6];
                ur.createdAt = row[7] == null ? null : Instant.ofEpochMilli(((Number)row[7]).longValue());
                ur.groups = row[8] == null ? Map.of() : (Map)this.om.readValue((String)row[8], MAP_TYPE);
                ur.attributes = row[9] == null ? Map.of() : (Map)this.om.readValue((String)row[9], MAP_TYPE);
                return ur;
            }
            catch (JsonProcessingException ex) {
                throw new IllegalStateException(ex);
            }
        }).toList();
        return new PageResponse(slice, totalAcc.get());
    }

    public static class Factory
    implements RealmResourceProviderFactory {
        private String[] requiredClientRole;

        public RealmResourceProvider create(final KeycloakSession session) {
            ResourceAuthenticator.enforceServiceAccountHasClientRole((KeycloakSession)session, (String)this.requiredClientRole[0], (String)this.requiredClientRole[1]);
            return new RealmResourceProvider(){

                public Object getResource() {
                    return new InspectionEndpoints(session);
                }

                public void close() {
                }
            };
        }

        public void init(Config.Scope config) {
            this.requiredClientRole = config.get("role", "realm-management/view-users").split("/");
        }

        public void postInit(KeycloakSessionFactory factory) {
        }

        public void close() {
        }

        public String getId() {
            return "inspection";
        }
    }
}

