/*
 * Decompiled with CFR 0.152.
 */
package net.optionfactory.hj.jackson.reflection;

import net.optionfactory.hj.jackson.reflection.ObjectUtils;

public abstract class Assert {
    public static void isTrue(boolean expression, String message) {
        if (!expression) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void notNull(Object object, String message) {
        if (object == null) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void hasLength(String text, String message) {
        if (text == null || text.length() == 0) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void notEmpty(Object[] array, String message) {
        if (ObjectUtils.isEmpty(array)) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void notEmpty(Object[] array) {
        Assert.notEmpty(array, "[Assertion failed] - this array must not be empty: it must contain at least 1 element");
    }

    public static void noNullElements(Object[] array, String message) {
        if (array != null) {
            Object[] objectArray = array;
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                if (element == null) {
                    throw new IllegalArgumentException(message);
                }
                ++n2;
            }
        }
    }

    public static void noNullElements(Object[] array) {
        Assert.noNullElements(array, "[Assertion failed] - this array must not contain any null elements");
    }

    public static void state(boolean expression, String message) {
        if (!expression) {
            throw new IllegalStateException(message);
        }
    }

    public static void state(boolean expression) {
        Assert.state(expression, "[Assertion failed] - this state invariant must be true");
    }
}

