/*
 * Decompiled with CFR 0.152.
 */
package net.optionfactory.hj.cdi;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.CDI;
import javax.inject.Qualifier;
import net.optionfactory.hj.JsonDriver;
import net.optionfactory.hj.JsonDriverLocator;
import net.optionfactory.hj.JsonDriverNotFound;
import net.optionfactory.hj.UserTypes;

public class CdiDriverLocator
implements JsonDriverLocator {
    @Override
    public JsonDriver locate(Annotation[] fieldAnnotations, Optional<String> name) {
        BeanManager bm = CDI.current().getBeanManager();
        Annotation[] qualifiers = (Annotation[])Arrays.stream(fieldAnnotations).filter(a -> UserTypes.searchAnnotation(a, Qualifier.class).isPresent()).toArray(Annotation[]::new);
        JsonDriverNotFound.failIf(qualifiers.length > 0 && name.isPresent(), "found both @Qualifiers and @WithDriver.value()");
        Set beans = name.map(n -> bm.getBeans(n)).orElseGet(() -> bm.getBeans(JsonDriver.class, qualifiers));
        JsonDriverNotFound.failIf(beans.isEmpty(), "no JsonDriver found in BeanManager");
        JsonDriverNotFound.failIf(beans.size() > 1, "more than one JsonDriver found in BeanManager, use @JsonType.WithDriver to disambiguate");
        Bean bean = (Bean)beans.iterator().next();
        CreationalContext ctx = bm.createCreationalContext((Contextual)bean);
        return (JsonDriver)bm.getReference(bean, JsonDriver.class, ctx);
    }
}

