/*
 * Decompiled with CFR 0.152.
 */
package net.optionfactory.hj;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Optional;
import java.util.Properties;
import net.optionfactory.hj.JsonDriverLocator;
import net.optionfactory.hj.JsonType;
import net.optionfactory.hj.spring.SpringDriverLocator;

public class UserTypes {
    public static final String DRIVER_NAME_KEY = "jsonDriverName";
    public static final String DRIVER_LOCATOR_CLASS_KEY = "jsonDriverLocatorClass";
    public static final String COLUMN_TYPE_KEY = "columnType";

    public static Class<?> entityClass(Properties properties) {
        try {
            return Class.forName(properties.getProperty("org.hibernate.type.ParameterType.entityClass"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalStateException(String.format("Entity class not found: %s", properties.getProperty("org.hibernate.type.ParameterType.entityClass")));
        }
    }

    public static Field mappedField(Class<?> baseClass, Properties properties) {
        String fieldName = properties.getProperty("org.hibernate.type.ParameterType.propertyName");
        Class<?> cls = baseClass;
        while (cls != null) {
            Field[] fieldArray = cls.getDeclaredFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field f = fieldArray[n2];
                if (fieldName.equals(f.getName())) {
                    return f;
                }
                ++n2;
            }
            cls = cls.getSuperclass();
        }
        throw new IllegalStateException(String.format("Entity field not found: %s::%s", baseClass, fieldName));
    }

    public static Optional<String> driverName(Field field, Properties properties) {
        String driverName = UserTypes.searchAnnotation(field, JsonType.Conf.class).map(a -> a.driver()).orElseGet(() -> properties.getProperty(DRIVER_NAME_KEY, ""));
        return driverName.isEmpty() ? Optional.empty() : Optional.of(driverName);
    }

    public static JsonDriverLocator makeLocator(Field field, Properties properties) {
        try {
            Class locatorClass = UserTypes.searchAnnotation(field, JsonType.Conf.class).map(a -> a.locator()).orElseGet(() -> {
                try {
                    return Class.forName(properties.getProperty(DRIVER_LOCATOR_CLASS_KEY, SpringDriverLocator.class.getName()));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new IllegalStateException(String.format("DriverLocator class not found: %s", properties.getProperty(DRIVER_LOCATOR_CLASS_KEY)));
                }
            });
            return (JsonDriverLocator)locatorClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException ex) {
            throw new IllegalStateException("Cannot instantiate DriverLocator", ex);
        }
    }

    public static JsonType.ColumnType columnType(Field field, Properties properties) {
        return UserTypes.searchAnnotation(field, JsonType.Conf.class).map(a -> a.type()).orElseGet(() -> JsonType.ColumnType.valueOf(properties.getProperty(COLUMN_TYPE_KEY, "Text")));
    }

    private static <T extends Annotation> Optional<T> searchAnnotation(Field field, Class<T> annotationClass) {
        T annotation = field.getAnnotation(annotationClass);
        if (annotation != null) {
            return Optional.of(annotation);
        }
        Annotation[] annotationArray = field.getAnnotations();
        int n = annotationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation fieldAnnotation = annotationArray[n2];
            Optional<T> up = UserTypes.searchAnnotation(fieldAnnotation, annotationClass);
            if (up.isPresent()) {
                return up;
            }
            ++n2;
        }
        return Optional.empty();
    }

    public static <T extends Annotation> Optional<T> searchAnnotation(Annotation annotation, Class<T> annotationClass) {
        Annotation[] annotationArray = annotation.annotationType().getAnnotations();
        int n = annotationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotationOnAnnotation = annotationArray[n2];
            if (annotationOnAnnotation.annotationType() == annotationClass) {
                return Optional.of(annotationOnAnnotation);
            }
            ++n2;
        }
        return Optional.empty();
    }
}

