/*
 * Decompiled with CFR 0.152.
 */
package net.optionfactory.hj;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Optional;
import java.util.Properties;
import net.optionfactory.hj.JsonDriver;
import net.optionfactory.hj.JsonDriverLocator;
import net.optionfactory.hj.JsonMappingException;
import net.optionfactory.hj.JsonType;
import net.optionfactory.hj.TypeDescriptor;
import net.optionfactory.hj.UserTypes;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.usertype.DynamicParameterizedType;
import org.hibernate.usertype.UserType;
import org.postgresql.util.PGobject;

public class JsonMutableType
implements UserType<Object>,
DynamicParameterizedType {
    public static final String TYPE = "net.optionfactory.hj.JsonMutableType";
    private JsonDriver json;
    private TypeDescriptor type;
    private JsonType.ColumnType ct;

    public void setParameterValues(Properties properties) {
        Class<?> declaringClass = UserTypes.entityClass(properties);
        Field field = UserTypes.mappedField(declaringClass, properties);
        JsonDriverLocator locator = UserTypes.makeLocator(field, properties);
        Optional<String> driverName = UserTypes.driverName(field, properties);
        this.json = locator.locate(field.getAnnotations(), driverName);
        this.type = this.json.fieldType(field, declaringClass);
        this.ensureEqualsIsOverridden();
        this.ct = UserTypes.columnType(field, properties);
    }

    private void ensureEqualsIsOverridden() {
        try {
            if (this.type.rawClass().getDeclaredMethod("equals", Object.class).getDeclaringClass().equals(Object.class)) {
                throw new IllegalStateException("Class or one of its ancestors (but not Object) must implement equals");
            }
        }
        catch (NoSuchMethodException | SecurityException ex) {
            throw new RuntimeException(ex);
        }
    }

    public int getSqlType() {
        return this.ct.sqlType();
    }

    public Class<Object> returnedClass() {
        return this.type.rawClass();
    }

    public boolean equals(Object lhs, Object rhs) throws HibernateException {
        return lhs == null ? rhs == null : lhs.equals(rhs);
    }

    public int hashCode(Object obj) throws HibernateException {
        return obj == null ? 0 : obj.hashCode();
    }

    public Object nullSafeGet(ResultSet rs, int position, SharedSessionContractImplementor session, Object owner) throws SQLException {
        String string = rs.getString(position);
        if (rs.wasNull() || string == null || string.isEmpty()) {
            return this.json.deserialize("null", this.type);
        }
        try {
            return this.json.deserialize(string, this.type);
        }
        catch (Exception ex) {
            throw new JsonMappingException(ex);
        }
    }

    public void nullSafeSet(PreparedStatement ps, Object value, int index, SharedSessionContractImplementor si) throws HibernateException, SQLException {
        if (value == null) {
            ps.setNull(index, this.ct.sqlType());
            return;
        }
        ps.getConnection().getMetaData().getDatabaseProductName();
        try {
            String serialized = this.json.serialize(value, this.type);
            switch (this.ct) {
                case Text: 
                case MysqlJson: {
                    ps.setString(index, serialized);
                    break;
                }
                case PostgresJson: {
                    PGobject postgresObject = new PGobject();
                    postgresObject.setType("json");
                    postgresObject.setValue(serialized);
                    ps.setObject(index, postgresObject);
                    break;
                }
                case PostgresJsonb: {
                    PGobject postgresObject = new PGobject();
                    postgresObject.setType("jsonb");
                    postgresObject.setValue(serialized);
                    ps.setObject(index, postgresObject);
                }
            }
        }
        catch (Exception ex) {
            throw new JsonMappingException(ex);
        }
    }

    public Object deepCopy(Object value) throws HibernateException {
        return this.json.deserialize(this.json.serialize(value, this.type), this.type);
    }

    public boolean isMutable() {
        return true;
    }

    public Serializable disassemble(Object value) throws HibernateException {
        try {
            return this.json.serialize(value, this.type);
        }
        catch (Exception ex) {
            throw new JsonMappingException(ex);
        }
    }

    public Object assemble(Serializable cached, Object owner) throws HibernateException {
        if (!(cached instanceof String)) {
            throw new HibernateException(String.format("Cached object is not a string: '%s'", cached));
        }
        try {
            return this.json.deserialize((String)((Object)cached), this.type);
        }
        catch (Exception ex) {
            throw new JsonMappingException(ex);
        }
    }

    public Object replace(Object original, Object target, Object owner) throws HibernateException {
        return this.json.deserialize(this.json.serialize(original, this.type), this.type);
    }
}

