/*
 * Decompiled with CFR 0.152.
 */
package net.optionfactory.hj.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.io.SegmentedStringWriter;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.ser.DefaultSerializerProvider;
import java.io.Closeable;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.Arrays;
import net.optionfactory.hj.JsonDriver;
import net.optionfactory.hj.JsonMappingException;
import net.optionfactory.hj.TypeDescriptor;
import net.optionfactory.hj.jackson.JacksonTypeDescriptor;
import net.optionfactory.hj.jackson.reflection.ResolvableType;

public class JacksonJsonDriver
implements JsonDriver {
    private final ObjectMapper mapper;

    public JacksonJsonDriver(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public String serialize(Object value, TypeDescriptor type) {
        try {
            return this.writeValueAsString(value, type.as(JavaType.class));
        }
        catch (JsonProcessingException ex) {
            throw new JsonMappingException(ex);
        }
    }

    @Override
    public Object deserialize(String value, TypeDescriptor type) {
        try {
            return this.mapper.readValue(value, type.as(JavaType.class));
        }
        catch (IOException ex) {
            throw new JsonMappingException(ex);
        }
    }

    @Override
    public JacksonTypeDescriptor fieldType(Field field, Class<?> context) {
        ResolvableType rt = ResolvableType.forField(field, context);
        return new JacksonTypeDescriptor(this.resolvableTypeToJavaType(rt));
    }

    private JavaType resolvableTypeToJavaType(ResolvableType source) {
        JavaType[] generics = (JavaType[])Arrays.stream(source.getGenerics()).map(this::resolvableTypeToJavaType).toArray(JavaType[]::new);
        return this.mapper.getTypeFactory().constructParametricType(source.resolve(), generics);
    }

    private String writeValueAsString(Object value, JavaType type) throws JsonProcessingException {
        String string;
        block12: {
            SegmentedStringWriter sw = new SegmentedStringWriter(this.mapper.getFactory()._getBufferRecycler());
            JsonGenerator g = this.mapper.getFactory().createGenerator((Writer)sw);
            SerializationConfig cfg = this.mapper.getSerializationConfig();
            cfg.initialize(g);
            if (cfg.isEnabled(SerializationFeature.CLOSE_CLOSEABLE) && value instanceof Closeable) {
                this._configAndWriteCloseable(g, value, cfg);
                return sw.getAndClear();
            }
            boolean closed = false;
            try {
                this._serializerProvider(cfg).serializeValue(g, value, type);
                closed = true;
                g.close();
                string = sw.getAndClear();
                if (closed) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (!closed) {
                        g.disable(JsonGenerator.Feature.AUTO_CLOSE_JSON_CONTENT);
                        try {
                            g.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                catch (JsonProcessingException e) {
                    throw e;
                }
                catch (IOException e) {
                    throw com.fasterxml.jackson.databind.JsonMappingException.fromUnexpectedIOE((IOException)e);
                }
            }
            g.disable(JsonGenerator.Feature.AUTO_CLOSE_JSON_CONTENT);
            try {
                g.close();
            }
            catch (IOException iOException) {}
        }
        return string;
    }

    private void _configAndWriteCloseable(JsonGenerator g, Object value, SerializationConfig cfg) throws IOException {
        Closeable toClose = (Closeable)value;
        try {
            this._serializerProvider(cfg).serializeValue(g, value);
            JsonGenerator tmpGen = g;
            g = null;
            tmpGen.close();
            Closeable tmpToClose = toClose;
            toClose = null;
            tmpToClose.close();
        }
        catch (Throwable throwable) {
            if (g != null) {
                g.disable(JsonGenerator.Feature.AUTO_CLOSE_JSON_CONTENT);
                try {
                    g.close();
                }
                catch (IOException iOException) {}
            }
            if (toClose != null) {
                try {
                    toClose.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (g != null) {
            g.disable(JsonGenerator.Feature.AUTO_CLOSE_JSON_CONTENT);
            try {
                g.close();
            }
            catch (IOException iOException) {}
        }
        if (toClose != null) {
            try {
                toClose.close();
            }
            catch (IOException iOException) {}
        }
    }

    private DefaultSerializerProvider _serializerProvider(SerializationConfig cfg) {
        return ((DefaultSerializerProvider)this.mapper.getSerializerProvider()).createInstance(cfg, this.mapper.getSerializerFactory());
    }
}

