/*
 * Decompiled with CFR 0.152.
 */
package net.optionfactory.hj;

import java.io.Serializable;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Optional;
import java.util.Properties;
import net.optionfactory.hj.JsonDriver;
import net.optionfactory.hj.JsonDriverLocator;
import net.optionfactory.hj.JsonMappingException;
import net.optionfactory.hj.TypeDescriptor;
import net.optionfactory.hj.UserTypes;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.usertype.DynamicParameterizedType;
import org.hibernate.usertype.UserType;
import org.postgresql.util.PGobject;

public class JsonType
implements UserType,
DynamicParameterizedType {
    public static final String TYPE = "net.optionfactory.hj.JsonType";
    private JsonDriver json;
    private TypeDescriptor type;
    private ColumnType ct;

    public void setParameterValues(Properties properties) {
        Class<?> declaringClass = UserTypes.entityClass(properties);
        Field field = UserTypes.mappedField(declaringClass, properties);
        JsonDriverLocator locator = UserTypes.makeLocator(field, properties);
        Optional<String> driverName = UserTypes.driverName(field, properties);
        this.json = locator.locate(field.getAnnotations(), driverName);
        this.type = this.json.fieldType(field, declaringClass);
        this.ct = UserTypes.columnType(field, properties);
    }

    public int[] sqlTypes() {
        return this.ct.sqlTypes();
    }

    public Class returnedClass() {
        return this.type.rawClass();
    }

    public boolean equals(Object lhs, Object rhs) throws HibernateException {
        return lhs == null ? rhs == null : lhs.equals(rhs);
    }

    public int hashCode(Object obj) throws HibernateException {
        return obj == null ? 0 : obj.hashCode();
    }

    public Object nullSafeGet(ResultSet rs, String[] names, SessionImplementor si, Object owner) throws HibernateException, SQLException {
        String string = rs.getString(names[0]);
        if (rs.wasNull() || string == null || string.isEmpty()) {
            return null;
        }
        try {
            return this.json.deserialize(string, this.type);
        }
        catch (Exception ex) {
            throw new JsonMappingException(ex);
        }
    }

    public void nullSafeSet(PreparedStatement ps, Object value, int index, SessionImplementor si) throws HibernateException, SQLException {
        if (value == null) {
            ps.setNull(index, this.ct.sqlTypes()[0]);
            return;
        }
        ps.getConnection().getMetaData().getDatabaseProductName();
        try {
            String serialized = this.json.serialize(value, this.type);
            switch (this.ct) {
                case Text: 
                case MysqlJson: {
                    ps.setString(index, serialized);
                    break;
                }
                case PostgresJson: {
                    PGobject postgresObject = new PGobject();
                    postgresObject.setType("json");
                    postgresObject.setValue(serialized);
                    ps.setObject(index, postgresObject);
                    break;
                }
                case PostgresJsonb: {
                    PGobject postgresObject = new PGobject();
                    postgresObject.setType("jsonb");
                    postgresObject.setValue(serialized);
                    ps.setObject(index, postgresObject);
                }
            }
        }
        catch (Exception ex) {
            throw new JsonMappingException(ex);
        }
    }

    public Object deepCopy(Object value) throws HibernateException {
        return value;
    }

    public boolean isMutable() {
        return false;
    }

    public Serializable disassemble(Object value) throws HibernateException {
        try {
            return this.json.serialize(value, this.type);
        }
        catch (Exception ex) {
            throw new JsonMappingException(ex);
        }
    }

    public Object assemble(Serializable cached, Object owner) throws HibernateException {
        if (!(cached instanceof String)) {
            throw new HibernateException(String.format("Cached object is not a string: '%s'", cached));
        }
        try {
            return this.json.deserialize((String)((Object)cached), this.type);
        }
        catch (Exception ex) {
            throw new JsonMappingException(ex);
        }
    }

    public Object replace(Object original, Object target, Object owner) throws HibernateException {
        return original;
    }

    public static enum ColumnType {
        Text(-1),
        MysqlJson(2000),
        PostgresJson(2000),
        PostgresJsonb(1111);

        private final int[] sqlType;

        private ColumnType(int sqlType) {
            this.sqlType = new int[]{sqlType};
        }

        public int[] sqlTypes() {
            return this.sqlType;
        }
    }

    @Target(value={ElementType.FIELD, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Conf {
        public String driver() default "";

        public Class<? extends JsonDriverLocator> locator();

        public ColumnType type() default ColumnType.Text;
    }
}

