/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.koloboke.collect.set.hash;

import net.openhft.koloboke.collect.*;
import net.openhft.koloboke.collect.hash.*;
import java.util.function.Consumer;
import net.openhft.koloboke.collect.set.LongSetFactory;

import javax.annotation.Nonnull;

import java.util.Iterator;


/**
 * An immutable factory of {@code HashLongSet}s.
 *
 * @see HashLongSet
 * @see HashLongSets#getDefaultFactory()
 */
public interface HashLongSetFactory
        extends LongSetFactory<HashLongSetFactory>
        , LongHashFactory<HashLongSetFactory>
         {



    

    

    

    @Override
    @Nonnull
     HashLongSet newMutableSet();

    @Override
    @Nonnull
     HashLongSet newMutableSet(int expectedSize);

    

    @Override
    @Nonnull
     HashLongSet newMutableSet(@Nonnull Iterable<Long> elements, int expectedSize);

    @Override
    @Nonnull
     HashLongSet newMutableSet(@Nonnull Iterable<Long> elems1,
            @Nonnull Iterable<Long> elems2, int expectedSize);

    @Override
    @Nonnull
     HashLongSet newMutableSet(@Nonnull Iterable<Long> elems1,
            @Nonnull Iterable<Long> elems2,
            @Nonnull Iterable<Long> elems3, int expectedSize);

    @Override
    @Nonnull
     HashLongSet newMutableSet(@Nonnull Iterable<Long> elems1,
            @Nonnull Iterable<Long> elems2,
            @Nonnull Iterable<Long> elems3,
            @Nonnull Iterable<Long> elems4, int expectedSize);

    @Override
    @Nonnull
     HashLongSet newMutableSet(@Nonnull Iterable<Long> elems1,
            @Nonnull Iterable<Long> elems2,
            @Nonnull Iterable<Long> elems3,
            @Nonnull Iterable<Long> elems4,
            @Nonnull Iterable<Long> elems5, int expectedSize);

    @Override
    @Nonnull
     HashLongSet newMutableSet(@Nonnull Iterator<Long> elements, int expectedSize);

    @Override
    @Nonnull
     HashLongSet newMutableSet(@Nonnull
            Consumer<net.openhft.koloboke.function.LongConsumer> elementsSupplier
            , int expectedSize);

    

    @Override
    @Nonnull
     HashLongSet newMutableSet(@Nonnull long[] elements, int expectedSize);

    @Override
    @Nonnull
     HashLongSet newMutableSet(@Nonnull Long[] elements, int expectedSize);

    

    @Override
    @Nonnull
     HashLongSet newMutableSet(@Nonnull Iterable<Long> elements);

    @Override
    @Nonnull
     HashLongSet newMutableSet(@Nonnull Iterable<Long> elems1,
            @Nonnull Iterable<Long> elems2);

    @Override
    @Nonnull
     HashLongSet newMutableSet(@Nonnull Iterable<Long> elems1,
            @Nonnull Iterable<Long> elems2,
            @Nonnull Iterable<Long> elems3);

    @Override
    @Nonnull
     HashLongSet newMutableSet(@Nonnull Iterable<Long> elems1,
            @Nonnull Iterable<Long> elems2,
            @Nonnull Iterable<Long> elems3,
            @Nonnull Iterable<Long> elems4);

    @Override
    @Nonnull
     HashLongSet newMutableSet(@Nonnull Iterable<Long> elems1,
            @Nonnull Iterable<Long> elems2,
            @Nonnull Iterable<Long> elems3,
            @Nonnull Iterable<Long> elems4,
            @Nonnull Iterable<Long> elems5);

    @Override
    @Nonnull
     HashLongSet newMutableSet(@Nonnull Iterator<Long> elements);

    @Override
    @Nonnull
     HashLongSet newMutableSet(@Nonnull
            Consumer<net.openhft.koloboke.function.LongConsumer> elementsSupplier
            );

    

    @Override
    @Nonnull
     HashLongSet newMutableSet(@Nonnull long[] elements);

    @Override
    @Nonnull
     HashLongSet newMutableSet(@Nonnull Long[] elements);


    @Override
    @Nonnull
     HashLongSet newMutableSetOf(long e1);

    @Override
    @Nonnull
     HashLongSet newMutableSetOf(long e1, long e2);

    @Override
    @Nonnull
     HashLongSet newMutableSetOf(long e1, long e2,
            long e3);

    @Override
    @Nonnull
     HashLongSet newMutableSetOf(long e1, long e2,
            long e3, long e4);

    @Override
    @Nonnull
     HashLongSet newMutableSetOf(long e1, long e2,
            long e3, long e4, long e5,
            long... restElements);
    @Override
    @Nonnull
     HashLongSet newUpdatableSet();

    @Override
    @Nonnull
     HashLongSet newUpdatableSet(int expectedSize);

    

    @Override
    @Nonnull
     HashLongSet newUpdatableSet(@Nonnull Iterable<Long> elements, int expectedSize);

    @Override
    @Nonnull
     HashLongSet newUpdatableSet(@Nonnull Iterable<Long> elems1,
            @Nonnull Iterable<Long> elems2, int expectedSize);

    @Override
    @Nonnull
     HashLongSet newUpdatableSet(@Nonnull Iterable<Long> elems1,
            @Nonnull Iterable<Long> elems2,
            @Nonnull Iterable<Long> elems3, int expectedSize);

    @Override
    @Nonnull
     HashLongSet newUpdatableSet(@Nonnull Iterable<Long> elems1,
            @Nonnull Iterable<Long> elems2,
            @Nonnull Iterable<Long> elems3,
            @Nonnull Iterable<Long> elems4, int expectedSize);

    @Override
    @Nonnull
     HashLongSet newUpdatableSet(@Nonnull Iterable<Long> elems1,
            @Nonnull Iterable<Long> elems2,
            @Nonnull Iterable<Long> elems3,
            @Nonnull Iterable<Long> elems4,
            @Nonnull Iterable<Long> elems5, int expectedSize);

    @Override
    @Nonnull
     HashLongSet newUpdatableSet(@Nonnull Iterator<Long> elements, int expectedSize);

    @Override
    @Nonnull
     HashLongSet newUpdatableSet(@Nonnull
            Consumer<net.openhft.koloboke.function.LongConsumer> elementsSupplier
            , int expectedSize);

    

    @Override
    @Nonnull
     HashLongSet newUpdatableSet(@Nonnull long[] elements, int expectedSize);

    @Override
    @Nonnull
     HashLongSet newUpdatableSet(@Nonnull Long[] elements, int expectedSize);

    

    @Override
    @Nonnull
     HashLongSet newUpdatableSet(@Nonnull Iterable<Long> elements);

    @Override
    @Nonnull
     HashLongSet newUpdatableSet(@Nonnull Iterable<Long> elems1,
            @Nonnull Iterable<Long> elems2);

    @Override
    @Nonnull
     HashLongSet newUpdatableSet(@Nonnull Iterable<Long> elems1,
            @Nonnull Iterable<Long> elems2,
            @Nonnull Iterable<Long> elems3);

    @Override
    @Nonnull
     HashLongSet newUpdatableSet(@Nonnull Iterable<Long> elems1,
            @Nonnull Iterable<Long> elems2,
            @Nonnull Iterable<Long> elems3,
            @Nonnull Iterable<Long> elems4);

    @Override
    @Nonnull
     HashLongSet newUpdatableSet(@Nonnull Iterable<Long> elems1,
            @Nonnull Iterable<Long> elems2,
            @Nonnull Iterable<Long> elems3,
            @Nonnull Iterable<Long> elems4,
            @Nonnull Iterable<Long> elems5);

    @Override
    @Nonnull
     HashLongSet newUpdatableSet(@Nonnull Iterator<Long> elements);

    @Override
    @Nonnull
     HashLongSet newUpdatableSet(@Nonnull
            Consumer<net.openhft.koloboke.function.LongConsumer> elementsSupplier
            );

    

    @Override
    @Nonnull
     HashLongSet newUpdatableSet(@Nonnull long[] elements);

    @Override
    @Nonnull
     HashLongSet newUpdatableSet(@Nonnull Long[] elements);


    @Override
    @Nonnull
     HashLongSet newUpdatableSetOf(long e1);

    @Override
    @Nonnull
     HashLongSet newUpdatableSetOf(long e1, long e2);

    @Override
    @Nonnull
     HashLongSet newUpdatableSetOf(long e1, long e2,
            long e3);

    @Override
    @Nonnull
     HashLongSet newUpdatableSetOf(long e1, long e2,
            long e3, long e4);

    @Override
    @Nonnull
     HashLongSet newUpdatableSetOf(long e1, long e2,
            long e3, long e4, long e5,
            long... restElements);

    

    @Override
    @Nonnull
     HashLongSet newImmutableSet(@Nonnull Iterable<Long> elements, int expectedSize);

    @Override
    @Nonnull
     HashLongSet newImmutableSet(@Nonnull Iterable<Long> elems1,
            @Nonnull Iterable<Long> elems2, int expectedSize);

    @Override
    @Nonnull
     HashLongSet newImmutableSet(@Nonnull Iterable<Long> elems1,
            @Nonnull Iterable<Long> elems2,
            @Nonnull Iterable<Long> elems3, int expectedSize);

    @Override
    @Nonnull
     HashLongSet newImmutableSet(@Nonnull Iterable<Long> elems1,
            @Nonnull Iterable<Long> elems2,
            @Nonnull Iterable<Long> elems3,
            @Nonnull Iterable<Long> elems4, int expectedSize);

    @Override
    @Nonnull
     HashLongSet newImmutableSet(@Nonnull Iterable<Long> elems1,
            @Nonnull Iterable<Long> elems2,
            @Nonnull Iterable<Long> elems3,
            @Nonnull Iterable<Long> elems4,
            @Nonnull Iterable<Long> elems5, int expectedSize);

    @Override
    @Nonnull
     HashLongSet newImmutableSet(@Nonnull Iterator<Long> elements, int expectedSize);

    @Override
    @Nonnull
     HashLongSet newImmutableSet(@Nonnull
            Consumer<net.openhft.koloboke.function.LongConsumer> elementsSupplier
            , int expectedSize);

    

    @Override
    @Nonnull
     HashLongSet newImmutableSet(@Nonnull long[] elements, int expectedSize);

    @Override
    @Nonnull
     HashLongSet newImmutableSet(@Nonnull Long[] elements, int expectedSize);

    

    @Override
    @Nonnull
     HashLongSet newImmutableSet(@Nonnull Iterable<Long> elements);

    @Override
    @Nonnull
     HashLongSet newImmutableSet(@Nonnull Iterable<Long> elems1,
            @Nonnull Iterable<Long> elems2);

    @Override
    @Nonnull
     HashLongSet newImmutableSet(@Nonnull Iterable<Long> elems1,
            @Nonnull Iterable<Long> elems2,
            @Nonnull Iterable<Long> elems3);

    @Override
    @Nonnull
     HashLongSet newImmutableSet(@Nonnull Iterable<Long> elems1,
            @Nonnull Iterable<Long> elems2,
            @Nonnull Iterable<Long> elems3,
            @Nonnull Iterable<Long> elems4);

    @Override
    @Nonnull
     HashLongSet newImmutableSet(@Nonnull Iterable<Long> elems1,
            @Nonnull Iterable<Long> elems2,
            @Nonnull Iterable<Long> elems3,
            @Nonnull Iterable<Long> elems4,
            @Nonnull Iterable<Long> elems5);

    @Override
    @Nonnull
     HashLongSet newImmutableSet(@Nonnull Iterator<Long> elements);

    @Override
    @Nonnull
     HashLongSet newImmutableSet(@Nonnull
            Consumer<net.openhft.koloboke.function.LongConsumer> elementsSupplier
            );

    

    @Override
    @Nonnull
     HashLongSet newImmutableSet(@Nonnull long[] elements);

    @Override
    @Nonnull
     HashLongSet newImmutableSet(@Nonnull Long[] elements);


    @Override
    @Nonnull
     HashLongSet newImmutableSetOf(long e1);

    @Override
    @Nonnull
     HashLongSet newImmutableSetOf(long e1, long e2);

    @Override
    @Nonnull
     HashLongSet newImmutableSetOf(long e1, long e2,
            long e3);

    @Override
    @Nonnull
     HashLongSet newImmutableSetOf(long e1, long e2,
            long e3, long e4);

    @Override
    @Nonnull
     HashLongSet newImmutableSetOf(long e1, long e2,
            long e3, long e4, long e5,
            long... restElements);
}

