/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.koloboke.collect.map.hash;

import net.openhft.koloboke.collect.*;
import net.openhft.koloboke.collect.hash.*;
import java.util.function.Consumer;
import net.openhft.koloboke.collect.map.*;

import javax.annotation.Nonnull;

import java.util.Map;



/**
 * An immutable factory of {@code HashIntShortMap}s.
 *
 * @see HashIntShortMap
 * @see HashIntShortMaps#getDefaultFactory()
 */
public interface HashIntShortMapFactory
        extends IntShortMapFactory<HashIntShortMapFactory>
        , IntHashFactory<HashIntShortMapFactory>
        {


    

    

    

    

    

    
    

    
    


    @Override
    @Nonnull
     HashIntShortMap newMutableMap();

    @Override
    @Nonnull
     HashIntShortMap newMutableMap(int expectedSize);

    


    @Override
    @Nonnull
     HashIntShortMap newMutableMap(@Nonnull Map<Integer, Short> map1,
            @Nonnull Map<Integer, Short> map2, int expectedSize);

    @Override
    @Nonnull
     HashIntShortMap newMutableMap(@Nonnull Map<Integer, Short> map1,
            @Nonnull Map<Integer, Short> map2,
            @Nonnull Map<Integer, Short> map3, int expectedSize);

    @Override
    @Nonnull
     HashIntShortMap newMutableMap(@Nonnull Map<Integer, Short> map1,
            @Nonnull Map<Integer, Short> map2,
            @Nonnull Map<Integer, Short> map3,
            @Nonnull Map<Integer, Short> map4, int expectedSize);

    @Override
    @Nonnull
     HashIntShortMap newMutableMap(@Nonnull Map<Integer, Short> map1,
            @Nonnull Map<Integer, Short> map2,
            @Nonnull Map<Integer, Short> map3,
            @Nonnull Map<Integer, Short> map4,
            @Nonnull Map<Integer, Short> map5, int expectedSize);



    @Override
    @Nonnull
     HashIntShortMap newMutableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.IntShortConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashIntShortMap newMutableMap(
            @Nonnull int[] keys, @Nonnull short[] values, int expectedSize);

    @Override
    @Nonnull
     HashIntShortMap newMutableMap(
            @Nonnull Integer[] keys, @Nonnull Short[] values, int expectedSize);

    @Override
    @Nonnull
     HashIntShortMap newMutableMap(@Nonnull Iterable<Integer> keys,
            @Nonnull Iterable<Short> values, int expectedSize);

    

    @Override
    @Nonnull
     HashIntShortMap newMutableMap(
            @Nonnull Map<Integer, Short> map);

    @Override
    @Nonnull
     HashIntShortMap newMutableMap(@Nonnull Map<Integer, Short> map1,
            @Nonnull Map<Integer, Short> map2);

    @Override
    @Nonnull
     HashIntShortMap newMutableMap(@Nonnull Map<Integer, Short> map1,
            @Nonnull Map<Integer, Short> map2,
            @Nonnull Map<Integer, Short> map3);

    @Override
    @Nonnull
     HashIntShortMap newMutableMap(@Nonnull Map<Integer, Short> map1,
            @Nonnull Map<Integer, Short> map2,
            @Nonnull Map<Integer, Short> map3,
            @Nonnull Map<Integer, Short> map4);

    @Override
    @Nonnull
     HashIntShortMap newMutableMap(@Nonnull Map<Integer, Short> map1,
            @Nonnull Map<Integer, Short> map2,
            @Nonnull Map<Integer, Short> map3,
            @Nonnull Map<Integer, Short> map4,
            @Nonnull Map<Integer, Short> map5);



    @Override
    @Nonnull
     HashIntShortMap newMutableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.IntShortConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashIntShortMap newMutableMap(
            @Nonnull int[] keys, @Nonnull short[] values);

    @Override
    @Nonnull
     HashIntShortMap newMutableMap(
            @Nonnull Integer[] keys, @Nonnull Short[] values);

    @Override
    @Nonnull
     HashIntShortMap newMutableMap(@Nonnull Iterable<Integer> keys,
            @Nonnull Iterable<Short> values);


    @Override
    @Nonnull
     HashIntShortMap newMutableMapOf(int k1, short v1);

    @Override
    @Nonnull
     HashIntShortMap newMutableMapOf(int k1, short v1,
            int k2, short v2);

    @Override
    @Nonnull
     HashIntShortMap newMutableMapOf(int k1, short v1,
            int k2, short v2, int k3, short v3);

    @Override
    @Nonnull
     HashIntShortMap newMutableMapOf(int k1, short v1,
            int k2, short v2, int k3, short v3,
            int k4, short v4);

    @Override
    @Nonnull
     HashIntShortMap newMutableMapOf(int k1, short v1,
            int k2, short v2, int k3, short v3,
            int k4, short v4, int k5, short v5);
    @Override
    @Nonnull
     HashIntShortMap newUpdatableMap();

    @Override
    @Nonnull
     HashIntShortMap newUpdatableMap(int expectedSize);

    


    @Override
    @Nonnull
     HashIntShortMap newUpdatableMap(@Nonnull Map<Integer, Short> map1,
            @Nonnull Map<Integer, Short> map2, int expectedSize);

    @Override
    @Nonnull
     HashIntShortMap newUpdatableMap(@Nonnull Map<Integer, Short> map1,
            @Nonnull Map<Integer, Short> map2,
            @Nonnull Map<Integer, Short> map3, int expectedSize);

    @Override
    @Nonnull
     HashIntShortMap newUpdatableMap(@Nonnull Map<Integer, Short> map1,
            @Nonnull Map<Integer, Short> map2,
            @Nonnull Map<Integer, Short> map3,
            @Nonnull Map<Integer, Short> map4, int expectedSize);

    @Override
    @Nonnull
     HashIntShortMap newUpdatableMap(@Nonnull Map<Integer, Short> map1,
            @Nonnull Map<Integer, Short> map2,
            @Nonnull Map<Integer, Short> map3,
            @Nonnull Map<Integer, Short> map4,
            @Nonnull Map<Integer, Short> map5, int expectedSize);



    @Override
    @Nonnull
     HashIntShortMap newUpdatableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.IntShortConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashIntShortMap newUpdatableMap(
            @Nonnull int[] keys, @Nonnull short[] values, int expectedSize);

    @Override
    @Nonnull
     HashIntShortMap newUpdatableMap(
            @Nonnull Integer[] keys, @Nonnull Short[] values, int expectedSize);

    @Override
    @Nonnull
     HashIntShortMap newUpdatableMap(@Nonnull Iterable<Integer> keys,
            @Nonnull Iterable<Short> values, int expectedSize);

    

    @Override
    @Nonnull
     HashIntShortMap newUpdatableMap(
            @Nonnull Map<Integer, Short> map);

    @Override
    @Nonnull
     HashIntShortMap newUpdatableMap(@Nonnull Map<Integer, Short> map1,
            @Nonnull Map<Integer, Short> map2);

    @Override
    @Nonnull
     HashIntShortMap newUpdatableMap(@Nonnull Map<Integer, Short> map1,
            @Nonnull Map<Integer, Short> map2,
            @Nonnull Map<Integer, Short> map3);

    @Override
    @Nonnull
     HashIntShortMap newUpdatableMap(@Nonnull Map<Integer, Short> map1,
            @Nonnull Map<Integer, Short> map2,
            @Nonnull Map<Integer, Short> map3,
            @Nonnull Map<Integer, Short> map4);

    @Override
    @Nonnull
     HashIntShortMap newUpdatableMap(@Nonnull Map<Integer, Short> map1,
            @Nonnull Map<Integer, Short> map2,
            @Nonnull Map<Integer, Short> map3,
            @Nonnull Map<Integer, Short> map4,
            @Nonnull Map<Integer, Short> map5);



    @Override
    @Nonnull
     HashIntShortMap newUpdatableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.IntShortConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashIntShortMap newUpdatableMap(
            @Nonnull int[] keys, @Nonnull short[] values);

    @Override
    @Nonnull
     HashIntShortMap newUpdatableMap(
            @Nonnull Integer[] keys, @Nonnull Short[] values);

    @Override
    @Nonnull
     HashIntShortMap newUpdatableMap(@Nonnull Iterable<Integer> keys,
            @Nonnull Iterable<Short> values);


    @Override
    @Nonnull
     HashIntShortMap newUpdatableMapOf(int k1, short v1);

    @Override
    @Nonnull
     HashIntShortMap newUpdatableMapOf(int k1, short v1,
            int k2, short v2);

    @Override
    @Nonnull
     HashIntShortMap newUpdatableMapOf(int k1, short v1,
            int k2, short v2, int k3, short v3);

    @Override
    @Nonnull
     HashIntShortMap newUpdatableMapOf(int k1, short v1,
            int k2, short v2, int k3, short v3,
            int k4, short v4);

    @Override
    @Nonnull
     HashIntShortMap newUpdatableMapOf(int k1, short v1,
            int k2, short v2, int k3, short v3,
            int k4, short v4, int k5, short v5);

    


    @Override
    @Nonnull
     HashIntShortMap newImmutableMap(@Nonnull Map<Integer, Short> map1,
            @Nonnull Map<Integer, Short> map2, int expectedSize);

    @Override
    @Nonnull
     HashIntShortMap newImmutableMap(@Nonnull Map<Integer, Short> map1,
            @Nonnull Map<Integer, Short> map2,
            @Nonnull Map<Integer, Short> map3, int expectedSize);

    @Override
    @Nonnull
     HashIntShortMap newImmutableMap(@Nonnull Map<Integer, Short> map1,
            @Nonnull Map<Integer, Short> map2,
            @Nonnull Map<Integer, Short> map3,
            @Nonnull Map<Integer, Short> map4, int expectedSize);

    @Override
    @Nonnull
     HashIntShortMap newImmutableMap(@Nonnull Map<Integer, Short> map1,
            @Nonnull Map<Integer, Short> map2,
            @Nonnull Map<Integer, Short> map3,
            @Nonnull Map<Integer, Short> map4,
            @Nonnull Map<Integer, Short> map5, int expectedSize);



    @Override
    @Nonnull
     HashIntShortMap newImmutableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.IntShortConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashIntShortMap newImmutableMap(
            @Nonnull int[] keys, @Nonnull short[] values, int expectedSize);

    @Override
    @Nonnull
     HashIntShortMap newImmutableMap(
            @Nonnull Integer[] keys, @Nonnull Short[] values, int expectedSize);

    @Override
    @Nonnull
     HashIntShortMap newImmutableMap(@Nonnull Iterable<Integer> keys,
            @Nonnull Iterable<Short> values, int expectedSize);

    

    @Override
    @Nonnull
     HashIntShortMap newImmutableMap(
            @Nonnull Map<Integer, Short> map);

    @Override
    @Nonnull
     HashIntShortMap newImmutableMap(@Nonnull Map<Integer, Short> map1,
            @Nonnull Map<Integer, Short> map2);

    @Override
    @Nonnull
     HashIntShortMap newImmutableMap(@Nonnull Map<Integer, Short> map1,
            @Nonnull Map<Integer, Short> map2,
            @Nonnull Map<Integer, Short> map3);

    @Override
    @Nonnull
     HashIntShortMap newImmutableMap(@Nonnull Map<Integer, Short> map1,
            @Nonnull Map<Integer, Short> map2,
            @Nonnull Map<Integer, Short> map3,
            @Nonnull Map<Integer, Short> map4);

    @Override
    @Nonnull
     HashIntShortMap newImmutableMap(@Nonnull Map<Integer, Short> map1,
            @Nonnull Map<Integer, Short> map2,
            @Nonnull Map<Integer, Short> map3,
            @Nonnull Map<Integer, Short> map4,
            @Nonnull Map<Integer, Short> map5);



    @Override
    @Nonnull
     HashIntShortMap newImmutableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.IntShortConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashIntShortMap newImmutableMap(
            @Nonnull int[] keys, @Nonnull short[] values);

    @Override
    @Nonnull
     HashIntShortMap newImmutableMap(
            @Nonnull Integer[] keys, @Nonnull Short[] values);

    @Override
    @Nonnull
     HashIntShortMap newImmutableMap(@Nonnull Iterable<Integer> keys,
            @Nonnull Iterable<Short> values);


    @Override
    @Nonnull
     HashIntShortMap newImmutableMapOf(int k1, short v1);

    @Override
    @Nonnull
     HashIntShortMap newImmutableMapOf(int k1, short v1,
            int k2, short v2);

    @Override
    @Nonnull
     HashIntShortMap newImmutableMapOf(int k1, short v1,
            int k2, short v2, int k3, short v3);

    @Override
    @Nonnull
     HashIntShortMap newImmutableMapOf(int k1, short v1,
            int k2, short v2, int k3, short v3,
            int k4, short v4);

    @Override
    @Nonnull
     HashIntShortMap newImmutableMapOf(int k1, short v1,
            int k2, short v2, int k3, short v3,
            int k4, short v4, int k5, short v5);
}

