/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.koloboke.collect.map.hash;

import net.openhft.koloboke.collect.*;
import net.openhft.koloboke.collect.hash.*;
import java.util.function.Consumer;
import net.openhft.koloboke.collect.map.*;

import javax.annotation.Nonnull;

import java.util.Map;



/**
 * An immutable factory of {@code HashIntByteMap}s.
 *
 * @see HashIntByteMap
 * @see HashIntByteMaps#getDefaultFactory()
 */
public interface HashIntByteMapFactory
        extends IntByteMapFactory<HashIntByteMapFactory>
        , IntHashFactory<HashIntByteMapFactory>
        {


    

    

    

    

    

    
    

    
    


    @Override
    @Nonnull
     HashIntByteMap newMutableMap();

    @Override
    @Nonnull
     HashIntByteMap newMutableMap(int expectedSize);

    


    @Override
    @Nonnull
     HashIntByteMap newMutableMap(@Nonnull Map<Integer, Byte> map1,
            @Nonnull Map<Integer, Byte> map2, int expectedSize);

    @Override
    @Nonnull
     HashIntByteMap newMutableMap(@Nonnull Map<Integer, Byte> map1,
            @Nonnull Map<Integer, Byte> map2,
            @Nonnull Map<Integer, Byte> map3, int expectedSize);

    @Override
    @Nonnull
     HashIntByteMap newMutableMap(@Nonnull Map<Integer, Byte> map1,
            @Nonnull Map<Integer, Byte> map2,
            @Nonnull Map<Integer, Byte> map3,
            @Nonnull Map<Integer, Byte> map4, int expectedSize);

    @Override
    @Nonnull
     HashIntByteMap newMutableMap(@Nonnull Map<Integer, Byte> map1,
            @Nonnull Map<Integer, Byte> map2,
            @Nonnull Map<Integer, Byte> map3,
            @Nonnull Map<Integer, Byte> map4,
            @Nonnull Map<Integer, Byte> map5, int expectedSize);



    @Override
    @Nonnull
     HashIntByteMap newMutableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.IntByteConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashIntByteMap newMutableMap(
            @Nonnull int[] keys, @Nonnull byte[] values, int expectedSize);

    @Override
    @Nonnull
     HashIntByteMap newMutableMap(
            @Nonnull Integer[] keys, @Nonnull Byte[] values, int expectedSize);

    @Override
    @Nonnull
     HashIntByteMap newMutableMap(@Nonnull Iterable<Integer> keys,
            @Nonnull Iterable<Byte> values, int expectedSize);

    

    @Override
    @Nonnull
     HashIntByteMap newMutableMap(
            @Nonnull Map<Integer, Byte> map);

    @Override
    @Nonnull
     HashIntByteMap newMutableMap(@Nonnull Map<Integer, Byte> map1,
            @Nonnull Map<Integer, Byte> map2);

    @Override
    @Nonnull
     HashIntByteMap newMutableMap(@Nonnull Map<Integer, Byte> map1,
            @Nonnull Map<Integer, Byte> map2,
            @Nonnull Map<Integer, Byte> map3);

    @Override
    @Nonnull
     HashIntByteMap newMutableMap(@Nonnull Map<Integer, Byte> map1,
            @Nonnull Map<Integer, Byte> map2,
            @Nonnull Map<Integer, Byte> map3,
            @Nonnull Map<Integer, Byte> map4);

    @Override
    @Nonnull
     HashIntByteMap newMutableMap(@Nonnull Map<Integer, Byte> map1,
            @Nonnull Map<Integer, Byte> map2,
            @Nonnull Map<Integer, Byte> map3,
            @Nonnull Map<Integer, Byte> map4,
            @Nonnull Map<Integer, Byte> map5);



    @Override
    @Nonnull
     HashIntByteMap newMutableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.IntByteConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashIntByteMap newMutableMap(
            @Nonnull int[] keys, @Nonnull byte[] values);

    @Override
    @Nonnull
     HashIntByteMap newMutableMap(
            @Nonnull Integer[] keys, @Nonnull Byte[] values);

    @Override
    @Nonnull
     HashIntByteMap newMutableMap(@Nonnull Iterable<Integer> keys,
            @Nonnull Iterable<Byte> values);


    @Override
    @Nonnull
     HashIntByteMap newMutableMapOf(int k1, byte v1);

    @Override
    @Nonnull
     HashIntByteMap newMutableMapOf(int k1, byte v1,
            int k2, byte v2);

    @Override
    @Nonnull
     HashIntByteMap newMutableMapOf(int k1, byte v1,
            int k2, byte v2, int k3, byte v3);

    @Override
    @Nonnull
     HashIntByteMap newMutableMapOf(int k1, byte v1,
            int k2, byte v2, int k3, byte v3,
            int k4, byte v4);

    @Override
    @Nonnull
     HashIntByteMap newMutableMapOf(int k1, byte v1,
            int k2, byte v2, int k3, byte v3,
            int k4, byte v4, int k5, byte v5);
    @Override
    @Nonnull
     HashIntByteMap newUpdatableMap();

    @Override
    @Nonnull
     HashIntByteMap newUpdatableMap(int expectedSize);

    


    @Override
    @Nonnull
     HashIntByteMap newUpdatableMap(@Nonnull Map<Integer, Byte> map1,
            @Nonnull Map<Integer, Byte> map2, int expectedSize);

    @Override
    @Nonnull
     HashIntByteMap newUpdatableMap(@Nonnull Map<Integer, Byte> map1,
            @Nonnull Map<Integer, Byte> map2,
            @Nonnull Map<Integer, Byte> map3, int expectedSize);

    @Override
    @Nonnull
     HashIntByteMap newUpdatableMap(@Nonnull Map<Integer, Byte> map1,
            @Nonnull Map<Integer, Byte> map2,
            @Nonnull Map<Integer, Byte> map3,
            @Nonnull Map<Integer, Byte> map4, int expectedSize);

    @Override
    @Nonnull
     HashIntByteMap newUpdatableMap(@Nonnull Map<Integer, Byte> map1,
            @Nonnull Map<Integer, Byte> map2,
            @Nonnull Map<Integer, Byte> map3,
            @Nonnull Map<Integer, Byte> map4,
            @Nonnull Map<Integer, Byte> map5, int expectedSize);



    @Override
    @Nonnull
     HashIntByteMap newUpdatableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.IntByteConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashIntByteMap newUpdatableMap(
            @Nonnull int[] keys, @Nonnull byte[] values, int expectedSize);

    @Override
    @Nonnull
     HashIntByteMap newUpdatableMap(
            @Nonnull Integer[] keys, @Nonnull Byte[] values, int expectedSize);

    @Override
    @Nonnull
     HashIntByteMap newUpdatableMap(@Nonnull Iterable<Integer> keys,
            @Nonnull Iterable<Byte> values, int expectedSize);

    

    @Override
    @Nonnull
     HashIntByteMap newUpdatableMap(
            @Nonnull Map<Integer, Byte> map);

    @Override
    @Nonnull
     HashIntByteMap newUpdatableMap(@Nonnull Map<Integer, Byte> map1,
            @Nonnull Map<Integer, Byte> map2);

    @Override
    @Nonnull
     HashIntByteMap newUpdatableMap(@Nonnull Map<Integer, Byte> map1,
            @Nonnull Map<Integer, Byte> map2,
            @Nonnull Map<Integer, Byte> map3);

    @Override
    @Nonnull
     HashIntByteMap newUpdatableMap(@Nonnull Map<Integer, Byte> map1,
            @Nonnull Map<Integer, Byte> map2,
            @Nonnull Map<Integer, Byte> map3,
            @Nonnull Map<Integer, Byte> map4);

    @Override
    @Nonnull
     HashIntByteMap newUpdatableMap(@Nonnull Map<Integer, Byte> map1,
            @Nonnull Map<Integer, Byte> map2,
            @Nonnull Map<Integer, Byte> map3,
            @Nonnull Map<Integer, Byte> map4,
            @Nonnull Map<Integer, Byte> map5);



    @Override
    @Nonnull
     HashIntByteMap newUpdatableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.IntByteConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashIntByteMap newUpdatableMap(
            @Nonnull int[] keys, @Nonnull byte[] values);

    @Override
    @Nonnull
     HashIntByteMap newUpdatableMap(
            @Nonnull Integer[] keys, @Nonnull Byte[] values);

    @Override
    @Nonnull
     HashIntByteMap newUpdatableMap(@Nonnull Iterable<Integer> keys,
            @Nonnull Iterable<Byte> values);


    @Override
    @Nonnull
     HashIntByteMap newUpdatableMapOf(int k1, byte v1);

    @Override
    @Nonnull
     HashIntByteMap newUpdatableMapOf(int k1, byte v1,
            int k2, byte v2);

    @Override
    @Nonnull
     HashIntByteMap newUpdatableMapOf(int k1, byte v1,
            int k2, byte v2, int k3, byte v3);

    @Override
    @Nonnull
     HashIntByteMap newUpdatableMapOf(int k1, byte v1,
            int k2, byte v2, int k3, byte v3,
            int k4, byte v4);

    @Override
    @Nonnull
     HashIntByteMap newUpdatableMapOf(int k1, byte v1,
            int k2, byte v2, int k3, byte v3,
            int k4, byte v4, int k5, byte v5);

    


    @Override
    @Nonnull
     HashIntByteMap newImmutableMap(@Nonnull Map<Integer, Byte> map1,
            @Nonnull Map<Integer, Byte> map2, int expectedSize);

    @Override
    @Nonnull
     HashIntByteMap newImmutableMap(@Nonnull Map<Integer, Byte> map1,
            @Nonnull Map<Integer, Byte> map2,
            @Nonnull Map<Integer, Byte> map3, int expectedSize);

    @Override
    @Nonnull
     HashIntByteMap newImmutableMap(@Nonnull Map<Integer, Byte> map1,
            @Nonnull Map<Integer, Byte> map2,
            @Nonnull Map<Integer, Byte> map3,
            @Nonnull Map<Integer, Byte> map4, int expectedSize);

    @Override
    @Nonnull
     HashIntByteMap newImmutableMap(@Nonnull Map<Integer, Byte> map1,
            @Nonnull Map<Integer, Byte> map2,
            @Nonnull Map<Integer, Byte> map3,
            @Nonnull Map<Integer, Byte> map4,
            @Nonnull Map<Integer, Byte> map5, int expectedSize);



    @Override
    @Nonnull
     HashIntByteMap newImmutableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.IntByteConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashIntByteMap newImmutableMap(
            @Nonnull int[] keys, @Nonnull byte[] values, int expectedSize);

    @Override
    @Nonnull
     HashIntByteMap newImmutableMap(
            @Nonnull Integer[] keys, @Nonnull Byte[] values, int expectedSize);

    @Override
    @Nonnull
     HashIntByteMap newImmutableMap(@Nonnull Iterable<Integer> keys,
            @Nonnull Iterable<Byte> values, int expectedSize);

    

    @Override
    @Nonnull
     HashIntByteMap newImmutableMap(
            @Nonnull Map<Integer, Byte> map);

    @Override
    @Nonnull
     HashIntByteMap newImmutableMap(@Nonnull Map<Integer, Byte> map1,
            @Nonnull Map<Integer, Byte> map2);

    @Override
    @Nonnull
     HashIntByteMap newImmutableMap(@Nonnull Map<Integer, Byte> map1,
            @Nonnull Map<Integer, Byte> map2,
            @Nonnull Map<Integer, Byte> map3);

    @Override
    @Nonnull
     HashIntByteMap newImmutableMap(@Nonnull Map<Integer, Byte> map1,
            @Nonnull Map<Integer, Byte> map2,
            @Nonnull Map<Integer, Byte> map3,
            @Nonnull Map<Integer, Byte> map4);

    @Override
    @Nonnull
     HashIntByteMap newImmutableMap(@Nonnull Map<Integer, Byte> map1,
            @Nonnull Map<Integer, Byte> map2,
            @Nonnull Map<Integer, Byte> map3,
            @Nonnull Map<Integer, Byte> map4,
            @Nonnull Map<Integer, Byte> map5);



    @Override
    @Nonnull
     HashIntByteMap newImmutableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.IntByteConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashIntByteMap newImmutableMap(
            @Nonnull int[] keys, @Nonnull byte[] values);

    @Override
    @Nonnull
     HashIntByteMap newImmutableMap(
            @Nonnull Integer[] keys, @Nonnull Byte[] values);

    @Override
    @Nonnull
     HashIntByteMap newImmutableMap(@Nonnull Iterable<Integer> keys,
            @Nonnull Iterable<Byte> values);


    @Override
    @Nonnull
     HashIntByteMap newImmutableMapOf(int k1, byte v1);

    @Override
    @Nonnull
     HashIntByteMap newImmutableMapOf(int k1, byte v1,
            int k2, byte v2);

    @Override
    @Nonnull
     HashIntByteMap newImmutableMapOf(int k1, byte v1,
            int k2, byte v2, int k3, byte v3);

    @Override
    @Nonnull
     HashIntByteMap newImmutableMapOf(int k1, byte v1,
            int k2, byte v2, int k3, byte v3,
            int k4, byte v4);

    @Override
    @Nonnull
     HashIntByteMap newImmutableMapOf(int k1, byte v1,
            int k2, byte v2, int k3, byte v3,
            int k4, byte v4, int k5, byte v5);
}

