/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.koloboke.collect.map.hash;

import net.openhft.koloboke.collect.*;
import net.openhft.koloboke.collect.hash.*;
import java.util.function.Consumer;
import net.openhft.koloboke.collect.map.*;

import javax.annotation.Nonnull;

import java.util.Map;



/**
 * An immutable factory of {@code HashCharLongMap}s.
 *
 * @see HashCharLongMap
 * @see HashCharLongMaps#getDefaultFactory()
 */
public interface HashCharLongMapFactory
        extends CharLongMapFactory<HashCharLongMapFactory>
        , CharHashFactory<HashCharLongMapFactory>
        {


    

    

    

    

    

    
    

    
    


    @Override
    @Nonnull
     HashCharLongMap newMutableMap();

    @Override
    @Nonnull
     HashCharLongMap newMutableMap(int expectedSize);

    


    @Override
    @Nonnull
     HashCharLongMap newMutableMap(@Nonnull Map<Character, Long> map1,
            @Nonnull Map<Character, Long> map2, int expectedSize);

    @Override
    @Nonnull
     HashCharLongMap newMutableMap(@Nonnull Map<Character, Long> map1,
            @Nonnull Map<Character, Long> map2,
            @Nonnull Map<Character, Long> map3, int expectedSize);

    @Override
    @Nonnull
     HashCharLongMap newMutableMap(@Nonnull Map<Character, Long> map1,
            @Nonnull Map<Character, Long> map2,
            @Nonnull Map<Character, Long> map3,
            @Nonnull Map<Character, Long> map4, int expectedSize);

    @Override
    @Nonnull
     HashCharLongMap newMutableMap(@Nonnull Map<Character, Long> map1,
            @Nonnull Map<Character, Long> map2,
            @Nonnull Map<Character, Long> map3,
            @Nonnull Map<Character, Long> map4,
            @Nonnull Map<Character, Long> map5, int expectedSize);



    @Override
    @Nonnull
     HashCharLongMap newMutableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.CharLongConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashCharLongMap newMutableMap(
            @Nonnull char[] keys, @Nonnull long[] values, int expectedSize);

    @Override
    @Nonnull
     HashCharLongMap newMutableMap(
            @Nonnull Character[] keys, @Nonnull Long[] values, int expectedSize);

    @Override
    @Nonnull
     HashCharLongMap newMutableMap(@Nonnull Iterable<Character> keys,
            @Nonnull Iterable<Long> values, int expectedSize);

    

    @Override
    @Nonnull
     HashCharLongMap newMutableMap(
            @Nonnull Map<Character, Long> map);

    @Override
    @Nonnull
     HashCharLongMap newMutableMap(@Nonnull Map<Character, Long> map1,
            @Nonnull Map<Character, Long> map2);

    @Override
    @Nonnull
     HashCharLongMap newMutableMap(@Nonnull Map<Character, Long> map1,
            @Nonnull Map<Character, Long> map2,
            @Nonnull Map<Character, Long> map3);

    @Override
    @Nonnull
     HashCharLongMap newMutableMap(@Nonnull Map<Character, Long> map1,
            @Nonnull Map<Character, Long> map2,
            @Nonnull Map<Character, Long> map3,
            @Nonnull Map<Character, Long> map4);

    @Override
    @Nonnull
     HashCharLongMap newMutableMap(@Nonnull Map<Character, Long> map1,
            @Nonnull Map<Character, Long> map2,
            @Nonnull Map<Character, Long> map3,
            @Nonnull Map<Character, Long> map4,
            @Nonnull Map<Character, Long> map5);



    @Override
    @Nonnull
     HashCharLongMap newMutableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.CharLongConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashCharLongMap newMutableMap(
            @Nonnull char[] keys, @Nonnull long[] values);

    @Override
    @Nonnull
     HashCharLongMap newMutableMap(
            @Nonnull Character[] keys, @Nonnull Long[] values);

    @Override
    @Nonnull
     HashCharLongMap newMutableMap(@Nonnull Iterable<Character> keys,
            @Nonnull Iterable<Long> values);


    @Override
    @Nonnull
     HashCharLongMap newMutableMapOf(char k1, long v1);

    @Override
    @Nonnull
     HashCharLongMap newMutableMapOf(char k1, long v1,
            char k2, long v2);

    @Override
    @Nonnull
     HashCharLongMap newMutableMapOf(char k1, long v1,
            char k2, long v2, char k3, long v3);

    @Override
    @Nonnull
     HashCharLongMap newMutableMapOf(char k1, long v1,
            char k2, long v2, char k3, long v3,
            char k4, long v4);

    @Override
    @Nonnull
     HashCharLongMap newMutableMapOf(char k1, long v1,
            char k2, long v2, char k3, long v3,
            char k4, long v4, char k5, long v5);
    @Override
    @Nonnull
     HashCharLongMap newUpdatableMap();

    @Override
    @Nonnull
     HashCharLongMap newUpdatableMap(int expectedSize);

    


    @Override
    @Nonnull
     HashCharLongMap newUpdatableMap(@Nonnull Map<Character, Long> map1,
            @Nonnull Map<Character, Long> map2, int expectedSize);

    @Override
    @Nonnull
     HashCharLongMap newUpdatableMap(@Nonnull Map<Character, Long> map1,
            @Nonnull Map<Character, Long> map2,
            @Nonnull Map<Character, Long> map3, int expectedSize);

    @Override
    @Nonnull
     HashCharLongMap newUpdatableMap(@Nonnull Map<Character, Long> map1,
            @Nonnull Map<Character, Long> map2,
            @Nonnull Map<Character, Long> map3,
            @Nonnull Map<Character, Long> map4, int expectedSize);

    @Override
    @Nonnull
     HashCharLongMap newUpdatableMap(@Nonnull Map<Character, Long> map1,
            @Nonnull Map<Character, Long> map2,
            @Nonnull Map<Character, Long> map3,
            @Nonnull Map<Character, Long> map4,
            @Nonnull Map<Character, Long> map5, int expectedSize);



    @Override
    @Nonnull
     HashCharLongMap newUpdatableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.CharLongConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashCharLongMap newUpdatableMap(
            @Nonnull char[] keys, @Nonnull long[] values, int expectedSize);

    @Override
    @Nonnull
     HashCharLongMap newUpdatableMap(
            @Nonnull Character[] keys, @Nonnull Long[] values, int expectedSize);

    @Override
    @Nonnull
     HashCharLongMap newUpdatableMap(@Nonnull Iterable<Character> keys,
            @Nonnull Iterable<Long> values, int expectedSize);

    

    @Override
    @Nonnull
     HashCharLongMap newUpdatableMap(
            @Nonnull Map<Character, Long> map);

    @Override
    @Nonnull
     HashCharLongMap newUpdatableMap(@Nonnull Map<Character, Long> map1,
            @Nonnull Map<Character, Long> map2);

    @Override
    @Nonnull
     HashCharLongMap newUpdatableMap(@Nonnull Map<Character, Long> map1,
            @Nonnull Map<Character, Long> map2,
            @Nonnull Map<Character, Long> map3);

    @Override
    @Nonnull
     HashCharLongMap newUpdatableMap(@Nonnull Map<Character, Long> map1,
            @Nonnull Map<Character, Long> map2,
            @Nonnull Map<Character, Long> map3,
            @Nonnull Map<Character, Long> map4);

    @Override
    @Nonnull
     HashCharLongMap newUpdatableMap(@Nonnull Map<Character, Long> map1,
            @Nonnull Map<Character, Long> map2,
            @Nonnull Map<Character, Long> map3,
            @Nonnull Map<Character, Long> map4,
            @Nonnull Map<Character, Long> map5);



    @Override
    @Nonnull
     HashCharLongMap newUpdatableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.CharLongConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashCharLongMap newUpdatableMap(
            @Nonnull char[] keys, @Nonnull long[] values);

    @Override
    @Nonnull
     HashCharLongMap newUpdatableMap(
            @Nonnull Character[] keys, @Nonnull Long[] values);

    @Override
    @Nonnull
     HashCharLongMap newUpdatableMap(@Nonnull Iterable<Character> keys,
            @Nonnull Iterable<Long> values);


    @Override
    @Nonnull
     HashCharLongMap newUpdatableMapOf(char k1, long v1);

    @Override
    @Nonnull
     HashCharLongMap newUpdatableMapOf(char k1, long v1,
            char k2, long v2);

    @Override
    @Nonnull
     HashCharLongMap newUpdatableMapOf(char k1, long v1,
            char k2, long v2, char k3, long v3);

    @Override
    @Nonnull
     HashCharLongMap newUpdatableMapOf(char k1, long v1,
            char k2, long v2, char k3, long v3,
            char k4, long v4);

    @Override
    @Nonnull
     HashCharLongMap newUpdatableMapOf(char k1, long v1,
            char k2, long v2, char k3, long v3,
            char k4, long v4, char k5, long v5);

    


    @Override
    @Nonnull
     HashCharLongMap newImmutableMap(@Nonnull Map<Character, Long> map1,
            @Nonnull Map<Character, Long> map2, int expectedSize);

    @Override
    @Nonnull
     HashCharLongMap newImmutableMap(@Nonnull Map<Character, Long> map1,
            @Nonnull Map<Character, Long> map2,
            @Nonnull Map<Character, Long> map3, int expectedSize);

    @Override
    @Nonnull
     HashCharLongMap newImmutableMap(@Nonnull Map<Character, Long> map1,
            @Nonnull Map<Character, Long> map2,
            @Nonnull Map<Character, Long> map3,
            @Nonnull Map<Character, Long> map4, int expectedSize);

    @Override
    @Nonnull
     HashCharLongMap newImmutableMap(@Nonnull Map<Character, Long> map1,
            @Nonnull Map<Character, Long> map2,
            @Nonnull Map<Character, Long> map3,
            @Nonnull Map<Character, Long> map4,
            @Nonnull Map<Character, Long> map5, int expectedSize);



    @Override
    @Nonnull
     HashCharLongMap newImmutableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.CharLongConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashCharLongMap newImmutableMap(
            @Nonnull char[] keys, @Nonnull long[] values, int expectedSize);

    @Override
    @Nonnull
     HashCharLongMap newImmutableMap(
            @Nonnull Character[] keys, @Nonnull Long[] values, int expectedSize);

    @Override
    @Nonnull
     HashCharLongMap newImmutableMap(@Nonnull Iterable<Character> keys,
            @Nonnull Iterable<Long> values, int expectedSize);

    

    @Override
    @Nonnull
     HashCharLongMap newImmutableMap(
            @Nonnull Map<Character, Long> map);

    @Override
    @Nonnull
     HashCharLongMap newImmutableMap(@Nonnull Map<Character, Long> map1,
            @Nonnull Map<Character, Long> map2);

    @Override
    @Nonnull
     HashCharLongMap newImmutableMap(@Nonnull Map<Character, Long> map1,
            @Nonnull Map<Character, Long> map2,
            @Nonnull Map<Character, Long> map3);

    @Override
    @Nonnull
     HashCharLongMap newImmutableMap(@Nonnull Map<Character, Long> map1,
            @Nonnull Map<Character, Long> map2,
            @Nonnull Map<Character, Long> map3,
            @Nonnull Map<Character, Long> map4);

    @Override
    @Nonnull
     HashCharLongMap newImmutableMap(@Nonnull Map<Character, Long> map1,
            @Nonnull Map<Character, Long> map2,
            @Nonnull Map<Character, Long> map3,
            @Nonnull Map<Character, Long> map4,
            @Nonnull Map<Character, Long> map5);



    @Override
    @Nonnull
     HashCharLongMap newImmutableMap(@Nonnull
            Consumer<net.openhft.koloboke.function.CharLongConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashCharLongMap newImmutableMap(
            @Nonnull char[] keys, @Nonnull long[] values);

    @Override
    @Nonnull
     HashCharLongMap newImmutableMap(
            @Nonnull Character[] keys, @Nonnull Long[] values);

    @Override
    @Nonnull
     HashCharLongMap newImmutableMap(@Nonnull Iterable<Character> keys,
            @Nonnull Iterable<Long> values);


    @Override
    @Nonnull
     HashCharLongMap newImmutableMapOf(char k1, long v1);

    @Override
    @Nonnull
     HashCharLongMap newImmutableMapOf(char k1, long v1,
            char k2, long v2);

    @Override
    @Nonnull
     HashCharLongMap newImmutableMapOf(char k1, long v1,
            char k2, long v2, char k3, long v3);

    @Override
    @Nonnull
     HashCharLongMap newImmutableMapOf(char k1, long v1,
            char k2, long v2, char k3, long v3,
            char k4, long v4);

    @Override
    @Nonnull
     HashCharLongMap newImmutableMapOf(char k1, long v1,
            char k2, long v2, char k3, long v3,
            char k4, long v4, char k5, long v5);
}

