/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.openhft.collect.Equivalence;
import net.openhft.collect.FloatCollection;
import net.openhft.collect.FloatCursor;
import net.openhft.collect.FloatIterator;
import net.openhft.collect.ObjCollection;
import net.openhft.collect.ObjCursor;
import net.openhft.collect.ObjIterator;
import net.openhft.collect.hash.HashConfig;
import net.openhft.collect.impl.AbstractEntry;
import net.openhft.collect.impl.AbstractFloatValueView;
import net.openhft.collect.impl.AbstractSetView;
import net.openhft.collect.impl.CommonMapOps;
import net.openhft.collect.impl.CommonObjCollectionOps;
import net.openhft.collect.impl.CommonObjFloatMapOps;
import net.openhft.collect.impl.InternalFloatCollectionOps;
import net.openhft.collect.impl.InternalObjCollectionOps;
import net.openhft.collect.impl.InternalObjFloatMapOps;
import net.openhft.collect.impl.NullableObjects;
import net.openhft.collect.impl.Primitives;
import net.openhft.collect.impl.hash.ObjHash;
import net.openhft.collect.impl.hash.QHash;
import net.openhft.collect.impl.hash.SeparateKVObjFloatQHash;
import net.openhft.collect.impl.hash.UpdatableQHashSeparateKVObjFloatMapSO;
import net.openhft.collect.map.ObjFloatCursor;
import net.openhft.collect.set.FloatSet;
import net.openhft.collect.set.ObjSet;
import net.openhft.collect.set.hash.HashObjSet;
import net.openhft.function.FloatBinaryOperator;
import net.openhft.function.FloatConsumer;
import net.openhft.function.FloatPredicate;
import net.openhft.function.ObjFloatConsumer;
import net.openhft.function.ObjFloatPredicate;
import net.openhft.function.ObjFloatToFloatFunction;
import net.openhft.function.ToFloatFunction;

public class UpdatableQHashSeparateKVObjFloatMapGO<K>
extends UpdatableQHashSeparateKVObjFloatMapSO<K> {
    @Override
    final void copy(SeparateKVObjFloatQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.copy(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    final void move(SeparateKVObjFloatQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.move(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public float defaultValue() {
        return 0.0f;
    }

    @Override
    public boolean containsEntry(Object key, float value) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index] == Float.floatToIntBits(value);
        }
        return false;
    }

    @Override
    public boolean containsEntry(Object key, int value) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index] == value;
        }
        return false;
    }

    @Override
    public Float get(Object key) {
        int index = this.index(key);
        if (index >= 0) {
            return Float.valueOf(Float.intBitsToFloat(this.values[index]));
        }
        return null;
    }

    public float getFloat(Object key) {
        int index = this.index(key);
        if (index >= 0) {
            return Float.intBitsToFloat(this.values[index]);
        }
        return this.defaultValue();
    }

    @Override
    public Float getOrDefault(Object key, Float defaultValue) {
        int index = this.index(key);
        if (index >= 0) {
            return Float.valueOf(Float.intBitsToFloat(this.values[index]));
        }
        return defaultValue;
    }

    @Override
    public float getOrDefault(Object key, float defaultValue) {
        int index = this.index(key);
        if (index >= 0) {
            return Float.intBitsToFloat(this.values[index]);
        }
        return defaultValue;
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super Float> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        Object[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            Object key = keys[i];
            if (key == FREE) continue;
            action.accept(key, Float.valueOf(Float.intBitsToFloat(vals[i])));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public void forEach(ObjFloatConsumer<? super K> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        Object[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            Object key = keys[i];
            if (key == FREE) continue;
            action.accept(key, Float.intBitsToFloat(vals[i]));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public boolean forEachWhile(ObjFloatPredicate<? super K> predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        int mc = this.modCount();
        Object[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            Object key = keys[i];
            if (key == FREE || predicate.test(key, Float.intBitsToFloat(vals[i]))) continue;
            terminated = true;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return !terminated;
    }

    @Nonnull
    public ObjFloatCursor<K> cursor() {
        int mc = this.modCount();
        return new NoRemovedMapCursor(mc);
    }

    @Override
    public boolean containsAllEntries(Map<?, ?> m) {
        return CommonObjFloatMapOps.containsAllEntries(this, m);
    }

    @Override
    public boolean allEntriesContainingIn(InternalObjFloatMapOps<?> m) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        int mc = this.modCount();
        Object[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            Object key = keys[i];
            if (key == FREE || m.containsEntry(key, vals[i])) continue;
            containsAll = false;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return containsAll;
    }

    @Override
    public void reversePutAllTo(InternalObjFloatMapOps<? super K> m) {
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        Object[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            Object key = keys[i];
            if (key == FREE) continue;
            m.justPut(key, vals[i]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    @Nonnull
    public HashObjSet<Map.Entry<K, Float>> entrySet() {
        return new EntryView();
    }

    @Nonnull
    public FloatCollection values() {
        return new ValueView();
    }

    @Override
    public boolean equals(Object o) {
        return CommonMapOps.equals(this, o);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        int mc = this.modCount();
        Object[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            Object key = keys[i];
            if (key == FREE) continue;
            hashCode += this.nullableKeyHashCode(key) ^ vals[i];
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return hashCode;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        int mc = this.modCount();
        Object[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            Object key = keys[i];
            if (key == FREE) continue;
            sb.append(' ');
            sb.append(key != this ? key : "(this Map)");
            sb.append('=');
            sb.append(Float.intBitsToFloat(vals[i]));
            sb.append(',');
            if (++elementCount != 8) continue;
            int expectedLength = sb.length() * (this.size() / 8);
            sb.ensureCapacity(expectedLength + expectedLength / 2);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        sb.setCharAt(0, '{');
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    @Override
    void rehash(int newCapacity) {
        int mc = this.modCount();
        Object[] keys = this.set;
        int[] vals = this.values;
        this.initForRehash(newCapacity);
        ++mc;
        Object[] newKeys = this.set;
        int capacity = newKeys.length;
        int[] newVals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            Object key = keys[i];
            if (key == FREE) continue;
            int index = QHash.SeparateKVObjKeyMixing.mix(this.nullableKeyHashCode(key)) % capacity;
            if (newKeys[index] != FREE) {
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if (newKeys[bIndex] != FREE) {
                        index = bIndex;
                        break;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if (newKeys[fIndex] != FREE) {
                        index = fIndex;
                        break;
                    }
                    step += 2;
                }
            }
            newKeys[index] = key;
            newVals[index] = vals[i];
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public Float put(K key, Float value) {
        int index = this.insert(key, Float.floatToIntBits(value.floatValue()));
        if (index < 0) {
            return null;
        }
        int[] vals = this.values;
        float prevValue = Float.intBitsToFloat(vals[index]);
        vals[index] = Float.floatToIntBits(value.floatValue());
        return Float.valueOf(prevValue);
    }

    @Override
    public float put(K key, float value) {
        int index = this.insert(key, Float.floatToIntBits(value));
        if (index < 0) {
            return this.defaultValue();
        }
        int[] vals = this.values;
        float prevValue = Float.intBitsToFloat(vals[index]);
        vals[index] = Float.floatToIntBits(value);
        return prevValue;
    }

    @Override
    public Float putIfAbsent(K key, Float value) {
        int index = this.insert(key, Float.floatToIntBits(value.floatValue()));
        if (index < 0) {
            return null;
        }
        return Float.valueOf(Float.intBitsToFloat(this.values[index]));
    }

    @Override
    public float putIfAbsent(K key, float value) {
        int index = this.insert(key, Float.floatToIntBits(value));
        if (index < 0) {
            return this.defaultValue();
        }
        return Float.intBitsToFloat(this.values[index]);
    }

    @Override
    public void justPut(K key, float value) {
        int index = this.insert(key, Float.floatToIntBits(value));
        if (index < 0) {
            return;
        }
        this.values[index] = Float.floatToIntBits(value);
    }

    @Override
    public void justPut(K key, int value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return;
        }
        this.values[index] = value;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Float compute(K key, BiFunction<? super K, ? super Float, ? extends Float> remappingFunction) {
        if (key != null) {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            keys = this.set;
            vals = this.values;
            capacity = keys.length;
            index = QHash.SeparateKVObjKeyMixing.mix(this.keyHashCode(key)) % capacity;
            cur = keys[index];
            if (cur != key) {
                if (cur != UpdatableQHashSeparateKVObjFloatMapGO.FREE) {
                    if (!this.keyEquals(key, cur)) {
                        bIndex = index;
                        fIndex = index;
                        step = 1;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == key) {
                                index = bIndex;
                                break;
                            }
                            if (cur == UpdatableQHashSeparateKVObjFloatMapGO.FREE) {
                                index = bIndex;
                                ** break;
                            }
                            if (this.keyEquals(key, cur)) {
                                index = bIndex;
                                break;
                            }
                            t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == key) {
                                index = fIndex;
                                break;
                            }
                            if (cur == UpdatableQHashSeparateKVObjFloatMapGO.FREE) {
                                index = fIndex;
                                ** break;
                            }
                            if (this.keyEquals(key, cur)) {
                                index = fIndex;
                                break;
                            }
                            step += 2;
                        }
                    }
                } else lbl-1000:
                // 3 sources

                {
                    if ((newValue = remappingFunction.apply(key, null)) != null) {
                        this.incrementModCount();
                        keys[index] = key;
                        vals[index] = Float.floatToIntBits(newValue.floatValue());
                        this.postInsertHook();
                        return newValue;
                    }
                    return null;
                }
            }
            if ((newValue = remappingFunction.apply(key, Float.valueOf(Float.intBitsToFloat(vals[index])))) != null) {
                vals[index] = Float.floatToIntBits(newValue.floatValue());
                return newValue;
            }
            throw new UnsupportedOperationException("Compute operation of updatable map doesn't support removals");
        }
        return this.computeNullKey(remappingFunction);
    }

    Float computeNullKey(BiFunction<? super K, ? super Float, ? extends Float> remappingFunction) {
        Float newValue;
        int index;
        int[] vals;
        block12: {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            Object[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = 0;
            Object cur = keys[0];
            if (cur != null) {
                Float newValue2;
                if (cur != FREE) {
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if ((cur = keys[bIndex]) == null) {
                            index = bIndex;
                            break block12;
                        }
                        if (cur == FREE) {
                            index = bIndex;
                            break;
                        }
                        int t = (fIndex += step) - capacity;
                        if (t >= 0) {
                            fIndex = t;
                        }
                        if ((cur = keys[fIndex]) == null) {
                            index = fIndex;
                            break block12;
                        }
                        if (cur == FREE) {
                            index = fIndex;
                            break;
                        }
                        step += 2;
                    }
                }
                if ((newValue2 = remappingFunction.apply(null, null)) != null) {
                    this.incrementModCount();
                    keys[index] = null;
                    vals[index] = Float.floatToIntBits(newValue2.floatValue());
                    this.postInsertHook();
                    return newValue2;
                }
                return null;
            }
        }
        if ((newValue = remappingFunction.apply(null, Float.valueOf(Float.intBitsToFloat(vals[index])))) != null) {
            vals[index] = Float.floatToIntBits(newValue.floatValue());
            return newValue;
        }
        throw new UnsupportedOperationException("Compute operation of updatable map doesn't support removals");
    }

    /*
     * Unable to fully structure code
     */
    public float compute(K key, ObjFloatToFloatFunction<? super K> remappingFunction) {
        if (key != null) {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            keys = this.set;
            vals = this.values;
            capacity = keys.length;
            index = QHash.SeparateKVObjKeyMixing.mix(this.keyHashCode(key)) % capacity;
            cur = keys[index];
            if (cur != key) {
                if (cur != UpdatableQHashSeparateKVObjFloatMapGO.FREE) {
                    if (!this.keyEquals(key, cur)) {
                        bIndex = index;
                        fIndex = index;
                        step = 1;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == key) {
                                index = bIndex;
                                break;
                            }
                            if (cur == UpdatableQHashSeparateKVObjFloatMapGO.FREE) {
                                index = bIndex;
                                ** break;
                            }
                            if (this.keyEquals(key, cur)) {
                                index = bIndex;
                                break;
                            }
                            t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == key) {
                                index = fIndex;
                                break;
                            }
                            if (cur == UpdatableQHashSeparateKVObjFloatMapGO.FREE) {
                                index = fIndex;
                                ** break;
                            }
                            if (this.keyEquals(key, cur)) {
                                index = fIndex;
                                break;
                            }
                            step += 2;
                        }
                    }
                } else lbl-1000:
                // 3 sources

                {
                    newValue = remappingFunction.applyAsFloat(key, this.defaultValue());
                    this.incrementModCount();
                    keys[index] = key;
                    vals[index] = Float.floatToIntBits(newValue);
                    this.postInsertHook();
                    return newValue;
                }
            }
            newValue = remappingFunction.applyAsFloat(key, Float.intBitsToFloat(vals[index]));
            vals[index] = Float.floatToIntBits(newValue);
            return newValue;
        }
        return this.computeNullKey(remappingFunction);
    }

    float computeNullKey(ObjFloatToFloatFunction<? super K> remappingFunction) {
        int index;
        int[] vals;
        block10: {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            Object[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = 0;
            Object cur = keys[0];
            if (cur != null) {
                if (cur != FREE) {
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if ((cur = keys[bIndex]) == null) {
                            index = bIndex;
                            break block10;
                        }
                        if (cur == FREE) {
                            index = bIndex;
                            break;
                        }
                        int t = (fIndex += step) - capacity;
                        if (t >= 0) {
                            fIndex = t;
                        }
                        if ((cur = keys[fIndex]) == null) {
                            index = fIndex;
                            break block10;
                        }
                        if (cur == FREE) {
                            index = fIndex;
                            break;
                        }
                        step += 2;
                    }
                }
                float newValue = remappingFunction.applyAsFloat(null, this.defaultValue());
                this.incrementModCount();
                keys[index] = null;
                vals[index] = Float.floatToIntBits(newValue);
                this.postInsertHook();
                return newValue;
            }
        }
        float newValue = remappingFunction.applyAsFloat(null, Float.intBitsToFloat(vals[index]));
        vals[index] = Float.floatToIntBits(newValue);
        return newValue;
    }

    @Override
    public Float computeIfAbsent(K key, Function<? super K, ? extends Float> mappingFunction) {
        if (key != null) {
            Float value;
            if (mappingFunction == null) {
                throw new NullPointerException();
            }
            Object[] keys = this.set;
            int[] vals = this.values;
            int capacity = keys.length;
            int index = QHash.SeparateKVObjKeyMixing.mix(this.keyHashCode(key)) % capacity;
            Object cur = keys[index];
            if (cur != FREE) {
                if (cur == key || this.keyEquals(key, cur)) {
                    return Float.valueOf(Float.intBitsToFloat(vals[index]));
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == FREE) {
                        index = bIndex;
                        break;
                    }
                    if (cur == key || this.keyEquals(key, cur)) {
                        return Float.valueOf(Float.intBitsToFloat(vals[bIndex]));
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == FREE) {
                        index = fIndex;
                        break;
                    }
                    if (cur == key || this.keyEquals(key, cur)) {
                        return Float.valueOf(Float.intBitsToFloat(vals[fIndex]));
                    }
                    step += 2;
                }
            }
            if ((value = mappingFunction.apply(key)) != null) {
                this.incrementModCount();
                keys[index] = key;
                vals[index] = Float.floatToIntBits(value.floatValue());
                this.postInsertHook();
                return value;
            }
            return null;
        }
        return this.computeIfAbsentNullKey(mappingFunction);
    }

    Float computeIfAbsentNullKey(Function<? super K, ? extends Float> mappingFunction) {
        Float value;
        if (mappingFunction == null) {
            throw new NullPointerException();
        }
        Object[] keys = this.set;
        int[] vals = this.values;
        int capacity = keys.length;
        int index = 0;
        Object cur = keys[0];
        if (cur != FREE) {
            if (cur == null) {
                return Float.valueOf(Float.intBitsToFloat(vals[index]));
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = keys[bIndex]) == FREE) {
                    index = bIndex;
                    break;
                }
                if (cur == null) {
                    return Float.valueOf(Float.intBitsToFloat(vals[bIndex]));
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = keys[fIndex]) == FREE) {
                    index = fIndex;
                    break;
                }
                if (cur == null) {
                    return Float.valueOf(Float.intBitsToFloat(vals[fIndex]));
                }
                step += 2;
            }
        }
        if ((value = mappingFunction.apply(null)) != null) {
            this.incrementModCount();
            keys[index] = null;
            vals[index] = Float.floatToIntBits(value.floatValue());
            this.postInsertHook();
            return value;
        }
        return null;
    }

    public float computeIfAbsent(K key, ToFloatFunction<? super K> mappingFunction) {
        if (key != null) {
            if (mappingFunction == null) {
                throw new NullPointerException();
            }
            Object[] keys = this.set;
            int[] vals = this.values;
            int capacity = keys.length;
            int index = QHash.SeparateKVObjKeyMixing.mix(this.keyHashCode(key)) % capacity;
            Object cur = keys[index];
            if (cur != FREE) {
                if (cur == key || this.keyEquals(key, cur)) {
                    return Float.intBitsToFloat(vals[index]);
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == FREE) {
                        index = bIndex;
                        break;
                    }
                    if (cur == key || this.keyEquals(key, cur)) {
                        return Float.intBitsToFloat(vals[bIndex]);
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == FREE) {
                        index = fIndex;
                        break;
                    }
                    if (cur == key || this.keyEquals(key, cur)) {
                        return Float.intBitsToFloat(vals[fIndex]);
                    }
                    step += 2;
                }
            }
            float value = mappingFunction.applyAsFloat(key);
            this.incrementModCount();
            keys[index] = key;
            vals[index] = Float.floatToIntBits(value);
            this.postInsertHook();
            return value;
        }
        return this.computeIfAbsentNullKey(mappingFunction);
    }

    float computeIfAbsentNullKey(ToFloatFunction<? super K> mappingFunction) {
        if (mappingFunction == null) {
            throw new NullPointerException();
        }
        Object[] keys = this.set;
        int[] vals = this.values;
        int capacity = keys.length;
        int index = 0;
        Object cur = keys[0];
        if (cur != FREE) {
            if (cur == null) {
                return Float.intBitsToFloat(vals[index]);
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = keys[bIndex]) == FREE) {
                    index = bIndex;
                    break;
                }
                if (cur == null) {
                    return Float.intBitsToFloat(vals[bIndex]);
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = keys[fIndex]) == FREE) {
                    index = fIndex;
                    break;
                }
                if (cur == null) {
                    return Float.intBitsToFloat(vals[fIndex]);
                }
                step += 2;
            }
        }
        float value = mappingFunction.applyAsFloat(null);
        this.incrementModCount();
        keys[index] = null;
        vals[index] = Float.floatToIntBits(value);
        this.postInsertHook();
        return value;
    }

    @Override
    public Float computeIfPresent(K key, BiFunction<? super K, ? super Float, ? extends Float> remappingFunction) {
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        int index = this.index(key);
        if (index >= 0) {
            int[] vals = this.values;
            Float newValue = remappingFunction.apply(key, Float.valueOf(Float.intBitsToFloat(vals[index])));
            if (newValue != null) {
                vals[index] = Float.floatToIntBits(newValue.floatValue());
                return newValue;
            }
            throw new UnsupportedOperationException("ComputeIfPresent operation of updatable map doesn't support removals");
        }
        return null;
    }

    public float computeIfPresent(K key, ObjFloatToFloatFunction<? super K> remappingFunction) {
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        int index = this.index(key);
        if (index >= 0) {
            int[] vals = this.values;
            float newValue = remappingFunction.applyAsFloat(key, Float.intBitsToFloat(vals[index]));
            vals[index] = Float.floatToIntBits(newValue);
            return newValue;
        }
        return this.defaultValue();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Float merge(K key, Float value, BiFunction<? super Float, ? super Float, ? extends Float> remappingFunction) {
        if (key != null) {
            if (value == null) {
                throw new NullPointerException();
            }
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            keys = this.set;
            vals = this.values;
            capacity = keys.length;
            index = QHash.SeparateKVObjKeyMixing.mix(this.keyHashCode(key)) % capacity;
            cur = keys[index];
            if (cur != key) {
                if (cur != UpdatableQHashSeparateKVObjFloatMapGO.FREE) {
                    if (!this.keyEquals(key, cur)) {
                        bIndex = index;
                        fIndex = index;
                        step = 1;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == key) {
                                index = bIndex;
                                break;
                            }
                            if (cur == UpdatableQHashSeparateKVObjFloatMapGO.FREE) {
                                index = bIndex;
                                ** break;
                            }
                            if (this.keyEquals(key, cur)) {
                                index = bIndex;
                                break;
                            }
                            t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == key) {
                                index = fIndex;
                                break;
                            }
                            if (cur == UpdatableQHashSeparateKVObjFloatMapGO.FREE) {
                                index = fIndex;
                                ** break;
                            }
                            if (this.keyEquals(key, cur)) {
                                index = fIndex;
                                break;
                            }
                            step += 2;
                        }
                    }
                } else lbl-1000:
                // 3 sources

                {
                    this.incrementModCount();
                    keys[index] = key;
                    vals[index] = Float.floatToIntBits(value.floatValue());
                    this.postInsertHook();
                    return value;
                }
            }
            if ((newValue = remappingFunction.apply(Float.valueOf(Float.intBitsToFloat(vals[index])), value)) != null) {
                vals[index] = Float.floatToIntBits(newValue.floatValue());
                return newValue;
            }
            throw new UnsupportedOperationException("Merge operation of updatable map doesn't support removals");
        }
        return this.mergeNullKey(value, remappingFunction);
    }

    Float mergeNullKey(Float value, BiFunction<? super Float, ? super Float, ? extends Float> remappingFunction) {
        Float newValue;
        int index;
        int[] vals;
        block12: {
            if (value == null) {
                throw new NullPointerException();
            }
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            Object[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = 0;
            Object cur = keys[0];
            if (cur != null) {
                if (cur != FREE) {
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if ((cur = keys[bIndex]) == null) {
                            index = bIndex;
                            break block12;
                        }
                        if (cur == FREE) {
                            index = bIndex;
                            break;
                        }
                        int t = (fIndex += step) - capacity;
                        if (t >= 0) {
                            fIndex = t;
                        }
                        if ((cur = keys[fIndex]) == null) {
                            index = fIndex;
                            break block12;
                        }
                        if (cur == FREE) {
                            index = fIndex;
                            break;
                        }
                        step += 2;
                    }
                }
                this.incrementModCount();
                keys[index] = null;
                vals[index] = Float.floatToIntBits(value.floatValue());
                this.postInsertHook();
                return value;
            }
        }
        if ((newValue = remappingFunction.apply(Float.valueOf(Float.intBitsToFloat(vals[index])), value)) != null) {
            vals[index] = Float.floatToIntBits(newValue.floatValue());
            return newValue;
        }
        throw new UnsupportedOperationException("Merge operation of updatable map doesn't support removals");
    }

    /*
     * Unable to fully structure code
     */
    public float merge(K key, float value, FloatBinaryOperator remappingFunction) {
        if (key != null) {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            keys = this.set;
            vals = this.values;
            capacity = keys.length;
            index = QHash.SeparateKVObjKeyMixing.mix(this.keyHashCode(key)) % capacity;
            cur = keys[index];
            if (cur != key) {
                if (cur != UpdatableQHashSeparateKVObjFloatMapGO.FREE) {
                    if (!this.keyEquals(key, cur)) {
                        bIndex = index;
                        fIndex = index;
                        step = 1;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == key) {
                                index = bIndex;
                                break;
                            }
                            if (cur == UpdatableQHashSeparateKVObjFloatMapGO.FREE) {
                                index = bIndex;
                                ** break;
                            }
                            if (this.keyEquals(key, cur)) {
                                index = bIndex;
                                break;
                            }
                            t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == key) {
                                index = fIndex;
                                break;
                            }
                            if (cur == UpdatableQHashSeparateKVObjFloatMapGO.FREE) {
                                index = fIndex;
                                ** break;
                            }
                            if (this.keyEquals(key, cur)) {
                                index = fIndex;
                                break;
                            }
                            step += 2;
                        }
                    }
                } else lbl-1000:
                // 3 sources

                {
                    this.incrementModCount();
                    keys[index] = key;
                    vals[index] = Float.floatToIntBits(value);
                    this.postInsertHook();
                    return value;
                }
            }
            newValue = remappingFunction.applyAsFloat(Float.intBitsToFloat(vals[index]), value);
            vals[index] = Float.floatToIntBits(newValue);
            return newValue;
        }
        return this.mergeNullKey(value, remappingFunction);
    }

    float mergeNullKey(float value, FloatBinaryOperator remappingFunction) {
        int index;
        int[] vals;
        block10: {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            Object[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = 0;
            Object cur = keys[0];
            if (cur != null) {
                if (cur != FREE) {
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if ((cur = keys[bIndex]) == null) {
                            index = bIndex;
                            break block10;
                        }
                        if (cur == FREE) {
                            index = bIndex;
                            break;
                        }
                        int t = (fIndex += step) - capacity;
                        if (t >= 0) {
                            fIndex = t;
                        }
                        if ((cur = keys[fIndex]) == null) {
                            index = fIndex;
                            break block10;
                        }
                        if (cur == FREE) {
                            index = fIndex;
                            break;
                        }
                        step += 2;
                    }
                }
                this.incrementModCount();
                keys[index] = null;
                vals[index] = Float.floatToIntBits(value);
                this.postInsertHook();
                return value;
            }
        }
        float newValue = remappingFunction.applyAsFloat(Float.intBitsToFloat(vals[index]), value);
        vals[index] = Float.floatToIntBits(newValue);
        return newValue;
    }

    public float addValue(K key, float value) {
        int index = this.insert(key, Float.floatToIntBits(value));
        if (index < 0) {
            return value;
        }
        int[] vals = this.values;
        float newValue = Float.intBitsToFloat(vals[index]) + value;
        vals[index] = Float.floatToIntBits(newValue);
        return newValue;
    }

    public float addValue(K key, float addition, float defaultValue) {
        float value = defaultValue + addition;
        int index = this.insert(key, Float.floatToIntBits(value));
        if (index < 0) {
            return value;
        }
        int[] vals = this.values;
        float newValue = Float.intBitsToFloat(vals[index]) + addition;
        vals[index] = Float.floatToIntBits(newValue);
        return newValue;
    }

    @Override
    public void putAll(@Nonnull Map<? extends K, ? extends Float> m) {
        CommonObjFloatMapOps.putAll(this, m);
    }

    @Override
    public Float replace(K key, Float value) {
        int index = this.index(key);
        if (index >= 0) {
            int[] vals = this.values;
            float oldValue = Float.intBitsToFloat(vals[index]);
            vals[index] = Float.floatToIntBits(value.floatValue());
            return Float.valueOf(oldValue);
        }
        return null;
    }

    @Override
    public float replace(K key, float value) {
        int index = this.index(key);
        if (index >= 0) {
            int[] vals = this.values;
            float oldValue = Float.intBitsToFloat(vals[index]);
            vals[index] = Float.floatToIntBits(value);
            return oldValue;
        }
        return this.defaultValue();
    }

    @Override
    public boolean replace(K key, Float oldValue, Float newValue) {
        return this.replace(key, oldValue.floatValue(), newValue.floatValue());
    }

    @Override
    public boolean replace(K key, float oldValue, float newValue) {
        int index = this.index(key);
        if (index >= 0) {
            int[] vals = this.values;
            if (vals[index] == Float.floatToIntBits(oldValue)) {
                vals[index] = Float.floatToIntBits(newValue);
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super Float, ? extends Float> function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        Object[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            Object key = keys[i];
            if (key == FREE) continue;
            vals[i] = Float.floatToIntBits(function.apply(key, Float.valueOf(Float.intBitsToFloat(vals[i]))).floatValue());
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void replaceAll(ObjFloatToFloatFunction<? super K> function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        Object[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            Object key = keys[i];
            if (key == FREE) continue;
            vals[i] = Float.floatToIntBits(function.applyAsFloat(key, Float.intBitsToFloat(vals[i])));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public void clear() {
        int mc = this.modCount() + 1;
        super.clear();
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public Float remove(Object key) {
        throw new UnsupportedOperationException();
    }

    Float removeNullKey() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean justRemove(Object key) {
        throw new UnsupportedOperationException();
    }

    boolean justRemoveNullKey() {
        throw new UnsupportedOperationException();
    }

    public float removeAsFloat(Object key) {
        throw new UnsupportedOperationException();
    }

    float removeAsFloatNullKey() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.remove(key, ((Float)value).floatValue());
    }

    public boolean remove(Object key, float value) {
        throw new UnsupportedOperationException();
    }

    boolean removeEntryNullKey(float value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeIf(ObjFloatPredicate<? super K> filter) {
        throw new UnsupportedOperationException();
    }

    class NoRemovedMapCursor
    implements ObjFloatCursor<K> {
        final K[] keys;
        final int[] vals;
        int expectedModCount;
        int index;
        Object curKey;
        int curValue;

        NoRemovedMapCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = UpdatableQHashSeparateKVObjFloatMapGO.this.set;
            this.index = this.keys.length;
            this.vals = UpdatableQHashSeparateKVObjFloatMapGO.this.values;
            this.curKey = ObjHash.FREE;
        }

        public void forEachForward(ObjFloatConsumer<? super K> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            K[] keys = this.keys;
            int[] vals = this.vals;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                action.accept(key, Float.intBitsToFloat(vals[i]));
            }
            if (index != this.index || mc != UpdatableQHashSeparateKVObjFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = ObjHash.FREE;
        }

        public K key() {
            Object curKey = this.curKey;
            if (curKey != ObjHash.FREE) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public float value() {
            if (this.curKey != ObjHash.FREE) {
                return Float.intBitsToFloat(this.curValue);
            }
            throw new IllegalStateException();
        }

        public void setValue(float value) {
            if (this.curKey != ObjHash.FREE) {
                if (this.expectedModCount != UpdatableQHashSeparateKVObjFloatMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.vals[this.index] = Float.floatToIntBits(value);
        }

        public boolean moveNext() {
            if (this.expectedModCount == UpdatableQHashSeparateKVObjFloatMapGO.this.modCount()) {
                K[] keys = this.keys;
                for (int i = this.index - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = ObjHash.FREE;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueCursor
    implements FloatCursor {
        final K[] keys;
        final int[] vals;
        int expectedModCount;
        int index;
        Object curKey;
        int curValue;

        NoRemovedValueCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = UpdatableQHashSeparateKVObjFloatMapGO.this.set;
            this.index = this.keys.length;
            this.vals = UpdatableQHashSeparateKVObjFloatMapGO.this.values;
            this.curKey = ObjHash.FREE;
        }

        public void forEachForward(FloatConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            K[] keys = this.keys;
            int[] vals = this.vals;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                action.accept(Float.intBitsToFloat(vals[i]));
            }
            if (index != this.index || mc != UpdatableQHashSeparateKVObjFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = ObjHash.FREE;
        }

        public float elem() {
            if (this.curKey != ObjHash.FREE) {
                return Float.intBitsToFloat(this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == UpdatableQHashSeparateKVObjFloatMapGO.this.modCount()) {
                K[] keys = this.keys;
                for (int i = this.index - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = ObjHash.FREE;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueIterator
    implements FloatIterator {
        final K[] keys;
        final int[] vals;
        int expectedModCount;
        int nextIndex;
        float next;

        NoRemovedValueIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = UpdatableQHashSeparateKVObjFloatMapGO.this.set;
            Object[] keys = this.keys;
            this.vals = UpdatableQHashSeparateKVObjFloatMapGO.this.values;
            int[] vals = UpdatableQHashSeparateKVObjFloatMapGO.this.values;
            int nextI = keys.length;
            while (--nextI >= 0) {
                if (keys[nextI] == ObjHash.FREE) continue;
                this.next = Float.intBitsToFloat(vals[nextI]);
                break;
            }
            this.nextIndex = nextI;
        }

        public float nextFloat() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                if (this.expectedModCount == UpdatableQHashSeparateKVObjFloatMapGO.this.modCount()) {
                    K[] keys = this.keys;
                    float prev = this.next;
                    while (--nextI >= 0) {
                        if (keys[nextI] == ObjHash.FREE) continue;
                        this.next = Float.intBitsToFloat(this.vals[nextI]);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void forEachRemaining(Consumer<? super Float> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            K[] keys = this.keys;
            int[] vals = this.vals;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                action.accept(Float.valueOf(Float.intBitsToFloat(vals[i])));
            }
            if (nextI != this.nextIndex || mc != UpdatableQHashSeparateKVObjFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public void forEachRemaining(FloatConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            K[] keys = this.keys;
            int[] vals = this.vals;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                action.accept(Float.intBitsToFloat(vals[i]));
            }
            if (nextI != this.nextIndex || mc != UpdatableQHashSeparateKVObjFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Float next() {
            return Float.valueOf(this.nextFloat());
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryCursor
    implements ObjCursor<Map.Entry<K, Float>> {
        final K[] keys;
        final int[] vals;
        int expectedModCount;
        int index;
        Object curKey;
        int curValue;

        NoRemovedEntryCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = UpdatableQHashSeparateKVObjFloatMapGO.this.set;
            this.index = this.keys.length;
            this.vals = UpdatableQHashSeparateKVObjFloatMapGO.this.values;
            this.curKey = ObjHash.FREE;
        }

        public void forEachForward(Consumer<? super Map.Entry<K, Float>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            K[] keys = this.keys;
            int[] vals = this.vals;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                action.accept(new MutableEntry(mc, i, key, vals[i]));
            }
            if (index != this.index || mc != UpdatableQHashSeparateKVObjFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = ObjHash.FREE;
        }

        public Map.Entry<K, Float> elem() {
            Object curKey = this.curKey;
            if (curKey != ObjHash.FREE) {
                return new MutableEntry(this.expectedModCount, this.index, curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == UpdatableQHashSeparateKVObjFloatMapGO.this.modCount()) {
                K[] keys = this.keys;
                for (int i = this.index - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = ObjHash.FREE;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryIterator
    implements ObjIterator<Map.Entry<K, Float>> {
        final K[] keys;
        final int[] vals;
        int expectedModCount;
        int nextIndex;
        MutableEntry next;

        NoRemovedEntryIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = UpdatableQHashSeparateKVObjFloatMapGO.this.set;
            Object[] keys = this.keys;
            this.vals = UpdatableQHashSeparateKVObjFloatMapGO.this.values;
            int[] vals = UpdatableQHashSeparateKVObjFloatMapGO.this.values;
            int nextI = keys.length;
            while (--nextI >= 0) {
                Object key = keys[nextI];
                if (key == ObjHash.FREE) continue;
                this.next = new MutableEntry(mc, nextI, key, vals[nextI]);
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<K, Float>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            K[] keys = this.keys;
            int[] vals = this.vals;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                action.accept(new MutableEntry(mc, i, key, vals[i]));
            }
            if (nextI != this.nextIndex || mc != UpdatableQHashSeparateKVObjFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<K, Float> next() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                int mc = this.expectedModCount;
                if (mc == UpdatableQHashSeparateKVObjFloatMapGO.this.modCount()) {
                    K[] keys = this.keys;
                    MutableEntry prev = this.next;
                    while (--nextI >= 0) {
                        Object key = keys[nextI];
                        if (key == ObjHash.FREE) continue;
                        this.next = new MutableEntry(mc, nextI, key, this.vals[nextI]);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class ValueView
    extends AbstractFloatValueView {
        ValueView() {
        }

        @Override
        public int size() {
            return UpdatableQHashSeparateKVObjFloatMapGO.this.size();
        }

        public boolean shrink() {
            return UpdatableQHashSeparateKVObjFloatMapGO.this.shrink();
        }

        @Override
        public boolean contains(Object o) {
            return UpdatableQHashSeparateKVObjFloatMapGO.this.containsValue(o);
        }

        public boolean contains(float v) {
            return UpdatableQHashSeparateKVObjFloatMapGO.this.containsValue(v);
        }

        @Override
        public boolean contains(int bits) {
            return UpdatableQHashSeparateKVObjFloatMapGO.this.containsValue(bits);
        }

        @Override
        public void forEach(Consumer<? super Float> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = UpdatableQHashSeparateKVObjFloatMapGO.this.modCount();
            Object[] keys = UpdatableQHashSeparateKVObjFloatMapGO.this.set;
            int[] vals = UpdatableQHashSeparateKVObjFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                action.accept(Float.valueOf(Float.intBitsToFloat(vals[i])));
            }
            if (mc != UpdatableQHashSeparateKVObjFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public void forEach(FloatConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = UpdatableQHashSeparateKVObjFloatMapGO.this.modCount();
            Object[] keys = UpdatableQHashSeparateKVObjFloatMapGO.this.set;
            int[] vals = UpdatableQHashSeparateKVObjFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                action.accept(Float.intBitsToFloat(vals[i]));
            }
            if (mc != UpdatableQHashSeparateKVObjFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(FloatPredicate predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = UpdatableQHashSeparateKVObjFloatMapGO.this.modCount();
            Object[] keys = UpdatableQHashSeparateKVObjFloatMapGO.this.set;
            int[] vals = UpdatableQHashSeparateKVObjFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE || predicate.test(Float.intBitsToFloat(vals[i]))) continue;
                terminated = true;
                break;
            }
            if (mc != UpdatableQHashSeparateKVObjFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Override
        public boolean allContainingIn(FloatCollection c) {
            if (c instanceof InternalFloatCollectionOps) {
                return this.allContainingIn((InternalFloatCollectionOps)c);
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            int mc = UpdatableQHashSeparateKVObjFloatMapGO.this.modCount();
            Object[] keys = UpdatableQHashSeparateKVObjFloatMapGO.this.set;
            int[] vals = UpdatableQHashSeparateKVObjFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE || c.contains(Float.intBitsToFloat(vals[i]))) continue;
                containsAll = false;
                break;
            }
            if (mc != UpdatableQHashSeparateKVObjFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        private boolean allContainingIn(InternalFloatCollectionOps c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            int mc = UpdatableQHashSeparateKVObjFloatMapGO.this.modCount();
            Object[] keys = UpdatableQHashSeparateKVObjFloatMapGO.this.set;
            int[] vals = UpdatableQHashSeparateKVObjFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE || c.contains(vals[i])) continue;
                containsAll = false;
                break;
            }
            if (mc != UpdatableQHashSeparateKVObjFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        @Override
        public boolean reverseAddAllTo(FloatCollection c) {
            if (c instanceof InternalFloatCollectionOps) {
                return this.reverseAddAllTo((InternalFloatCollectionOps)c);
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = UpdatableQHashSeparateKVObjFloatMapGO.this.modCount();
            Object[] keys = UpdatableQHashSeparateKVObjFloatMapGO.this.set;
            int[] vals = UpdatableQHashSeparateKVObjFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                changed |= c.add(Float.intBitsToFloat(vals[i]));
            }
            if (mc != UpdatableQHashSeparateKVObjFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean reverseAddAllTo(InternalFloatCollectionOps c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = UpdatableQHashSeparateKVObjFloatMapGO.this.modCount();
            Object[] keys = UpdatableQHashSeparateKVObjFloatMapGO.this.set;
            int[] vals = UpdatableQHashSeparateKVObjFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                changed |= c.add(vals[i]);
            }
            if (mc != UpdatableQHashSeparateKVObjFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public boolean reverseRemoveAllFrom(FloatSet s) {
            if (s instanceof InternalFloatCollectionOps) {
                return this.reverseRemoveAllFrom((InternalFloatCollectionOps)s);
            }
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = UpdatableQHashSeparateKVObjFloatMapGO.this.modCount();
            Object[] keys = UpdatableQHashSeparateKVObjFloatMapGO.this.set;
            int[] vals = UpdatableQHashSeparateKVObjFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                changed |= s.removeFloat(Float.intBitsToFloat(vals[i]));
            }
            if (mc != UpdatableQHashSeparateKVObjFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean reverseRemoveAllFrom(InternalFloatCollectionOps s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = UpdatableQHashSeparateKVObjFloatMapGO.this.modCount();
            Object[] keys = UpdatableQHashSeparateKVObjFloatMapGO.this.set;
            int[] vals = UpdatableQHashSeparateKVObjFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                changed |= s.removeFloat(vals[i]);
            }
            if (mc != UpdatableQHashSeparateKVObjFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Nonnull
        public FloatIterator iterator() {
            int mc = UpdatableQHashSeparateKVObjFloatMapGO.this.modCount();
            return new NoRemovedValueIterator(mc);
        }

        @Nonnull
        public FloatCursor cursor() {
            int mc = UpdatableQHashSeparateKVObjFloatMapGO.this.modCount();
            return new NoRemovedValueCursor(mc);
        }

        @Override
        @Nonnull
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = UpdatableQHashSeparateKVObjFloatMapGO.this.modCount();
            Object[] keys = UpdatableQHashSeparateKVObjFloatMapGO.this.set;
            int[] vals = UpdatableQHashSeparateKVObjFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                result[resultIndex++] = Float.valueOf(Float.intBitsToFloat(vals[i]));
            }
            if (mc != UpdatableQHashSeparateKVObjFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Override
        @Nonnull
        public <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = UpdatableQHashSeparateKVObjFloatMapGO.this.modCount();
            Object[] keys = UpdatableQHashSeparateKVObjFloatMapGO.this.set;
            int[] vals = UpdatableQHashSeparateKVObjFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                a[resultIndex++] = Float.valueOf(Float.intBitsToFloat(vals[i]));
            }
            if (mc != UpdatableQHashSeparateKVObjFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public float[] toFloatArray() {
            int size = this.size();
            float[] result = new float[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = UpdatableQHashSeparateKVObjFloatMapGO.this.modCount();
            Object[] keys = UpdatableQHashSeparateKVObjFloatMapGO.this.set;
            int[] vals = UpdatableQHashSeparateKVObjFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                result[resultIndex++] = Float.intBitsToFloat(vals[i]);
            }
            if (mc != UpdatableQHashSeparateKVObjFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        public float[] toArray(float[] a) {
            int size = this.size();
            if (a.length < size) {
                a = new float[size];
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = 0.0f;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = UpdatableQHashSeparateKVObjFloatMapGO.this.modCount();
            Object[] keys = UpdatableQHashSeparateKVObjFloatMapGO.this.set;
            int[] vals = UpdatableQHashSeparateKVObjFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                a[resultIndex++] = Float.intBitsToFloat(vals[i]);
            }
            if (mc != UpdatableQHashSeparateKVObjFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = 0.0f;
            }
            return a;
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = UpdatableQHashSeparateKVObjFloatMapGO.this.modCount();
            Object[] keys = UpdatableQHashSeparateKVObjFloatMapGO.this.set;
            int[] vals = UpdatableQHashSeparateKVObjFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                sb.append(' ').append(Float.intBitsToFloat(vals[i])).append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            if (mc != UpdatableQHashSeparateKVObjFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        @Override
        public boolean remove(Object o) {
            return this.removeFloat(((Float)o).floatValue());
        }

        public boolean removeFloat(float v) {
            return UpdatableQHashSeparateKVObjFloatMapGO.this.removeValue(v);
        }

        @Override
        public boolean removeFloat(int bits) {
            return UpdatableQHashSeparateKVObjFloatMapGO.this.removeValue(bits);
        }

        @Override
        public void clear() {
            UpdatableQHashSeparateKVObjFloatMapGO.this.clear();
        }

        @Override
        public boolean removeIf(Predicate<? super Float> filter) {
            throw new UnsupportedOperationException();
        }

        public boolean removeIf(FloatPredicate filter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }
    }

    class ReusableEntry
    extends ObjFloatEntry {
        private K key;
        private int value;

        ReusableEntry() {
        }

        ReusableEntry with(K key, int value) {
            this.key = key;
            this.value = value;
            return this;
        }

        @Override
        public K key() {
            return this.key;
        }

        @Override
        public int value() {
            return this.value;
        }
    }

    class MutableEntry
    extends ObjFloatEntry {
        int modCount;
        private final int index;
        final K key;
        private int value;

        MutableEntry(int modCount, int index, K key, int value) {
            this.modCount = modCount;
            this.index = index;
            this.key = key;
            this.value = value;
        }

        @Override
        public K key() {
            return this.key;
        }

        @Override
        public int value() {
            return this.value;
        }

        @Override
        public Float setValue(Float newValue) {
            int unwrappedNewValue;
            if (this.modCount != UpdatableQHashSeparateKVObjFloatMapGO.this.modCount()) {
                throw new IllegalStateException();
            }
            float oldValue = Float.intBitsToFloat(this.value);
            this.value = unwrappedNewValue = Float.floatToIntBits(newValue.floatValue());
            this.updateValueInTable(unwrappedNewValue);
            return Float.valueOf(oldValue);
        }

        void updateValueInTable(int newValue) {
            UpdatableQHashSeparateKVObjFloatMapGO.this.values[this.index] = newValue;
        }
    }

    abstract class ObjFloatEntry
    extends AbstractEntry<K, Float> {
        ObjFloatEntry() {
        }

        abstract K key();

        @Override
        public final K getKey() {
            return this.key();
        }

        abstract int value();

        @Override
        public final Float getValue() {
            return Float.valueOf(Float.intBitsToFloat(this.value()));
        }

        @Override
        public boolean equals(Object o) {
            try {
                Map.Entry e2 = (Map.Entry)o;
                Object k2 = e2.getKey();
                int v2 = Float.floatToIntBits(((Float)e2.getValue()).floatValue());
                return UpdatableQHashSeparateKVObjFloatMapGO.this.nullableKeyEquals(this.key(), k2) && this.value() == v2;
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        @Override
        public int hashCode() {
            return UpdatableQHashSeparateKVObjFloatMapGO.this.nullableKeyHashCode(this.key()) ^ Primitives.hashCode(this.value());
        }
    }

    class EntryView
    extends AbstractSetView<Map.Entry<K, Float>>
    implements HashObjSet<Map.Entry<K, Float>>,
    InternalObjCollectionOps<Map.Entry<K, Float>> {
        EntryView() {
        }

        @Nullable
        public Equivalence<Map.Entry<K, Float>> equivalence() {
            return Equivalence.entryEquivalence(UpdatableQHashSeparateKVObjFloatMapGO.this.keyEquivalence(), null);
        }

        @Nonnull
        public HashConfig hashConfig() {
            return UpdatableQHashSeparateKVObjFloatMapGO.this.hashConfig();
        }

        @Override
        public int size() {
            return UpdatableQHashSeparateKVObjFloatMapGO.this.size();
        }

        public double currentLoad() {
            return UpdatableQHashSeparateKVObjFloatMapGO.this.currentLoad();
        }

        @Override
        public boolean contains(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                return UpdatableQHashSeparateKVObjFloatMapGO.this.containsEntry(e.getKey(), ((Float)e.getValue()).floatValue());
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        @Nonnull
        public final Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = UpdatableQHashSeparateKVObjFloatMapGO.this.modCount();
            Object[] keys = UpdatableQHashSeparateKVObjFloatMapGO.this.set;
            int[] vals = UpdatableQHashSeparateKVObjFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                result[resultIndex++] = new MutableEntry(mc, i, key, vals[i]);
            }
            if (mc != UpdatableQHashSeparateKVObjFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Override
        @Nonnull
        public final <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = UpdatableQHashSeparateKVObjFloatMapGO.this.modCount();
            Object[] keys = UpdatableQHashSeparateKVObjFloatMapGO.this.set;
            int[] vals = UpdatableQHashSeparateKVObjFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                a[resultIndex++] = new MutableEntry(mc, i, key, vals[i]);
            }
            if (mc != UpdatableQHashSeparateKVObjFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        @Override
        public final void forEach(@Nonnull Consumer<? super Map.Entry<K, Float>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = UpdatableQHashSeparateKVObjFloatMapGO.this.modCount();
            Object[] keys = UpdatableQHashSeparateKVObjFloatMapGO.this.set;
            int[] vals = UpdatableQHashSeparateKVObjFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                action.accept(new MutableEntry(mc, i, key, vals[i]));
            }
            if (mc != UpdatableQHashSeparateKVObjFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(@Nonnull Predicate<? super Map.Entry<K, Float>> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = UpdatableQHashSeparateKVObjFloatMapGO.this.modCount();
            Object[] keys = UpdatableQHashSeparateKVObjFloatMapGO.this.set;
            int[] vals = UpdatableQHashSeparateKVObjFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE || predicate.test(new MutableEntry(mc, i, key, vals[i]))) continue;
                terminated = true;
                break;
            }
            if (mc != UpdatableQHashSeparateKVObjFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Override
        @Nonnull
        public ObjIterator<Map.Entry<K, Float>> iterator() {
            int mc = UpdatableQHashSeparateKVObjFloatMapGO.this.modCount();
            return new NoRemovedEntryIterator(mc);
        }

        @Nonnull
        public ObjCursor<Map.Entry<K, Float>> cursor() {
            int mc = UpdatableQHashSeparateKVObjFloatMapGO.this.modCount();
            return new NoRemovedEntryCursor(mc);
        }

        @Override
        public final boolean containsAll(@Nonnull Collection<?> c) {
            return CommonObjCollectionOps.containsAll(this, c);
        }

        @Override
        public final boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            ReusableEntry e = new ReusableEntry();
            int mc = UpdatableQHashSeparateKVObjFloatMapGO.this.modCount();
            Object[] keys = UpdatableQHashSeparateKVObjFloatMapGO.this.set;
            int[] vals = UpdatableQHashSeparateKVObjFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE || c.contains((Object)e.with(key, vals[i]))) continue;
                containsAll = false;
                break;
            }
            if (mc != UpdatableQHashSeparateKVObjFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        @Override
        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = UpdatableQHashSeparateKVObjFloatMapGO.this.modCount();
            Object[] keys = UpdatableQHashSeparateKVObjFloatMapGO.this.set;
            int[] vals = UpdatableQHashSeparateKVObjFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                changed |= s.remove((Object)e.with(key, vals[i]));
            }
            if (mc != UpdatableQHashSeparateKVObjFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public final boolean reverseAddAllTo(ObjCollection<? super Map.Entry<K, Float>> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = UpdatableQHashSeparateKVObjFloatMapGO.this.modCount();
            Object[] keys = UpdatableQHashSeparateKVObjFloatMapGO.this.set;
            int[] vals = UpdatableQHashSeparateKVObjFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                changed |= c.add((Object)new MutableEntry(mc, i, key, vals[i]));
            }
            if (mc != UpdatableQHashSeparateKVObjFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public int hashCode() {
            return UpdatableQHashSeparateKVObjFloatMapGO.this.hashCode();
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = UpdatableQHashSeparateKVObjFloatMapGO.this.modCount();
            Object[] keys = UpdatableQHashSeparateKVObjFloatMapGO.this.set;
            int[] vals = UpdatableQHashSeparateKVObjFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                sb.append(' ');
                sb.append(key != this ? key : "(this Collection)");
                sb.append('=');
                sb.append(Float.intBitsToFloat(vals[i]));
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            if (mc != UpdatableQHashSeparateKVObjFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean shrink() {
            return UpdatableQHashSeparateKVObjFloatMapGO.this.shrink();
        }

        @Override
        public boolean remove(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                Object key = e.getKey();
                float value = ((Float)e.getValue()).floatValue();
                return UpdatableQHashSeparateKVObjFloatMapGO.this.remove(key, value);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        public final boolean removeIf(@Nonnull Predicate<? super Map.Entry<K, Float>> filter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof InternalObjCollectionOps) {
                InternalObjCollectionOps c2 = (InternalObjCollectionOps)((Object)c);
                if (NullableObjects.equals(this.equivalence(), c2.equivalence()) && c2.size() < this.size()) {
                    c2.reverseRemoveAllFrom((ObjSet<?>)this);
                }
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            UpdatableQHashSeparateKVObjFloatMapGO.this.clear();
        }
    }
}

