/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleConsumer;
import java.util.function.DoublePredicate;
import java.util.function.Function;
import java.util.function.ObjDoubleConsumer;
import java.util.function.Predicate;
import java.util.function.ToDoubleFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.openhft.collect.DoubleCollection;
import net.openhft.collect.DoubleCursor;
import net.openhft.collect.DoubleIterator;
import net.openhft.collect.Equivalence;
import net.openhft.collect.ObjCollection;
import net.openhft.collect.ObjCursor;
import net.openhft.collect.ObjIterator;
import net.openhft.collect.hash.HashConfig;
import net.openhft.collect.impl.AbstractDoubleValueView;
import net.openhft.collect.impl.AbstractEntry;
import net.openhft.collect.impl.AbstractSetView;
import net.openhft.collect.impl.CommonMapOps;
import net.openhft.collect.impl.CommonObjCollectionOps;
import net.openhft.collect.impl.CommonObjDoubleMapOps;
import net.openhft.collect.impl.InternalDoubleCollectionOps;
import net.openhft.collect.impl.InternalObjCollectionOps;
import net.openhft.collect.impl.InternalObjDoubleMapOps;
import net.openhft.collect.impl.NullableObjects;
import net.openhft.collect.impl.Primitives;
import net.openhft.collect.impl.hash.ObjHash;
import net.openhft.collect.impl.hash.QHash;
import net.openhft.collect.impl.hash.SeparateKVObjDoubleQHash;
import net.openhft.collect.impl.hash.UpdatableQHashSeparateKVObjDoubleMapSO;
import net.openhft.collect.map.ObjDoubleCursor;
import net.openhft.collect.set.DoubleSet;
import net.openhft.collect.set.ObjSet;
import net.openhft.collect.set.hash.HashObjSet;
import net.openhft.function.ObjDoublePredicate;
import net.openhft.function.ObjDoubleToDoubleFunction;

public class UpdatableQHashSeparateKVObjDoubleMapGO<K>
extends UpdatableQHashSeparateKVObjDoubleMapSO<K> {
    @Override
    final void copy(SeparateKVObjDoubleQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.copy(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    final void move(SeparateKVObjDoubleQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.move(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public double defaultValue() {
        return 0.0;
    }

    @Override
    public boolean containsEntry(Object key, double value) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index] == Double.doubleToLongBits(value);
        }
        return false;
    }

    @Override
    public boolean containsEntry(Object key, long value) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index] == value;
        }
        return false;
    }

    @Override
    public Double get(Object key) {
        int index = this.index(key);
        if (index >= 0) {
            return Double.longBitsToDouble(this.values[index]);
        }
        return null;
    }

    public double getDouble(Object key) {
        int index = this.index(key);
        if (index >= 0) {
            return Double.longBitsToDouble(this.values[index]);
        }
        return this.defaultValue();
    }

    @Override
    public Double getOrDefault(Object key, Double defaultValue) {
        int index = this.index(key);
        if (index >= 0) {
            return Double.longBitsToDouble(this.values[index]);
        }
        return defaultValue;
    }

    @Override
    public double getOrDefault(Object key, double defaultValue) {
        int index = this.index(key);
        if (index >= 0) {
            return Double.longBitsToDouble(this.values[index]);
        }
        return defaultValue;
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super Double> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        Object[] keys = this.set;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            Object key = keys[i];
            if (key == FREE) continue;
            action.accept(key, Double.longBitsToDouble(vals[i]));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public void forEach(ObjDoubleConsumer<? super K> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        Object[] keys = this.set;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            Object key = keys[i];
            if (key == FREE) continue;
            action.accept(key, Double.longBitsToDouble(vals[i]));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public boolean forEachWhile(ObjDoublePredicate<? super K> predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        int mc = this.modCount();
        Object[] keys = this.set;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            Object key = keys[i];
            if (key == FREE || predicate.test(key, Double.longBitsToDouble(vals[i]))) continue;
            terminated = true;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return !terminated;
    }

    @Nonnull
    public ObjDoubleCursor<K> cursor() {
        int mc = this.modCount();
        return new NoRemovedMapCursor(mc);
    }

    @Override
    public boolean containsAllEntries(Map<?, ?> m) {
        return CommonObjDoubleMapOps.containsAllEntries(this, m);
    }

    @Override
    public boolean allEntriesContainingIn(InternalObjDoubleMapOps<?> m) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        int mc = this.modCount();
        Object[] keys = this.set;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            Object key = keys[i];
            if (key == FREE || m.containsEntry(key, vals[i])) continue;
            containsAll = false;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return containsAll;
    }

    @Override
    public void reversePutAllTo(InternalObjDoubleMapOps<? super K> m) {
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        Object[] keys = this.set;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            Object key = keys[i];
            if (key == FREE) continue;
            m.justPut(key, vals[i]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    @Nonnull
    public HashObjSet<Map.Entry<K, Double>> entrySet() {
        return new EntryView();
    }

    @Nonnull
    public DoubleCollection values() {
        return new ValueView();
    }

    @Override
    public boolean equals(Object o) {
        return CommonMapOps.equals(this, o);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        int mc = this.modCount();
        Object[] keys = this.set;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            Object key = keys[i];
            if (key == FREE) continue;
            long val = vals[i];
            hashCode += this.nullableKeyHashCode(key) ^ (int)(val ^ val >>> 32);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return hashCode;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        int mc = this.modCount();
        Object[] keys = this.set;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            Object key = keys[i];
            if (key == FREE) continue;
            sb.append(' ');
            sb.append(key != this ? key : "(this Map)");
            sb.append('=');
            sb.append(Double.longBitsToDouble(vals[i]));
            sb.append(',');
            if (++elementCount != 8) continue;
            int expectedLength = sb.length() * (this.size() / 8);
            sb.ensureCapacity(expectedLength + expectedLength / 2);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        sb.setCharAt(0, '{');
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    @Override
    void rehash(int newCapacity) {
        int mc = this.modCount();
        Object[] keys = this.set;
        long[] vals = this.values;
        this.initForRehash(newCapacity);
        ++mc;
        Object[] newKeys = this.set;
        int capacity = newKeys.length;
        long[] newVals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            Object key = keys[i];
            if (key == FREE) continue;
            int index = QHash.SeparateKVObjKeyMixing.mix(this.nullableKeyHashCode(key)) % capacity;
            if (newKeys[index] != FREE) {
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if (newKeys[bIndex] != FREE) {
                        index = bIndex;
                        break;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if (newKeys[fIndex] != FREE) {
                        index = fIndex;
                        break;
                    }
                    step += 2;
                }
            }
            newKeys[index] = key;
            newVals[index] = vals[i];
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public Double put(K key, Double value) {
        int index = this.insert(key, Double.doubleToLongBits(value));
        if (index < 0) {
            return null;
        }
        long[] vals = this.values;
        double prevValue = Double.longBitsToDouble(vals[index]);
        vals[index] = Double.doubleToLongBits(value);
        return prevValue;
    }

    @Override
    public double put(K key, double value) {
        int index = this.insert(key, Double.doubleToLongBits(value));
        if (index < 0) {
            return this.defaultValue();
        }
        long[] vals = this.values;
        double prevValue = Double.longBitsToDouble(vals[index]);
        vals[index] = Double.doubleToLongBits(value);
        return prevValue;
    }

    @Override
    public Double putIfAbsent(K key, Double value) {
        int index = this.insert(key, Double.doubleToLongBits(value));
        if (index < 0) {
            return null;
        }
        return Double.longBitsToDouble(this.values[index]);
    }

    @Override
    public double putIfAbsent(K key, double value) {
        int index = this.insert(key, Double.doubleToLongBits(value));
        if (index < 0) {
            return this.defaultValue();
        }
        return Double.longBitsToDouble(this.values[index]);
    }

    @Override
    public void justPut(K key, double value) {
        int index = this.insert(key, Double.doubleToLongBits(value));
        if (index < 0) {
            return;
        }
        this.values[index] = Double.doubleToLongBits(value);
    }

    @Override
    public void justPut(K key, long value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return;
        }
        this.values[index] = value;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Double compute(K key, BiFunction<? super K, ? super Double, ? extends Double> remappingFunction) {
        if (key != null) {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            keys = this.set;
            vals = this.values;
            capacity = keys.length;
            index = QHash.SeparateKVObjKeyMixing.mix(this.keyHashCode(key)) % capacity;
            cur = keys[index];
            if (cur != key) {
                if (cur != UpdatableQHashSeparateKVObjDoubleMapGO.FREE) {
                    if (!this.keyEquals(key, cur)) {
                        bIndex = index;
                        fIndex = index;
                        step = 1;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == key) {
                                index = bIndex;
                                break;
                            }
                            if (cur == UpdatableQHashSeparateKVObjDoubleMapGO.FREE) {
                                index = bIndex;
                                ** break;
                            }
                            if (this.keyEquals(key, cur)) {
                                index = bIndex;
                                break;
                            }
                            t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == key) {
                                index = fIndex;
                                break;
                            }
                            if (cur == UpdatableQHashSeparateKVObjDoubleMapGO.FREE) {
                                index = fIndex;
                                ** break;
                            }
                            if (this.keyEquals(key, cur)) {
                                index = fIndex;
                                break;
                            }
                            step += 2;
                        }
                    }
                } else lbl-1000:
                // 3 sources

                {
                    if ((newValue = remappingFunction.apply(key, null)) != null) {
                        this.incrementModCount();
                        keys[index] = key;
                        vals[index] = Double.doubleToLongBits(newValue);
                        this.postInsertHook();
                        return newValue;
                    }
                    return null;
                }
            }
            if ((newValue = remappingFunction.apply(key, Double.longBitsToDouble(vals[index]))) != null) {
                vals[index] = Double.doubleToLongBits(newValue);
                return newValue;
            }
            throw new UnsupportedOperationException("Compute operation of updatable map doesn't support removals");
        }
        return this.computeNullKey(remappingFunction);
    }

    Double computeNullKey(BiFunction<? super K, ? super Double, ? extends Double> remappingFunction) {
        Double newValue;
        int index;
        long[] vals;
        block12: {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            Object[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = 0;
            Object cur = keys[0];
            if (cur != null) {
                Double newValue2;
                if (cur != FREE) {
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if ((cur = keys[bIndex]) == null) {
                            index = bIndex;
                            break block12;
                        }
                        if (cur == FREE) {
                            index = bIndex;
                            break;
                        }
                        int t = (fIndex += step) - capacity;
                        if (t >= 0) {
                            fIndex = t;
                        }
                        if ((cur = keys[fIndex]) == null) {
                            index = fIndex;
                            break block12;
                        }
                        if (cur == FREE) {
                            index = fIndex;
                            break;
                        }
                        step += 2;
                    }
                }
                if ((newValue2 = remappingFunction.apply(null, null)) != null) {
                    this.incrementModCount();
                    keys[index] = null;
                    vals[index] = Double.doubleToLongBits(newValue2);
                    this.postInsertHook();
                    return newValue2;
                }
                return null;
            }
        }
        if ((newValue = remappingFunction.apply(null, Double.longBitsToDouble(vals[index]))) != null) {
            vals[index] = Double.doubleToLongBits(newValue);
            return newValue;
        }
        throw new UnsupportedOperationException("Compute operation of updatable map doesn't support removals");
    }

    /*
     * Unable to fully structure code
     */
    public double compute(K key, ObjDoubleToDoubleFunction<? super K> remappingFunction) {
        if (key != null) {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            keys = this.set;
            vals = this.values;
            capacity = keys.length;
            index = QHash.SeparateKVObjKeyMixing.mix(this.keyHashCode(key)) % capacity;
            cur = keys[index];
            if (cur != key) {
                if (cur != UpdatableQHashSeparateKVObjDoubleMapGO.FREE) {
                    if (!this.keyEquals(key, cur)) {
                        bIndex = index;
                        fIndex = index;
                        step = 1;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == key) {
                                index = bIndex;
                                break;
                            }
                            if (cur == UpdatableQHashSeparateKVObjDoubleMapGO.FREE) {
                                index = bIndex;
                                ** break;
                            }
                            if (this.keyEquals(key, cur)) {
                                index = bIndex;
                                break;
                            }
                            t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == key) {
                                index = fIndex;
                                break;
                            }
                            if (cur == UpdatableQHashSeparateKVObjDoubleMapGO.FREE) {
                                index = fIndex;
                                ** break;
                            }
                            if (this.keyEquals(key, cur)) {
                                index = fIndex;
                                break;
                            }
                            step += 2;
                        }
                    }
                } else lbl-1000:
                // 3 sources

                {
                    newValue = remappingFunction.applyAsDouble(key, this.defaultValue());
                    this.incrementModCount();
                    keys[index] = key;
                    vals[index] = Double.doubleToLongBits(newValue);
                    this.postInsertHook();
                    return newValue;
                }
            }
            newValue = remappingFunction.applyAsDouble(key, Double.longBitsToDouble(vals[index]));
            vals[index] = Double.doubleToLongBits(newValue);
            return newValue;
        }
        return this.computeNullKey(remappingFunction);
    }

    double computeNullKey(ObjDoubleToDoubleFunction<? super K> remappingFunction) {
        int index;
        long[] vals;
        block10: {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            Object[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = 0;
            Object cur = keys[0];
            if (cur != null) {
                if (cur != FREE) {
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if ((cur = keys[bIndex]) == null) {
                            index = bIndex;
                            break block10;
                        }
                        if (cur == FREE) {
                            index = bIndex;
                            break;
                        }
                        int t = (fIndex += step) - capacity;
                        if (t >= 0) {
                            fIndex = t;
                        }
                        if ((cur = keys[fIndex]) == null) {
                            index = fIndex;
                            break block10;
                        }
                        if (cur == FREE) {
                            index = fIndex;
                            break;
                        }
                        step += 2;
                    }
                }
                double newValue = remappingFunction.applyAsDouble(null, this.defaultValue());
                this.incrementModCount();
                keys[index] = null;
                vals[index] = Double.doubleToLongBits(newValue);
                this.postInsertHook();
                return newValue;
            }
        }
        double newValue = remappingFunction.applyAsDouble(null, Double.longBitsToDouble(vals[index]));
        vals[index] = Double.doubleToLongBits(newValue);
        return newValue;
    }

    @Override
    public Double computeIfAbsent(K key, Function<? super K, ? extends Double> mappingFunction) {
        if (key != null) {
            Double value;
            if (mappingFunction == null) {
                throw new NullPointerException();
            }
            Object[] keys = this.set;
            long[] vals = this.values;
            int capacity = keys.length;
            int index = QHash.SeparateKVObjKeyMixing.mix(this.keyHashCode(key)) % capacity;
            Object cur = keys[index];
            if (cur != FREE) {
                if (cur == key || this.keyEquals(key, cur)) {
                    return Double.longBitsToDouble(vals[index]);
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == FREE) {
                        index = bIndex;
                        break;
                    }
                    if (cur == key || this.keyEquals(key, cur)) {
                        return Double.longBitsToDouble(vals[bIndex]);
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == FREE) {
                        index = fIndex;
                        break;
                    }
                    if (cur == key || this.keyEquals(key, cur)) {
                        return Double.longBitsToDouble(vals[fIndex]);
                    }
                    step += 2;
                }
            }
            if ((value = mappingFunction.apply(key)) != null) {
                this.incrementModCount();
                keys[index] = key;
                vals[index] = Double.doubleToLongBits(value);
                this.postInsertHook();
                return value;
            }
            return null;
        }
        return this.computeIfAbsentNullKey(mappingFunction);
    }

    Double computeIfAbsentNullKey(Function<? super K, ? extends Double> mappingFunction) {
        Double value;
        if (mappingFunction == null) {
            throw new NullPointerException();
        }
        Object[] keys = this.set;
        long[] vals = this.values;
        int capacity = keys.length;
        int index = 0;
        Object cur = keys[0];
        if (cur != FREE) {
            if (cur == null) {
                return Double.longBitsToDouble(vals[index]);
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = keys[bIndex]) == FREE) {
                    index = bIndex;
                    break;
                }
                if (cur == null) {
                    return Double.longBitsToDouble(vals[bIndex]);
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = keys[fIndex]) == FREE) {
                    index = fIndex;
                    break;
                }
                if (cur == null) {
                    return Double.longBitsToDouble(vals[fIndex]);
                }
                step += 2;
            }
        }
        if ((value = mappingFunction.apply(null)) != null) {
            this.incrementModCount();
            keys[index] = null;
            vals[index] = Double.doubleToLongBits(value);
            this.postInsertHook();
            return value;
        }
        return null;
    }

    public double computeIfAbsent(K key, ToDoubleFunction<? super K> mappingFunction) {
        if (key != null) {
            if (mappingFunction == null) {
                throw new NullPointerException();
            }
            Object[] keys = this.set;
            long[] vals = this.values;
            int capacity = keys.length;
            int index = QHash.SeparateKVObjKeyMixing.mix(this.keyHashCode(key)) % capacity;
            Object cur = keys[index];
            if (cur != FREE) {
                if (cur == key || this.keyEquals(key, cur)) {
                    return Double.longBitsToDouble(vals[index]);
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == FREE) {
                        index = bIndex;
                        break;
                    }
                    if (cur == key || this.keyEquals(key, cur)) {
                        return Double.longBitsToDouble(vals[bIndex]);
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == FREE) {
                        index = fIndex;
                        break;
                    }
                    if (cur == key || this.keyEquals(key, cur)) {
                        return Double.longBitsToDouble(vals[fIndex]);
                    }
                    step += 2;
                }
            }
            double value = mappingFunction.applyAsDouble(key);
            this.incrementModCount();
            keys[index] = key;
            vals[index] = Double.doubleToLongBits(value);
            this.postInsertHook();
            return value;
        }
        return this.computeIfAbsentNullKey(mappingFunction);
    }

    double computeIfAbsentNullKey(ToDoubleFunction<? super K> mappingFunction) {
        if (mappingFunction == null) {
            throw new NullPointerException();
        }
        Object[] keys = this.set;
        long[] vals = this.values;
        int capacity = keys.length;
        int index = 0;
        Object cur = keys[0];
        if (cur != FREE) {
            if (cur == null) {
                return Double.longBitsToDouble(vals[index]);
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = keys[bIndex]) == FREE) {
                    index = bIndex;
                    break;
                }
                if (cur == null) {
                    return Double.longBitsToDouble(vals[bIndex]);
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = keys[fIndex]) == FREE) {
                    index = fIndex;
                    break;
                }
                if (cur == null) {
                    return Double.longBitsToDouble(vals[fIndex]);
                }
                step += 2;
            }
        }
        double value = mappingFunction.applyAsDouble(null);
        this.incrementModCount();
        keys[index] = null;
        vals[index] = Double.doubleToLongBits(value);
        this.postInsertHook();
        return value;
    }

    @Override
    public Double computeIfPresent(K key, BiFunction<? super K, ? super Double, ? extends Double> remappingFunction) {
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        int index = this.index(key);
        if (index >= 0) {
            long[] vals = this.values;
            Double newValue = remappingFunction.apply(key, Double.longBitsToDouble(vals[index]));
            if (newValue != null) {
                vals[index] = Double.doubleToLongBits(newValue);
                return newValue;
            }
            throw new UnsupportedOperationException("ComputeIfPresent operation of updatable map doesn't support removals");
        }
        return null;
    }

    public double computeIfPresent(K key, ObjDoubleToDoubleFunction<? super K> remappingFunction) {
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        int index = this.index(key);
        if (index >= 0) {
            long[] vals = this.values;
            double newValue = remappingFunction.applyAsDouble(key, Double.longBitsToDouble(vals[index]));
            vals[index] = Double.doubleToLongBits(newValue);
            return newValue;
        }
        return this.defaultValue();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Double merge(K key, Double value, BiFunction<? super Double, ? super Double, ? extends Double> remappingFunction) {
        if (key != null) {
            if (value == null) {
                throw new NullPointerException();
            }
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            keys = this.set;
            vals = this.values;
            capacity = keys.length;
            index = QHash.SeparateKVObjKeyMixing.mix(this.keyHashCode(key)) % capacity;
            cur = keys[index];
            if (cur != key) {
                if (cur != UpdatableQHashSeparateKVObjDoubleMapGO.FREE) {
                    if (!this.keyEquals(key, cur)) {
                        bIndex = index;
                        fIndex = index;
                        step = 1;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == key) {
                                index = bIndex;
                                break;
                            }
                            if (cur == UpdatableQHashSeparateKVObjDoubleMapGO.FREE) {
                                index = bIndex;
                                ** break;
                            }
                            if (this.keyEquals(key, cur)) {
                                index = bIndex;
                                break;
                            }
                            t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == key) {
                                index = fIndex;
                                break;
                            }
                            if (cur == UpdatableQHashSeparateKVObjDoubleMapGO.FREE) {
                                index = fIndex;
                                ** break;
                            }
                            if (this.keyEquals(key, cur)) {
                                index = fIndex;
                                break;
                            }
                            step += 2;
                        }
                    }
                } else lbl-1000:
                // 3 sources

                {
                    this.incrementModCount();
                    keys[index] = key;
                    vals[index] = Double.doubleToLongBits(value);
                    this.postInsertHook();
                    return value;
                }
            }
            if ((newValue = remappingFunction.apply((Double)Double.longBitsToDouble(vals[index]), value)) != null) {
                vals[index] = Double.doubleToLongBits(newValue);
                return newValue;
            }
            throw new UnsupportedOperationException("Merge operation of updatable map doesn't support removals");
        }
        return this.mergeNullKey(value, remappingFunction);
    }

    Double mergeNullKey(Double value, BiFunction<? super Double, ? super Double, ? extends Double> remappingFunction) {
        Double newValue;
        int index;
        long[] vals;
        block12: {
            if (value == null) {
                throw new NullPointerException();
            }
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            Object[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = 0;
            Object cur = keys[0];
            if (cur != null) {
                if (cur != FREE) {
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if ((cur = keys[bIndex]) == null) {
                            index = bIndex;
                            break block12;
                        }
                        if (cur == FREE) {
                            index = bIndex;
                            break;
                        }
                        int t = (fIndex += step) - capacity;
                        if (t >= 0) {
                            fIndex = t;
                        }
                        if ((cur = keys[fIndex]) == null) {
                            index = fIndex;
                            break block12;
                        }
                        if (cur == FREE) {
                            index = fIndex;
                            break;
                        }
                        step += 2;
                    }
                }
                this.incrementModCount();
                keys[index] = null;
                vals[index] = Double.doubleToLongBits(value);
                this.postInsertHook();
                return value;
            }
        }
        if ((newValue = remappingFunction.apply((Double)Double.longBitsToDouble(vals[index]), value)) != null) {
            vals[index] = Double.doubleToLongBits(newValue);
            return newValue;
        }
        throw new UnsupportedOperationException("Merge operation of updatable map doesn't support removals");
    }

    /*
     * Unable to fully structure code
     */
    public double merge(K key, double value, DoubleBinaryOperator remappingFunction) {
        if (key != null) {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            keys = this.set;
            vals = this.values;
            capacity = keys.length;
            index = QHash.SeparateKVObjKeyMixing.mix(this.keyHashCode(key)) % capacity;
            cur = keys[index];
            if (cur != key) {
                if (cur != UpdatableQHashSeparateKVObjDoubleMapGO.FREE) {
                    if (!this.keyEquals(key, cur)) {
                        bIndex = index;
                        fIndex = index;
                        step = 1;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == key) {
                                index = bIndex;
                                break;
                            }
                            if (cur == UpdatableQHashSeparateKVObjDoubleMapGO.FREE) {
                                index = bIndex;
                                ** break;
                            }
                            if (this.keyEquals(key, cur)) {
                                index = bIndex;
                                break;
                            }
                            t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == key) {
                                index = fIndex;
                                break;
                            }
                            if (cur == UpdatableQHashSeparateKVObjDoubleMapGO.FREE) {
                                index = fIndex;
                                ** break;
                            }
                            if (this.keyEquals(key, cur)) {
                                index = fIndex;
                                break;
                            }
                            step += 2;
                        }
                    }
                } else lbl-1000:
                // 3 sources

                {
                    this.incrementModCount();
                    keys[index] = key;
                    vals[index] = Double.doubleToLongBits(value);
                    this.postInsertHook();
                    return value;
                }
            }
            newValue = remappingFunction.applyAsDouble(Double.longBitsToDouble(vals[index]), value);
            vals[index] = Double.doubleToLongBits(newValue);
            return newValue;
        }
        return this.mergeNullKey(value, remappingFunction);
    }

    double mergeNullKey(double value, DoubleBinaryOperator remappingFunction) {
        int index;
        long[] vals;
        block10: {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            Object[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = 0;
            Object cur = keys[0];
            if (cur != null) {
                if (cur != FREE) {
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if ((cur = keys[bIndex]) == null) {
                            index = bIndex;
                            break block10;
                        }
                        if (cur == FREE) {
                            index = bIndex;
                            break;
                        }
                        int t = (fIndex += step) - capacity;
                        if (t >= 0) {
                            fIndex = t;
                        }
                        if ((cur = keys[fIndex]) == null) {
                            index = fIndex;
                            break block10;
                        }
                        if (cur == FREE) {
                            index = fIndex;
                            break;
                        }
                        step += 2;
                    }
                }
                this.incrementModCount();
                keys[index] = null;
                vals[index] = Double.doubleToLongBits(value);
                this.postInsertHook();
                return value;
            }
        }
        double newValue = remappingFunction.applyAsDouble(Double.longBitsToDouble(vals[index]), value);
        vals[index] = Double.doubleToLongBits(newValue);
        return newValue;
    }

    public double addValue(K key, double value) {
        int index = this.insert(key, Double.doubleToLongBits(value));
        if (index < 0) {
            return value;
        }
        long[] vals = this.values;
        double newValue = Double.longBitsToDouble(vals[index]) + value;
        vals[index] = Double.doubleToLongBits(newValue);
        return newValue;
    }

    public double addValue(K key, double addition, double defaultValue) {
        double value = defaultValue + addition;
        int index = this.insert(key, Double.doubleToLongBits(value));
        if (index < 0) {
            return value;
        }
        long[] vals = this.values;
        double newValue = Double.longBitsToDouble(vals[index]) + addition;
        vals[index] = Double.doubleToLongBits(newValue);
        return newValue;
    }

    @Override
    public void putAll(@Nonnull Map<? extends K, ? extends Double> m) {
        CommonObjDoubleMapOps.putAll(this, m);
    }

    @Override
    public Double replace(K key, Double value) {
        int index = this.index(key);
        if (index >= 0) {
            long[] vals = this.values;
            double oldValue = Double.longBitsToDouble(vals[index]);
            vals[index] = Double.doubleToLongBits(value);
            return oldValue;
        }
        return null;
    }

    @Override
    public double replace(K key, double value) {
        int index = this.index(key);
        if (index >= 0) {
            long[] vals = this.values;
            double oldValue = Double.longBitsToDouble(vals[index]);
            vals[index] = Double.doubleToLongBits(value);
            return oldValue;
        }
        return this.defaultValue();
    }

    @Override
    public boolean replace(K key, Double oldValue, Double newValue) {
        return this.replace(key, (double)oldValue, (double)newValue);
    }

    @Override
    public boolean replace(K key, double oldValue, double newValue) {
        int index = this.index(key);
        if (index >= 0) {
            long[] vals = this.values;
            if (vals[index] == Double.doubleToLongBits(oldValue)) {
                vals[index] = Double.doubleToLongBits(newValue);
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super Double, ? extends Double> function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        Object[] keys = this.set;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            Object key = keys[i];
            if (key == FREE) continue;
            vals[i] = Double.doubleToLongBits(function.apply(key, Double.longBitsToDouble(vals[i])));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void replaceAll(ObjDoubleToDoubleFunction<? super K> function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        Object[] keys = this.set;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            Object key = keys[i];
            if (key == FREE) continue;
            vals[i] = Double.doubleToLongBits(function.applyAsDouble(key, Double.longBitsToDouble(vals[i])));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public void clear() {
        int mc = this.modCount() + 1;
        super.clear();
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public Double remove(Object key) {
        throw new UnsupportedOperationException();
    }

    Double removeNullKey() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean justRemove(Object key) {
        throw new UnsupportedOperationException();
    }

    boolean justRemoveNullKey() {
        throw new UnsupportedOperationException();
    }

    public double removeAsDouble(Object key) {
        throw new UnsupportedOperationException();
    }

    double removeAsDoubleNullKey() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.remove(key, (Double)value);
    }

    public boolean remove(Object key, double value) {
        throw new UnsupportedOperationException();
    }

    boolean removeEntryNullKey(double value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeIf(ObjDoublePredicate<? super K> filter) {
        throw new UnsupportedOperationException();
    }

    class NoRemovedMapCursor
    implements ObjDoubleCursor<K> {
        final K[] keys;
        final long[] vals;
        int expectedModCount;
        int index;
        Object curKey;
        long curValue;

        NoRemovedMapCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = UpdatableQHashSeparateKVObjDoubleMapGO.this.set;
            this.index = this.keys.length;
            this.vals = UpdatableQHashSeparateKVObjDoubleMapGO.this.values;
            this.curKey = ObjHash.FREE;
        }

        public void forEachForward(ObjDoubleConsumer<? super K> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            K[] keys = this.keys;
            long[] vals = this.vals;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                action.accept(key, Double.longBitsToDouble(vals[i]));
            }
            if (index != this.index || mc != UpdatableQHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = ObjHash.FREE;
        }

        public K key() {
            Object curKey = this.curKey;
            if (curKey != ObjHash.FREE) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public double value() {
            if (this.curKey != ObjHash.FREE) {
                return Double.longBitsToDouble(this.curValue);
            }
            throw new IllegalStateException();
        }

        public void setValue(double value) {
            if (this.curKey != ObjHash.FREE) {
                if (this.expectedModCount != UpdatableQHashSeparateKVObjDoubleMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.vals[this.index] = Double.doubleToLongBits(value);
        }

        public boolean moveNext() {
            if (this.expectedModCount == UpdatableQHashSeparateKVObjDoubleMapGO.this.modCount()) {
                K[] keys = this.keys;
                for (int i = this.index - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = ObjHash.FREE;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueCursor
    implements DoubleCursor {
        final K[] keys;
        final long[] vals;
        int expectedModCount;
        int index;
        Object curKey;
        long curValue;

        NoRemovedValueCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = UpdatableQHashSeparateKVObjDoubleMapGO.this.set;
            this.index = this.keys.length;
            this.vals = UpdatableQHashSeparateKVObjDoubleMapGO.this.values;
            this.curKey = ObjHash.FREE;
        }

        public void forEachForward(DoubleConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            K[] keys = this.keys;
            long[] vals = this.vals;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                action.accept(Double.longBitsToDouble(vals[i]));
            }
            if (index != this.index || mc != UpdatableQHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = ObjHash.FREE;
        }

        public double elem() {
            if (this.curKey != ObjHash.FREE) {
                return Double.longBitsToDouble(this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == UpdatableQHashSeparateKVObjDoubleMapGO.this.modCount()) {
                K[] keys = this.keys;
                for (int i = this.index - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = ObjHash.FREE;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueIterator
    implements DoubleIterator {
        final K[] keys;
        final long[] vals;
        int expectedModCount;
        int nextIndex;
        double next;

        NoRemovedValueIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = UpdatableQHashSeparateKVObjDoubleMapGO.this.set;
            Object[] keys = this.keys;
            this.vals = UpdatableQHashSeparateKVObjDoubleMapGO.this.values;
            long[] vals = UpdatableQHashSeparateKVObjDoubleMapGO.this.values;
            int nextI = keys.length;
            while (--nextI >= 0) {
                if (keys[nextI] == ObjHash.FREE) continue;
                this.next = Double.longBitsToDouble(vals[nextI]);
                break;
            }
            this.nextIndex = nextI;
        }

        public double nextDouble() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                if (this.expectedModCount == UpdatableQHashSeparateKVObjDoubleMapGO.this.modCount()) {
                    K[] keys = this.keys;
                    double prev = this.next;
                    while (--nextI >= 0) {
                        if (keys[nextI] == ObjHash.FREE) continue;
                        this.next = Double.longBitsToDouble(this.vals[nextI]);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void forEachRemaining(Consumer<? super Double> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            K[] keys = this.keys;
            long[] vals = this.vals;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                action.accept((Double)Double.longBitsToDouble(vals[i]));
            }
            if (nextI != this.nextIndex || mc != UpdatableQHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public void forEachRemaining(DoubleConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            K[] keys = this.keys;
            long[] vals = this.vals;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                action.accept(Double.longBitsToDouble(vals[i]));
            }
            if (nextI != this.nextIndex || mc != UpdatableQHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Double next() {
            return this.nextDouble();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryCursor
    implements ObjCursor<Map.Entry<K, Double>> {
        final K[] keys;
        final long[] vals;
        int expectedModCount;
        int index;
        Object curKey;
        long curValue;

        NoRemovedEntryCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = UpdatableQHashSeparateKVObjDoubleMapGO.this.set;
            this.index = this.keys.length;
            this.vals = UpdatableQHashSeparateKVObjDoubleMapGO.this.values;
            this.curKey = ObjHash.FREE;
        }

        public void forEachForward(Consumer<? super Map.Entry<K, Double>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            K[] keys = this.keys;
            long[] vals = this.vals;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                action.accept(new MutableEntry(mc, i, key, vals[i]));
            }
            if (index != this.index || mc != UpdatableQHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = ObjHash.FREE;
        }

        public Map.Entry<K, Double> elem() {
            Object curKey = this.curKey;
            if (curKey != ObjHash.FREE) {
                return new MutableEntry(this.expectedModCount, this.index, curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == UpdatableQHashSeparateKVObjDoubleMapGO.this.modCount()) {
                K[] keys = this.keys;
                for (int i = this.index - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = ObjHash.FREE;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryIterator
    implements ObjIterator<Map.Entry<K, Double>> {
        final K[] keys;
        final long[] vals;
        int expectedModCount;
        int nextIndex;
        MutableEntry next;

        NoRemovedEntryIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = UpdatableQHashSeparateKVObjDoubleMapGO.this.set;
            Object[] keys = this.keys;
            this.vals = UpdatableQHashSeparateKVObjDoubleMapGO.this.values;
            long[] vals = UpdatableQHashSeparateKVObjDoubleMapGO.this.values;
            int nextI = keys.length;
            while (--nextI >= 0) {
                Object key = keys[nextI];
                if (key == ObjHash.FREE) continue;
                this.next = new MutableEntry(mc, nextI, key, vals[nextI]);
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<K, Double>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            K[] keys = this.keys;
            long[] vals = this.vals;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                action.accept(new MutableEntry(mc, i, key, vals[i]));
            }
            if (nextI != this.nextIndex || mc != UpdatableQHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<K, Double> next() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                int mc = this.expectedModCount;
                if (mc == UpdatableQHashSeparateKVObjDoubleMapGO.this.modCount()) {
                    K[] keys = this.keys;
                    MutableEntry prev = this.next;
                    while (--nextI >= 0) {
                        Object key = keys[nextI];
                        if (key == ObjHash.FREE) continue;
                        this.next = new MutableEntry(mc, nextI, key, this.vals[nextI]);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class ValueView
    extends AbstractDoubleValueView {
        ValueView() {
        }

        @Override
        public int size() {
            return UpdatableQHashSeparateKVObjDoubleMapGO.this.size();
        }

        public boolean shrink() {
            return UpdatableQHashSeparateKVObjDoubleMapGO.this.shrink();
        }

        @Override
        public boolean contains(Object o) {
            return UpdatableQHashSeparateKVObjDoubleMapGO.this.containsValue(o);
        }

        public boolean contains(double v) {
            return UpdatableQHashSeparateKVObjDoubleMapGO.this.containsValue(v);
        }

        @Override
        public boolean contains(long bits) {
            return UpdatableQHashSeparateKVObjDoubleMapGO.this.containsValue(bits);
        }

        @Override
        public void forEach(Consumer<? super Double> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = UpdatableQHashSeparateKVObjDoubleMapGO.this.modCount();
            Object[] keys = UpdatableQHashSeparateKVObjDoubleMapGO.this.set;
            long[] vals = UpdatableQHashSeparateKVObjDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                action.accept((Double)Double.longBitsToDouble(vals[i]));
            }
            if (mc != UpdatableQHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public void forEach(DoubleConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = UpdatableQHashSeparateKVObjDoubleMapGO.this.modCount();
            Object[] keys = UpdatableQHashSeparateKVObjDoubleMapGO.this.set;
            long[] vals = UpdatableQHashSeparateKVObjDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                action.accept(Double.longBitsToDouble(vals[i]));
            }
            if (mc != UpdatableQHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(DoublePredicate predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = UpdatableQHashSeparateKVObjDoubleMapGO.this.modCount();
            Object[] keys = UpdatableQHashSeparateKVObjDoubleMapGO.this.set;
            long[] vals = UpdatableQHashSeparateKVObjDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE || predicate.test(Double.longBitsToDouble(vals[i]))) continue;
                terminated = true;
                break;
            }
            if (mc != UpdatableQHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Override
        public boolean allContainingIn(DoubleCollection c) {
            if (c instanceof InternalDoubleCollectionOps) {
                return this.allContainingIn((InternalDoubleCollectionOps)c);
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            int mc = UpdatableQHashSeparateKVObjDoubleMapGO.this.modCount();
            Object[] keys = UpdatableQHashSeparateKVObjDoubleMapGO.this.set;
            long[] vals = UpdatableQHashSeparateKVObjDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE || c.contains(Double.longBitsToDouble(vals[i]))) continue;
                containsAll = false;
                break;
            }
            if (mc != UpdatableQHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        private boolean allContainingIn(InternalDoubleCollectionOps c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            int mc = UpdatableQHashSeparateKVObjDoubleMapGO.this.modCount();
            Object[] keys = UpdatableQHashSeparateKVObjDoubleMapGO.this.set;
            long[] vals = UpdatableQHashSeparateKVObjDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE || c.contains(vals[i])) continue;
                containsAll = false;
                break;
            }
            if (mc != UpdatableQHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        @Override
        public boolean reverseAddAllTo(DoubleCollection c) {
            if (c instanceof InternalDoubleCollectionOps) {
                return this.reverseAddAllTo((InternalDoubleCollectionOps)c);
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = UpdatableQHashSeparateKVObjDoubleMapGO.this.modCount();
            Object[] keys = UpdatableQHashSeparateKVObjDoubleMapGO.this.set;
            long[] vals = UpdatableQHashSeparateKVObjDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                changed |= c.add(Double.longBitsToDouble(vals[i]));
            }
            if (mc != UpdatableQHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean reverseAddAllTo(InternalDoubleCollectionOps c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = UpdatableQHashSeparateKVObjDoubleMapGO.this.modCount();
            Object[] keys = UpdatableQHashSeparateKVObjDoubleMapGO.this.set;
            long[] vals = UpdatableQHashSeparateKVObjDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                changed |= c.add(vals[i]);
            }
            if (mc != UpdatableQHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public boolean reverseRemoveAllFrom(DoubleSet s) {
            if (s instanceof InternalDoubleCollectionOps) {
                return this.reverseRemoveAllFrom((InternalDoubleCollectionOps)s);
            }
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = UpdatableQHashSeparateKVObjDoubleMapGO.this.modCount();
            Object[] keys = UpdatableQHashSeparateKVObjDoubleMapGO.this.set;
            long[] vals = UpdatableQHashSeparateKVObjDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                changed |= s.removeDouble(Double.longBitsToDouble(vals[i]));
            }
            if (mc != UpdatableQHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean reverseRemoveAllFrom(InternalDoubleCollectionOps s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = UpdatableQHashSeparateKVObjDoubleMapGO.this.modCount();
            Object[] keys = UpdatableQHashSeparateKVObjDoubleMapGO.this.set;
            long[] vals = UpdatableQHashSeparateKVObjDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                changed |= s.removeDouble(vals[i]);
            }
            if (mc != UpdatableQHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Nonnull
        public DoubleIterator iterator() {
            int mc = UpdatableQHashSeparateKVObjDoubleMapGO.this.modCount();
            return new NoRemovedValueIterator(mc);
        }

        @Nonnull
        public DoubleCursor cursor() {
            int mc = UpdatableQHashSeparateKVObjDoubleMapGO.this.modCount();
            return new NoRemovedValueCursor(mc);
        }

        @Override
        @Nonnull
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = UpdatableQHashSeparateKVObjDoubleMapGO.this.modCount();
            Object[] keys = UpdatableQHashSeparateKVObjDoubleMapGO.this.set;
            long[] vals = UpdatableQHashSeparateKVObjDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                result[resultIndex++] = Double.longBitsToDouble(vals[i]);
            }
            if (mc != UpdatableQHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Override
        @Nonnull
        public <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = UpdatableQHashSeparateKVObjDoubleMapGO.this.modCount();
            Object[] keys = UpdatableQHashSeparateKVObjDoubleMapGO.this.set;
            long[] vals = UpdatableQHashSeparateKVObjDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                a[resultIndex++] = Double.longBitsToDouble(vals[i]);
            }
            if (mc != UpdatableQHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public double[] toDoubleArray() {
            int size = this.size();
            double[] result = new double[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = UpdatableQHashSeparateKVObjDoubleMapGO.this.modCount();
            Object[] keys = UpdatableQHashSeparateKVObjDoubleMapGO.this.set;
            long[] vals = UpdatableQHashSeparateKVObjDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                result[resultIndex++] = Double.longBitsToDouble(vals[i]);
            }
            if (mc != UpdatableQHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        public double[] toArray(double[] a) {
            int size = this.size();
            if (a.length < size) {
                a = new double[size];
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = 0.0;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = UpdatableQHashSeparateKVObjDoubleMapGO.this.modCount();
            Object[] keys = UpdatableQHashSeparateKVObjDoubleMapGO.this.set;
            long[] vals = UpdatableQHashSeparateKVObjDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                a[resultIndex++] = Double.longBitsToDouble(vals[i]);
            }
            if (mc != UpdatableQHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = 0.0;
            }
            return a;
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = UpdatableQHashSeparateKVObjDoubleMapGO.this.modCount();
            Object[] keys = UpdatableQHashSeparateKVObjDoubleMapGO.this.set;
            long[] vals = UpdatableQHashSeparateKVObjDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                sb.append(' ').append(Double.longBitsToDouble(vals[i])).append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            if (mc != UpdatableQHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        @Override
        public boolean remove(Object o) {
            return this.removeDouble((Double)o);
        }

        public boolean removeDouble(double v) {
            return UpdatableQHashSeparateKVObjDoubleMapGO.this.removeValue(v);
        }

        @Override
        public boolean removeDouble(long bits) {
            return UpdatableQHashSeparateKVObjDoubleMapGO.this.removeValue(bits);
        }

        @Override
        public void clear() {
            UpdatableQHashSeparateKVObjDoubleMapGO.this.clear();
        }

        @Override
        public boolean removeIf(Predicate<? super Double> filter) {
            throw new UnsupportedOperationException();
        }

        public boolean removeIf(DoublePredicate filter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }
    }

    class ReusableEntry
    extends ObjDoubleEntry {
        private K key;
        private long value;

        ReusableEntry() {
        }

        ReusableEntry with(K key, long value) {
            this.key = key;
            this.value = value;
            return this;
        }

        @Override
        public K key() {
            return this.key;
        }

        @Override
        public long value() {
            return this.value;
        }
    }

    class MutableEntry
    extends ObjDoubleEntry {
        int modCount;
        private final int index;
        final K key;
        private long value;

        MutableEntry(int modCount, int index, K key, long value) {
            this.modCount = modCount;
            this.index = index;
            this.key = key;
            this.value = value;
        }

        @Override
        public K key() {
            return this.key;
        }

        @Override
        public long value() {
            return this.value;
        }

        @Override
        public Double setValue(Double newValue) {
            long unwrappedNewValue;
            if (this.modCount != UpdatableQHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new IllegalStateException();
            }
            double oldValue = Double.longBitsToDouble(this.value);
            this.value = unwrappedNewValue = Double.doubleToLongBits(newValue);
            this.updateValueInTable(unwrappedNewValue);
            return oldValue;
        }

        void updateValueInTable(long newValue) {
            UpdatableQHashSeparateKVObjDoubleMapGO.this.values[this.index] = newValue;
        }
    }

    abstract class ObjDoubleEntry
    extends AbstractEntry<K, Double> {
        ObjDoubleEntry() {
        }

        abstract K key();

        @Override
        public final K getKey() {
            return this.key();
        }

        abstract long value();

        @Override
        public final Double getValue() {
            return Double.longBitsToDouble(this.value());
        }

        @Override
        public boolean equals(Object o) {
            try {
                Map.Entry e2 = (Map.Entry)o;
                Object k2 = e2.getKey();
                long v2 = Double.doubleToLongBits((Double)e2.getValue());
                return UpdatableQHashSeparateKVObjDoubleMapGO.this.nullableKeyEquals(this.key(), k2) && this.value() == v2;
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        @Override
        public int hashCode() {
            return UpdatableQHashSeparateKVObjDoubleMapGO.this.nullableKeyHashCode(this.key()) ^ Primitives.hashCode(this.value());
        }
    }

    class EntryView
    extends AbstractSetView<Map.Entry<K, Double>>
    implements HashObjSet<Map.Entry<K, Double>>,
    InternalObjCollectionOps<Map.Entry<K, Double>> {
        EntryView() {
        }

        @Nullable
        public Equivalence<Map.Entry<K, Double>> equivalence() {
            return Equivalence.entryEquivalence(UpdatableQHashSeparateKVObjDoubleMapGO.this.keyEquivalence(), null);
        }

        @Nonnull
        public HashConfig hashConfig() {
            return UpdatableQHashSeparateKVObjDoubleMapGO.this.hashConfig();
        }

        @Override
        public int size() {
            return UpdatableQHashSeparateKVObjDoubleMapGO.this.size();
        }

        public double currentLoad() {
            return UpdatableQHashSeparateKVObjDoubleMapGO.this.currentLoad();
        }

        @Override
        public boolean contains(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                return UpdatableQHashSeparateKVObjDoubleMapGO.this.containsEntry(e.getKey(), (Double)e.getValue());
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        @Nonnull
        public final Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = UpdatableQHashSeparateKVObjDoubleMapGO.this.modCount();
            Object[] keys = UpdatableQHashSeparateKVObjDoubleMapGO.this.set;
            long[] vals = UpdatableQHashSeparateKVObjDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                result[resultIndex++] = new MutableEntry(mc, i, key, vals[i]);
            }
            if (mc != UpdatableQHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Override
        @Nonnull
        public final <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = UpdatableQHashSeparateKVObjDoubleMapGO.this.modCount();
            Object[] keys = UpdatableQHashSeparateKVObjDoubleMapGO.this.set;
            long[] vals = UpdatableQHashSeparateKVObjDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                a[resultIndex++] = new MutableEntry(mc, i, key, vals[i]);
            }
            if (mc != UpdatableQHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        @Override
        public final void forEach(@Nonnull Consumer<? super Map.Entry<K, Double>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = UpdatableQHashSeparateKVObjDoubleMapGO.this.modCount();
            Object[] keys = UpdatableQHashSeparateKVObjDoubleMapGO.this.set;
            long[] vals = UpdatableQHashSeparateKVObjDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                action.accept(new MutableEntry(mc, i, key, vals[i]));
            }
            if (mc != UpdatableQHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(@Nonnull Predicate<? super Map.Entry<K, Double>> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = UpdatableQHashSeparateKVObjDoubleMapGO.this.modCount();
            Object[] keys = UpdatableQHashSeparateKVObjDoubleMapGO.this.set;
            long[] vals = UpdatableQHashSeparateKVObjDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE || predicate.test(new MutableEntry(mc, i, key, vals[i]))) continue;
                terminated = true;
                break;
            }
            if (mc != UpdatableQHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Override
        @Nonnull
        public ObjIterator<Map.Entry<K, Double>> iterator() {
            int mc = UpdatableQHashSeparateKVObjDoubleMapGO.this.modCount();
            return new NoRemovedEntryIterator(mc);
        }

        @Nonnull
        public ObjCursor<Map.Entry<K, Double>> cursor() {
            int mc = UpdatableQHashSeparateKVObjDoubleMapGO.this.modCount();
            return new NoRemovedEntryCursor(mc);
        }

        @Override
        public final boolean containsAll(@Nonnull Collection<?> c) {
            return CommonObjCollectionOps.containsAll(this, c);
        }

        @Override
        public final boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            ReusableEntry e = new ReusableEntry();
            int mc = UpdatableQHashSeparateKVObjDoubleMapGO.this.modCount();
            Object[] keys = UpdatableQHashSeparateKVObjDoubleMapGO.this.set;
            long[] vals = UpdatableQHashSeparateKVObjDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE || c.contains((Object)e.with(key, vals[i]))) continue;
                containsAll = false;
                break;
            }
            if (mc != UpdatableQHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        @Override
        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = UpdatableQHashSeparateKVObjDoubleMapGO.this.modCount();
            Object[] keys = UpdatableQHashSeparateKVObjDoubleMapGO.this.set;
            long[] vals = UpdatableQHashSeparateKVObjDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                changed |= s.remove((Object)e.with(key, vals[i]));
            }
            if (mc != UpdatableQHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public final boolean reverseAddAllTo(ObjCollection<? super Map.Entry<K, Double>> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = UpdatableQHashSeparateKVObjDoubleMapGO.this.modCount();
            Object[] keys = UpdatableQHashSeparateKVObjDoubleMapGO.this.set;
            long[] vals = UpdatableQHashSeparateKVObjDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                changed |= c.add((Object)new MutableEntry(mc, i, key, vals[i]));
            }
            if (mc != UpdatableQHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public int hashCode() {
            return UpdatableQHashSeparateKVObjDoubleMapGO.this.hashCode();
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = UpdatableQHashSeparateKVObjDoubleMapGO.this.modCount();
            Object[] keys = UpdatableQHashSeparateKVObjDoubleMapGO.this.set;
            long[] vals = UpdatableQHashSeparateKVObjDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                sb.append(' ');
                sb.append(key != this ? key : "(this Collection)");
                sb.append('=');
                sb.append(Double.longBitsToDouble(vals[i]));
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            if (mc != UpdatableQHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean shrink() {
            return UpdatableQHashSeparateKVObjDoubleMapGO.this.shrink();
        }

        @Override
        public boolean remove(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                Object key = e.getKey();
                double value = (Double)e.getValue();
                return UpdatableQHashSeparateKVObjDoubleMapGO.this.remove(key, value);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        public final boolean removeIf(@Nonnull Predicate<? super Map.Entry<K, Double>> filter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof InternalObjCollectionOps) {
                InternalObjCollectionOps c2 = (InternalObjCollectionOps)((Object)c);
                if (NullableObjects.equals(this.equivalence(), c2.equivalence()) && c2.size() < this.size()) {
                    c2.reverseRemoveAllFrom((ObjSet<?>)this);
                }
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            UpdatableQHashSeparateKVObjDoubleMapGO.this.clear();
        }
    }
}

