/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.openhft.collect.Equivalence;
import net.openhft.collect.FloatCollection;
import net.openhft.collect.FloatCursor;
import net.openhft.collect.FloatIterator;
import net.openhft.collect.ObjCollection;
import net.openhft.collect.ObjCursor;
import net.openhft.collect.ObjIterator;
import net.openhft.collect.hash.HashConfig;
import net.openhft.collect.impl.AbstractEntry;
import net.openhft.collect.impl.AbstractFloatValueView;
import net.openhft.collect.impl.AbstractSetView;
import net.openhft.collect.impl.CommonDoubleFloatMapOps;
import net.openhft.collect.impl.CommonMapOps;
import net.openhft.collect.impl.CommonObjCollectionOps;
import net.openhft.collect.impl.InternalDoubleFloatMapOps;
import net.openhft.collect.impl.InternalFloatCollectionOps;
import net.openhft.collect.impl.InternalObjCollectionOps;
import net.openhft.collect.impl.NullableObjects;
import net.openhft.collect.impl.Primitives;
import net.openhft.collect.impl.hash.QHash;
import net.openhft.collect.impl.hash.SeparateKVDoubleFloatQHash;
import net.openhft.collect.impl.hash.UpdatableQHashSeparateKVDoubleFloatMapSO;
import net.openhft.collect.map.DoubleFloatCursor;
import net.openhft.collect.set.FloatSet;
import net.openhft.collect.set.ObjSet;
import net.openhft.collect.set.hash.HashObjSet;
import net.openhft.function.DoubleFloatConsumer;
import net.openhft.function.DoubleFloatPredicate;
import net.openhft.function.DoubleFloatToFloatFunction;
import net.openhft.function.DoubleToFloatFunction;
import net.openhft.function.FloatBinaryOperator;
import net.openhft.function.FloatConsumer;
import net.openhft.function.FloatPredicate;

public class UpdatableQHashSeparateKVDoubleFloatMapGO
extends UpdatableQHashSeparateKVDoubleFloatMapSO {
    @Override
    final void copy(SeparateKVDoubleFloatQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.copy(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    final void move(SeparateKVDoubleFloatQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.move(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public float defaultValue() {
        return 0.0f;
    }

    @Override
    public boolean containsEntry(double key, float value) {
        long k = Double.doubleToLongBits(key);
        int index = this.index(k);
        if (index >= 0) {
            return this.values[index] == Float.floatToIntBits(value);
        }
        return false;
    }

    @Override
    public boolean containsEntry(long key, int value) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index] == value;
        }
        return false;
    }

    @Override
    public Float get(Object key) {
        long k = Double.doubleToLongBits((Double)key);
        int index = this.index(k);
        if (index >= 0) {
            return Float.valueOf(Float.intBitsToFloat(this.values[index]));
        }
        return null;
    }

    public float get(double key) {
        long k = Double.doubleToLongBits(key);
        int index = this.index(k);
        if (index >= 0) {
            return Float.intBitsToFloat(this.values[index]);
        }
        return this.defaultValue();
    }

    @Override
    public Float getOrDefault(Object key, Float defaultValue) {
        long k = Double.doubleToLongBits((Double)key);
        int index = this.index(k);
        if (index >= 0) {
            return Float.valueOf(Float.intBitsToFloat(this.values[index]));
        }
        return defaultValue;
    }

    public float getOrDefault(double key, float defaultValue) {
        long k = Double.doubleToLongBits(key);
        int index = this.index(k);
        if (index >= 0) {
            return Float.intBitsToFloat(this.values[index]);
        }
        return defaultValue;
    }

    @Override
    public void forEach(BiConsumer<? super Double, ? super Float> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
            action.accept((Double)Double.longBitsToDouble(key), Float.valueOf(Float.intBitsToFloat(vals[i])));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void forEach(DoubleFloatConsumer action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
            action.accept(Double.longBitsToDouble(key), Float.intBitsToFloat(vals[i]));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public boolean forEachWhile(DoubleFloatPredicate predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        int mc = this.modCount();
        long[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL || predicate.test(Double.longBitsToDouble(key), Float.intBitsToFloat(vals[i]))) continue;
            terminated = true;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return !terminated;
    }

    @Nonnull
    public DoubleFloatCursor cursor() {
        int mc = this.modCount();
        return new NoRemovedMapCursor(mc);
    }

    @Override
    public boolean containsAllEntries(Map<?, ?> m) {
        return CommonDoubleFloatMapOps.containsAllEntries(this, m);
    }

    @Override
    public boolean allEntriesContainingIn(InternalDoubleFloatMapOps m) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        int mc = this.modCount();
        long[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL || m.containsEntry(key, vals[i])) continue;
            containsAll = false;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return containsAll;
    }

    @Override
    public void reversePutAllTo(InternalDoubleFloatMapOps m) {
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
            m.justPut(key, vals[i]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    @Nonnull
    public HashObjSet<Map.Entry<Double, Float>> entrySet() {
        return new EntryView();
    }

    @Nonnull
    public FloatCollection values() {
        return new ValueView();
    }

    @Override
    public boolean equals(Object o) {
        return CommonMapOps.equals(this, o);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        int mc = this.modCount();
        long[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
            hashCode += (int)(key ^ key >>> 32) ^ vals[i];
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return hashCode;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        int mc = this.modCount();
        long[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
            sb.append(' ');
            sb.append(Double.longBitsToDouble(key));
            sb.append('=');
            sb.append(Float.intBitsToFloat(vals[i]));
            sb.append(',');
            if (++elementCount != 8) continue;
            int expectedLength = sb.length() * (this.size() / 8);
            sb.ensureCapacity(expectedLength + expectedLength / 2);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        sb.setCharAt(0, '{');
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    @Override
    void rehash(int newCapacity) {
        int mc = this.modCount();
        long[] keys = this.set;
        int[] vals = this.values;
        this.initForRehash(newCapacity);
        ++mc;
        long[] newKeys = this.set;
        int capacity = newKeys.length;
        int[] newVals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
            int index = QHash.SeparateKVDoubleKeyMixing.mix(key) % capacity;
            if (newKeys[index] != 0x7FFFFFFFFFFFFFFEL) {
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if (newKeys[bIndex] != 0x7FFFFFFFFFFFFFFEL) {
                        index = bIndex;
                        break;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if (newKeys[fIndex] != 0x7FFFFFFFFFFFFFFEL) {
                        index = fIndex;
                        break;
                    }
                    step += 2;
                }
            }
            newKeys[index] = key;
            newVals[index] = vals[i];
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public Float put(Double key, Float value) {
        long k = Double.doubleToLongBits(key);
        int index = this.insert(k, Float.floatToIntBits(value.floatValue()));
        if (index < 0) {
            return null;
        }
        int[] vals = this.values;
        float prevValue = Float.intBitsToFloat(vals[index]);
        vals[index] = Float.floatToIntBits(value.floatValue());
        return Float.valueOf(prevValue);
    }

    @Override
    public float put(double key, float value) {
        long k = Double.doubleToLongBits(key);
        int index = this.insert(k, Float.floatToIntBits(value));
        if (index < 0) {
            return this.defaultValue();
        }
        int[] vals = this.values;
        float prevValue = Float.intBitsToFloat(vals[index]);
        vals[index] = Float.floatToIntBits(value);
        return prevValue;
    }

    @Override
    public Float putIfAbsent(Double key, Float value) {
        long k = Double.doubleToLongBits(key);
        int index = this.insert(k, Float.floatToIntBits(value.floatValue()));
        if (index < 0) {
            return null;
        }
        return Float.valueOf(Float.intBitsToFloat(this.values[index]));
    }

    @Override
    public float putIfAbsent(double key, float value) {
        long k = Double.doubleToLongBits(key);
        int index = this.insert(k, Float.floatToIntBits(value));
        if (index < 0) {
            return this.defaultValue();
        }
        return Float.intBitsToFloat(this.values[index]);
    }

    @Override
    public void justPut(double key, float value) {
        long k = Double.doubleToLongBits(key);
        int index = this.insert(k, Float.floatToIntBits(value));
        if (index < 0) {
            return;
        }
        this.values[index] = Float.floatToIntBits(value);
    }

    @Override
    public void justPut(long key, int value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return;
        }
        this.values[index] = value;
    }

    @Override
    public Float compute(Double key, BiFunction<? super Double, ? super Float, ? extends Float> remappingFunction) {
        Float newValue;
        int index;
        int[] vals;
        long k;
        block12: {
            k = Double.doubleToLongBits(key);
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            long[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = QHash.SeparateKVDoubleKeyMixing.mix(k) % capacity;
            long cur = keys[index];
            if (cur != k) {
                Float newValue2;
                if (cur != 0x7FFFFFFFFFFFFFFEL) {
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if ((cur = keys[bIndex]) == k) {
                            index = bIndex;
                            break block12;
                        }
                        if (cur == 0x7FFFFFFFFFFFFFFEL) {
                            index = bIndex;
                            break;
                        }
                        int t = (fIndex += step) - capacity;
                        if (t >= 0) {
                            fIndex = t;
                        }
                        if ((cur = keys[fIndex]) == k) {
                            index = fIndex;
                            break block12;
                        }
                        if (cur == 0x7FFFFFFFFFFFFFFEL) {
                            index = fIndex;
                            break;
                        }
                        step += 2;
                    }
                }
                if ((newValue2 = remappingFunction.apply((Double)Double.longBitsToDouble(k), null)) != null) {
                    this.incrementModCount();
                    keys[index] = k;
                    vals[index] = Float.floatToIntBits(newValue2.floatValue());
                    this.postInsertHook();
                    return newValue2;
                }
                return null;
            }
        }
        if ((newValue = remappingFunction.apply((Double)Double.longBitsToDouble(k), Float.valueOf(Float.intBitsToFloat(vals[index])))) != null) {
            vals[index] = Float.floatToIntBits(newValue.floatValue());
            return newValue;
        }
        throw new UnsupportedOperationException("Compute operation of updatable map doesn't support removals");
    }

    public float compute(double key, DoubleFloatToFloatFunction remappingFunction) {
        int index;
        int[] vals;
        long k;
        block10: {
            k = Double.doubleToLongBits(key);
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            long[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = QHash.SeparateKVDoubleKeyMixing.mix(k) % capacity;
            long cur = keys[index];
            if (cur != k) {
                if (cur != 0x7FFFFFFFFFFFFFFEL) {
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if ((cur = keys[bIndex]) == k) {
                            index = bIndex;
                            break block10;
                        }
                        if (cur == 0x7FFFFFFFFFFFFFFEL) {
                            index = bIndex;
                            break;
                        }
                        int t = (fIndex += step) - capacity;
                        if (t >= 0) {
                            fIndex = t;
                        }
                        if ((cur = keys[fIndex]) == k) {
                            index = fIndex;
                            break block10;
                        }
                        if (cur == 0x7FFFFFFFFFFFFFFEL) {
                            index = fIndex;
                            break;
                        }
                        step += 2;
                    }
                }
                float newValue = remappingFunction.applyAsFloat(Double.longBitsToDouble(k), this.defaultValue());
                this.incrementModCount();
                keys[index] = k;
                vals[index] = Float.floatToIntBits(newValue);
                this.postInsertHook();
                return newValue;
            }
        }
        float newValue = remappingFunction.applyAsFloat(Double.longBitsToDouble(k), Float.intBitsToFloat(vals[index]));
        vals[index] = Float.floatToIntBits(newValue);
        return newValue;
    }

    @Override
    public Float computeIfAbsent(Double key, Function<? super Double, ? extends Float> mappingFunction) {
        Float value;
        long k = Double.doubleToLongBits(key);
        if (mappingFunction == null) {
            throw new NullPointerException();
        }
        long[] keys = this.set;
        int[] vals = this.values;
        int capacity = keys.length;
        int index = QHash.SeparateKVDoubleKeyMixing.mix(k) % capacity;
        long cur = keys[index];
        if (cur != 0x7FFFFFFFFFFFFFFEL) {
            if (cur == k) {
                return Float.valueOf(Float.intBitsToFloat(vals[index]));
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = keys[bIndex]) == 0x7FFFFFFFFFFFFFFEL) {
                    index = bIndex;
                    break;
                }
                if (cur == k) {
                    return Float.valueOf(Float.intBitsToFloat(vals[bIndex]));
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = keys[fIndex]) == 0x7FFFFFFFFFFFFFFEL) {
                    index = fIndex;
                    break;
                }
                if (cur == k) {
                    return Float.valueOf(Float.intBitsToFloat(vals[fIndex]));
                }
                step += 2;
            }
        }
        if ((value = mappingFunction.apply((Double)Double.longBitsToDouble(k))) != null) {
            this.incrementModCount();
            keys[index] = k;
            vals[index] = Float.floatToIntBits(value.floatValue());
            this.postInsertHook();
            return value;
        }
        return null;
    }

    public float computeIfAbsent(double key, DoubleToFloatFunction mappingFunction) {
        long k = Double.doubleToLongBits(key);
        if (mappingFunction == null) {
            throw new NullPointerException();
        }
        long[] keys = this.set;
        int[] vals = this.values;
        int capacity = keys.length;
        int index = QHash.SeparateKVDoubleKeyMixing.mix(k) % capacity;
        long cur = keys[index];
        if (cur != 0x7FFFFFFFFFFFFFFEL) {
            if (cur == k) {
                return Float.intBitsToFloat(vals[index]);
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = keys[bIndex]) == 0x7FFFFFFFFFFFFFFEL) {
                    index = bIndex;
                    break;
                }
                if (cur == k) {
                    return Float.intBitsToFloat(vals[bIndex]);
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = keys[fIndex]) == 0x7FFFFFFFFFFFFFFEL) {
                    index = fIndex;
                    break;
                }
                if (cur == k) {
                    return Float.intBitsToFloat(vals[fIndex]);
                }
                step += 2;
            }
        }
        float value = mappingFunction.applyAsFloat(Double.longBitsToDouble(k));
        this.incrementModCount();
        keys[index] = k;
        vals[index] = Float.floatToIntBits(value);
        this.postInsertHook();
        return value;
    }

    @Override
    public Float computeIfPresent(Double key, BiFunction<? super Double, ? super Float, ? extends Float> remappingFunction) {
        long k = Double.doubleToLongBits(key);
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        int index = this.index(k);
        if (index >= 0) {
            int[] vals = this.values;
            Float newValue = remappingFunction.apply((Double)Double.longBitsToDouble(k), Float.valueOf(Float.intBitsToFloat(vals[index])));
            if (newValue != null) {
                vals[index] = Float.floatToIntBits(newValue.floatValue());
                return newValue;
            }
            throw new UnsupportedOperationException("ComputeIfPresent operation of updatable map doesn't support removals");
        }
        return null;
    }

    public float computeIfPresent(double key, DoubleFloatToFloatFunction remappingFunction) {
        long k = Double.doubleToLongBits(key);
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        int index = this.index(k);
        if (index >= 0) {
            int[] vals = this.values;
            float newValue = remappingFunction.applyAsFloat(Double.longBitsToDouble(k), Float.intBitsToFloat(vals[index]));
            vals[index] = Float.floatToIntBits(newValue);
            return newValue;
        }
        return this.defaultValue();
    }

    @Override
    public Float merge(Double key, Float value, BiFunction<? super Float, ? super Float, ? extends Float> remappingFunction) {
        Float newValue;
        int index;
        int[] vals;
        block12: {
            long k = Double.doubleToLongBits(key);
            if (value == null) {
                throw new NullPointerException();
            }
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            long[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = QHash.SeparateKVDoubleKeyMixing.mix(k) % capacity;
            long cur = keys[index];
            if (cur != k) {
                if (cur != 0x7FFFFFFFFFFFFFFEL) {
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if ((cur = keys[bIndex]) == k) {
                            index = bIndex;
                            break block12;
                        }
                        if (cur == 0x7FFFFFFFFFFFFFFEL) {
                            index = bIndex;
                            break;
                        }
                        int t = (fIndex += step) - capacity;
                        if (t >= 0) {
                            fIndex = t;
                        }
                        if ((cur = keys[fIndex]) == k) {
                            index = fIndex;
                            break block12;
                        }
                        if (cur == 0x7FFFFFFFFFFFFFFEL) {
                            index = fIndex;
                            break;
                        }
                        step += 2;
                    }
                }
                this.incrementModCount();
                keys[index] = k;
                vals[index] = Float.floatToIntBits(value.floatValue());
                this.postInsertHook();
                return value;
            }
        }
        if ((newValue = remappingFunction.apply(Float.valueOf(Float.intBitsToFloat(vals[index])), value)) != null) {
            vals[index] = Float.floatToIntBits(newValue.floatValue());
            return newValue;
        }
        throw new UnsupportedOperationException("Merge operation of updatable map doesn't support removals");
    }

    public float merge(double key, float value, FloatBinaryOperator remappingFunction) {
        int index;
        int[] vals;
        block10: {
            long k = Double.doubleToLongBits(key);
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            long[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = QHash.SeparateKVDoubleKeyMixing.mix(k) % capacity;
            long cur = keys[index];
            if (cur != k) {
                if (cur != 0x7FFFFFFFFFFFFFFEL) {
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if ((cur = keys[bIndex]) == k) {
                            index = bIndex;
                            break block10;
                        }
                        if (cur == 0x7FFFFFFFFFFFFFFEL) {
                            index = bIndex;
                            break;
                        }
                        int t = (fIndex += step) - capacity;
                        if (t >= 0) {
                            fIndex = t;
                        }
                        if ((cur = keys[fIndex]) == k) {
                            index = fIndex;
                            break block10;
                        }
                        if (cur == 0x7FFFFFFFFFFFFFFEL) {
                            index = fIndex;
                            break;
                        }
                        step += 2;
                    }
                }
                this.incrementModCount();
                keys[index] = k;
                vals[index] = Float.floatToIntBits(value);
                this.postInsertHook();
                return value;
            }
        }
        float newValue = remappingFunction.applyAsFloat(Float.intBitsToFloat(vals[index]), value);
        vals[index] = Float.floatToIntBits(newValue);
        return newValue;
    }

    public float addValue(double key, float value) {
        long k = Double.doubleToLongBits(key);
        int index = this.insert(k, Float.floatToIntBits(value));
        if (index < 0) {
            return value;
        }
        int[] vals = this.values;
        float newValue = Float.intBitsToFloat(vals[index]) + value;
        vals[index] = Float.floatToIntBits(newValue);
        return newValue;
    }

    public float addValue(double key, float addition, float defaultValue) {
        float value;
        long k = Double.doubleToLongBits(key);
        int index = this.insert(k, Float.floatToIntBits(value = defaultValue + addition));
        if (index < 0) {
            return value;
        }
        int[] vals = this.values;
        float newValue = Float.intBitsToFloat(vals[index]) + addition;
        vals[index] = Float.floatToIntBits(newValue);
        return newValue;
    }

    @Override
    public void putAll(@Nonnull Map<? extends Double, ? extends Float> m) {
        CommonDoubleFloatMapOps.putAll(this, m);
    }

    @Override
    public Float replace(Double key, Float value) {
        long k = Double.doubleToLongBits(key);
        int index = this.index(k);
        if (index >= 0) {
            int[] vals = this.values;
            float oldValue = Float.intBitsToFloat(vals[index]);
            vals[index] = Float.floatToIntBits(value.floatValue());
            return Float.valueOf(oldValue);
        }
        return null;
    }

    @Override
    public float replace(double key, float value) {
        long k = Double.doubleToLongBits(key);
        int index = this.index(k);
        if (index >= 0) {
            int[] vals = this.values;
            float oldValue = Float.intBitsToFloat(vals[index]);
            vals[index] = Float.floatToIntBits(value);
            return oldValue;
        }
        return this.defaultValue();
    }

    @Override
    public boolean replace(Double key, Float oldValue, Float newValue) {
        return this.replace((double)key, oldValue.floatValue(), newValue.floatValue());
    }

    @Override
    public boolean replace(double key, float oldValue, float newValue) {
        long k = Double.doubleToLongBits(key);
        int index = this.index(k);
        if (index >= 0) {
            int[] vals = this.values;
            if (vals[index] == Float.floatToIntBits(oldValue)) {
                vals[index] = Float.floatToIntBits(newValue);
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public void replaceAll(BiFunction<? super Double, ? super Float, ? extends Float> function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
            vals[i] = Float.floatToIntBits(function.apply((Double)Double.longBitsToDouble(key), Float.valueOf(Float.intBitsToFloat(vals[i]))).floatValue());
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void replaceAll(DoubleFloatToFloatFunction function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
            vals[i] = Float.floatToIntBits(function.applyAsFloat(Double.longBitsToDouble(key), Float.intBitsToFloat(vals[i])));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public void clear() {
        int mc = this.modCount() + 1;
        super.clear();
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public Float remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean justRemove(double key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean justRemove(long key) {
        throw new UnsupportedOperationException();
    }

    public float remove(double key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.remove((Double)key, ((Float)value).floatValue());
    }

    public boolean remove(double key, float value) {
        throw new UnsupportedOperationException();
    }

    public boolean removeIf(DoubleFloatPredicate filter) {
        throw new UnsupportedOperationException();
    }

    class NoRemovedMapCursor
    implements DoubleFloatCursor {
        final long[] keys;
        final int[] vals;
        int expectedModCount;
        int index;
        long curKey;
        int curValue;

        NoRemovedMapCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = UpdatableQHashSeparateKVDoubleFloatMapGO.this.set;
            this.index = this.keys.length;
            this.vals = UpdatableQHashSeparateKVDoubleFloatMapGO.this.values;
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
        }

        public void forEachForward(DoubleFloatConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] keys = this.keys;
            int[] vals = this.vals;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                long key = keys[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept(Double.longBitsToDouble(key), Float.intBitsToFloat(vals[i]));
            }
            if (index != this.index || mc != UpdatableQHashSeparateKVDoubleFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
        }

        public double key() {
            long curKey = this.curKey;
            if (curKey != 0x7FFFFFFFFFFFFFFEL) {
                return Double.longBitsToDouble(curKey);
            }
            throw new IllegalStateException();
        }

        public float value() {
            if (this.curKey != 0x7FFFFFFFFFFFFFFEL) {
                return Float.intBitsToFloat(this.curValue);
            }
            throw new IllegalStateException();
        }

        public void setValue(float value) {
            if (this.curKey != 0x7FFFFFFFFFFFFFFEL) {
                if (this.expectedModCount != UpdatableQHashSeparateKVDoubleFloatMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.vals[this.index] = Float.floatToIntBits(value);
        }

        public boolean moveNext() {
            if (this.expectedModCount == UpdatableQHashSeparateKVDoubleFloatMapGO.this.modCount()) {
                long[] keys = this.keys;
                for (int i = this.index - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = 0x7FFFFFFFFFFFFFFEL;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueCursor
    implements FloatCursor {
        final long[] keys;
        final int[] vals;
        int expectedModCount;
        int index;
        long curKey;
        int curValue;

        NoRemovedValueCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = UpdatableQHashSeparateKVDoubleFloatMapGO.this.set;
            this.index = this.keys.length;
            this.vals = UpdatableQHashSeparateKVDoubleFloatMapGO.this.values;
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
        }

        public void forEachForward(FloatConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] keys = this.keys;
            int[] vals = this.vals;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept(Float.intBitsToFloat(vals[i]));
            }
            if (index != this.index || mc != UpdatableQHashSeparateKVDoubleFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
        }

        public float elem() {
            if (this.curKey != 0x7FFFFFFFFFFFFFFEL) {
                return Float.intBitsToFloat(this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == UpdatableQHashSeparateKVDoubleFloatMapGO.this.modCount()) {
                long[] keys = this.keys;
                for (int i = this.index - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = 0x7FFFFFFFFFFFFFFEL;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueIterator
    implements FloatIterator {
        final long[] keys;
        final int[] vals;
        int expectedModCount;
        int nextIndex;
        float next;

        NoRemovedValueIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = UpdatableQHashSeparateKVDoubleFloatMapGO.this.set;
            long[] keys = UpdatableQHashSeparateKVDoubleFloatMapGO.this.set;
            this.vals = UpdatableQHashSeparateKVDoubleFloatMapGO.this.values;
            int[] vals = UpdatableQHashSeparateKVDoubleFloatMapGO.this.values;
            int nextI = keys.length;
            while (--nextI >= 0) {
                if (keys[nextI] >= 0x7FFFFFFFFFFFFFFEL) continue;
                this.next = Float.intBitsToFloat(vals[nextI]);
                break;
            }
            this.nextIndex = nextI;
        }

        public float nextFloat() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                if (this.expectedModCount == UpdatableQHashSeparateKVDoubleFloatMapGO.this.modCount()) {
                    long[] keys = this.keys;
                    float prev = this.next;
                    while (--nextI >= 0) {
                        if (keys[nextI] >= 0x7FFFFFFFFFFFFFFEL) continue;
                        this.next = Float.intBitsToFloat(this.vals[nextI]);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void forEachRemaining(Consumer<? super Float> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] keys = this.keys;
            int[] vals = this.vals;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept(Float.valueOf(Float.intBitsToFloat(vals[i])));
            }
            if (nextI != this.nextIndex || mc != UpdatableQHashSeparateKVDoubleFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public void forEachRemaining(FloatConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] keys = this.keys;
            int[] vals = this.vals;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept(Float.intBitsToFloat(vals[i]));
            }
            if (nextI != this.nextIndex || mc != UpdatableQHashSeparateKVDoubleFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Float next() {
            return Float.valueOf(this.nextFloat());
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryCursor
    implements ObjCursor<Map.Entry<Double, Float>> {
        final long[] keys;
        final int[] vals;
        int expectedModCount;
        int index;
        long curKey;
        int curValue;

        NoRemovedEntryCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = UpdatableQHashSeparateKVDoubleFloatMapGO.this.set;
            this.index = this.keys.length;
            this.vals = UpdatableQHashSeparateKVDoubleFloatMapGO.this.values;
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
        }

        public void forEachForward(Consumer<? super Map.Entry<Double, Float>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] keys = this.keys;
            int[] vals = this.vals;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                long key = keys[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept(new MutableEntry(mc, i, key, vals[i]));
            }
            if (index != this.index || mc != UpdatableQHashSeparateKVDoubleFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
        }

        public Map.Entry<Double, Float> elem() {
            long curKey = this.curKey;
            if (curKey != 0x7FFFFFFFFFFFFFFEL) {
                return new MutableEntry(this.expectedModCount, this.index, curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == UpdatableQHashSeparateKVDoubleFloatMapGO.this.modCount()) {
                long[] keys = this.keys;
                for (int i = this.index - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = 0x7FFFFFFFFFFFFFFEL;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryIterator
    implements ObjIterator<Map.Entry<Double, Float>> {
        final long[] keys;
        final int[] vals;
        int expectedModCount;
        int nextIndex;
        MutableEntry next;

        NoRemovedEntryIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = UpdatableQHashSeparateKVDoubleFloatMapGO.this.set;
            long[] keys = UpdatableQHashSeparateKVDoubleFloatMapGO.this.set;
            this.vals = UpdatableQHashSeparateKVDoubleFloatMapGO.this.values;
            int[] vals = UpdatableQHashSeparateKVDoubleFloatMapGO.this.values;
            int nextI = keys.length;
            while (--nextI >= 0) {
                long key = keys[nextI];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                this.next = new MutableEntry(mc, nextI, key, vals[nextI]);
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<Double, Float>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] keys = this.keys;
            int[] vals = this.vals;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                long key = keys[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept(new MutableEntry(mc, i, key, vals[i]));
            }
            if (nextI != this.nextIndex || mc != UpdatableQHashSeparateKVDoubleFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<Double, Float> next() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                int mc = this.expectedModCount;
                if (mc == UpdatableQHashSeparateKVDoubleFloatMapGO.this.modCount()) {
                    long[] keys = this.keys;
                    MutableEntry prev = this.next;
                    while (--nextI >= 0) {
                        long key = keys[nextI];
                        if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                        this.next = new MutableEntry(mc, nextI, key, this.vals[nextI]);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class ValueView
    extends AbstractFloatValueView {
        ValueView() {
        }

        @Override
        public int size() {
            return UpdatableQHashSeparateKVDoubleFloatMapGO.this.size();
        }

        public boolean shrink() {
            return UpdatableQHashSeparateKVDoubleFloatMapGO.this.shrink();
        }

        @Override
        public boolean contains(Object o) {
            return UpdatableQHashSeparateKVDoubleFloatMapGO.this.containsValue(o);
        }

        public boolean contains(float v) {
            return UpdatableQHashSeparateKVDoubleFloatMapGO.this.containsValue(v);
        }

        @Override
        public boolean contains(int bits) {
            return UpdatableQHashSeparateKVDoubleFloatMapGO.this.containsValue(bits);
        }

        @Override
        public void forEach(Consumer<? super Float> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = UpdatableQHashSeparateKVDoubleFloatMapGO.this.modCount();
            long[] keys = UpdatableQHashSeparateKVDoubleFloatMapGO.this.set;
            int[] vals = UpdatableQHashSeparateKVDoubleFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept(Float.valueOf(Float.intBitsToFloat(vals[i])));
            }
            if (mc != UpdatableQHashSeparateKVDoubleFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public void forEach(FloatConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = UpdatableQHashSeparateKVDoubleFloatMapGO.this.modCount();
            long[] keys = UpdatableQHashSeparateKVDoubleFloatMapGO.this.set;
            int[] vals = UpdatableQHashSeparateKVDoubleFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept(Float.intBitsToFloat(vals[i]));
            }
            if (mc != UpdatableQHashSeparateKVDoubleFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(FloatPredicate predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = UpdatableQHashSeparateKVDoubleFloatMapGO.this.modCount();
            long[] keys = UpdatableQHashSeparateKVDoubleFloatMapGO.this.set;
            int[] vals = UpdatableQHashSeparateKVDoubleFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL || predicate.test(Float.intBitsToFloat(vals[i]))) continue;
                terminated = true;
                break;
            }
            if (mc != UpdatableQHashSeparateKVDoubleFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Override
        public boolean allContainingIn(FloatCollection c) {
            if (c instanceof InternalFloatCollectionOps) {
                return this.allContainingIn((InternalFloatCollectionOps)c);
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            int mc = UpdatableQHashSeparateKVDoubleFloatMapGO.this.modCount();
            long[] keys = UpdatableQHashSeparateKVDoubleFloatMapGO.this.set;
            int[] vals = UpdatableQHashSeparateKVDoubleFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL || c.contains(Float.intBitsToFloat(vals[i]))) continue;
                containsAll = false;
                break;
            }
            if (mc != UpdatableQHashSeparateKVDoubleFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        private boolean allContainingIn(InternalFloatCollectionOps c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            int mc = UpdatableQHashSeparateKVDoubleFloatMapGO.this.modCount();
            long[] keys = UpdatableQHashSeparateKVDoubleFloatMapGO.this.set;
            int[] vals = UpdatableQHashSeparateKVDoubleFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL || c.contains(vals[i])) continue;
                containsAll = false;
                break;
            }
            if (mc != UpdatableQHashSeparateKVDoubleFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        @Override
        public boolean reverseAddAllTo(FloatCollection c) {
            if (c instanceof InternalFloatCollectionOps) {
                return this.reverseAddAllTo((InternalFloatCollectionOps)c);
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = UpdatableQHashSeparateKVDoubleFloatMapGO.this.modCount();
            long[] keys = UpdatableQHashSeparateKVDoubleFloatMapGO.this.set;
            int[] vals = UpdatableQHashSeparateKVDoubleFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                changed |= c.add(Float.intBitsToFloat(vals[i]));
            }
            if (mc != UpdatableQHashSeparateKVDoubleFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean reverseAddAllTo(InternalFloatCollectionOps c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = UpdatableQHashSeparateKVDoubleFloatMapGO.this.modCount();
            long[] keys = UpdatableQHashSeparateKVDoubleFloatMapGO.this.set;
            int[] vals = UpdatableQHashSeparateKVDoubleFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                changed |= c.add(vals[i]);
            }
            if (mc != UpdatableQHashSeparateKVDoubleFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public boolean reverseRemoveAllFrom(FloatSet s) {
            if (s instanceof InternalFloatCollectionOps) {
                return this.reverseRemoveAllFrom((InternalFloatCollectionOps)s);
            }
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = UpdatableQHashSeparateKVDoubleFloatMapGO.this.modCount();
            long[] keys = UpdatableQHashSeparateKVDoubleFloatMapGO.this.set;
            int[] vals = UpdatableQHashSeparateKVDoubleFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                changed |= s.removeFloat(Float.intBitsToFloat(vals[i]));
            }
            if (mc != UpdatableQHashSeparateKVDoubleFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean reverseRemoveAllFrom(InternalFloatCollectionOps s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = UpdatableQHashSeparateKVDoubleFloatMapGO.this.modCount();
            long[] keys = UpdatableQHashSeparateKVDoubleFloatMapGO.this.set;
            int[] vals = UpdatableQHashSeparateKVDoubleFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                changed |= s.removeFloat(vals[i]);
            }
            if (mc != UpdatableQHashSeparateKVDoubleFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Nonnull
        public FloatIterator iterator() {
            int mc = UpdatableQHashSeparateKVDoubleFloatMapGO.this.modCount();
            return new NoRemovedValueIterator(mc);
        }

        @Nonnull
        public FloatCursor cursor() {
            int mc = UpdatableQHashSeparateKVDoubleFloatMapGO.this.modCount();
            return new NoRemovedValueCursor(mc);
        }

        @Override
        @Nonnull
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = UpdatableQHashSeparateKVDoubleFloatMapGO.this.modCount();
            long[] keys = UpdatableQHashSeparateKVDoubleFloatMapGO.this.set;
            int[] vals = UpdatableQHashSeparateKVDoubleFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                result[resultIndex++] = Float.valueOf(Float.intBitsToFloat(vals[i]));
            }
            if (mc != UpdatableQHashSeparateKVDoubleFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Override
        @Nonnull
        public <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = UpdatableQHashSeparateKVDoubleFloatMapGO.this.modCount();
            long[] keys = UpdatableQHashSeparateKVDoubleFloatMapGO.this.set;
            int[] vals = UpdatableQHashSeparateKVDoubleFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                a[resultIndex++] = Float.valueOf(Float.intBitsToFloat(vals[i]));
            }
            if (mc != UpdatableQHashSeparateKVDoubleFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public float[] toFloatArray() {
            int size = this.size();
            float[] result = new float[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = UpdatableQHashSeparateKVDoubleFloatMapGO.this.modCount();
            long[] keys = UpdatableQHashSeparateKVDoubleFloatMapGO.this.set;
            int[] vals = UpdatableQHashSeparateKVDoubleFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                result[resultIndex++] = Float.intBitsToFloat(vals[i]);
            }
            if (mc != UpdatableQHashSeparateKVDoubleFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        public float[] toArray(float[] a) {
            int size = this.size();
            if (a.length < size) {
                a = new float[size];
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = 0.0f;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = UpdatableQHashSeparateKVDoubleFloatMapGO.this.modCount();
            long[] keys = UpdatableQHashSeparateKVDoubleFloatMapGO.this.set;
            int[] vals = UpdatableQHashSeparateKVDoubleFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                a[resultIndex++] = Float.intBitsToFloat(vals[i]);
            }
            if (mc != UpdatableQHashSeparateKVDoubleFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = 0.0f;
            }
            return a;
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = UpdatableQHashSeparateKVDoubleFloatMapGO.this.modCount();
            long[] keys = UpdatableQHashSeparateKVDoubleFloatMapGO.this.set;
            int[] vals = UpdatableQHashSeparateKVDoubleFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                sb.append(' ').append(Float.intBitsToFloat(vals[i])).append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            if (mc != UpdatableQHashSeparateKVDoubleFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        @Override
        public boolean remove(Object o) {
            return this.removeFloat(((Float)o).floatValue());
        }

        public boolean removeFloat(float v) {
            return UpdatableQHashSeparateKVDoubleFloatMapGO.this.removeValue(v);
        }

        @Override
        public boolean removeFloat(int bits) {
            return UpdatableQHashSeparateKVDoubleFloatMapGO.this.removeValue(bits);
        }

        @Override
        public void clear() {
            UpdatableQHashSeparateKVDoubleFloatMapGO.this.clear();
        }

        @Override
        public boolean removeIf(Predicate<? super Float> filter) {
            throw new UnsupportedOperationException();
        }

        public boolean removeIf(FloatPredicate filter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }
    }

    class ReusableEntry
    extends DoubleFloatEntry {
        private long key;
        private int value;

        ReusableEntry() {
        }

        ReusableEntry with(long key, int value) {
            this.key = key;
            this.value = value;
            return this;
        }

        @Override
        public long key() {
            return this.key;
        }

        @Override
        public int value() {
            return this.value;
        }
    }

    class MutableEntry
    extends DoubleFloatEntry {
        int modCount;
        private final int index;
        final long key;
        private int value;

        MutableEntry(int modCount, int index, long key, int value) {
            this.modCount = modCount;
            this.index = index;
            this.key = key;
            this.value = value;
        }

        @Override
        public long key() {
            return this.key;
        }

        @Override
        public int value() {
            return this.value;
        }

        @Override
        public Float setValue(Float newValue) {
            int unwrappedNewValue;
            if (this.modCount != UpdatableQHashSeparateKVDoubleFloatMapGO.this.modCount()) {
                throw new IllegalStateException();
            }
            float oldValue = Float.intBitsToFloat(this.value);
            this.value = unwrappedNewValue = Float.floatToIntBits(newValue.floatValue());
            this.updateValueInTable(unwrappedNewValue);
            return Float.valueOf(oldValue);
        }

        void updateValueInTable(int newValue) {
            UpdatableQHashSeparateKVDoubleFloatMapGO.this.values[this.index] = newValue;
        }
    }

    abstract class DoubleFloatEntry
    extends AbstractEntry<Double, Float> {
        DoubleFloatEntry() {
        }

        abstract long key();

        @Override
        public final Double getKey() {
            return Double.longBitsToDouble(this.key());
        }

        abstract int value();

        @Override
        public final Float getValue() {
            return Float.valueOf(Float.intBitsToFloat(this.value()));
        }

        @Override
        public boolean equals(Object o) {
            try {
                Map.Entry e2 = (Map.Entry)o;
                long k2 = Double.doubleToLongBits((Double)e2.getKey());
                int v2 = Float.floatToIntBits(((Float)e2.getValue()).floatValue());
                return this.key() == k2 && this.value() == v2;
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        @Override
        public int hashCode() {
            return Primitives.hashCode(this.key()) ^ Primitives.hashCode(this.value());
        }
    }

    class EntryView
    extends AbstractSetView<Map.Entry<Double, Float>>
    implements HashObjSet<Map.Entry<Double, Float>>,
    InternalObjCollectionOps<Map.Entry<Double, Float>> {
        EntryView() {
        }

        @Nullable
        public Equivalence<Map.Entry<Double, Float>> equivalence() {
            return Equivalence.entryEquivalence(null, null);
        }

        @Nonnull
        public HashConfig hashConfig() {
            return UpdatableQHashSeparateKVDoubleFloatMapGO.this.hashConfig();
        }

        @Override
        public int size() {
            return UpdatableQHashSeparateKVDoubleFloatMapGO.this.size();
        }

        public double currentLoad() {
            return UpdatableQHashSeparateKVDoubleFloatMapGO.this.currentLoad();
        }

        @Override
        public boolean contains(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                return UpdatableQHashSeparateKVDoubleFloatMapGO.this.containsEntry((Double)e.getKey(), ((Float)e.getValue()).floatValue());
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        @Nonnull
        public final Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = UpdatableQHashSeparateKVDoubleFloatMapGO.this.modCount();
            long[] keys = UpdatableQHashSeparateKVDoubleFloatMapGO.this.set;
            int[] vals = UpdatableQHashSeparateKVDoubleFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                result[resultIndex++] = new MutableEntry(mc, i, key, vals[i]);
            }
            if (mc != UpdatableQHashSeparateKVDoubleFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Override
        @Nonnull
        public final <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = UpdatableQHashSeparateKVDoubleFloatMapGO.this.modCount();
            long[] keys = UpdatableQHashSeparateKVDoubleFloatMapGO.this.set;
            int[] vals = UpdatableQHashSeparateKVDoubleFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                a[resultIndex++] = new MutableEntry(mc, i, key, vals[i]);
            }
            if (mc != UpdatableQHashSeparateKVDoubleFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        @Override
        public final void forEach(@Nonnull Consumer<? super Map.Entry<Double, Float>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = UpdatableQHashSeparateKVDoubleFloatMapGO.this.modCount();
            long[] keys = UpdatableQHashSeparateKVDoubleFloatMapGO.this.set;
            int[] vals = UpdatableQHashSeparateKVDoubleFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept(new MutableEntry(mc, i, key, vals[i]));
            }
            if (mc != UpdatableQHashSeparateKVDoubleFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(@Nonnull Predicate<? super Map.Entry<Double, Float>> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = UpdatableQHashSeparateKVDoubleFloatMapGO.this.modCount();
            long[] keys = UpdatableQHashSeparateKVDoubleFloatMapGO.this.set;
            int[] vals = UpdatableQHashSeparateKVDoubleFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL || predicate.test(new MutableEntry(mc, i, key, vals[i]))) continue;
                terminated = true;
                break;
            }
            if (mc != UpdatableQHashSeparateKVDoubleFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Override
        @Nonnull
        public ObjIterator<Map.Entry<Double, Float>> iterator() {
            int mc = UpdatableQHashSeparateKVDoubleFloatMapGO.this.modCount();
            return new NoRemovedEntryIterator(mc);
        }

        @Nonnull
        public ObjCursor<Map.Entry<Double, Float>> cursor() {
            int mc = UpdatableQHashSeparateKVDoubleFloatMapGO.this.modCount();
            return new NoRemovedEntryCursor(mc);
        }

        @Override
        public final boolean containsAll(@Nonnull Collection<?> c) {
            return CommonObjCollectionOps.containsAll(this, c);
        }

        @Override
        public final boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            ReusableEntry e = new ReusableEntry();
            int mc = UpdatableQHashSeparateKVDoubleFloatMapGO.this.modCount();
            long[] keys = UpdatableQHashSeparateKVDoubleFloatMapGO.this.set;
            int[] vals = UpdatableQHashSeparateKVDoubleFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL || c.contains((Object)e.with(key, vals[i]))) continue;
                containsAll = false;
                break;
            }
            if (mc != UpdatableQHashSeparateKVDoubleFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        @Override
        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = UpdatableQHashSeparateKVDoubleFloatMapGO.this.modCount();
            long[] keys = UpdatableQHashSeparateKVDoubleFloatMapGO.this.set;
            int[] vals = UpdatableQHashSeparateKVDoubleFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                changed |= s.remove((Object)e.with(key, vals[i]));
            }
            if (mc != UpdatableQHashSeparateKVDoubleFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public final boolean reverseAddAllTo(ObjCollection<? super Map.Entry<Double, Float>> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = UpdatableQHashSeparateKVDoubleFloatMapGO.this.modCount();
            long[] keys = UpdatableQHashSeparateKVDoubleFloatMapGO.this.set;
            int[] vals = UpdatableQHashSeparateKVDoubleFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                changed |= c.add((Object)new MutableEntry(mc, i, key, vals[i]));
            }
            if (mc != UpdatableQHashSeparateKVDoubleFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public int hashCode() {
            return UpdatableQHashSeparateKVDoubleFloatMapGO.this.hashCode();
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = UpdatableQHashSeparateKVDoubleFloatMapGO.this.modCount();
            long[] keys = UpdatableQHashSeparateKVDoubleFloatMapGO.this.set;
            int[] vals = UpdatableQHashSeparateKVDoubleFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                sb.append(' ');
                sb.append(Double.longBitsToDouble(key));
                sb.append('=');
                sb.append(Float.intBitsToFloat(vals[i]));
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            if (mc != UpdatableQHashSeparateKVDoubleFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean shrink() {
            return UpdatableQHashSeparateKVDoubleFloatMapGO.this.shrink();
        }

        @Override
        public boolean remove(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                double key = (Double)e.getKey();
                float value = ((Float)e.getValue()).floatValue();
                return UpdatableQHashSeparateKVDoubleFloatMapGO.this.remove(key, value);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        public final boolean removeIf(@Nonnull Predicate<? super Map.Entry<Double, Float>> filter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof InternalObjCollectionOps) {
                InternalObjCollectionOps c2 = (InternalObjCollectionOps)((Object)c);
                if (NullableObjects.equals(this.equivalence(), c2.equivalence()) && c2.size() < this.size()) {
                    c2.reverseRemoveAllFrom((ObjSet<?>)this);
                }
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            UpdatableQHashSeparateKVDoubleFloatMapGO.this.clear();
        }
    }
}

