/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntBinaryOperator;
import java.util.function.IntConsumer;
import java.util.function.IntPredicate;
import java.util.function.IntUnaryOperator;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.openhft.collect.Equivalence;
import net.openhft.collect.IntCollection;
import net.openhft.collect.IntCursor;
import net.openhft.collect.IntIterator;
import net.openhft.collect.ObjCollection;
import net.openhft.collect.ObjCursor;
import net.openhft.collect.ObjIterator;
import net.openhft.collect.hash.HashConfig;
import net.openhft.collect.impl.AbstractEntry;
import net.openhft.collect.impl.AbstractIntValueView;
import net.openhft.collect.impl.AbstractSetView;
import net.openhft.collect.impl.CommonIntIntMapOps;
import net.openhft.collect.impl.CommonMapOps;
import net.openhft.collect.impl.CommonObjCollectionOps;
import net.openhft.collect.impl.InternalIntIntMapOps;
import net.openhft.collect.impl.InternalObjCollectionOps;
import net.openhft.collect.impl.NullableObjects;
import net.openhft.collect.impl.Primitives;
import net.openhft.collect.impl.UnsafeConstants;
import net.openhft.collect.impl.hash.ParallelKVIntIntQHash;
import net.openhft.collect.impl.hash.QHash;
import net.openhft.collect.impl.hash.UpdatableQHashParallelKVIntIntMapSO;
import net.openhft.collect.map.IntIntCursor;
import net.openhft.collect.set.IntSet;
import net.openhft.collect.set.ObjSet;
import net.openhft.collect.set.hash.HashObjSet;
import net.openhft.function.IntIntConsumer;
import net.openhft.function.IntIntPredicate;
import net.openhft.function.IntIntToIntFunction;

public class UpdatableQHashParallelKVIntIntMapGO
extends UpdatableQHashParallelKVIntIntMapSO {
    final void copy(ParallelKVIntIntQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.copy(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    final void move(ParallelKVIntIntQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.move(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public int defaultValue() {
        return 0;
    }

    @Override
    public boolean containsEntry(int key, int value) {
        int free = this.freeValue;
        if (key != free) {
            long[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVIntKeyMixing.mix(key) % capacity;
            long entry = tab[index];
            int cur = (int)entry;
            if (cur == key) {
                return (int)(entry >>> 32) == value;
            }
            if (cur == free) {
                return false;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = (int)(entry = tab[bIndex])) == key) {
                    return (int)(entry >>> 32) == value;
                }
                if (cur == free) {
                    return false;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = (int)(entry = tab[fIndex])) == key) {
                    return (int)(entry >>> 32) == value;
                }
                if (cur == free) {
                    return false;
                }
                step += 2;
            }
        }
        return false;
    }

    @Override
    public Integer get(Object key) {
        int free;
        int k = (Integer)key;
        if (k != (free = this.freeValue)) {
            long[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVIntKeyMixing.mix(k) % capacity;
            long entry = tab[index];
            int cur = (int)entry;
            if (cur == k) {
                return (int)(entry >>> 32);
            }
            if (cur == free) {
                return null;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = (int)(entry = tab[bIndex])) == k) {
                    return (int)(entry >>> 32);
                }
                if (cur == free) {
                    return null;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = (int)(entry = tab[fIndex])) == k) {
                    return (int)(entry >>> 32);
                }
                if (cur == free) {
                    return null;
                }
                step += 2;
            }
        }
        return null;
    }

    public int get(int key) {
        int free = this.freeValue;
        if (key != free) {
            long[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVIntKeyMixing.mix(key) % capacity;
            long entry = tab[index];
            int cur = (int)entry;
            if (cur == key) {
                return (int)(entry >>> 32);
            }
            if (cur == free) {
                return this.defaultValue();
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = (int)(entry = tab[bIndex])) == key) {
                    return (int)(entry >>> 32);
                }
                if (cur == free) {
                    return this.defaultValue();
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = (int)(entry = tab[fIndex])) == key) {
                    return (int)(entry >>> 32);
                }
                if (cur == free) {
                    return this.defaultValue();
                }
                step += 2;
            }
        }
        return this.defaultValue();
    }

    @Override
    public Integer getOrDefault(Object key, Integer defaultValue) {
        int free;
        int k = (Integer)key;
        if (k != (free = this.freeValue)) {
            long[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVIntKeyMixing.mix(k) % capacity;
            long entry = tab[index];
            int cur = (int)entry;
            if (cur == k) {
                return (int)(entry >>> 32);
            }
            if (cur == free) {
                return defaultValue;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = (int)(entry = tab[bIndex])) == k) {
                    return (int)(entry >>> 32);
                }
                if (cur == free) {
                    return defaultValue;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = (int)(entry = tab[fIndex])) == k) {
                    return (int)(entry >>> 32);
                }
                if (cur == free) {
                    return defaultValue;
                }
                step += 2;
            }
        }
        return defaultValue;
    }

    public int getOrDefault(int key, int defaultValue) {
        int free = this.freeValue;
        if (key != free) {
            long[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVIntKeyMixing.mix(key) % capacity;
            long entry = tab[index];
            int cur = (int)entry;
            if (cur == key) {
                return (int)(entry >>> 32);
            }
            if (cur == free) {
                return defaultValue;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = (int)(entry = tab[bIndex])) == key) {
                    return (int)(entry >>> 32);
                }
                if (cur == free) {
                    return defaultValue;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = (int)(entry = tab[fIndex])) == key) {
                    return (int)(entry >>> 32);
                }
                if (cur == free) {
                    return defaultValue;
                }
                step += 2;
            }
        }
        return defaultValue;
    }

    @Override
    public void forEach(BiConsumer<? super Integer, ? super Integer> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        int free = this.freeValue;
        long[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            long entry = tab[i];
            int key = (int)entry;
            if (key == free) continue;
            action.accept((Integer)key, (Integer)((int)(entry >>> 32)));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void forEach(IntIntConsumer action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        int free = this.freeValue;
        long[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            long entry = tab[i];
            int key = (int)entry;
            if (key == free) continue;
            action.accept(key, (int)(entry >>> 32));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public boolean forEachWhile(IntIntPredicate predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        int mc = this.modCount();
        int free = this.freeValue;
        long[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            long entry = tab[i];
            int key = (int)entry;
            if (key == free || predicate.test(key, (int)(entry >>> 32))) continue;
            terminated = true;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return !terminated;
    }

    @Nonnull
    public IntIntCursor cursor() {
        int mc = this.modCount();
        return new NoRemovedMapCursor(mc);
    }

    @Override
    public boolean containsAllEntries(Map<?, ?> m) {
        return CommonIntIntMapOps.containsAllEntries(this, m);
    }

    @Override
    public boolean allEntriesContainingIn(InternalIntIntMapOps m) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        int mc = this.modCount();
        int free = this.freeValue;
        long[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            long entry = tab[i];
            int key = (int)entry;
            if (key == free || m.containsEntry(key, (int)(entry >>> 32))) continue;
            containsAll = false;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return containsAll;
    }

    @Override
    public void reversePutAllTo(InternalIntIntMapOps m) {
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        int free = this.freeValue;
        long[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            long entry = tab[i];
            int key = (int)entry;
            if (key == free) continue;
            m.justPut(key, (int)(entry >>> 32));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    @Nonnull
    public HashObjSet<Map.Entry<Integer, Integer>> entrySet() {
        return new EntryView();
    }

    @Nonnull
    public IntCollection values() {
        return new ValueView();
    }

    @Override
    public boolean equals(Object o) {
        return CommonMapOps.equals(this, o);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        int mc = this.modCount();
        int free = this.freeValue;
        long[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            long entry = tab[i];
            int key = (int)entry;
            if (key == free) continue;
            hashCode += key ^ (int)(entry >>> 32);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return hashCode;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        int mc = this.modCount();
        int free = this.freeValue;
        long[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            long entry = tab[i];
            int key = (int)entry;
            if (key == free) continue;
            sb.append(' ');
            sb.append(key);
            sb.append('=');
            sb.append((int)(entry >>> 32));
            sb.append(',');
            if (++elementCount != 8) continue;
            int expectedLength = sb.length() * (this.size() / 8);
            sb.ensureCapacity(expectedLength + expectedLength / 2);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        sb.setCharAt(0, '{');
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    @Override
    void rehash(int newCapacity) {
        int mc = this.modCount();
        int free = this.freeValue;
        long[] tab = this.table;
        this.initForRehash(newCapacity);
        ++mc;
        long[] newTab = this.table;
        int capacity = newTab.length;
        for (int i = tab.length - 1; i >= 0; --i) {
            long entry = tab[i];
            int key = (int)entry;
            if (key == free) continue;
            int index = QHash.ParallelKVIntKeyMixing.mix(key) % capacity;
            if (U.getInt(newTab, LONG_BASE + INT_KEY_OFFSET + ((long)index << 3)) != free) {
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if (U.getInt(newTab, LONG_BASE + INT_KEY_OFFSET + ((long)bIndex << 3)) != free) {
                        index = bIndex;
                        break;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if (U.getInt(newTab, LONG_BASE + INT_KEY_OFFSET + ((long)fIndex << 3)) != free) {
                        index = fIndex;
                        break;
                    }
                    step += 2;
                }
            }
            newTab[index] = entry;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public Integer put(Integer key, Integer value) {
        int free;
        int k = key;
        if (k == (free = this.freeValue)) {
            free = this.changeFree();
        }
        long[] tab = this.table;
        int capacity = tab.length;
        int index = QHash.ParallelKVIntKeyMixing.mix(k) % capacity;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur == free) {
            this.incrementModCount();
            tab[index] = (long)k & 0xFFFFFFFFL | (long)value.intValue() << 32;
            this.postInsertHook();
            return null;
        }
        if (cur != k) {
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = (int)(entry = tab[bIndex])) == free) {
                    this.incrementModCount();
                    tab[bIndex] = (long)k & 0xFFFFFFFFL | (long)value.intValue() << 32;
                    this.postInsertHook();
                    return null;
                }
                if (cur == k) {
                    index = bIndex;
                    break;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = (int)(entry = tab[fIndex])) == free) {
                    this.incrementModCount();
                    tab[fIndex] = (long)k & 0xFFFFFFFFL | (long)value.intValue() << 32;
                    this.postInsertHook();
                    return null;
                }
                if (cur == k) {
                    index = fIndex;
                    break;
                }
                step += 2;
            }
        }
        int prevValue = (int)(entry >>> 32);
        U.putInt(tab, LONG_BASE + INT_VALUE_OFFSET + ((long)index << 3), value);
        return prevValue;
    }

    @Override
    public int put(int key, int value) {
        int free = this.freeValue;
        if (key == free) {
            free = this.changeFree();
        }
        long[] tab = this.table;
        int capacity = tab.length;
        int index = QHash.ParallelKVIntKeyMixing.mix(key) % capacity;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur == free) {
            this.incrementModCount();
            tab[index] = (long)key & 0xFFFFFFFFL | (long)value << 32;
            this.postInsertHook();
            return this.defaultValue();
        }
        if (cur != key) {
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = (int)(entry = tab[bIndex])) == free) {
                    this.incrementModCount();
                    tab[bIndex] = (long)key & 0xFFFFFFFFL | (long)value << 32;
                    this.postInsertHook();
                    return this.defaultValue();
                }
                if (cur == key) {
                    index = bIndex;
                    break;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = (int)(entry = tab[fIndex])) == free) {
                    this.incrementModCount();
                    tab[fIndex] = (long)key & 0xFFFFFFFFL | (long)value << 32;
                    this.postInsertHook();
                    return this.defaultValue();
                }
                if (cur == key) {
                    index = fIndex;
                    break;
                }
                step += 2;
            }
        }
        int prevValue = (int)(entry >>> 32);
        U.putInt(tab, LONG_BASE + INT_VALUE_OFFSET + ((long)index << 3), value);
        return prevValue;
    }

    @Override
    public Integer putIfAbsent(Integer key, Integer value) {
        int free;
        int k = key;
        if (k == (free = this.freeValue)) {
            free = this.changeFree();
        }
        long[] tab = this.table;
        int capacity = tab.length;
        int index = QHash.ParallelKVIntKeyMixing.mix(k) % capacity;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur == free) {
            this.incrementModCount();
            tab[index] = (long)k & 0xFFFFFFFFL | (long)value.intValue() << 32;
            this.postInsertHook();
            return null;
        }
        if (cur == k) {
            return (int)(entry >>> 32);
        }
        int bIndex = index;
        int fIndex = index;
        int step = 1;
        while (true) {
            if ((bIndex -= step) < 0) {
                bIndex += capacity;
            }
            if ((cur = (int)(entry = tab[bIndex])) == free) {
                this.incrementModCount();
                tab[bIndex] = (long)k & 0xFFFFFFFFL | (long)value.intValue() << 32;
                this.postInsertHook();
                return null;
            }
            if (cur == k) {
                return (int)(entry >>> 32);
            }
            int t = (fIndex += step) - capacity;
            if (t >= 0) {
                fIndex = t;
            }
            if ((cur = (int)(entry = tab[fIndex])) == free) {
                this.incrementModCount();
                tab[fIndex] = (long)k & 0xFFFFFFFFL | (long)value.intValue() << 32;
                this.postInsertHook();
                return null;
            }
            if (cur == k) {
                return (int)(entry >>> 32);
            }
            step += 2;
        }
    }

    @Override
    public int putIfAbsent(int key, int value) {
        int free = this.freeValue;
        if (key == free) {
            free = this.changeFree();
        }
        long[] tab = this.table;
        int capacity = tab.length;
        int index = QHash.ParallelKVIntKeyMixing.mix(key) % capacity;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur == free) {
            this.incrementModCount();
            tab[index] = (long)key & 0xFFFFFFFFL | (long)value << 32;
            this.postInsertHook();
            return this.defaultValue();
        }
        if (cur == key) {
            return (int)(entry >>> 32);
        }
        int bIndex = index;
        int fIndex = index;
        int step = 1;
        while (true) {
            if ((bIndex -= step) < 0) {
                bIndex += capacity;
            }
            if ((cur = (int)(entry = tab[bIndex])) == free) {
                this.incrementModCount();
                tab[bIndex] = (long)key & 0xFFFFFFFFL | (long)value << 32;
                this.postInsertHook();
                return this.defaultValue();
            }
            if (cur == key) {
                return (int)(entry >>> 32);
            }
            int t = (fIndex += step) - capacity;
            if (t >= 0) {
                fIndex = t;
            }
            if ((cur = (int)(entry = tab[fIndex])) == free) {
                this.incrementModCount();
                tab[fIndex] = (long)key & 0xFFFFFFFFL | (long)value << 32;
                this.postInsertHook();
                return this.defaultValue();
            }
            if (cur == key) {
                return (int)(entry >>> 32);
            }
            step += 2;
        }
    }

    @Override
    public void justPut(int key, int value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return;
        }
        U.putInt(this.table, LONG_BASE + INT_VALUE_OFFSET + ((long)index << 3), value);
    }

    @Override
    public Integer compute(Integer key, BiFunction<? super Integer, ? super Integer, ? extends Integer> remappingFunction) {
        Integer newValue;
        long entry;
        int index;
        long[] tab;
        int k;
        block13: {
            k = key;
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            int free = this.freeValue;
            if (k == free) {
                free = this.changeFree();
            }
            tab = this.table;
            int capacity = tab.length;
            index = QHash.ParallelKVIntKeyMixing.mix(k) % capacity;
            entry = tab[index];
            int cur = (int)entry;
            if (cur != k) {
                Integer newValue2;
                if (cur != free) {
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if ((cur = (int)(entry = tab[bIndex])) == k) {
                            index = bIndex;
                            break block13;
                        }
                        if (cur == free) {
                            index = bIndex;
                            break;
                        }
                        int t = (fIndex += step) - capacity;
                        if (t >= 0) {
                            fIndex = t;
                        }
                        if ((cur = (int)(entry = tab[fIndex])) == k) {
                            index = fIndex;
                            break block13;
                        }
                        if (cur == free) {
                            index = fIndex;
                            break;
                        }
                        step += 2;
                    }
                }
                if ((newValue2 = remappingFunction.apply((Integer)k, null)) != null) {
                    this.incrementModCount();
                    tab[index] = (long)k & 0xFFFFFFFFL | (long)newValue2.intValue() << 32;
                    this.postInsertHook();
                    return newValue2;
                }
                return null;
            }
        }
        if ((newValue = remappingFunction.apply((Integer)k, (Integer)((int)(entry >>> 32)))) != null) {
            U.putInt(tab, LONG_BASE + INT_VALUE_OFFSET + ((long)index << 3), newValue);
            return newValue;
        }
        throw new UnsupportedOperationException("Compute operation of updatable map doesn't support removals");
    }

    public int compute(int key, IntIntToIntFunction remappingFunction) {
        int newValue;
        long entry;
        int index;
        long[] tab;
        block11: {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            int free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            }
            tab = this.table;
            int capacity = tab.length;
            index = QHash.ParallelKVIntKeyMixing.mix(key) % capacity;
            entry = tab[index];
            int cur = (int)entry;
            if (cur != key) {
                if (cur != free) {
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if ((cur = (int)(entry = tab[bIndex])) == key) {
                            index = bIndex;
                            break block11;
                        }
                        if (cur == free) {
                            index = bIndex;
                            break;
                        }
                        int t = (fIndex += step) - capacity;
                        if (t >= 0) {
                            fIndex = t;
                        }
                        if ((cur = (int)(entry = tab[fIndex])) == key) {
                            index = fIndex;
                            break block11;
                        }
                        if (cur == free) {
                            index = fIndex;
                            break;
                        }
                        step += 2;
                    }
                }
                newValue = remappingFunction.applyAsInt(key, this.defaultValue());
                this.incrementModCount();
                tab[index] = (long)key & 0xFFFFFFFFL | (long)newValue << 32;
                this.postInsertHook();
                return newValue;
            }
        }
        newValue = remappingFunction.applyAsInt(key, (int)(entry >>> 32));
        U.putInt(tab, LONG_BASE + INT_VALUE_OFFSET + ((long)index << 3), newValue);
        return newValue;
    }

    @Override
    public Integer computeIfAbsent(Integer key, Function<? super Integer, ? extends Integer> mappingFunction) {
        Integer value;
        int k = key;
        if (mappingFunction == null) {
            throw new NullPointerException();
        }
        int free = this.freeValue;
        if (k == free) {
            free = this.changeFree();
        }
        long[] tab = this.table;
        int capacity = tab.length;
        int index = QHash.ParallelKVIntKeyMixing.mix(k) % capacity;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur != free) {
            if (cur == k) {
                return (int)(entry >>> 32);
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = (int)(entry = tab[bIndex])) == free) {
                    index = bIndex;
                    break;
                }
                if (cur == k) {
                    return (int)(entry >>> 32);
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = (int)(entry = tab[fIndex])) == free) {
                    index = fIndex;
                    break;
                }
                if (cur == k) {
                    return (int)(entry >>> 32);
                }
                step += 2;
            }
        }
        if ((value = mappingFunction.apply((Integer)k)) != null) {
            this.incrementModCount();
            tab[index] = (long)k & 0xFFFFFFFFL | (long)value.intValue() << 32;
            this.postInsertHook();
            return value;
        }
        return null;
    }

    public int computeIfAbsent(int key, IntUnaryOperator mappingFunction) {
        if (mappingFunction == null) {
            throw new NullPointerException();
        }
        int free = this.freeValue;
        if (key == free) {
            free = this.changeFree();
        }
        long[] tab = this.table;
        int capacity = tab.length;
        int index = QHash.ParallelKVIntKeyMixing.mix(key) % capacity;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur != free) {
            if (cur == key) {
                return (int)(entry >>> 32);
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = (int)(entry = tab[bIndex])) == free) {
                    index = bIndex;
                    break;
                }
                if (cur == key) {
                    return (int)(entry >>> 32);
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = (int)(entry = tab[fIndex])) == free) {
                    index = fIndex;
                    break;
                }
                if (cur == key) {
                    return (int)(entry >>> 32);
                }
                step += 2;
            }
        }
        int value = mappingFunction.applyAsInt(key);
        this.incrementModCount();
        tab[index] = (long)key & 0xFFFFFFFFL | (long)value << 32;
        this.postInsertHook();
        return value;
    }

    @Override
    public Integer computeIfPresent(Integer key, BiFunction<? super Integer, ? super Integer, ? extends Integer> remappingFunction) {
        int k = key;
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        int free = this.freeValue;
        if (k != free) {
            Integer newValue;
            long[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVIntKeyMixing.mix(k) % capacity;
            long entry = tab[index];
            int cur = (int)entry;
            if (cur != k) {
                if (cur == free) {
                    return null;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = (int)(entry = tab[bIndex])) == k) {
                        index = bIndex;
                        break;
                    }
                    if (cur == free) {
                        return null;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = (int)(entry = tab[fIndex])) == k) {
                        index = fIndex;
                        break;
                    }
                    if (cur == free) {
                        return null;
                    }
                    step += 2;
                }
            }
            if ((newValue = remappingFunction.apply((Integer)k, (Integer)((int)(entry >>> 32)))) != null) {
                U.putInt(tab, LONG_BASE + INT_VALUE_OFFSET + ((long)index << 3), newValue);
                return newValue;
            }
            throw new UnsupportedOperationException("ComputeIfPresent operation of updatable map doesn't support removals");
        }
        return null;
    }

    public int computeIfPresent(int key, IntIntToIntFunction remappingFunction) {
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        int free = this.freeValue;
        if (key != free) {
            long[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVIntKeyMixing.mix(key) % capacity;
            long entry = tab[index];
            int cur = (int)entry;
            if (cur != key) {
                if (cur == free) {
                    return this.defaultValue();
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = (int)(entry = tab[bIndex])) == key) {
                        index = bIndex;
                        break;
                    }
                    if (cur == free) {
                        return this.defaultValue();
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = (int)(entry = tab[fIndex])) == key) {
                        index = fIndex;
                        break;
                    }
                    if (cur == free) {
                        return this.defaultValue();
                    }
                    step += 2;
                }
            }
            int newValue = remappingFunction.applyAsInt(key, (int)(entry >>> 32));
            U.putInt(tab, LONG_BASE + INT_VALUE_OFFSET + ((long)index << 3), newValue);
            return newValue;
        }
        return this.defaultValue();
    }

    @Override
    public Integer merge(Integer key, Integer value, BiFunction<? super Integer, ? super Integer, ? extends Integer> remappingFunction) {
        Integer newValue;
        long entry;
        int index;
        long[] tab;
        block13: {
            int k = key;
            if (value == null) {
                throw new NullPointerException();
            }
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            int free = this.freeValue;
            if (k == free) {
                free = this.changeFree();
            }
            tab = this.table;
            int capacity = tab.length;
            index = QHash.ParallelKVIntKeyMixing.mix(k) % capacity;
            entry = tab[index];
            int cur = (int)entry;
            if (cur != k) {
                if (cur != free) {
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if ((cur = (int)(entry = tab[bIndex])) == k) {
                            index = bIndex;
                            break block13;
                        }
                        if (cur == free) {
                            index = bIndex;
                            break;
                        }
                        int t = (fIndex += step) - capacity;
                        if (t >= 0) {
                            fIndex = t;
                        }
                        if ((cur = (int)(entry = tab[fIndex])) == k) {
                            index = fIndex;
                            break block13;
                        }
                        if (cur == free) {
                            index = fIndex;
                            break;
                        }
                        step += 2;
                    }
                }
                this.incrementModCount();
                tab[index] = (long)k & 0xFFFFFFFFL | (long)value.intValue() << 32;
                this.postInsertHook();
                return value;
            }
        }
        if ((newValue = remappingFunction.apply((Integer)((int)(entry >>> 32)), value)) != null) {
            U.putInt(tab, LONG_BASE + INT_VALUE_OFFSET + ((long)index << 3), newValue);
            return newValue;
        }
        throw new UnsupportedOperationException("Merge operation of updatable map doesn't support removals");
    }

    public int merge(int key, int value, IntBinaryOperator remappingFunction) {
        long entry;
        int index;
        long[] tab;
        block11: {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            int free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            }
            tab = this.table;
            int capacity = tab.length;
            index = QHash.ParallelKVIntKeyMixing.mix(key) % capacity;
            entry = tab[index];
            int cur = (int)entry;
            if (cur != key) {
                if (cur != free) {
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if ((cur = (int)(entry = tab[bIndex])) == key) {
                            index = bIndex;
                            break block11;
                        }
                        if (cur == free) {
                            index = bIndex;
                            break;
                        }
                        int t = (fIndex += step) - capacity;
                        if (t >= 0) {
                            fIndex = t;
                        }
                        if ((cur = (int)(entry = tab[fIndex])) == key) {
                            index = fIndex;
                            break block11;
                        }
                        if (cur == free) {
                            index = fIndex;
                            break;
                        }
                        step += 2;
                    }
                }
                this.incrementModCount();
                tab[index] = (long)key & 0xFFFFFFFFL | (long)value << 32;
                this.postInsertHook();
                return value;
            }
        }
        int newValue = remappingFunction.applyAsInt((int)(entry >>> 32), value);
        U.putInt(tab, LONG_BASE + INT_VALUE_OFFSET + ((long)index << 3), newValue);
        return newValue;
    }

    public int addValue(int key, int value) {
        int free = this.freeValue;
        if (key == free) {
            free = this.changeFree();
        }
        long[] tab = this.table;
        int capacity = tab.length;
        int index = QHash.ParallelKVIntKeyMixing.mix(key) % capacity;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur == free) {
            this.incrementModCount();
            tab[index] = (long)key & 0xFFFFFFFFL | (long)value << 32;
            this.postInsertHook();
            return value;
        }
        if (cur != key) {
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = (int)(entry = tab[bIndex])) == free) {
                    this.incrementModCount();
                    tab[bIndex] = (long)key & 0xFFFFFFFFL | (long)value << 32;
                    this.postInsertHook();
                    return value;
                }
                if (cur == key) {
                    index = bIndex;
                    break;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = (int)(entry = tab[fIndex])) == free) {
                    this.incrementModCount();
                    tab[fIndex] = (long)key & 0xFFFFFFFFL | (long)value << 32;
                    this.postInsertHook();
                    return value;
                }
                if (cur == key) {
                    index = fIndex;
                    break;
                }
                step += 2;
            }
        }
        int newValue = (int)(entry >>> 32) + value;
        U.putInt(tab, LONG_BASE + INT_VALUE_OFFSET + ((long)index << 3), newValue);
        return newValue;
    }

    public int addValue(int key, int addition, int defaultValue) {
        int value = defaultValue + addition;
        int free = this.freeValue;
        if (key == free) {
            free = this.changeFree();
        }
        long[] tab = this.table;
        int capacity = tab.length;
        int index = QHash.ParallelKVIntKeyMixing.mix(key) % capacity;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur == free) {
            this.incrementModCount();
            tab[index] = (long)key & 0xFFFFFFFFL | (long)value << 32;
            this.postInsertHook();
            return value;
        }
        if (cur != key) {
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = (int)(entry = tab[bIndex])) == free) {
                    this.incrementModCount();
                    tab[bIndex] = (long)key & 0xFFFFFFFFL | (long)value << 32;
                    this.postInsertHook();
                    return value;
                }
                if (cur == key) {
                    index = bIndex;
                    break;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = (int)(entry = tab[fIndex])) == free) {
                    this.incrementModCount();
                    tab[fIndex] = (long)key & 0xFFFFFFFFL | (long)value << 32;
                    this.postInsertHook();
                    return value;
                }
                if (cur == key) {
                    index = fIndex;
                    break;
                }
                step += 2;
            }
        }
        int newValue = (int)(entry >>> 32) + addition;
        U.putInt(tab, LONG_BASE + INT_VALUE_OFFSET + ((long)index << 3), newValue);
        return newValue;
    }

    @Override
    public void putAll(@Nonnull Map<? extends Integer, ? extends Integer> m) {
        CommonIntIntMapOps.putAll(this, m);
    }

    @Override
    public Integer replace(Integer key, Integer value) {
        int free;
        int k = key;
        if (k != (free = this.freeValue)) {
            long[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVIntKeyMixing.mix(k) % capacity;
            long entry = tab[index];
            int cur = (int)entry;
            if (cur != k) {
                if (cur == free) {
                    return null;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = (int)(entry = tab[bIndex])) == k) {
                        index = bIndex;
                        break;
                    }
                    if (cur == free) {
                        return null;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = (int)(entry = tab[fIndex])) == k) {
                        index = fIndex;
                        break;
                    }
                    if (cur == free) {
                        return null;
                    }
                    step += 2;
                }
            }
            int oldValue = (int)(entry >>> 32);
            U.putInt(tab, LONG_BASE + INT_VALUE_OFFSET + ((long)index << 3), value);
            return oldValue;
        }
        return null;
    }

    @Override
    public int replace(int key, int value) {
        int free = this.freeValue;
        if (key != free) {
            long[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVIntKeyMixing.mix(key) % capacity;
            long entry = tab[index];
            int cur = (int)entry;
            if (cur != key) {
                if (cur == free) {
                    return this.defaultValue();
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = (int)(entry = tab[bIndex])) == key) {
                        index = bIndex;
                        break;
                    }
                    if (cur == free) {
                        return this.defaultValue();
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = (int)(entry = tab[fIndex])) == key) {
                        index = fIndex;
                        break;
                    }
                    if (cur == free) {
                        return this.defaultValue();
                    }
                    step += 2;
                }
            }
            int oldValue = (int)(entry >>> 32);
            U.putInt(tab, LONG_BASE + INT_VALUE_OFFSET + ((long)index << 3), value);
            return oldValue;
        }
        return this.defaultValue();
    }

    @Override
    public boolean replace(Integer key, Integer oldValue, Integer newValue) {
        return this.replace((int)key, (int)oldValue, (int)newValue);
    }

    @Override
    public boolean replace(int key, int oldValue, int newValue) {
        int free = this.freeValue;
        if (key != free) {
            long[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVIntKeyMixing.mix(key) % capacity;
            long entry = tab[index];
            int cur = (int)entry;
            if (cur != key) {
                if (cur == free) {
                    return false;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = (int)(entry = tab[bIndex])) == key) {
                        index = bIndex;
                        break;
                    }
                    if (cur == free) {
                        return false;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = (int)(entry = tab[fIndex])) == key) {
                        index = fIndex;
                        break;
                    }
                    if (cur == free) {
                        return false;
                    }
                    step += 2;
                }
            }
            if ((int)(entry >>> 32) == oldValue) {
                U.putInt(tab, LONG_BASE + INT_VALUE_OFFSET + ((long)index << 3), newValue);
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public void replaceAll(BiFunction<? super Integer, ? super Integer, ? extends Integer> function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        int free = this.freeValue;
        long[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            long entry = tab[i];
            int key = (int)entry;
            if (key == free) continue;
            U.putInt(tab, LONG_BASE + INT_VALUE_OFFSET + ((long)i << 3), function.apply((Integer)key, (Integer)((int)(entry >>> 32))));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void replaceAll(IntIntToIntFunction function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        int free = this.freeValue;
        long[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            long entry = tab[i];
            int key = (int)entry;
            if (key == free) continue;
            U.putInt(tab, LONG_BASE + INT_VALUE_OFFSET + ((long)i << 3), function.applyAsInt(key, (int)(entry >>> 32)));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public void clear() {
        int mc = this.modCount() + 1;
        super.clear();
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public Integer remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean justRemove(int key) {
        throw new UnsupportedOperationException();
    }

    public int remove(int key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.remove((Integer)key, (Integer)value);
    }

    public boolean remove(int key, int value) {
        throw new UnsupportedOperationException();
    }

    public boolean removeIf(IntIntPredicate filter) {
        throw new UnsupportedOperationException();
    }

    class NoRemovedMapCursor
    implements IntIntCursor {
        final long[] tab;
        final int free;
        int expectedModCount;
        int index;
        int curKey;
        int curValue;

        NoRemovedMapCursor(int mc) {
            int free;
            this.expectedModCount = mc;
            this.tab = UpdatableQHashParallelKVIntIntMapGO.this.table;
            this.index = this.tab.length;
            this.curKey = free = (this.free = UpdatableQHashParallelKVIntIntMapGO.this.freeValue);
        }

        public void forEachForward(IntIntConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            int free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free) continue;
                action.accept(key, (int)(entry >>> 32));
            }
            if (index != this.index || mc != UpdatableQHashParallelKVIntIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public int key() {
            int curKey = this.curKey;
            if (curKey != this.free) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public int value() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public void setValue(int value) {
            if (this.curKey != this.free) {
                if (this.expectedModCount != UpdatableQHashParallelKVIntIntMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            UnsafeConstants.U.putInt(this.tab, UnsafeConstants.LONG_BASE + UnsafeConstants.INT_VALUE_OFFSET + ((long)this.index << 3), value);
        }

        public boolean moveNext() {
            if (this.expectedModCount == UpdatableQHashParallelKVIntIntMapGO.this.modCount()) {
                long[] tab = this.tab;
                int free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    long entry = tab[i];
                    int key = (int)entry;
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = (int)(entry >>> 32);
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueCursor
    implements IntCursor {
        final long[] tab;
        final int free;
        int expectedModCount;
        int index;
        int curKey;
        int curValue;

        NoRemovedValueCursor(int mc) {
            int free;
            this.expectedModCount = mc;
            this.tab = UpdatableQHashParallelKVIntIntMapGO.this.table;
            this.index = this.tab.length;
            this.curKey = free = (this.free = UpdatableQHashParallelKVIntIntMapGO.this.freeValue);
        }

        public void forEachForward(IntConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            int free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry == free) continue;
                action.accept((int)(entry >>> 32));
            }
            if (index != this.index || mc != UpdatableQHashParallelKVIntIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public int elem() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == UpdatableQHashParallelKVIntIntMapGO.this.modCount()) {
                long[] tab = this.tab;
                int free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    long entry = tab[i];
                    int key = (int)entry;
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = (int)(entry >>> 32);
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueIterator
    implements IntIterator {
        final long[] tab;
        final int free;
        int expectedModCount;
        int nextIndex;
        int next;

        NoRemovedValueIterator(int mc) {
            this.expectedModCount = mc;
            this.tab = UpdatableQHashParallelKVIntIntMapGO.this.table;
            long[] tab = UpdatableQHashParallelKVIntIntMapGO.this.table;
            int free = this.free = UpdatableQHashParallelKVIntIntMapGO.this.freeValue;
            int nextI = tab.length;
            while (--nextI >= 0) {
                long entry = tab[nextI];
                if ((int)entry == free) continue;
                this.next = (int)(entry >>> 32);
                break;
            }
            this.nextIndex = nextI;
        }

        public int nextInt() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                if (this.expectedModCount == UpdatableQHashParallelKVIntIntMapGO.this.modCount()) {
                    long[] tab = this.tab;
                    int free = this.free;
                    int prev = this.next;
                    while (--nextI >= 0) {
                        long entry = tab[nextI];
                        if ((int)entry == free) continue;
                        this.next = (int)(entry >>> 32);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void forEachRemaining(Consumer<? super Integer> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            int free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry == free) continue;
                action.accept((Integer)((int)(entry >>> 32)));
            }
            if (nextI != this.nextIndex || mc != UpdatableQHashParallelKVIntIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public void forEachRemaining(IntConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            int free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry == free) continue;
                action.accept((int)(entry >>> 32));
            }
            if (nextI != this.nextIndex || mc != UpdatableQHashParallelKVIntIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Integer next() {
            return this.nextInt();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryCursor
    implements ObjCursor<Map.Entry<Integer, Integer>> {
        final long[] tab;
        final int free;
        int expectedModCount;
        int index;
        int curKey;
        int curValue;

        NoRemovedEntryCursor(int mc) {
            int free;
            this.expectedModCount = mc;
            this.tab = UpdatableQHashParallelKVIntIntMapGO.this.table;
            this.index = this.tab.length;
            this.curKey = free = (this.free = UpdatableQHashParallelKVIntIntMapGO.this.freeValue);
        }

        public void forEachForward(Consumer<? super Map.Entry<Integer, Integer>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            int free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free) continue;
                action.accept(new MutableEntry(mc, i, key, (int)(entry >>> 32)));
            }
            if (index != this.index || mc != UpdatableQHashParallelKVIntIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public Map.Entry<Integer, Integer> elem() {
            int curKey = this.curKey;
            if (curKey != this.free) {
                return new MutableEntry(this.expectedModCount, this.index, curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == UpdatableQHashParallelKVIntIntMapGO.this.modCount()) {
                long[] tab = this.tab;
                int free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    long entry = tab[i];
                    int key = (int)entry;
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = (int)(entry >>> 32);
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryIterator
    implements ObjIterator<Map.Entry<Integer, Integer>> {
        final long[] tab;
        final int free;
        int expectedModCount;
        int nextIndex;
        MutableEntry next;

        NoRemovedEntryIterator(int mc) {
            this.expectedModCount = mc;
            this.tab = UpdatableQHashParallelKVIntIntMapGO.this.table;
            long[] tab = UpdatableQHashParallelKVIntIntMapGO.this.table;
            int free = this.free = UpdatableQHashParallelKVIntIntMapGO.this.freeValue;
            int nextI = tab.length;
            while (--nextI >= 0) {
                long entry = tab[nextI];
                int key = (int)entry;
                if (key == free) continue;
                this.next = new MutableEntry(mc, nextI, key, (int)(entry >>> 32));
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<Integer, Integer>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            int free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free) continue;
                action.accept(new MutableEntry(mc, i, key, (int)(entry >>> 32)));
            }
            if (nextI != this.nextIndex || mc != UpdatableQHashParallelKVIntIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<Integer, Integer> next() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                int mc = this.expectedModCount;
                if (mc == UpdatableQHashParallelKVIntIntMapGO.this.modCount()) {
                    long[] tab = this.tab;
                    int free = this.free;
                    MutableEntry prev = this.next;
                    while (--nextI >= 0) {
                        long entry = tab[nextI];
                        int key = (int)entry;
                        if (key == free) continue;
                        this.next = new MutableEntry(mc, nextI, key, (int)(entry >>> 32));
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class ValueView
    extends AbstractIntValueView {
        ValueView() {
        }

        @Override
        public int size() {
            return UpdatableQHashParallelKVIntIntMapGO.this.size();
        }

        public boolean shrink() {
            return UpdatableQHashParallelKVIntIntMapGO.this.shrink();
        }

        @Override
        public boolean contains(Object o) {
            return UpdatableQHashParallelKVIntIntMapGO.this.containsValue(o);
        }

        public boolean contains(int v) {
            return UpdatableQHashParallelKVIntIntMapGO.this.containsValue(v);
        }

        @Override
        public void forEach(Consumer<? super Integer> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = UpdatableQHashParallelKVIntIntMapGO.this.modCount();
            int free = UpdatableQHashParallelKVIntIntMapGO.this.freeValue;
            long[] tab = UpdatableQHashParallelKVIntIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry == free) continue;
                action.accept((Integer)((int)(entry >>> 32)));
            }
            if (mc != UpdatableQHashParallelKVIntIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public void forEach(IntConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = UpdatableQHashParallelKVIntIntMapGO.this.modCount();
            int free = UpdatableQHashParallelKVIntIntMapGO.this.freeValue;
            long[] tab = UpdatableQHashParallelKVIntIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry == free) continue;
                action.accept((int)(entry >>> 32));
            }
            if (mc != UpdatableQHashParallelKVIntIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(IntPredicate predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = UpdatableQHashParallelKVIntIntMapGO.this.modCount();
            int free = UpdatableQHashParallelKVIntIntMapGO.this.freeValue;
            long[] tab = UpdatableQHashParallelKVIntIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry == free || predicate.test((int)(entry >>> 32))) continue;
                terminated = true;
                break;
            }
            if (mc != UpdatableQHashParallelKVIntIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Override
        public boolean allContainingIn(IntCollection c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            int mc = UpdatableQHashParallelKVIntIntMapGO.this.modCount();
            int free = UpdatableQHashParallelKVIntIntMapGO.this.freeValue;
            long[] tab = UpdatableQHashParallelKVIntIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry == free || c.contains((int)(entry >>> 32))) continue;
                containsAll = false;
                break;
            }
            if (mc != UpdatableQHashParallelKVIntIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        @Override
        public boolean reverseAddAllTo(IntCollection c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = UpdatableQHashParallelKVIntIntMapGO.this.modCount();
            int free = UpdatableQHashParallelKVIntIntMapGO.this.freeValue;
            long[] tab = UpdatableQHashParallelKVIntIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry == free) continue;
                changed |= c.add((int)(entry >>> 32));
            }
            if (mc != UpdatableQHashParallelKVIntIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public boolean reverseRemoveAllFrom(IntSet s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = UpdatableQHashParallelKVIntIntMapGO.this.modCount();
            int free = UpdatableQHashParallelKVIntIntMapGO.this.freeValue;
            long[] tab = UpdatableQHashParallelKVIntIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry == free) continue;
                changed |= s.removeInt((int)(entry >>> 32));
            }
            if (mc != UpdatableQHashParallelKVIntIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Nonnull
        public IntIterator iterator() {
            int mc = UpdatableQHashParallelKVIntIntMapGO.this.modCount();
            return new NoRemovedValueIterator(mc);
        }

        @Nonnull
        public IntCursor cursor() {
            int mc = UpdatableQHashParallelKVIntIntMapGO.this.modCount();
            return new NoRemovedValueCursor(mc);
        }

        @Override
        @Nonnull
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = UpdatableQHashParallelKVIntIntMapGO.this.modCount();
            int free = UpdatableQHashParallelKVIntIntMapGO.this.freeValue;
            long[] tab = UpdatableQHashParallelKVIntIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry == free) continue;
                result[resultIndex++] = (int)(entry >>> 32);
            }
            if (mc != UpdatableQHashParallelKVIntIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Override
        @Nonnull
        public <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = UpdatableQHashParallelKVIntIntMapGO.this.modCount();
            int free = UpdatableQHashParallelKVIntIntMapGO.this.freeValue;
            long[] tab = UpdatableQHashParallelKVIntIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry == free) continue;
                a[resultIndex++] = (int)(entry >>> 32);
            }
            if (mc != UpdatableQHashParallelKVIntIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public int[] toIntArray() {
            int size = this.size();
            int[] result = new int[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = UpdatableQHashParallelKVIntIntMapGO.this.modCount();
            int free = UpdatableQHashParallelKVIntIntMapGO.this.freeValue;
            long[] tab = UpdatableQHashParallelKVIntIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry == free) continue;
                result[resultIndex++] = (int)(entry >>> 32);
            }
            if (mc != UpdatableQHashParallelKVIntIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        public int[] toArray(int[] a) {
            int size = this.size();
            if (a.length < size) {
                a = new int[size];
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = 0;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = UpdatableQHashParallelKVIntIntMapGO.this.modCount();
            int free = UpdatableQHashParallelKVIntIntMapGO.this.freeValue;
            long[] tab = UpdatableQHashParallelKVIntIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry == free) continue;
                a[resultIndex++] = (int)(entry >>> 32);
            }
            if (mc != UpdatableQHashParallelKVIntIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = 0;
            }
            return a;
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = UpdatableQHashParallelKVIntIntMapGO.this.modCount();
            int free = UpdatableQHashParallelKVIntIntMapGO.this.freeValue;
            long[] tab = UpdatableQHashParallelKVIntIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry == free) continue;
                sb.append(' ').append((int)(entry >>> 32)).append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            if (mc != UpdatableQHashParallelKVIntIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        @Override
        public boolean remove(Object o) {
            return this.removeInt((Integer)o);
        }

        public boolean removeInt(int v) {
            return UpdatableQHashParallelKVIntIntMapGO.this.removeValue(v);
        }

        @Override
        public void clear() {
            UpdatableQHashParallelKVIntIntMapGO.this.clear();
        }

        @Override
        public boolean removeIf(Predicate<? super Integer> filter) {
            throw new UnsupportedOperationException();
        }

        public boolean removeIf(IntPredicate filter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }
    }

    class ReusableEntry
    extends IntIntEntry {
        private int key;
        private int value;

        ReusableEntry() {
        }

        ReusableEntry with(int key, int value) {
            this.key = key;
            this.value = value;
            return this;
        }

        @Override
        public int key() {
            return this.key;
        }

        @Override
        public int value() {
            return this.value;
        }
    }

    class MutableEntry
    extends IntIntEntry {
        int modCount;
        private final int index;
        final int key;
        private int value;

        MutableEntry(int modCount, int index, int key, int value) {
            this.modCount = modCount;
            this.index = index;
            this.key = key;
            this.value = value;
        }

        @Override
        public int key() {
            return this.key;
        }

        @Override
        public int value() {
            return this.value;
        }

        @Override
        public Integer setValue(Integer newValue) {
            int unwrappedNewValue;
            if (this.modCount != UpdatableQHashParallelKVIntIntMapGO.this.modCount()) {
                throw new IllegalStateException();
            }
            int oldValue = this.value;
            this.value = unwrappedNewValue = newValue.intValue();
            this.updateValueInTable(unwrappedNewValue);
            return oldValue;
        }

        void updateValueInTable(int newValue) {
            UnsafeConstants.U.putInt(UpdatableQHashParallelKVIntIntMapGO.this.table, UnsafeConstants.LONG_BASE + UnsafeConstants.INT_VALUE_OFFSET + ((long)this.index << 3), newValue);
        }
    }

    abstract class IntIntEntry
    extends AbstractEntry<Integer, Integer> {
        IntIntEntry() {
        }

        abstract int key();

        @Override
        public final Integer getKey() {
            return this.key();
        }

        abstract int value();

        @Override
        public final Integer getValue() {
            return this.value();
        }

        @Override
        public boolean equals(Object o) {
            try {
                Map.Entry e2 = (Map.Entry)o;
                int k2 = (Integer)e2.getKey();
                int v2 = (Integer)e2.getValue();
                return this.key() == k2 && this.value() == v2;
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        @Override
        public int hashCode() {
            return Primitives.hashCode(this.key()) ^ Primitives.hashCode(this.value());
        }
    }

    class EntryView
    extends AbstractSetView<Map.Entry<Integer, Integer>>
    implements HashObjSet<Map.Entry<Integer, Integer>>,
    InternalObjCollectionOps<Map.Entry<Integer, Integer>> {
        EntryView() {
        }

        @Nullable
        public Equivalence<Map.Entry<Integer, Integer>> equivalence() {
            return Equivalence.entryEquivalence(null, null);
        }

        @Nonnull
        public HashConfig hashConfig() {
            return UpdatableQHashParallelKVIntIntMapGO.this.hashConfig();
        }

        @Override
        public int size() {
            return UpdatableQHashParallelKVIntIntMapGO.this.size();
        }

        public double currentLoad() {
            return UpdatableQHashParallelKVIntIntMapGO.this.currentLoad();
        }

        @Override
        public boolean contains(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                return UpdatableQHashParallelKVIntIntMapGO.this.containsEntry((Integer)e.getKey(), (Integer)e.getValue());
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        @Nonnull
        public final Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = UpdatableQHashParallelKVIntIntMapGO.this.modCount();
            int free = UpdatableQHashParallelKVIntIntMapGO.this.freeValue;
            long[] tab = UpdatableQHashParallelKVIntIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free) continue;
                result[resultIndex++] = new MutableEntry(mc, i, key, (int)(entry >>> 32));
            }
            if (mc != UpdatableQHashParallelKVIntIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Override
        @Nonnull
        public final <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = UpdatableQHashParallelKVIntIntMapGO.this.modCount();
            int free = UpdatableQHashParallelKVIntIntMapGO.this.freeValue;
            long[] tab = UpdatableQHashParallelKVIntIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free) continue;
                a[resultIndex++] = new MutableEntry(mc, i, key, (int)(entry >>> 32));
            }
            if (mc != UpdatableQHashParallelKVIntIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        @Override
        public final void forEach(@Nonnull Consumer<? super Map.Entry<Integer, Integer>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = UpdatableQHashParallelKVIntIntMapGO.this.modCount();
            int free = UpdatableQHashParallelKVIntIntMapGO.this.freeValue;
            long[] tab = UpdatableQHashParallelKVIntIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free) continue;
                action.accept(new MutableEntry(mc, i, key, (int)(entry >>> 32)));
            }
            if (mc != UpdatableQHashParallelKVIntIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(@Nonnull Predicate<? super Map.Entry<Integer, Integer>> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = UpdatableQHashParallelKVIntIntMapGO.this.modCount();
            int free = UpdatableQHashParallelKVIntIntMapGO.this.freeValue;
            long[] tab = UpdatableQHashParallelKVIntIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free || predicate.test(new MutableEntry(mc, i, key, (int)(entry >>> 32)))) continue;
                terminated = true;
                break;
            }
            if (mc != UpdatableQHashParallelKVIntIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Override
        @Nonnull
        public ObjIterator<Map.Entry<Integer, Integer>> iterator() {
            int mc = UpdatableQHashParallelKVIntIntMapGO.this.modCount();
            return new NoRemovedEntryIterator(mc);
        }

        @Nonnull
        public ObjCursor<Map.Entry<Integer, Integer>> cursor() {
            int mc = UpdatableQHashParallelKVIntIntMapGO.this.modCount();
            return new NoRemovedEntryCursor(mc);
        }

        @Override
        public final boolean containsAll(@Nonnull Collection<?> c) {
            return CommonObjCollectionOps.containsAll(this, c);
        }

        @Override
        public final boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            ReusableEntry e = new ReusableEntry();
            int mc = UpdatableQHashParallelKVIntIntMapGO.this.modCount();
            int free = UpdatableQHashParallelKVIntIntMapGO.this.freeValue;
            long[] tab = UpdatableQHashParallelKVIntIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free || c.contains((Object)e.with(key, (int)(entry >>> 32)))) continue;
                containsAll = false;
                break;
            }
            if (mc != UpdatableQHashParallelKVIntIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        @Override
        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = UpdatableQHashParallelKVIntIntMapGO.this.modCount();
            int free = UpdatableQHashParallelKVIntIntMapGO.this.freeValue;
            long[] tab = UpdatableQHashParallelKVIntIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free) continue;
                changed |= s.remove((Object)e.with(key, (int)(entry >>> 32)));
            }
            if (mc != UpdatableQHashParallelKVIntIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public final boolean reverseAddAllTo(ObjCollection<? super Map.Entry<Integer, Integer>> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = UpdatableQHashParallelKVIntIntMapGO.this.modCount();
            int free = UpdatableQHashParallelKVIntIntMapGO.this.freeValue;
            long[] tab = UpdatableQHashParallelKVIntIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free) continue;
                changed |= c.add((Object)new MutableEntry(mc, i, key, (int)(entry >>> 32)));
            }
            if (mc != UpdatableQHashParallelKVIntIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public int hashCode() {
            return UpdatableQHashParallelKVIntIntMapGO.this.hashCode();
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = UpdatableQHashParallelKVIntIntMapGO.this.modCount();
            int free = UpdatableQHashParallelKVIntIntMapGO.this.freeValue;
            long[] tab = UpdatableQHashParallelKVIntIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free) continue;
                sb.append(' ');
                sb.append(key);
                sb.append('=');
                sb.append((int)(entry >>> 32));
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            if (mc != UpdatableQHashParallelKVIntIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean shrink() {
            return UpdatableQHashParallelKVIntIntMapGO.this.shrink();
        }

        @Override
        public boolean remove(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                int key = (Integer)e.getKey();
                int value = (Integer)e.getValue();
                return UpdatableQHashParallelKVIntIntMapGO.this.remove(key, value);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        public final boolean removeIf(@Nonnull Predicate<? super Map.Entry<Integer, Integer>> filter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof InternalObjCollectionOps) {
                InternalObjCollectionOps c2 = (InternalObjCollectionOps)((Object)c);
                if (NullableObjects.equals(this.equivalence(), c2.equivalence()) && c2.size() < this.size()) {
                    c2.reverseRemoveAllFrom((ObjSet<?>)this);
                }
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            UpdatableQHashParallelKVIntIntMapGO.this.clear();
        }
    }
}

