/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import net.openhft.collect.impl.hash.HashConfigWrapper;
import net.openhft.collect.impl.hash.HashWithoutRemovedSlots;
import net.openhft.collect.impl.hash.QHash;
import net.openhft.collect.impl.hash.QHashCapacities;

public abstract class UpdatableQHash
extends HashWithoutRemovedSlots
implements QHash {
    private HashConfigWrapper configWrapper;
    private int size;
    private int maxSize;
    private int modCount = 0;

    @Override
    public final HashConfigWrapper configWrapper() {
        return this.configWrapper;
    }

    @Override
    public final int size() {
        return this.size;
    }

    @Override
    public final int modCount() {
        return this.modCount;
    }

    final void incrementModCount() {
        ++this.modCount;
    }

    final void copy(QHash hash) {
        this.configWrapper = hash.configWrapper();
        this.size = hash.size();
        int capacity = hash.capacity();
        this.maxSize = this.maxSize(capacity);
    }

    final void init(HashConfigWrapper configWrapper, int size) {
        this.configWrapper = configWrapper;
        this.size = 0;
        this.internalInit(this.targetCapacity(size));
    }

    private void internalInit(int capacity) {
        this.maxSize = this.maxSize(capacity);
        this.allocateArrays(capacity);
    }

    private int maxSize(int capacity) {
        return !this.isMaxCapacity(capacity) ? this.configWrapper.maxSize(capacity) : capacity - 1;
    }

    abstract void allocateArrays(int var1);

    abstract void rehash(int var1);

    final void initForRehash(int newCapacity) {
        ++this.modCount;
        this.internalInit(newCapacity);
    }

    public void clear() {
        ++this.modCount;
        this.size = 0;
    }

    public boolean shrink() {
        int newCapacity = this.targetCapacity(this.size);
        if (newCapacity < this.capacity()) {
            this.rehash(newCapacity);
            return true;
        }
        return false;
    }

    private boolean tryRehashForExpansion(int newCapacity) {
        if (newCapacity > this.capacity()) {
            this.rehash(newCapacity);
            return true;
        }
        return false;
    }

    public final boolean ensureCapacity(long minSize) {
        int intMinSize = (int)Math.min(minSize, Integer.MAX_VALUE);
        if (minSize < 0L) {
            throw new IllegalArgumentException("Min size should be positive, " + minSize + " given.");
        }
        return intMinSize > this.maxSize && this.tryRehashForExpansion(this.targetCapacity(intMinSize));
    }

    final void postInsertHook() {
        if (++this.size > this.maxSize) {
            this.tryRehashForExpansion(this.grownCapacity());
        }
    }

    boolean doubleSizedArrays() {
        return false;
    }

    private int targetCapacity(int size) {
        return QHashCapacities.capacity(this.configWrapper, size, this.doubleSizedArrays());
    }

    private boolean isMaxCapacity(int capacity) {
        return QHashCapacities.isMaxCapacity(capacity, this.doubleSizedArrays());
    }

    private int grownCapacity() {
        return QHashCapacities.nearestGreaterCapacity(this.configWrapper.grow(this.capacity()), this.size, this.doubleSizedArrays());
    }
}

