/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import java.util.Arrays;
import java.util.ConcurrentModificationException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.openhft.collect.impl.InternalLongObjMapOps;
import net.openhft.collect.impl.hash.LHash;
import net.openhft.collect.impl.hash.SeparateKVLongObjLHash;
import net.openhft.collect.impl.hash.UpdatableLHashSeparateKVLongKeyMap;
import net.openhft.collect.map.hash.HashLongObjMap;

public abstract class UpdatableLHashSeparateKVLongObjMapSO<V>
extends UpdatableLHashSeparateKVLongKeyMap
implements HashLongObjMap<V>,
InternalLongObjMapOps<V>,
SeparateKVLongObjLHash {
    V[] values;

    void copy(SeparateKVLongObjLHash hash) {
        super.copy(hash);
        this.values = (Object[])hash.valueArray().clone();
    }

    void move(SeparateKVLongObjLHash hash) {
        super.move(hash);
        this.values = hash.valueArray();
    }

    @Override
    @Nonnull
    public Object[] valueArray() {
        return this.values;
    }

    boolean nullableValueEquals(@Nullable V a, @Nullable V b) {
        return a == b || a != null && a.equals(b);
    }

    boolean valueEquals(@Nonnull V a, @Nullable V b) {
        return a.equals(b);
    }

    int nullableValueHashCode(@Nullable V value) {
        return value != null ? value.hashCode() : 0;
    }

    int valueHashCode(@Nonnull V value) {
        return value.hashCode();
    }

    int valueIndex(@Nullable Object value) {
        if (value == null) {
            return this.nullValueIndex();
        }
        if (this.isEmpty()) {
            return -1;
        }
        Object val = value;
        int index = -1;
        int mc = this.modCount();
        long free = this.freeValue;
        long[] keys = this.set;
        V[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            if (keys[i] == free || !this.valueEquals(val, vals[i])) continue;
            index = i;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return index;
    }

    private int nullValueIndex() {
        if (this.isEmpty()) {
            return -1;
        }
        int index = -1;
        int mc = this.modCount();
        long free = this.freeValue;
        long[] keys = this.set;
        V[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            if (keys[i] == free || vals[i] != null) continue;
            index = i;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return index;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.valueIndex(value) >= 0;
    }

    boolean removeValue(@Nullable Object value) {
        throw new UnsupportedOperationException();
    }

    int insert(long key, V value) {
        long free = this.freeValue;
        if (key == free) {
            free = this.changeFree();
        }
        long[] keys = this.set;
        int capacityMask = keys.length - 1;
        int index = LHash.SeparateKVLongKeyMixing.mix(key) & capacityMask;
        long cur = keys[index];
        if (cur == key) {
            return index;
        }
        if (cur != free) {
            do {
                if ((cur = keys[index = index - 1 & capacityMask]) != key) continue;
                return index;
            } while (cur != free);
        }
        this.incrementModCount();
        keys[index] = key;
        this.values[index] = value;
        this.postInsertHook();
        return -1;
    }

    @Override
    void allocateArrays(int capacity) {
        super.allocateArrays(capacity);
        this.values = new Object[capacity];
    }

    @Override
    public void clear() {
        super.clear();
        Arrays.fill(this.values, null);
    }
}

