/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import java.util.ConcurrentModificationException;
import javax.annotation.Nonnull;
import net.openhft.collect.impl.InternalIntLongMapOps;
import net.openhft.collect.impl.hash.LHash;
import net.openhft.collect.impl.hash.SeparateKVIntLongLHash;
import net.openhft.collect.impl.hash.UpdatableLHashSeparateKVIntKeyMap;
import net.openhft.collect.map.hash.HashIntLongMap;

public abstract class UpdatableLHashSeparateKVIntLongMapSO
extends UpdatableLHashSeparateKVIntKeyMap
implements HashIntLongMap,
InternalIntLongMapOps,
SeparateKVIntLongLHash {
    long[] values;

    void copy(SeparateKVIntLongLHash hash) {
        super.copy(hash);
        this.values = (long[])hash.valueArray().clone();
    }

    void move(SeparateKVIntLongLHash hash) {
        super.move(hash);
        this.values = hash.valueArray();
    }

    @Override
    @Nonnull
    public long[] valueArray() {
        return this.values;
    }

    int valueIndex(long value) {
        if (this.isEmpty()) {
            return -1;
        }
        int index = -1;
        int mc = this.modCount();
        int free = this.freeValue;
        int[] keys = this.set;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            if (keys[i] == free || value != vals[i]) continue;
            index = i;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return index;
    }

    public boolean containsValue(long value) {
        return this.valueIndex(value) >= 0;
    }

    boolean removeValue(long value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsValue(Object value) {
        return this.containsValue((Long)value);
    }

    int insert(int key, long value) {
        int free = this.freeValue;
        if (key == free) {
            free = this.changeFree();
        }
        int[] keys = this.set;
        int capacityMask = keys.length - 1;
        int index = LHash.SeparateKVIntKeyMixing.mix(key) & capacityMask;
        int cur = keys[index];
        if (cur == key) {
            return index;
        }
        if (cur != free) {
            do {
                if ((cur = keys[index = index - 1 & capacityMask]) != key) continue;
                return index;
            } while (cur != free);
        }
        this.incrementModCount();
        keys[index] = key;
        this.values[index] = value;
        this.postInsertHook();
        return -1;
    }

    @Override
    void allocateArrays(int capacity) {
        super.allocateArrays(capacity);
        this.values = new long[capacity];
    }
}

