/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import java.util.ConcurrentModificationException;
import javax.annotation.Nonnull;
import net.openhft.collect.impl.InternalDoubleCharMapOps;
import net.openhft.collect.impl.hash.LHash;
import net.openhft.collect.impl.hash.SeparateKVDoubleCharLHash;
import net.openhft.collect.impl.hash.UpdatableLHashSeparateKVDoubleKeyMap;
import net.openhft.collect.map.hash.HashDoubleCharMap;

public abstract class UpdatableLHashSeparateKVDoubleCharMapSO
extends UpdatableLHashSeparateKVDoubleKeyMap
implements HashDoubleCharMap,
InternalDoubleCharMapOps,
SeparateKVDoubleCharLHash {
    char[] values;

    void copy(SeparateKVDoubleCharLHash hash) {
        super.copy(hash);
        this.values = (char[])hash.valueArray().clone();
    }

    void move(SeparateKVDoubleCharLHash hash) {
        super.move(hash);
        this.values = hash.valueArray();
    }

    @Override
    @Nonnull
    public char[] valueArray() {
        return this.values;
    }

    int valueIndex(char value) {
        if (this.isEmpty()) {
            return -1;
        }
        int index = -1;
        int mc = this.modCount();
        long[] keys = this.set;
        char[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            if (keys[i] >= 0x7FFFFFFFFFFFFFFEL || value != vals[i]) continue;
            index = i;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return index;
    }

    public boolean containsValue(char value) {
        return this.valueIndex(value) >= 0;
    }

    boolean removeValue(char value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsValue(Object value) {
        return this.containsValue(((Character)value).charValue());
    }

    int insert(long key, char value) {
        long[] keys = this.set;
        int capacityMask = keys.length - 1;
        int index = LHash.SeparateKVDoubleKeyMixing.mix(key) & capacityMask;
        long cur = keys[index];
        if (cur == key) {
            return index;
        }
        if (cur != 0x7FFFFFFFFFFFFFFEL) {
            do {
                if ((cur = keys[index = index - 1 & capacityMask]) != key) continue;
                return index;
            } while (cur != 0x7FFFFFFFFFFFFFFEL);
        }
        this.incrementModCount();
        keys[index] = key;
        this.values[index] = value;
        this.postInsertHook();
        return -1;
    }

    @Override
    void allocateArrays(int capacity) {
        super.allocateArrays(capacity);
        this.values = new char[capacity];
    }
}

