/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.DoubleToLongFunction;
import java.util.function.Function;
import java.util.function.LongBinaryOperator;
import java.util.function.LongConsumer;
import java.util.function.LongPredicate;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.openhft.collect.Equivalence;
import net.openhft.collect.LongCollection;
import net.openhft.collect.LongCursor;
import net.openhft.collect.LongIterator;
import net.openhft.collect.ObjCollection;
import net.openhft.collect.ObjCursor;
import net.openhft.collect.ObjIterator;
import net.openhft.collect.hash.HashConfig;
import net.openhft.collect.impl.AbstractEntry;
import net.openhft.collect.impl.AbstractLongValueView;
import net.openhft.collect.impl.AbstractSetView;
import net.openhft.collect.impl.CommonDoubleLongMapOps;
import net.openhft.collect.impl.CommonMapOps;
import net.openhft.collect.impl.CommonObjCollectionOps;
import net.openhft.collect.impl.InternalDoubleLongMapOps;
import net.openhft.collect.impl.InternalObjCollectionOps;
import net.openhft.collect.impl.NullableObjects;
import net.openhft.collect.impl.Primitives;
import net.openhft.collect.impl.hash.LHash;
import net.openhft.collect.impl.hash.ParallelKVDoubleLongLHash;
import net.openhft.collect.impl.hash.UpdatableLHashParallelKVDoubleLongMapSO;
import net.openhft.collect.map.DoubleLongCursor;
import net.openhft.collect.set.LongSet;
import net.openhft.collect.set.ObjSet;
import net.openhft.collect.set.hash.HashObjSet;
import net.openhft.function.DoubleLongConsumer;
import net.openhft.function.DoubleLongPredicate;
import net.openhft.function.DoubleLongToLongFunction;

public class UpdatableLHashParallelKVDoubleLongMapGO
extends UpdatableLHashParallelKVDoubleLongMapSO {
    final void copy(ParallelKVDoubleLongLHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.copy(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    final void move(ParallelKVDoubleLongLHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.move(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public long defaultValue() {
        return 0L;
    }

    @Override
    public boolean containsEntry(double key, long value) {
        long k = Double.doubleToLongBits(key);
        int index = this.index(k);
        if (index >= 0) {
            return this.table[index + 1] == value;
        }
        return false;
    }

    @Override
    public boolean containsEntry(long key, long value) {
        int index = this.index(key);
        if (index >= 0) {
            return this.table[index + 1] == value;
        }
        return false;
    }

    @Override
    public Long get(Object key) {
        long k = Double.doubleToLongBits((Double)key);
        int index = this.index(k);
        if (index >= 0) {
            return this.table[index + 1];
        }
        return null;
    }

    public long get(double key) {
        long k = Double.doubleToLongBits(key);
        int index = this.index(k);
        if (index >= 0) {
            return this.table[index + 1];
        }
        return this.defaultValue();
    }

    @Override
    public Long getOrDefault(Object key, Long defaultValue) {
        long k = Double.doubleToLongBits((Double)key);
        int index = this.index(k);
        if (index >= 0) {
            return this.table[index + 1];
        }
        return defaultValue;
    }

    public long getOrDefault(double key, long defaultValue) {
        long k = Double.doubleToLongBits(key);
        int index = this.index(k);
        if (index >= 0) {
            return this.table[index + 1];
        }
        return defaultValue;
    }

    @Override
    public void forEach(BiConsumer<? super Double, ? super Long> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
            action.accept((Double)Double.longBitsToDouble(key), (Long)tab[i + 1]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void forEach(DoubleLongConsumer action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
            action.accept(Double.longBitsToDouble(key), tab[i + 1]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public boolean forEachWhile(DoubleLongPredicate predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        int mc = this.modCount();
        long[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL || predicate.test(Double.longBitsToDouble(key), tab[i + 1])) continue;
            terminated = true;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return !terminated;
    }

    @Nonnull
    public DoubleLongCursor cursor() {
        int mc = this.modCount();
        return new NoRemovedMapCursor(mc);
    }

    @Override
    public boolean containsAllEntries(Map<?, ?> m) {
        return CommonDoubleLongMapOps.containsAllEntries(this, m);
    }

    @Override
    public boolean allEntriesContainingIn(InternalDoubleLongMapOps m) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        int mc = this.modCount();
        long[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL || m.containsEntry(key, tab[i + 1])) continue;
            containsAll = false;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return containsAll;
    }

    @Override
    public void reversePutAllTo(InternalDoubleLongMapOps m) {
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
            m.justPut(key, tab[i + 1]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    @Nonnull
    public HashObjSet<Map.Entry<Double, Long>> entrySet() {
        return new EntryView();
    }

    @Nonnull
    public LongCollection values() {
        return new ValueView();
    }

    @Override
    public boolean equals(Object o) {
        return CommonMapOps.equals(this, o);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        int mc = this.modCount();
        long[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
            long val = tab[i + 1];
            hashCode += (int)(key ^ key >>> 32) ^ (int)(val ^ val >>> 32);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return hashCode;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        int mc = this.modCount();
        long[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
            sb.append(' ');
            sb.append(Double.longBitsToDouble(key));
            sb.append('=');
            sb.append(tab[i + 1]);
            sb.append(',');
            if (++elementCount != 8) continue;
            int expectedLength = sb.length() * (this.size() / 8);
            sb.ensureCapacity(expectedLength + expectedLength / 2);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        sb.setCharAt(0, '{');
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    @Override
    void rehash(int newCapacity) {
        int mc = this.modCount();
        long[] tab = this.table;
        this.initForRehash(newCapacity);
        ++mc;
        long[] newTab = this.table;
        int capacityMask = newTab.length - 2;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
            int index = LHash.ParallelKVDoubleKeyMixing.mix(key) & capacityMask;
            if (newTab[index] != 0x7FFFFFFFFFFFFFFEL) {
                while (newTab[index = index - 2 & capacityMask] == 0x7FFFFFFFFFFFFFFEL) {
                }
            }
            newTab[index] = key;
            newTab[index + 1] = tab[i + 1];
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public Long put(Double key, Long value) {
        long k = Double.doubleToLongBits(key);
        int index = this.insert(k, value);
        if (index < 0) {
            return null;
        }
        long[] tab = this.table;
        long prevValue = tab[index + 1];
        tab[index + 1] = value;
        return prevValue;
    }

    @Override
    public long put(double key, long value) {
        long k = Double.doubleToLongBits(key);
        int index = this.insert(k, value);
        if (index < 0) {
            return this.defaultValue();
        }
        long[] tab = this.table;
        long prevValue = tab[index + 1];
        tab[index + 1] = value;
        return prevValue;
    }

    @Override
    public Long putIfAbsent(Double key, Long value) {
        long k = Double.doubleToLongBits(key);
        int index = this.insert(k, value);
        if (index < 0) {
            return null;
        }
        return this.table[index + 1];
    }

    @Override
    public long putIfAbsent(double key, long value) {
        long k = Double.doubleToLongBits(key);
        int index = this.insert(k, value);
        if (index < 0) {
            return this.defaultValue();
        }
        return this.table[index + 1];
    }

    @Override
    public void justPut(double key, long value) {
        long k = Double.doubleToLongBits(key);
        int index = this.insert(k, value);
        if (index < 0) {
            return;
        }
        this.table[index + 1] = value;
    }

    @Override
    public void justPut(long key, long value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return;
        }
        this.table[index + 1] = value;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Long compute(Double key, BiFunction<? super Double, ? super Long, ? extends Long> remappingFunction) {
        block4: {
            k = Double.doubleToLongBits(key);
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            tab = this.table;
            capacityMask = tab.length - 2;
            index = LHash.ParallelKVDoubleKeyMixing.mix(k) & capacityMask;
            cur = tab[index];
            if (cur == k) break block4;
            if (cur == 0x7FFFFFFFFFFFFFFEL) ** GOTO lbl12
            while ((cur = tab[index = index - 2 & capacityMask]) != k) {
                if (cur != 0x7FFFFFFFFFFFFFFEL) continue;
lbl12:
                // 2 sources

                if ((newValue = remappingFunction.apply((Double)Double.longBitsToDouble(k), null)) != null) {
                    this.incrementModCount();
                    tab[index] = k;
                    tab[index + 1] = newValue;
                    this.postInsertHook();
                    return newValue;
                }
                return null;
            }
        }
        if ((newValue = remappingFunction.apply((Double)Double.longBitsToDouble(k), (Long)tab[index + 1])) != null) {
            tab[index + 1] = newValue;
            return newValue;
        }
        throw new UnsupportedOperationException("Compute operation of updatable map doesn't support removals");
    }

    /*
     * Unable to fully structure code
     */
    public long compute(double key, DoubleLongToLongFunction remappingFunction) {
        block2: {
            k = Double.doubleToLongBits(key);
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            tab = this.table;
            capacityMask = tab.length - 2;
            index = LHash.ParallelKVDoubleKeyMixing.mix(k) & capacityMask;
            cur = tab[index];
            if (cur == k) break block2;
            if (cur == 0x7FFFFFFFFFFFFFFEL) ** GOTO lbl12
            while ((cur = tab[index = index - 2 & capacityMask]) != k) {
                if (cur != 0x7FFFFFFFFFFFFFFEL) continue;
lbl12:
                // 2 sources

                newValue = remappingFunction.applyAsLong(Double.longBitsToDouble(k), this.defaultValue());
                this.incrementModCount();
                tab[index] = k;
                tab[index + 1] = newValue;
                this.postInsertHook();
                return newValue;
            }
        }
        tab[index + 1] = newValue = remappingFunction.applyAsLong(Double.longBitsToDouble(k), tab[index + 1]);
        return newValue;
    }

    @Override
    public Long computeIfAbsent(Double key, Function<? super Double, ? extends Long> mappingFunction) {
        Long value;
        long k = Double.doubleToLongBits(key);
        if (mappingFunction == null) {
            throw new NullPointerException();
        }
        long[] tab = this.table;
        int capacityMask = tab.length - 2;
        int index = LHash.ParallelKVDoubleKeyMixing.mix(k) & capacityMask;
        long cur = tab[index];
        if (cur != 0x7FFFFFFFFFFFFFFEL) {
            if (cur == k) {
                return tab[index + 1];
            }
            while ((cur = tab[index = index - 2 & capacityMask]) != 0x7FFFFFFFFFFFFFFEL) {
                if (cur != k) continue;
                return tab[index + 1];
            }
        }
        if ((value = mappingFunction.apply((Double)Double.longBitsToDouble(k))) != null) {
            this.incrementModCount();
            tab[index] = k;
            tab[index + 1] = value;
            this.postInsertHook();
            return value;
        }
        return null;
    }

    public long computeIfAbsent(double key, DoubleToLongFunction mappingFunction) {
        long k = Double.doubleToLongBits(key);
        if (mappingFunction == null) {
            throw new NullPointerException();
        }
        long[] tab = this.table;
        int capacityMask = tab.length - 2;
        int index = LHash.ParallelKVDoubleKeyMixing.mix(k) & capacityMask;
        long cur = tab[index];
        if (cur != 0x7FFFFFFFFFFFFFFEL) {
            if (cur == k) {
                return tab[index + 1];
            }
            while ((cur = tab[index = index - 2 & capacityMask]) != 0x7FFFFFFFFFFFFFFEL) {
                if (cur != k) continue;
                return tab[index + 1];
            }
        }
        long value = mappingFunction.applyAsLong(Double.longBitsToDouble(k));
        this.incrementModCount();
        tab[index] = k;
        tab[index + 1] = value;
        this.postInsertHook();
        return value;
    }

    @Override
    public Long computeIfPresent(Double key, BiFunction<? super Double, ? super Long, ? extends Long> remappingFunction) {
        long k = Double.doubleToLongBits(key);
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        int index = this.index(k);
        if (index >= 0) {
            long[] tab = this.table;
            Long newValue = remappingFunction.apply((Double)Double.longBitsToDouble(k), (Long)tab[index + 1]);
            if (newValue != null) {
                tab[index + 1] = newValue;
                return newValue;
            }
            throw new UnsupportedOperationException("ComputeIfPresent operation of updatable map doesn't support removals");
        }
        return null;
    }

    public long computeIfPresent(double key, DoubleLongToLongFunction remappingFunction) {
        long k = Double.doubleToLongBits(key);
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        int index = this.index(k);
        if (index >= 0) {
            long newValue;
            long[] tab = this.table;
            tab[index + 1] = newValue = remappingFunction.applyAsLong(Double.longBitsToDouble(k), tab[index + 1]);
            return newValue;
        }
        return this.defaultValue();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Long merge(Double key, Long value, BiFunction<? super Long, ? super Long, ? extends Long> remappingFunction) {
        block4: {
            k = Double.doubleToLongBits(key);
            if (value == null) {
                throw new NullPointerException();
            }
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            tab = this.table;
            capacityMask = tab.length - 2;
            index = LHash.ParallelKVDoubleKeyMixing.mix(k) & capacityMask;
            cur = tab[index];
            if (cur == k) break block4;
            if (cur == 0x7FFFFFFFFFFFFFFEL) ** GOTO lbl14
            while ((cur = tab[index = index - 2 & capacityMask]) != k) {
                if (cur != 0x7FFFFFFFFFFFFFFEL) continue;
lbl14:
                // 2 sources

                this.incrementModCount();
                tab[index] = k;
                tab[index + 1] = value;
                this.postInsertHook();
                return value;
            }
        }
        if ((newValue = remappingFunction.apply((Long)tab[index + 1], value)) != null) {
            tab[index + 1] = newValue;
            return newValue;
        }
        throw new UnsupportedOperationException("Merge operation of updatable map doesn't support removals");
    }

    /*
     * Unable to fully structure code
     */
    public long merge(double key, long value, LongBinaryOperator remappingFunction) {
        block2: {
            k = Double.doubleToLongBits(key);
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            tab = this.table;
            capacityMask = tab.length - 2;
            index = LHash.ParallelKVDoubleKeyMixing.mix(k) & capacityMask;
            cur = tab[index];
            if (cur == k) break block2;
            if (cur == 0x7FFFFFFFFFFFFFFEL) ** GOTO lbl12
            while ((cur = tab[index = index - 2 & capacityMask]) != k) {
                if (cur != 0x7FFFFFFFFFFFFFFEL) continue;
lbl12:
                // 2 sources

                this.incrementModCount();
                tab[index] = k;
                tab[index + 1] = value;
                this.postInsertHook();
                return value;
            }
        }
        tab[index + 1] = newValue = remappingFunction.applyAsLong(tab[index + 1], value);
        return newValue;
    }

    public long addValue(double key, long value) {
        long newValue;
        long k = Double.doubleToLongBits(key);
        int index = this.insert(k, value);
        if (index < 0) {
            return value;
        }
        long[] tab = this.table;
        tab[index + 1] = newValue = tab[index + 1] + value;
        return newValue;
    }

    public long addValue(double key, long addition, long defaultValue) {
        long newValue;
        long value;
        long k = Double.doubleToLongBits(key);
        int index = this.insert(k, value = defaultValue + addition);
        if (index < 0) {
            return value;
        }
        long[] tab = this.table;
        tab[index + 1] = newValue = tab[index + 1] + addition;
        return newValue;
    }

    @Override
    public void putAll(@Nonnull Map<? extends Double, ? extends Long> m) {
        CommonDoubleLongMapOps.putAll(this, m);
    }

    @Override
    public Long replace(Double key, Long value) {
        long k = Double.doubleToLongBits(key);
        int index = this.index(k);
        if (index >= 0) {
            long[] tab = this.table;
            long oldValue = tab[index + 1];
            tab[index + 1] = value;
            return oldValue;
        }
        return null;
    }

    @Override
    public long replace(double key, long value) {
        long k = Double.doubleToLongBits(key);
        int index = this.index(k);
        if (index >= 0) {
            long[] tab = this.table;
            long oldValue = tab[index + 1];
            tab[index + 1] = value;
            return oldValue;
        }
        return this.defaultValue();
    }

    @Override
    public boolean replace(Double key, Long oldValue, Long newValue) {
        return this.replace((double)key, (long)oldValue, (long)newValue);
    }

    @Override
    public boolean replace(double key, long oldValue, long newValue) {
        long k = Double.doubleToLongBits(key);
        int index = this.index(k);
        if (index >= 0) {
            long[] tab = this.table;
            if (tab[index + 1] == oldValue) {
                tab[index + 1] = newValue;
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public void replaceAll(BiFunction<? super Double, ? super Long, ? extends Long> function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
            tab[i + 1] = function.apply((Double)Double.longBitsToDouble(key), (Long)tab[i + 1]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void replaceAll(DoubleLongToLongFunction function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
            tab[i + 1] = function.applyAsLong(Double.longBitsToDouble(key), tab[i + 1]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public void clear() {
        int mc = this.modCount() + 1;
        super.clear();
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public Long remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean justRemove(double key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean justRemove(long key) {
        throw new UnsupportedOperationException();
    }

    public long remove(double key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.remove((Double)key, (Long)value);
    }

    public boolean remove(double key, long value) {
        throw new UnsupportedOperationException();
    }

    public boolean removeIf(DoubleLongPredicate filter) {
        throw new UnsupportedOperationException();
    }

    class NoRemovedMapCursor
    implements DoubleLongCursor {
        final long[] tab;
        int expectedModCount;
        int index;
        long curKey;
        long curValue;

        NoRemovedMapCursor(int mc) {
            this.expectedModCount = mc;
            this.tab = UpdatableLHashParallelKVDoubleLongMapGO.this.table;
            this.index = this.tab.length;
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
        }

        public void forEachForward(DoubleLongConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            int index = this.index;
            for (int i = index - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept(Double.longBitsToDouble(key), tab[i + 1]);
            }
            if (index != this.index || mc != UpdatableLHashParallelKVDoubleLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
        }

        public double key() {
            long curKey = this.curKey;
            if (curKey != 0x7FFFFFFFFFFFFFFEL) {
                return Double.longBitsToDouble(curKey);
            }
            throw new IllegalStateException();
        }

        public long value() {
            if (this.curKey != 0x7FFFFFFFFFFFFFFEL) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public void setValue(long value) {
            if (this.curKey != 0x7FFFFFFFFFFFFFFEL) {
                if (this.expectedModCount != UpdatableLHashParallelKVDoubleLongMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.tab[this.index + 1] = value;
        }

        public boolean moveNext() {
            if (this.expectedModCount == UpdatableLHashParallelKVDoubleLongMapGO.this.modCount()) {
                long[] tab = this.tab;
                for (int i = this.index - 2; i >= 0; i -= 2) {
                    long key = tab[i];
                    if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = tab[i + 1];
                    return true;
                }
                this.curKey = 0x7FFFFFFFFFFFFFFEL;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueCursor
    implements LongCursor {
        final long[] tab;
        int expectedModCount;
        int index;
        long curKey;
        long curValue;

        NoRemovedValueCursor(int mc) {
            this.expectedModCount = mc;
            this.tab = UpdatableLHashParallelKVDoubleLongMapGO.this.table;
            this.index = this.tab.length;
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
        }

        public void forEachForward(LongConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            int index = this.index;
            for (int i = index - 2; i >= 0; i -= 2) {
                if (tab[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept(tab[i + 1]);
            }
            if (index != this.index || mc != UpdatableLHashParallelKVDoubleLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
        }

        public long elem() {
            if (this.curKey != 0x7FFFFFFFFFFFFFFEL) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == UpdatableLHashParallelKVDoubleLongMapGO.this.modCount()) {
                long[] tab = this.tab;
                for (int i = this.index - 2; i >= 0; i -= 2) {
                    long key = tab[i];
                    if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = tab[i + 1];
                    return true;
                }
                this.curKey = 0x7FFFFFFFFFFFFFFEL;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueIterator
    implements LongIterator {
        final long[] tab;
        int expectedModCount;
        int nextIndex;
        long next;

        NoRemovedValueIterator(int mc) {
            this.expectedModCount = mc;
            this.tab = UpdatableLHashParallelKVDoubleLongMapGO.this.table;
            long[] tab = UpdatableLHashParallelKVDoubleLongMapGO.this.table;
            int nextI = tab.length;
            while ((nextI -= 2) >= 0) {
                if (tab[nextI] >= 0x7FFFFFFFFFFFFFFEL) continue;
                this.next = tab[nextI + 1];
                break;
            }
            this.nextIndex = nextI;
        }

        public long nextLong() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                if (this.expectedModCount == UpdatableLHashParallelKVDoubleLongMapGO.this.modCount()) {
                    long[] tab = this.tab;
                    long prev = this.next;
                    while ((nextI -= 2) >= 0) {
                        if (tab[nextI] >= 0x7FFFFFFFFFFFFFFEL) continue;
                        this.next = tab[nextI + 1];
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void forEachRemaining(Consumer<? super Long> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            for (int i = nextI = this.nextIndex; i >= 0; i -= 2) {
                if (tab[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept((Long)tab[i + 1]);
            }
            if (nextI != this.nextIndex || mc != UpdatableLHashParallelKVDoubleLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public void forEachRemaining(LongConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            for (int i = nextI = this.nextIndex; i >= 0; i -= 2) {
                if (tab[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept(tab[i + 1]);
            }
            if (nextI != this.nextIndex || mc != UpdatableLHashParallelKVDoubleLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Long next() {
            return this.nextLong();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryCursor
    implements ObjCursor<Map.Entry<Double, Long>> {
        final long[] tab;
        int expectedModCount;
        int index;
        long curKey;
        long curValue;

        NoRemovedEntryCursor(int mc) {
            this.expectedModCount = mc;
            this.tab = UpdatableLHashParallelKVDoubleLongMapGO.this.table;
            this.index = this.tab.length;
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
        }

        public void forEachForward(Consumer<? super Map.Entry<Double, Long>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            int index = this.index;
            for (int i = index - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept(new MutableEntry(mc, i, key, tab[i + 1]));
            }
            if (index != this.index || mc != UpdatableLHashParallelKVDoubleLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
        }

        public Map.Entry<Double, Long> elem() {
            long curKey = this.curKey;
            if (curKey != 0x7FFFFFFFFFFFFFFEL) {
                return new MutableEntry(this.expectedModCount, this.index, curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == UpdatableLHashParallelKVDoubleLongMapGO.this.modCount()) {
                long[] tab = this.tab;
                for (int i = this.index - 2; i >= 0; i -= 2) {
                    long key = tab[i];
                    if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = tab[i + 1];
                    return true;
                }
                this.curKey = 0x7FFFFFFFFFFFFFFEL;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryIterator
    implements ObjIterator<Map.Entry<Double, Long>> {
        final long[] tab;
        int expectedModCount;
        int nextIndex;
        MutableEntry next;

        NoRemovedEntryIterator(int mc) {
            this.expectedModCount = mc;
            this.tab = UpdatableLHashParallelKVDoubleLongMapGO.this.table;
            long[] tab = UpdatableLHashParallelKVDoubleLongMapGO.this.table;
            int nextI = tab.length;
            while ((nextI -= 2) >= 0) {
                long key = tab[nextI];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                this.next = new MutableEntry(mc, nextI, key, tab[nextI + 1]);
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<Double, Long>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            for (int i = nextI = this.nextIndex; i >= 0; i -= 2) {
                long key = tab[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept(new MutableEntry(mc, i, key, tab[i + 1]));
            }
            if (nextI != this.nextIndex || mc != UpdatableLHashParallelKVDoubleLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<Double, Long> next() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                int mc = this.expectedModCount;
                if (mc == UpdatableLHashParallelKVDoubleLongMapGO.this.modCount()) {
                    long[] tab = this.tab;
                    MutableEntry prev = this.next;
                    while ((nextI -= 2) >= 0) {
                        long key = tab[nextI];
                        if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                        this.next = new MutableEntry(mc, nextI, key, tab[nextI + 1]);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class ValueView
    extends AbstractLongValueView {
        ValueView() {
        }

        @Override
        public int size() {
            return UpdatableLHashParallelKVDoubleLongMapGO.this.size();
        }

        public boolean shrink() {
            return UpdatableLHashParallelKVDoubleLongMapGO.this.shrink();
        }

        @Override
        public boolean contains(Object o) {
            return UpdatableLHashParallelKVDoubleLongMapGO.this.containsValue(o);
        }

        public boolean contains(long v) {
            return UpdatableLHashParallelKVDoubleLongMapGO.this.containsValue(v);
        }

        @Override
        public void forEach(Consumer<? super Long> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = UpdatableLHashParallelKVDoubleLongMapGO.this.modCount();
            long[] tab = UpdatableLHashParallelKVDoubleLongMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept((Long)tab[i + 1]);
            }
            if (mc != UpdatableLHashParallelKVDoubleLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public void forEach(LongConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = UpdatableLHashParallelKVDoubleLongMapGO.this.modCount();
            long[] tab = UpdatableLHashParallelKVDoubleLongMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept(tab[i + 1]);
            }
            if (mc != UpdatableLHashParallelKVDoubleLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(LongPredicate predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = UpdatableLHashParallelKVDoubleLongMapGO.this.modCount();
            long[] tab = UpdatableLHashParallelKVDoubleLongMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] >= 0x7FFFFFFFFFFFFFFEL || predicate.test(tab[i + 1])) continue;
                terminated = true;
                break;
            }
            if (mc != UpdatableLHashParallelKVDoubleLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Override
        public boolean allContainingIn(LongCollection c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            int mc = UpdatableLHashParallelKVDoubleLongMapGO.this.modCount();
            long[] tab = UpdatableLHashParallelKVDoubleLongMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] >= 0x7FFFFFFFFFFFFFFEL || c.contains(tab[i + 1])) continue;
                containsAll = false;
                break;
            }
            if (mc != UpdatableLHashParallelKVDoubleLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        @Override
        public boolean reverseAddAllTo(LongCollection c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = UpdatableLHashParallelKVDoubleLongMapGO.this.modCount();
            long[] tab = UpdatableLHashParallelKVDoubleLongMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                changed |= c.add(tab[i + 1]);
            }
            if (mc != UpdatableLHashParallelKVDoubleLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public boolean reverseRemoveAllFrom(LongSet s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = UpdatableLHashParallelKVDoubleLongMapGO.this.modCount();
            long[] tab = UpdatableLHashParallelKVDoubleLongMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                changed |= s.removeLong(tab[i + 1]);
            }
            if (mc != UpdatableLHashParallelKVDoubleLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Nonnull
        public LongIterator iterator() {
            int mc = UpdatableLHashParallelKVDoubleLongMapGO.this.modCount();
            return new NoRemovedValueIterator(mc);
        }

        @Nonnull
        public LongCursor cursor() {
            int mc = UpdatableLHashParallelKVDoubleLongMapGO.this.modCount();
            return new NoRemovedValueCursor(mc);
        }

        @Override
        @Nonnull
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = UpdatableLHashParallelKVDoubleLongMapGO.this.modCount();
            long[] tab = UpdatableLHashParallelKVDoubleLongMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                result[resultIndex++] = tab[i + 1];
            }
            if (mc != UpdatableLHashParallelKVDoubleLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Override
        @Nonnull
        public <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = UpdatableLHashParallelKVDoubleLongMapGO.this.modCount();
            long[] tab = UpdatableLHashParallelKVDoubleLongMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                a[resultIndex++] = tab[i + 1];
            }
            if (mc != UpdatableLHashParallelKVDoubleLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public long[] toLongArray() {
            int size = this.size();
            long[] result = new long[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = UpdatableLHashParallelKVDoubleLongMapGO.this.modCount();
            long[] tab = UpdatableLHashParallelKVDoubleLongMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                result[resultIndex++] = tab[i + 1];
            }
            if (mc != UpdatableLHashParallelKVDoubleLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        public long[] toArray(long[] a) {
            int size = this.size();
            if (a.length < size) {
                a = new long[size];
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = 0L;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = UpdatableLHashParallelKVDoubleLongMapGO.this.modCount();
            long[] tab = UpdatableLHashParallelKVDoubleLongMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                a[resultIndex++] = tab[i + 1];
            }
            if (mc != UpdatableLHashParallelKVDoubleLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = 0L;
            }
            return a;
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = UpdatableLHashParallelKVDoubleLongMapGO.this.modCount();
            long[] tab = UpdatableLHashParallelKVDoubleLongMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                sb.append(' ').append(tab[i + 1]).append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            if (mc != UpdatableLHashParallelKVDoubleLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        @Override
        public boolean remove(Object o) {
            return this.removeLong((Long)o);
        }

        public boolean removeLong(long v) {
            return UpdatableLHashParallelKVDoubleLongMapGO.this.removeValue(v);
        }

        @Override
        public void clear() {
            UpdatableLHashParallelKVDoubleLongMapGO.this.clear();
        }

        @Override
        public boolean removeIf(Predicate<? super Long> filter) {
            throw new UnsupportedOperationException();
        }

        public boolean removeIf(LongPredicate filter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }
    }

    class ReusableEntry
    extends DoubleLongEntry {
        private long key;
        private long value;

        ReusableEntry() {
        }

        ReusableEntry with(long key, long value) {
            this.key = key;
            this.value = value;
            return this;
        }

        @Override
        public long key() {
            return this.key;
        }

        @Override
        public long value() {
            return this.value;
        }
    }

    class MutableEntry
    extends DoubleLongEntry {
        int modCount;
        private final int index;
        final long key;
        private long value;

        MutableEntry(int modCount, int index, long key, long value) {
            this.modCount = modCount;
            this.index = index;
            this.key = key;
            this.value = value;
        }

        @Override
        public long key() {
            return this.key;
        }

        @Override
        public long value() {
            return this.value;
        }

        @Override
        public Long setValue(Long newValue) {
            long unwrappedNewValue;
            if (this.modCount != UpdatableLHashParallelKVDoubleLongMapGO.this.modCount()) {
                throw new IllegalStateException();
            }
            long oldValue = this.value;
            this.value = unwrappedNewValue = newValue.longValue();
            this.updateValueInTable(unwrappedNewValue);
            return oldValue;
        }

        void updateValueInTable(long newValue) {
            UpdatableLHashParallelKVDoubleLongMapGO.this.table[this.index + 1] = newValue;
        }
    }

    abstract class DoubleLongEntry
    extends AbstractEntry<Double, Long> {
        DoubleLongEntry() {
        }

        abstract long key();

        @Override
        public final Double getKey() {
            return Double.longBitsToDouble(this.key());
        }

        abstract long value();

        @Override
        public final Long getValue() {
            return this.value();
        }

        @Override
        public boolean equals(Object o) {
            try {
                Map.Entry e2 = (Map.Entry)o;
                long k2 = Double.doubleToLongBits((Double)e2.getKey());
                long v2 = (Long)e2.getValue();
                return this.key() == k2 && this.value() == v2;
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        @Override
        public int hashCode() {
            return Primitives.hashCode(this.key()) ^ Primitives.hashCode(this.value());
        }
    }

    class EntryView
    extends AbstractSetView<Map.Entry<Double, Long>>
    implements HashObjSet<Map.Entry<Double, Long>>,
    InternalObjCollectionOps<Map.Entry<Double, Long>> {
        EntryView() {
        }

        @Nullable
        public Equivalence<Map.Entry<Double, Long>> equivalence() {
            return Equivalence.entryEquivalence(null, null);
        }

        @Nonnull
        public HashConfig hashConfig() {
            return UpdatableLHashParallelKVDoubleLongMapGO.this.hashConfig();
        }

        @Override
        public int size() {
            return UpdatableLHashParallelKVDoubleLongMapGO.this.size();
        }

        public double currentLoad() {
            return UpdatableLHashParallelKVDoubleLongMapGO.this.currentLoad();
        }

        @Override
        public boolean contains(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                return UpdatableLHashParallelKVDoubleLongMapGO.this.containsEntry((Double)e.getKey(), (long)((Long)e.getValue()));
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        @Nonnull
        public final Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = UpdatableLHashParallelKVDoubleLongMapGO.this.modCount();
            long[] tab = UpdatableLHashParallelKVDoubleLongMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                result[resultIndex++] = new MutableEntry(mc, i, key, tab[i + 1]);
            }
            if (mc != UpdatableLHashParallelKVDoubleLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Override
        @Nonnull
        public final <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = UpdatableLHashParallelKVDoubleLongMapGO.this.modCount();
            long[] tab = UpdatableLHashParallelKVDoubleLongMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                a[resultIndex++] = new MutableEntry(mc, i, key, tab[i + 1]);
            }
            if (mc != UpdatableLHashParallelKVDoubleLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        @Override
        public final void forEach(@Nonnull Consumer<? super Map.Entry<Double, Long>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = UpdatableLHashParallelKVDoubleLongMapGO.this.modCount();
            long[] tab = UpdatableLHashParallelKVDoubleLongMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept(new MutableEntry(mc, i, key, tab[i + 1]));
            }
            if (mc != UpdatableLHashParallelKVDoubleLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(@Nonnull Predicate<? super Map.Entry<Double, Long>> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = UpdatableLHashParallelKVDoubleLongMapGO.this.modCount();
            long[] tab = UpdatableLHashParallelKVDoubleLongMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL || predicate.test(new MutableEntry(mc, i, key, tab[i + 1]))) continue;
                terminated = true;
                break;
            }
            if (mc != UpdatableLHashParallelKVDoubleLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Override
        @Nonnull
        public ObjIterator<Map.Entry<Double, Long>> iterator() {
            int mc = UpdatableLHashParallelKVDoubleLongMapGO.this.modCount();
            return new NoRemovedEntryIterator(mc);
        }

        @Nonnull
        public ObjCursor<Map.Entry<Double, Long>> cursor() {
            int mc = UpdatableLHashParallelKVDoubleLongMapGO.this.modCount();
            return new NoRemovedEntryCursor(mc);
        }

        @Override
        public final boolean containsAll(@Nonnull Collection<?> c) {
            return CommonObjCollectionOps.containsAll(this, c);
        }

        @Override
        public final boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            ReusableEntry e = new ReusableEntry();
            int mc = UpdatableLHashParallelKVDoubleLongMapGO.this.modCount();
            long[] tab = UpdatableLHashParallelKVDoubleLongMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL || c.contains((Object)e.with(key, tab[i + 1]))) continue;
                containsAll = false;
                break;
            }
            if (mc != UpdatableLHashParallelKVDoubleLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        @Override
        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = UpdatableLHashParallelKVDoubleLongMapGO.this.modCount();
            long[] tab = UpdatableLHashParallelKVDoubleLongMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                changed |= s.remove((Object)e.with(key, tab[i + 1]));
            }
            if (mc != UpdatableLHashParallelKVDoubleLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public final boolean reverseAddAllTo(ObjCollection<? super Map.Entry<Double, Long>> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = UpdatableLHashParallelKVDoubleLongMapGO.this.modCount();
            long[] tab = UpdatableLHashParallelKVDoubleLongMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                changed |= c.add((Object)new MutableEntry(mc, i, key, tab[i + 1]));
            }
            if (mc != UpdatableLHashParallelKVDoubleLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public int hashCode() {
            return UpdatableLHashParallelKVDoubleLongMapGO.this.hashCode();
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = UpdatableLHashParallelKVDoubleLongMapGO.this.modCount();
            long[] tab = UpdatableLHashParallelKVDoubleLongMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                sb.append(' ');
                sb.append(Double.longBitsToDouble(key));
                sb.append('=');
                sb.append(tab[i + 1]);
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            if (mc != UpdatableLHashParallelKVDoubleLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean shrink() {
            return UpdatableLHashParallelKVDoubleLongMapGO.this.shrink();
        }

        @Override
        public boolean remove(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                double key = (Double)e.getKey();
                long value = (Long)e.getValue();
                return UpdatableLHashParallelKVDoubleLongMapGO.this.remove(key, value);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        public final boolean removeIf(@Nonnull Predicate<? super Map.Entry<Double, Long>> filter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof InternalObjCollectionOps) {
                InternalObjCollectionOps c2 = (InternalObjCollectionOps)((Object)c);
                if (NullableObjects.equals(this.equivalence(), c2.equivalence()) && c2.size() < this.size()) {
                    c2.reverseRemoveAllFrom((ObjSet<?>)this);
                }
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            UpdatableLHashParallelKVDoubleLongMapGO.this.clear();
        }
    }
}

