/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import java.util.Collection;
import java.util.Set;
import net.openhft.collect.ShortCollection;
import net.openhft.collect.hash.HashConfig;
import net.openhft.collect.impl.hash.ImmutableQHashShortSet;
import net.openhft.collect.impl.hash.ImmutableQHashShortSetGO;
import net.openhft.collect.impl.hash.MutableQHashShortSet;
import net.openhft.collect.impl.hash.MutableQHashShortSetGO;
import net.openhft.collect.impl.hash.SeparateKVShortQHash;
import net.openhft.collect.impl.hash.ShortQHashFactory;
import net.openhft.collect.impl.hash.UpdatableQHashShortSet;
import net.openhft.collect.impl.hash.UpdatableQHashShortSetGO;
import net.openhft.collect.set.hash.HashShortSetFactory;

public abstract class QHashShortSetFactorySO
extends ShortQHashFactory<MutableQHashShortSetGO>
implements HashShortSetFactory {
    QHashShortSetFactorySO(HashConfig hashConf, int defaultExpectedSize, short lower, short upper) {
        super(hashConf, defaultExpectedSize, lower, upper);
    }

    @Override
    MutableQHashShortSetGO createNewMutable(int expectedSize, short free, short removed) {
        MutableQHashShortSet set = new MutableQHashShortSet();
        set.init(this.configWrapper, expectedSize, free, removed);
        return set;
    }

    MutableQHashShortSetGO uninitializedMutableSet() {
        return new MutableQHashShortSet();
    }

    UpdatableQHashShortSetGO uninitializedUpdatableSet() {
        return new UpdatableQHashShortSet();
    }

    ImmutableQHashShortSetGO uninitializedImmutableSet() {
        return new ImmutableQHashShortSet();
    }

    public MutableQHashShortSetGO newMutableSet(int expectedSize) {
        return (MutableQHashShortSetGO)this.newMutableHash(expectedSize);
    }

    public UpdatableQHashShortSetGO newUpdatableSet(int expectedSize) {
        UpdatableQHashShortSet set = new UpdatableQHashShortSet();
        set.init(this.configWrapper, expectedSize, this.getFree());
        return set;
    }

    public UpdatableQHashShortSetGO newUpdatableSet(Iterable<Short> elements, int expectedSize) {
        if (elements instanceof ShortCollection) {
            SeparateKVShortQHash hash;
            if (elements instanceof SeparateKVShortQHash && (hash = (SeparateKVShortQHash)((Object)elements)).hashConfig().equals(this.hashConf)) {
                UpdatableQHashShortSet set = new UpdatableQHashShortSet();
                set.copy(hash);
                return set;
            }
            int size = elements instanceof Set ? ((Set)elements).size() : expectedSize;
            UpdatableQHashShortSetGO set = this.newUpdatableSet(size);
            set.addAll((Collection)elements);
            return set;
        }
        int size = elements instanceof Set ? ((Set)elements).size() : expectedSize;
        UpdatableQHashShortSetGO set = this.newUpdatableSet(size);
        for (short e : elements) {
            set.add(e);
        }
        return set;
    }
}

