/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import net.openhft.collect.hash.HashConfig;
import net.openhft.collect.hash.HashContainerFactory;
import net.openhft.collect.hash.IntHashFactory;
import net.openhft.collect.impl.Containers;
import net.openhft.collect.impl.Primitives;
import net.openhft.collect.impl.hash.ImmutableQHashSeparateKVIntByteMapGO;
import net.openhft.collect.impl.hash.LHashCapacities;
import net.openhft.collect.impl.hash.MutableQHashSeparateKVIntByteMapGO;
import net.openhft.collect.impl.hash.QHashSeparateKVIntByteMapFactorySO;
import net.openhft.collect.impl.hash.SeparateKVIntByteQHash;
import net.openhft.collect.impl.hash.UpdatableQHashSeparateKVIntByteMapGO;
import net.openhft.collect.map.hash.HashIntByteMap;
import net.openhft.collect.map.hash.HashIntByteMapFactory;
import net.openhft.function.Consumer;
import net.openhft.function.IntByteConsumer;
import net.openhft.function.Predicate;

public abstract class QHashSeparateKVIntByteMapFactoryGO
extends QHashSeparateKVIntByteMapFactorySO {
    QHashSeparateKVIntByteMapFactoryGO(HashConfig hashConf, int defaultExpectedSize, int lower, int upper) {
        super(hashConf, defaultExpectedSize, lower, upper);
    }

    abstract HashIntByteMapFactory thisWith(HashConfig var1, int var2, int var3, int var4);

    abstract HashIntByteMapFactory lHashLikeThisWith(HashConfig var1, int var2, int var3, int var4);

    abstract HashIntByteMapFactory qHashLikeThisWith(HashConfig var1, int var2, int var3, int var4);

    public final HashIntByteMapFactory withHashConfig(@Nonnull HashConfig hashConf) {
        if (LHashCapacities.configIsSuitableForMutableLHash(hashConf)) {
            return this.lHashLikeThisWith(hashConf, this.getDefaultExpectedSize(), this.getLowerKeyDomainBound(), this.getUpperKeyDomainBound());
        }
        return this.qHashLikeThisWith(hashConf, this.getDefaultExpectedSize(), this.getLowerKeyDomainBound(), this.getUpperKeyDomainBound());
    }

    public final HashIntByteMapFactory withDefaultExpectedSize(int defaultExpectedSize) {
        if (defaultExpectedSize == this.getDefaultExpectedSize()) {
            return this;
        }
        return this.thisWith(this.getHashConfig(), defaultExpectedSize, this.getLowerKeyDomainBound(), this.getUpperKeyDomainBound());
    }

    final HashIntByteMapFactory withDomain(int lower, int upper) {
        if (lower == this.getLowerKeyDomainBound() && upper == this.getUpperKeyDomainBound()) {
            return this;
        }
        return this.thisWith(this.getHashConfig(), this.getDefaultExpectedSize(), lower, upper);
    }

    public final HashIntByteMapFactory withKeysDomain(int lower, int upper) {
        if (lower > upper) {
            throw new IllegalArgumentException("minPossibleKey shouldn't be greater than maxPossibleKey");
        }
        return this.withDomain(lower, upper);
    }

    public final HashIntByteMapFactory withKeysDomainComplement(int lower, int upper) {
        if (lower > upper) {
            throw new IllegalArgumentException("minImpossibleKey shouldn't be greater than maxImpossibleKey");
        }
        return this.withDomain(upper + 1, lower - 1);
    }

    public String toString() {
        return "HashIntByteMapFactory[" + this.commonString() + this.keySpecialString() + ",defaultValue=" + this.getDefaultValue() + "]";
    }

    public int hashCode() {
        int hashCode = this.keySpecialHashCode(this.commonHashCode());
        hashCode = hashCode * 31 + Primitives.hashCode(this.getDefaultValue());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof HashIntByteMapFactory) {
            HashIntByteMapFactory factory = (HashIntByteMapFactory)obj;
            return this.commonEquals((HashContainerFactory<?>)factory) && this.keySpecialEquals((IntHashFactory)factory) && Byte.valueOf(this.getDefaultValue()).equals(factory.getDefaultValue());
        }
        return false;
    }

    public byte getDefaultValue() {
        return 0;
    }

    private UpdatableQHashSeparateKVIntByteMapGO shrunk(UpdatableQHashSeparateKVIntByteMapGO map) {
        Predicate shrinkCondition = this.hashConf.getShrinkCondition();
        if (shrinkCondition != null && shrinkCondition.test(map)) {
            map.shrink();
        }
        return map;
    }

    public UpdatableQHashSeparateKVIntByteMapGO newUpdatableMap() {
        return this.newUpdatableMap(this.getDefaultExpectedSize());
    }

    public MutableQHashSeparateKVIntByteMapGO newMutableMap() {
        return this.newMutableMap(this.getDefaultExpectedSize());
    }

    @Override
    public UpdatableQHashSeparateKVIntByteMapGO newUpdatableMap(Map<Integer, Byte> map) {
        return this.shrunk((UpdatableQHashSeparateKVIntByteMapGO)super.newUpdatableMap((Map)map));
    }

    public UpdatableQHashSeparateKVIntByteMapGO newUpdatableMap(Map<Integer, Byte> map1, Map<Integer, Byte> map2) {
        long expectedSize = map1.size();
        return this.newUpdatableMap((Map)map1, (Map)map2, Containers.sizeAsInt(expectedSize += (long)map2.size()));
    }

    public UpdatableQHashSeparateKVIntByteMapGO newUpdatableMap(Map<Integer, Byte> map1, Map<Integer, Byte> map2, Map<Integer, Byte> map3) {
        long expectedSize = map1.size();
        expectedSize += (long)map2.size();
        return this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, Containers.sizeAsInt(expectedSize += (long)map3.size()));
    }

    public UpdatableQHashSeparateKVIntByteMapGO newUpdatableMap(Map<Integer, Byte> map1, Map<Integer, Byte> map2, Map<Integer, Byte> map3, Map<Integer, Byte> map4) {
        long expectedSize = map1.size();
        expectedSize += (long)map2.size();
        expectedSize += (long)map3.size();
        return this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4, Containers.sizeAsInt(expectedSize += (long)map4.size()));
    }

    public UpdatableQHashSeparateKVIntByteMapGO newUpdatableMap(Map<Integer, Byte> map1, Map<Integer, Byte> map2, Map<Integer, Byte> map3, Map<Integer, Byte> map4, Map<Integer, Byte> map5) {
        long expectedSize = map1.size();
        expectedSize += (long)map2.size();
        expectedSize += (long)map3.size();
        expectedSize += (long)map4.size();
        return this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4, (Map)map5, Containers.sizeAsInt(expectedSize += (long)map5.size()));
    }

    public UpdatableQHashSeparateKVIntByteMapGO newUpdatableMap(Map<Integer, Byte> map1, Map<Integer, Byte> map2, int expectedSize) {
        UpdatableQHashSeparateKVIntByteMapGO map = this.newUpdatableMap(expectedSize);
        map.putAll((Map<? extends Integer, ? extends Byte>)map1);
        map.putAll((Map<? extends Integer, ? extends Byte>)map2);
        return this.shrunk(map);
    }

    public UpdatableQHashSeparateKVIntByteMapGO newUpdatableMap(Map<Integer, Byte> map1, Map<Integer, Byte> map2, Map<Integer, Byte> map3, int expectedSize) {
        UpdatableQHashSeparateKVIntByteMapGO map = this.newUpdatableMap(expectedSize);
        map.putAll((Map<? extends Integer, ? extends Byte>)map1);
        map.putAll((Map<? extends Integer, ? extends Byte>)map2);
        map.putAll((Map<? extends Integer, ? extends Byte>)map3);
        return this.shrunk(map);
    }

    public UpdatableQHashSeparateKVIntByteMapGO newUpdatableMap(Map<Integer, Byte> map1, Map<Integer, Byte> map2, Map<Integer, Byte> map3, Map<Integer, Byte> map4, int expectedSize) {
        UpdatableQHashSeparateKVIntByteMapGO map = this.newUpdatableMap(expectedSize);
        map.putAll((Map<? extends Integer, ? extends Byte>)map1);
        map.putAll((Map<? extends Integer, ? extends Byte>)map2);
        map.putAll((Map<? extends Integer, ? extends Byte>)map3);
        map.putAll((Map<? extends Integer, ? extends Byte>)map4);
        return this.shrunk(map);
    }

    public UpdatableQHashSeparateKVIntByteMapGO newUpdatableMap(Map<Integer, Byte> map1, Map<Integer, Byte> map2, Map<Integer, Byte> map3, Map<Integer, Byte> map4, Map<Integer, Byte> map5, int expectedSize) {
        UpdatableQHashSeparateKVIntByteMapGO map = this.newUpdatableMap(expectedSize);
        map.putAll((Map<? extends Integer, ? extends Byte>)map1);
        map.putAll((Map<? extends Integer, ? extends Byte>)map2);
        map.putAll((Map<? extends Integer, ? extends Byte>)map3);
        map.putAll((Map<? extends Integer, ? extends Byte>)map4);
        map.putAll((Map<? extends Integer, ? extends Byte>)map5);
        return this.shrunk(map);
    }

    public UpdatableQHashSeparateKVIntByteMapGO newUpdatableMap(Consumer<IntByteConsumer> entriesSupplier) {
        return this.newUpdatableMap((Consumer)entriesSupplier, this.getDefaultExpectedSize());
    }

    public UpdatableQHashSeparateKVIntByteMapGO newUpdatableMap(Consumer<IntByteConsumer> entriesSupplier, int expectedSize) {
        final UpdatableQHashSeparateKVIntByteMapGO map = this.newUpdatableMap(expectedSize);
        entriesSupplier.accept((Object)new IntByteConsumer(){

            public void accept(int k, byte v) {
                map.put(k, v);
            }
        });
        return this.shrunk(map);
    }

    public UpdatableQHashSeparateKVIntByteMapGO newUpdatableMap(int[] keys, byte[] values) {
        return this.newUpdatableMap(keys, values, keys.length);
    }

    public UpdatableQHashSeparateKVIntByteMapGO newUpdatableMap(int[] keys, byte[] values, int expectedSize) {
        UpdatableQHashSeparateKVIntByteMapGO map = this.newUpdatableMap(expectedSize);
        int keysLen = keys.length;
        if (keysLen != values.length) {
            throw new IllegalArgumentException("keys and values arrays must have the same size");
        }
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return this.shrunk(map);
    }

    public UpdatableQHashSeparateKVIntByteMapGO newUpdatableMap(Integer[] keys, Byte[] values) {
        return this.newUpdatableMap(keys, values, keys.length);
    }

    public UpdatableQHashSeparateKVIntByteMapGO newUpdatableMap(Integer[] keys, Byte[] values, int expectedSize) {
        UpdatableQHashSeparateKVIntByteMapGO map = this.newUpdatableMap(expectedSize);
        int keysLen = keys.length;
        if (keysLen != values.length) {
            throw new IllegalArgumentException("keys and values arrays must have the same size");
        }
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return this.shrunk(map);
    }

    public UpdatableQHashSeparateKVIntByteMapGO newUpdatableMap(Iterable<Integer> keys, Iterable<Byte> values) {
        int expectedSize = keys instanceof Collection ? ((Collection)keys).size() : this.getDefaultExpectedSize();
        return this.newUpdatableMap((Iterable)keys, (Iterable)values, expectedSize);
    }

    public UpdatableQHashSeparateKVIntByteMapGO newUpdatableMap(Iterable<Integer> keys, Iterable<Byte> values, int expectedSize) {
        UpdatableQHashSeparateKVIntByteMapGO map = this.newUpdatableMap(expectedSize);
        Iterator<Integer> keysIt = keys.iterator();
        Iterator<Byte> valuesIt = values.iterator();
        try {
            while (keysIt.hasNext()) {
                map.put(keysIt.next(), valuesIt.next());
            }
            return this.shrunk(map);
        }
        catch (NoSuchElementException e) {
            throw new IllegalArgumentException("keys and values iterables must have the same size", e);
        }
    }

    public UpdatableQHashSeparateKVIntByteMapGO newUpdatableMapOf(int k1, byte v1) {
        UpdatableQHashSeparateKVIntByteMapGO map = this.newUpdatableMap(1);
        map.put(k1, v1);
        return map;
    }

    public UpdatableQHashSeparateKVIntByteMapGO newUpdatableMapOf(int k1, byte v1, int k2, byte v2) {
        UpdatableQHashSeparateKVIntByteMapGO map = this.newUpdatableMap(2);
        map.put(k1, v1);
        map.put(k2, v2);
        return map;
    }

    public UpdatableQHashSeparateKVIntByteMapGO newUpdatableMapOf(int k1, byte v1, int k2, byte v2, int k3, byte v3) {
        UpdatableQHashSeparateKVIntByteMapGO map = this.newUpdatableMap(3);
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        return map;
    }

    public UpdatableQHashSeparateKVIntByteMapGO newUpdatableMapOf(int k1, byte v1, int k2, byte v2, int k3, byte v3, int k4, byte v4) {
        UpdatableQHashSeparateKVIntByteMapGO map = this.newUpdatableMap(4);
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        return map;
    }

    public UpdatableQHashSeparateKVIntByteMapGO newUpdatableMapOf(int k1, byte v1, int k2, byte v2, int k3, byte v3, int k4, byte v4, int k5, byte v5) {
        UpdatableQHashSeparateKVIntByteMapGO map = this.newUpdatableMap(5);
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        return map;
    }

    public HashIntByteMap newMutableMap(Map<Integer, Byte> map1, Map<Integer, Byte> map2, int expectedSize) {
        MutableQHashSeparateKVIntByteMapGO res = this.uninitializedMutableMap();
        res.move((SeparateKVIntByteQHash)this.newUpdatableMap((Map)map1, (Map)map2, expectedSize));
        return res;
    }

    public HashIntByteMap newMutableMap(Map<Integer, Byte> map1, Map<Integer, Byte> map2, Map<Integer, Byte> map3, int expectedSize) {
        MutableQHashSeparateKVIntByteMapGO res = this.uninitializedMutableMap();
        res.move((SeparateKVIntByteQHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, expectedSize));
        return res;
    }

    public HashIntByteMap newMutableMap(Map<Integer, Byte> map1, Map<Integer, Byte> map2, Map<Integer, Byte> map3, Map<Integer, Byte> map4, int expectedSize) {
        MutableQHashSeparateKVIntByteMapGO res = this.uninitializedMutableMap();
        res.move((SeparateKVIntByteQHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4, expectedSize));
        return res;
    }

    public HashIntByteMap newMutableMap(Map<Integer, Byte> map1, Map<Integer, Byte> map2, Map<Integer, Byte> map3, Map<Integer, Byte> map4, Map<Integer, Byte> map5, int expectedSize) {
        MutableQHashSeparateKVIntByteMapGO res = this.uninitializedMutableMap();
        res.move((SeparateKVIntByteQHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4, (Map)map5, expectedSize));
        return res;
    }

    public HashIntByteMap newMutableMap(Map<Integer, Byte> map) {
        MutableQHashSeparateKVIntByteMapGO res = this.uninitializedMutableMap();
        res.move((SeparateKVIntByteQHash)this.newUpdatableMap((Map)map));
        return res;
    }

    public HashIntByteMap newMutableMap(Map<Integer, Byte> map1, Map<Integer, Byte> map2) {
        MutableQHashSeparateKVIntByteMapGO res = this.uninitializedMutableMap();
        res.move((SeparateKVIntByteQHash)this.newUpdatableMap((Map)map1, (Map)map2));
        return res;
    }

    public HashIntByteMap newMutableMap(Map<Integer, Byte> map1, Map<Integer, Byte> map2, Map<Integer, Byte> map3) {
        MutableQHashSeparateKVIntByteMapGO res = this.uninitializedMutableMap();
        res.move((SeparateKVIntByteQHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3));
        return res;
    }

    public HashIntByteMap newMutableMap(Map<Integer, Byte> map1, Map<Integer, Byte> map2, Map<Integer, Byte> map3, Map<Integer, Byte> map4) {
        MutableQHashSeparateKVIntByteMapGO res = this.uninitializedMutableMap();
        res.move((SeparateKVIntByteQHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4));
        return res;
    }

    public HashIntByteMap newMutableMap(Map<Integer, Byte> map1, Map<Integer, Byte> map2, Map<Integer, Byte> map3, Map<Integer, Byte> map4, Map<Integer, Byte> map5) {
        MutableQHashSeparateKVIntByteMapGO res = this.uninitializedMutableMap();
        res.move((SeparateKVIntByteQHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4, (Map)map5));
        return res;
    }

    public HashIntByteMap newMutableMap(Consumer<IntByteConsumer> entriesSupplier) {
        MutableQHashSeparateKVIntByteMapGO map = this.uninitializedMutableMap();
        map.move((SeparateKVIntByteQHash)this.newUpdatableMap((Consumer)entriesSupplier));
        return map;
    }

    public HashIntByteMap newMutableMap(Consumer<IntByteConsumer> entriesSupplier, int expectedSize) {
        MutableQHashSeparateKVIntByteMapGO map = this.uninitializedMutableMap();
        map.move((SeparateKVIntByteQHash)this.newUpdatableMap((Consumer)entriesSupplier, expectedSize));
        return map;
    }

    public HashIntByteMap newMutableMap(int[] keys, byte[] values) {
        MutableQHashSeparateKVIntByteMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMap(keys, values));
        return map;
    }

    public HashIntByteMap newMutableMap(int[] keys, byte[] values, int expectedSize) {
        MutableQHashSeparateKVIntByteMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMap(keys, values, expectedSize));
        return map;
    }

    public HashIntByteMap newMutableMap(Integer[] keys, Byte[] values) {
        MutableQHashSeparateKVIntByteMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMap(keys, values));
        return map;
    }

    public HashIntByteMap newMutableMap(Integer[] keys, Byte[] values, int expectedSize) {
        MutableQHashSeparateKVIntByteMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMap(keys, values, expectedSize));
        return map;
    }

    public HashIntByteMap newMutableMap(Iterable<Integer> keys, Iterable<Byte> values) {
        MutableQHashSeparateKVIntByteMapGO map = this.uninitializedMutableMap();
        map.move((SeparateKVIntByteQHash)this.newUpdatableMap((Iterable)keys, (Iterable)values));
        return map;
    }

    public HashIntByteMap newMutableMap(Iterable<Integer> keys, Iterable<Byte> values, int expectedSize) {
        MutableQHashSeparateKVIntByteMapGO map = this.uninitializedMutableMap();
        map.move((SeparateKVIntByteQHash)this.newUpdatableMap((Iterable)keys, (Iterable)values, expectedSize));
        return map;
    }

    public HashIntByteMap newMutableMapOf(int k1, byte v1) {
        MutableQHashSeparateKVIntByteMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMapOf(k1, v1));
        return map;
    }

    public HashIntByteMap newMutableMapOf(int k1, byte v1, int k2, byte v2) {
        MutableQHashSeparateKVIntByteMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMapOf(k1, v1, k2, v2));
        return map;
    }

    public HashIntByteMap newMutableMapOf(int k1, byte v1, int k2, byte v2, int k3, byte v3) {
        MutableQHashSeparateKVIntByteMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMapOf(k1, v1, k2, v2, k3, v3));
        return map;
    }

    public HashIntByteMap newMutableMapOf(int k1, byte v1, int k2, byte v2, int k3, byte v3, int k4, byte v4) {
        MutableQHashSeparateKVIntByteMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4));
        return map;
    }

    public HashIntByteMap newMutableMapOf(int k1, byte v1, int k2, byte v2, int k3, byte v3, int k4, byte v4, int k5, byte v5) {
        MutableQHashSeparateKVIntByteMapGO map = this.uninitializedMutableMap();
        map.move(this.newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5));
        return map;
    }

    public HashIntByteMap newImmutableMap(Map<Integer, Byte> map1, Map<Integer, Byte> map2, int expectedSize) {
        ImmutableQHashSeparateKVIntByteMapGO res = this.uninitializedImmutableMap();
        res.move((SeparateKVIntByteQHash)this.newUpdatableMap((Map)map1, (Map)map2, expectedSize));
        return res;
    }

    public HashIntByteMap newImmutableMap(Map<Integer, Byte> map1, Map<Integer, Byte> map2, Map<Integer, Byte> map3, int expectedSize) {
        ImmutableQHashSeparateKVIntByteMapGO res = this.uninitializedImmutableMap();
        res.move((SeparateKVIntByteQHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, expectedSize));
        return res;
    }

    public HashIntByteMap newImmutableMap(Map<Integer, Byte> map1, Map<Integer, Byte> map2, Map<Integer, Byte> map3, Map<Integer, Byte> map4, int expectedSize) {
        ImmutableQHashSeparateKVIntByteMapGO res = this.uninitializedImmutableMap();
        res.move((SeparateKVIntByteQHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4, expectedSize));
        return res;
    }

    public HashIntByteMap newImmutableMap(Map<Integer, Byte> map1, Map<Integer, Byte> map2, Map<Integer, Byte> map3, Map<Integer, Byte> map4, Map<Integer, Byte> map5, int expectedSize) {
        ImmutableQHashSeparateKVIntByteMapGO res = this.uninitializedImmutableMap();
        res.move((SeparateKVIntByteQHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4, (Map)map5, expectedSize));
        return res;
    }

    public HashIntByteMap newImmutableMap(Map<Integer, Byte> map) {
        ImmutableQHashSeparateKVIntByteMapGO res = this.uninitializedImmutableMap();
        res.move((SeparateKVIntByteQHash)this.newUpdatableMap((Map)map));
        return res;
    }

    public HashIntByteMap newImmutableMap(Map<Integer, Byte> map1, Map<Integer, Byte> map2) {
        ImmutableQHashSeparateKVIntByteMapGO res = this.uninitializedImmutableMap();
        res.move((SeparateKVIntByteQHash)this.newUpdatableMap((Map)map1, (Map)map2));
        return res;
    }

    public HashIntByteMap newImmutableMap(Map<Integer, Byte> map1, Map<Integer, Byte> map2, Map<Integer, Byte> map3) {
        ImmutableQHashSeparateKVIntByteMapGO res = this.uninitializedImmutableMap();
        res.move((SeparateKVIntByteQHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3));
        return res;
    }

    public HashIntByteMap newImmutableMap(Map<Integer, Byte> map1, Map<Integer, Byte> map2, Map<Integer, Byte> map3, Map<Integer, Byte> map4) {
        ImmutableQHashSeparateKVIntByteMapGO res = this.uninitializedImmutableMap();
        res.move((SeparateKVIntByteQHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4));
        return res;
    }

    public HashIntByteMap newImmutableMap(Map<Integer, Byte> map1, Map<Integer, Byte> map2, Map<Integer, Byte> map3, Map<Integer, Byte> map4, Map<Integer, Byte> map5) {
        ImmutableQHashSeparateKVIntByteMapGO res = this.uninitializedImmutableMap();
        res.move((SeparateKVIntByteQHash)this.newUpdatableMap((Map)map1, (Map)map2, (Map)map3, (Map)map4, (Map)map5));
        return res;
    }

    public HashIntByteMap newImmutableMap(Consumer<IntByteConsumer> entriesSupplier) {
        ImmutableQHashSeparateKVIntByteMapGO map = this.uninitializedImmutableMap();
        map.move((SeparateKVIntByteQHash)this.newUpdatableMap((Consumer)entriesSupplier));
        return map;
    }

    public HashIntByteMap newImmutableMap(Consumer<IntByteConsumer> entriesSupplier, int expectedSize) {
        ImmutableQHashSeparateKVIntByteMapGO map = this.uninitializedImmutableMap();
        map.move((SeparateKVIntByteQHash)this.newUpdatableMap((Consumer)entriesSupplier, expectedSize));
        return map;
    }

    public HashIntByteMap newImmutableMap(int[] keys, byte[] values) {
        ImmutableQHashSeparateKVIntByteMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMap(keys, values));
        return map;
    }

    public HashIntByteMap newImmutableMap(int[] keys, byte[] values, int expectedSize) {
        ImmutableQHashSeparateKVIntByteMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMap(keys, values, expectedSize));
        return map;
    }

    public HashIntByteMap newImmutableMap(Integer[] keys, Byte[] values) {
        ImmutableQHashSeparateKVIntByteMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMap(keys, values));
        return map;
    }

    public HashIntByteMap newImmutableMap(Integer[] keys, Byte[] values, int expectedSize) {
        ImmutableQHashSeparateKVIntByteMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMap(keys, values, expectedSize));
        return map;
    }

    public HashIntByteMap newImmutableMap(Iterable<Integer> keys, Iterable<Byte> values) {
        ImmutableQHashSeparateKVIntByteMapGO map = this.uninitializedImmutableMap();
        map.move((SeparateKVIntByteQHash)this.newUpdatableMap((Iterable)keys, (Iterable)values));
        return map;
    }

    public HashIntByteMap newImmutableMap(Iterable<Integer> keys, Iterable<Byte> values, int expectedSize) {
        ImmutableQHashSeparateKVIntByteMapGO map = this.uninitializedImmutableMap();
        map.move((SeparateKVIntByteQHash)this.newUpdatableMap((Iterable)keys, (Iterable)values, expectedSize));
        return map;
    }

    public HashIntByteMap newImmutableMapOf(int k1, byte v1) {
        ImmutableQHashSeparateKVIntByteMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMapOf(k1, v1));
        return map;
    }

    public HashIntByteMap newImmutableMapOf(int k1, byte v1, int k2, byte v2) {
        ImmutableQHashSeparateKVIntByteMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMapOf(k1, v1, k2, v2));
        return map;
    }

    public HashIntByteMap newImmutableMapOf(int k1, byte v1, int k2, byte v2, int k3, byte v3) {
        ImmutableQHashSeparateKVIntByteMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMapOf(k1, v1, k2, v2, k3, v3));
        return map;
    }

    public HashIntByteMap newImmutableMapOf(int k1, byte v1, int k2, byte v2, int k3, byte v3, int k4, byte v4) {
        ImmutableQHashSeparateKVIntByteMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4));
        return map;
    }

    public HashIntByteMap newImmutableMapOf(int k1, byte v1, int k2, byte v2, int k3, byte v3, int k4, byte v4, int k5, byte v5) {
        ImmutableQHashSeparateKVIntByteMapGO map = this.uninitializedImmutableMap();
        map.move(this.newUpdatableMapOf(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5));
        return map;
    }
}

