/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import java.util.Collection;
import java.util.Iterator;
import javax.annotation.Nonnull;
import net.openhft.collect.hash.HashConfig;
import net.openhft.collect.hash.HashContainerFactory;
import net.openhft.collect.impl.Containers;
import net.openhft.collect.impl.hash.ImmutableQHashFloatSetGO;
import net.openhft.collect.impl.hash.LHashCapacities;
import net.openhft.collect.impl.hash.MutableQHashFloatSetGO;
import net.openhft.collect.impl.hash.QHashFloatSetFactorySO;
import net.openhft.collect.impl.hash.SeparateKVFloatQHash;
import net.openhft.collect.impl.hash.UpdatableQHashFloatSetGO;
import net.openhft.collect.set.hash.HashFloatSet;
import net.openhft.collect.set.hash.HashFloatSetFactory;
import net.openhft.function.Consumer;
import net.openhft.function.FloatConsumer;
import net.openhft.function.Predicate;

public abstract class QHashFloatSetFactoryGO
extends QHashFloatSetFactorySO {
    public QHashFloatSetFactoryGO(HashConfig hashConf, int defaultExpectedSize) {
        super(hashConf, defaultExpectedSize);
    }

    abstract HashFloatSetFactory thisWith(HashConfig var1, int var2);

    abstract HashFloatSetFactory lHashLikeThisWith(HashConfig var1, int var2);

    abstract HashFloatSetFactory qHashLikeThisWith(HashConfig var1, int var2);

    public final HashFloatSetFactory withHashConfig(@Nonnull HashConfig hashConf) {
        if (LHashCapacities.configIsSuitableForMutableLHash(hashConf)) {
            return this.lHashLikeThisWith(hashConf, this.getDefaultExpectedSize());
        }
        return this.qHashLikeThisWith(hashConf, this.getDefaultExpectedSize());
    }

    public final HashFloatSetFactory withDefaultExpectedSize(int defaultExpectedSize) {
        if (defaultExpectedSize == this.getDefaultExpectedSize()) {
            return this;
        }
        return this.thisWith(this.getHashConfig(), defaultExpectedSize);
    }

    public String toString() {
        return "HashFloatSetFactory[" + this.commonString() + this.keySpecialString() + "]";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof HashFloatSetFactory) {
            HashFloatSetFactory factory = (HashFloatSetFactory)obj;
            return this.commonEquals((HashContainerFactory<?>)factory) && this.keySpecialEquals(factory);
        }
        return false;
    }

    public int hashCode() {
        return this.keySpecialHashCode(this.commonHashCode());
    }

    private UpdatableQHashFloatSetGO shrunk(UpdatableQHashFloatSetGO set) {
        Predicate shrinkCondition = this.hashConf.getShrinkCondition();
        if (shrinkCondition != null && shrinkCondition.test(set)) {
            set.shrink();
        }
        return set;
    }

    public UpdatableQHashFloatSetGO newUpdatableSet() {
        return this.newUpdatableSet(this.getDefaultExpectedSize());
    }

    public MutableQHashFloatSetGO newMutableSet() {
        return this.newMutableSet(this.getDefaultExpectedSize());
    }

    private static int sizeOr(Iterable elems, int defaultSize) {
        return elems instanceof Collection ? ((Collection)elems).size() : defaultSize;
    }

    public UpdatableQHashFloatSetGO newUpdatableSet(Iterable<Float> elements) {
        return this.newUpdatableSet((Iterable)elements, QHashFloatSetFactoryGO.sizeOr(elements, this.getDefaultExpectedSize()));
    }

    public UpdatableQHashFloatSetGO newUpdatableSet(Iterable<Float> elems1, Iterable<Float> elems2) {
        long expectedSize = QHashFloatSetFactoryGO.sizeOr(elems1, 0);
        return this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, Containers.sizeAsInt(expectedSize += (long)QHashFloatSetFactoryGO.sizeOr(elems2, 0)));
    }

    public UpdatableQHashFloatSetGO newUpdatableSet(Iterable<Float> elems1, Iterable<Float> elems2, Iterable<Float> elems3) {
        long expectedSize = QHashFloatSetFactoryGO.sizeOr(elems1, 0);
        expectedSize += (long)QHashFloatSetFactoryGO.sizeOr(elems2, 0);
        return this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, Containers.sizeAsInt(expectedSize += (long)QHashFloatSetFactoryGO.sizeOr(elems3, 0)));
    }

    public UpdatableQHashFloatSetGO newUpdatableSet(Iterable<Float> elems1, Iterable<Float> elems2, Iterable<Float> elems3, Iterable<Float> elems4) {
        long expectedSize = QHashFloatSetFactoryGO.sizeOr(elems1, 0);
        expectedSize += (long)QHashFloatSetFactoryGO.sizeOr(elems2, 0);
        expectedSize += (long)QHashFloatSetFactoryGO.sizeOr(elems3, 0);
        return this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4, Containers.sizeAsInt(expectedSize += (long)QHashFloatSetFactoryGO.sizeOr(elems4, 0)));
    }

    public UpdatableQHashFloatSetGO newUpdatableSet(Iterable<Float> elems1, Iterable<Float> elems2, Iterable<Float> elems3, Iterable<Float> elems4, Iterable<Float> elems5) {
        long expectedSize = QHashFloatSetFactoryGO.sizeOr(elems1, 0);
        expectedSize += (long)QHashFloatSetFactoryGO.sizeOr(elems2, 0);
        expectedSize += (long)QHashFloatSetFactoryGO.sizeOr(elems3, 0);
        expectedSize += (long)QHashFloatSetFactoryGO.sizeOr(elems4, 0);
        return this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4, (Iterable)elems5, Containers.sizeAsInt(expectedSize += (long)QHashFloatSetFactoryGO.sizeOr(elems5, 0)));
    }

    @Override
    public UpdatableQHashFloatSetGO newUpdatableSet(Iterable<Float> elements, int expectedSize) {
        return this.shrunk((UpdatableQHashFloatSetGO)super.newUpdatableSet((Iterable)elements, expectedSize));
    }

    private static void addAll(UpdatableQHashFloatSetGO set, Iterable<? extends Float> elems) {
        if (elems instanceof Collection) {
            set.addAll((Collection)elems);
        } else {
            Iterator<? extends Float> iterator = elems.iterator();
            while (iterator.hasNext()) {
                float e = iterator.next().floatValue();
                set.add(e);
            }
        }
    }

    public UpdatableQHashFloatSetGO newUpdatableSet(Iterable<Float> elems1, Iterable<Float> elems2, int expectedSize) {
        UpdatableQHashFloatSetGO set = this.newUpdatableSet(expectedSize);
        QHashFloatSetFactoryGO.addAll(set, elems1);
        QHashFloatSetFactoryGO.addAll(set, elems2);
        return this.shrunk(set);
    }

    public UpdatableQHashFloatSetGO newUpdatableSet(Iterable<Float> elems1, Iterable<Float> elems2, Iterable<Float> elems3, int expectedSize) {
        UpdatableQHashFloatSetGO set = this.newUpdatableSet(expectedSize);
        QHashFloatSetFactoryGO.addAll(set, elems1);
        QHashFloatSetFactoryGO.addAll(set, elems2);
        QHashFloatSetFactoryGO.addAll(set, elems3);
        return this.shrunk(set);
    }

    public UpdatableQHashFloatSetGO newUpdatableSet(Iterable<Float> elems1, Iterable<Float> elems2, Iterable<Float> elems3, Iterable<Float> elems4, int expectedSize) {
        UpdatableQHashFloatSetGO set = this.newUpdatableSet(expectedSize);
        QHashFloatSetFactoryGO.addAll(set, elems1);
        QHashFloatSetFactoryGO.addAll(set, elems2);
        QHashFloatSetFactoryGO.addAll(set, elems3);
        QHashFloatSetFactoryGO.addAll(set, elems4);
        return this.shrunk(set);
    }

    public UpdatableQHashFloatSetGO newUpdatableSet(Iterable<Float> elems1, Iterable<Float> elems2, Iterable<Float> elems3, Iterable<Float> elems4, Iterable<Float> elems5, int expectedSize) {
        UpdatableQHashFloatSetGO set = this.newUpdatableSet(expectedSize);
        QHashFloatSetFactoryGO.addAll(set, elems1);
        QHashFloatSetFactoryGO.addAll(set, elems2);
        QHashFloatSetFactoryGO.addAll(set, elems3);
        QHashFloatSetFactoryGO.addAll(set, elems4);
        QHashFloatSetFactoryGO.addAll(set, elems5);
        return this.shrunk(set);
    }

    public UpdatableQHashFloatSetGO newUpdatableSet(Iterator<Float> elements) {
        return this.newUpdatableSet((Iterator)elements, this.getDefaultExpectedSize());
    }

    public UpdatableQHashFloatSetGO newUpdatableSet(Iterator<Float> elements, int expectedSize) {
        UpdatableQHashFloatSetGO set = this.newUpdatableSet(expectedSize);
        while (elements.hasNext()) {
            set.add(elements.next());
        }
        return this.shrunk(set);
    }

    public UpdatableQHashFloatSetGO newUpdatableSet(Consumer<FloatConsumer> elementsSupplier) {
        return this.newUpdatableSet((Consumer)elementsSupplier, this.getDefaultExpectedSize());
    }

    public UpdatableQHashFloatSetGO newUpdatableSet(Consumer<FloatConsumer> elementsSupplier, int expectedSize) {
        final UpdatableQHashFloatSetGO set = this.newUpdatableSet(expectedSize);
        elementsSupplier.accept((Object)new FloatConsumer(){

            public void accept(float e) {
                set.add(e);
            }
        });
        return this.shrunk(set);
    }

    public UpdatableQHashFloatSetGO newUpdatableSet(float[] elements) {
        return this.newUpdatableSet(elements, elements.length);
    }

    public UpdatableQHashFloatSetGO newUpdatableSet(float[] elements, int expectedSize) {
        UpdatableQHashFloatSetGO set = this.newUpdatableSet(expectedSize);
        for (float e : elements) {
            set.add(e);
        }
        return this.shrunk(set);
    }

    public UpdatableQHashFloatSetGO newUpdatableSet(Float[] elements) {
        return this.newUpdatableSet(elements, elements.length);
    }

    public UpdatableQHashFloatSetGO newUpdatableSet(Float[] elements, int expectedSize) {
        UpdatableQHashFloatSetGO set = this.newUpdatableSet(expectedSize);
        Float[] floatArray = elements;
        int n = floatArray.length;
        for (int i = 0; i < n; ++i) {
            float e = floatArray[i].floatValue();
            set.add(e);
        }
        return this.shrunk(set);
    }

    public UpdatableQHashFloatSetGO newUpdatableSetOf(float e1) {
        UpdatableQHashFloatSetGO set = this.newUpdatableSet(1);
        set.add(e1);
        return set;
    }

    public UpdatableQHashFloatSetGO newUpdatableSetOf(float e1, float e2) {
        UpdatableQHashFloatSetGO set = this.newUpdatableSet(2);
        set.add(e1);
        set.add(e2);
        return set;
    }

    public UpdatableQHashFloatSetGO newUpdatableSetOf(float e1, float e2, float e3) {
        UpdatableQHashFloatSetGO set = this.newUpdatableSet(3);
        set.add(e1);
        set.add(e2);
        set.add(e3);
        return set;
    }

    public UpdatableQHashFloatSetGO newUpdatableSetOf(float e1, float e2, float e3, float e4) {
        UpdatableQHashFloatSetGO set = this.newUpdatableSet(4);
        set.add(e1);
        set.add(e2);
        set.add(e3);
        set.add(e4);
        return set;
    }

    public UpdatableQHashFloatSetGO newUpdatableSetOf(float e1, float e2, float e3, float e4, float e5, float ... restElements) {
        UpdatableQHashFloatSetGO set = this.newUpdatableSet(5 + restElements.length);
        set.add(e1);
        set.add(e2);
        set.add(e3);
        set.add(e4);
        set.add(e5);
        for (float e : restElements) {
            set.add(e);
        }
        return this.shrunk(set);
    }

    public HashFloatSet newMutableSet(Iterable<Float> elements, int expectedSize) {
        MutableQHashFloatSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVFloatQHash)this.newUpdatableSet((Iterable)elements, expectedSize));
        return set;
    }

    public HashFloatSet newMutableSet(Iterable<Float> elems1, Iterable<Float> elems2, int expectedSize) {
        MutableQHashFloatSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVFloatQHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, expectedSize));
        return set;
    }

    public HashFloatSet newMutableSet(Iterable<Float> elems1, Iterable<Float> elems2, Iterable<Float> elems3, int expectedSize) {
        MutableQHashFloatSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVFloatQHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, expectedSize));
        return set;
    }

    public HashFloatSet newMutableSet(Iterable<Float> elems1, Iterable<Float> elems2, Iterable<Float> elems3, Iterable<Float> elems4, int expectedSize) {
        MutableQHashFloatSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVFloatQHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4, expectedSize));
        return set;
    }

    public HashFloatSet newMutableSet(Iterable<Float> elems1, Iterable<Float> elems2, Iterable<Float> elems3, Iterable<Float> elems4, Iterable<Float> elems5, int expectedSize) {
        MutableQHashFloatSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVFloatQHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4, (Iterable)elems5, expectedSize));
        return set;
    }

    public HashFloatSet newMutableSet(Iterable<Float> elements) {
        MutableQHashFloatSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVFloatQHash)this.newUpdatableSet((Iterable)elements));
        return set;
    }

    public HashFloatSet newMutableSet(Iterable<Float> elems1, Iterable<Float> elems2) {
        MutableQHashFloatSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVFloatQHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2));
        return set;
    }

    public HashFloatSet newMutableSet(Iterable<Float> elems1, Iterable<Float> elems2, Iterable<Float> elems3) {
        MutableQHashFloatSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVFloatQHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3));
        return set;
    }

    public HashFloatSet newMutableSet(Iterable<Float> elems1, Iterable<Float> elems2, Iterable<Float> elems3, Iterable<Float> elems4) {
        MutableQHashFloatSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVFloatQHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4));
        return set;
    }

    public HashFloatSet newMutableSet(Iterable<Float> elems1, Iterable<Float> elems2, Iterable<Float> elems3, Iterable<Float> elems4, Iterable<Float> elems5) {
        MutableQHashFloatSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVFloatQHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4, (Iterable)elems5));
        return set;
    }

    public HashFloatSet newMutableSet(Iterator<Float> elements) {
        MutableQHashFloatSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVFloatQHash)this.newUpdatableSet((Iterator)elements));
        return set;
    }

    public HashFloatSet newMutableSet(Iterator<Float> elements, int expectedSize) {
        MutableQHashFloatSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVFloatQHash)this.newUpdatableSet((Iterator)elements, expectedSize));
        return set;
    }

    public HashFloatSet newMutableSet(Consumer<FloatConsumer> elementsSupplier) {
        MutableQHashFloatSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVFloatQHash)this.newUpdatableSet((Consumer)elementsSupplier));
        return set;
    }

    public HashFloatSet newMutableSet(Consumer<FloatConsumer> elementsSupplier, int expectedSize) {
        MutableQHashFloatSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVFloatQHash)this.newUpdatableSet((Consumer)elementsSupplier, expectedSize));
        return set;
    }

    public HashFloatSet newMutableSet(float[] elements) {
        MutableQHashFloatSetGO set = this.uninitializedMutableSet();
        set.move(this.newUpdatableSet(elements));
        return set;
    }

    public HashFloatSet newMutableSet(float[] elements, int expectedSize) {
        MutableQHashFloatSetGO set = this.uninitializedMutableSet();
        set.move(this.newUpdatableSet(elements, expectedSize));
        return set;
    }

    public HashFloatSet newMutableSet(Float[] elements) {
        MutableQHashFloatSetGO set = this.uninitializedMutableSet();
        set.move(this.newUpdatableSet(elements));
        return set;
    }

    public HashFloatSet newMutableSet(Float[] elements, int expectedSize) {
        MutableQHashFloatSetGO set = this.uninitializedMutableSet();
        set.move(this.newUpdatableSet(elements, expectedSize));
        return set;
    }

    public HashFloatSet newMutableSetOf(float e1) {
        MutableQHashFloatSetGO set = this.uninitializedMutableSet();
        set.move(this.newUpdatableSetOf(e1));
        return set;
    }

    public HashFloatSet newMutableSetOf(float e1, float e2) {
        MutableQHashFloatSetGO set = this.uninitializedMutableSet();
        set.move(this.newUpdatableSetOf(e1, e2));
        return set;
    }

    public HashFloatSet newMutableSetOf(float e1, float e2, float e3) {
        MutableQHashFloatSetGO set = this.uninitializedMutableSet();
        set.move(this.newUpdatableSetOf(e1, e2, e3));
        return set;
    }

    public HashFloatSet newMutableSetOf(float e1, float e2, float e3, float e4) {
        MutableQHashFloatSetGO set = this.uninitializedMutableSet();
        set.move(this.newUpdatableSetOf(e1, e2, e3, e4));
        return set;
    }

    public HashFloatSet newMutableSetOf(float e1, float e2, float e3, float e4, float e5, float ... restElements) {
        MutableQHashFloatSetGO set = this.uninitializedMutableSet();
        set.move(this.newUpdatableSetOf(e1, e2, e3, e4, e5, restElements));
        return set;
    }

    public HashFloatSet newImmutableSet(Iterable<Float> elements, int expectedSize) {
        ImmutableQHashFloatSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVFloatQHash)this.newUpdatableSet((Iterable)elements, expectedSize));
        return set;
    }

    public HashFloatSet newImmutableSet(Iterable<Float> elems1, Iterable<Float> elems2, int expectedSize) {
        ImmutableQHashFloatSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVFloatQHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, expectedSize));
        return set;
    }

    public HashFloatSet newImmutableSet(Iterable<Float> elems1, Iterable<Float> elems2, Iterable<Float> elems3, int expectedSize) {
        ImmutableQHashFloatSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVFloatQHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, expectedSize));
        return set;
    }

    public HashFloatSet newImmutableSet(Iterable<Float> elems1, Iterable<Float> elems2, Iterable<Float> elems3, Iterable<Float> elems4, int expectedSize) {
        ImmutableQHashFloatSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVFloatQHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4, expectedSize));
        return set;
    }

    public HashFloatSet newImmutableSet(Iterable<Float> elems1, Iterable<Float> elems2, Iterable<Float> elems3, Iterable<Float> elems4, Iterable<Float> elems5, int expectedSize) {
        ImmutableQHashFloatSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVFloatQHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4, (Iterable)elems5, expectedSize));
        return set;
    }

    public HashFloatSet newImmutableSet(Iterable<Float> elements) {
        ImmutableQHashFloatSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVFloatQHash)this.newUpdatableSet((Iterable)elements));
        return set;
    }

    public HashFloatSet newImmutableSet(Iterable<Float> elems1, Iterable<Float> elems2) {
        ImmutableQHashFloatSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVFloatQHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2));
        return set;
    }

    public HashFloatSet newImmutableSet(Iterable<Float> elems1, Iterable<Float> elems2, Iterable<Float> elems3) {
        ImmutableQHashFloatSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVFloatQHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3));
        return set;
    }

    public HashFloatSet newImmutableSet(Iterable<Float> elems1, Iterable<Float> elems2, Iterable<Float> elems3, Iterable<Float> elems4) {
        ImmutableQHashFloatSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVFloatQHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4));
        return set;
    }

    public HashFloatSet newImmutableSet(Iterable<Float> elems1, Iterable<Float> elems2, Iterable<Float> elems3, Iterable<Float> elems4, Iterable<Float> elems5) {
        ImmutableQHashFloatSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVFloatQHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4, (Iterable)elems5));
        return set;
    }

    public HashFloatSet newImmutableSet(Iterator<Float> elements) {
        ImmutableQHashFloatSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVFloatQHash)this.newUpdatableSet((Iterator)elements));
        return set;
    }

    public HashFloatSet newImmutableSet(Iterator<Float> elements, int expectedSize) {
        ImmutableQHashFloatSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVFloatQHash)this.newUpdatableSet((Iterator)elements, expectedSize));
        return set;
    }

    public HashFloatSet newImmutableSet(Consumer<FloatConsumer> elementsSupplier) {
        ImmutableQHashFloatSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVFloatQHash)this.newUpdatableSet((Consumer)elementsSupplier));
        return set;
    }

    public HashFloatSet newImmutableSet(Consumer<FloatConsumer> elementsSupplier, int expectedSize) {
        ImmutableQHashFloatSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVFloatQHash)this.newUpdatableSet((Consumer)elementsSupplier, expectedSize));
        return set;
    }

    public HashFloatSet newImmutableSet(float[] elements) {
        ImmutableQHashFloatSetGO set = this.uninitializedImmutableSet();
        set.move(this.newUpdatableSet(elements));
        return set;
    }

    public HashFloatSet newImmutableSet(float[] elements, int expectedSize) {
        ImmutableQHashFloatSetGO set = this.uninitializedImmutableSet();
        set.move(this.newUpdatableSet(elements, expectedSize));
        return set;
    }

    public HashFloatSet newImmutableSet(Float[] elements) {
        ImmutableQHashFloatSetGO set = this.uninitializedImmutableSet();
        set.move(this.newUpdatableSet(elements));
        return set;
    }

    public HashFloatSet newImmutableSet(Float[] elements, int expectedSize) {
        ImmutableQHashFloatSetGO set = this.uninitializedImmutableSet();
        set.move(this.newUpdatableSet(elements, expectedSize));
        return set;
    }

    public HashFloatSet newImmutableSetOf(float e1) {
        ImmutableQHashFloatSetGO set = this.uninitializedImmutableSet();
        set.move(this.newUpdatableSetOf(e1));
        return set;
    }

    public HashFloatSet newImmutableSetOf(float e1, float e2) {
        ImmutableQHashFloatSetGO set = this.uninitializedImmutableSet();
        set.move(this.newUpdatableSetOf(e1, e2));
        return set;
    }

    public HashFloatSet newImmutableSetOf(float e1, float e2, float e3) {
        ImmutableQHashFloatSetGO set = this.uninitializedImmutableSet();
        set.move(this.newUpdatableSetOf(e1, e2, e3));
        return set;
    }

    public HashFloatSet newImmutableSetOf(float e1, float e2, float e3, float e4) {
        ImmutableQHashFloatSetGO set = this.uninitializedImmutableSet();
        set.move(this.newUpdatableSetOf(e1, e2, e3, e4));
        return set;
    }

    public HashFloatSet newImmutableSetOf(float e1, float e2, float e3, float e4, float e5, float ... restElements) {
        ImmutableQHashFloatSetGO set = this.uninitializedImmutableSet();
        set.move(this.newUpdatableSetOf(e1, e2, e3, e4, e5, restElements));
        return set;
    }
}

