/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import java.util.Collection;
import java.util.Set;
import net.openhft.collect.DoubleCollection;
import net.openhft.collect.hash.HashConfig;
import net.openhft.collect.impl.hash.DoubleQHashFactory;
import net.openhft.collect.impl.hash.ImmutableQHashDoubleSet;
import net.openhft.collect.impl.hash.ImmutableQHashDoubleSetGO;
import net.openhft.collect.impl.hash.MutableQHashDoubleSet;
import net.openhft.collect.impl.hash.MutableQHashDoubleSetGO;
import net.openhft.collect.impl.hash.SeparateKVDoubleQHash;
import net.openhft.collect.impl.hash.UpdatableQHashDoubleSet;
import net.openhft.collect.impl.hash.UpdatableQHashDoubleSetGO;
import net.openhft.collect.set.hash.HashDoubleSetFactory;

public abstract class QHashDoubleSetFactorySO
extends DoubleQHashFactory
implements HashDoubleSetFactory {
    QHashDoubleSetFactorySO(HashConfig hashConf, int defaultExpectedSize) {
        super(hashConf, defaultExpectedSize);
    }

    MutableQHashDoubleSetGO uninitializedMutableSet() {
        return new MutableQHashDoubleSet();
    }

    UpdatableQHashDoubleSetGO uninitializedUpdatableSet() {
        return new UpdatableQHashDoubleSet();
    }

    ImmutableQHashDoubleSetGO uninitializedImmutableSet() {
        return new ImmutableQHashDoubleSet();
    }

    public MutableQHashDoubleSetGO newMutableSet(int expectedSize) {
        MutableQHashDoubleSet set = new MutableQHashDoubleSet();
        set.init(this.configWrapper, expectedSize);
        return set;
    }

    public UpdatableQHashDoubleSetGO newUpdatableSet(int expectedSize) {
        UpdatableQHashDoubleSet set = new UpdatableQHashDoubleSet();
        set.init(this.configWrapper, expectedSize);
        return set;
    }

    public UpdatableQHashDoubleSetGO newUpdatableSet(Iterable<Double> elements, int expectedSize) {
        if (elements instanceof DoubleCollection) {
            SeparateKVDoubleQHash hash;
            if (elements instanceof SeparateKVDoubleQHash && (hash = (SeparateKVDoubleQHash)((Object)elements)).hashConfig().equals(this.hashConf)) {
                UpdatableQHashDoubleSet set = new UpdatableQHashDoubleSet();
                set.copy(hash);
                return set;
            }
            int size = elements instanceof Set ? ((Set)elements).size() : expectedSize;
            UpdatableQHashDoubleSetGO set = this.newUpdatableSet(size);
            set.addAll((Collection)elements);
            return set;
        }
        int size = elements instanceof Set ? ((Set)elements).size() : expectedSize;
        UpdatableQHashDoubleSetGO set = this.newUpdatableSet(size);
        for (double e : elements) {
            set.add(e);
        }
        return set;
    }
}

