/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import java.util.Collection;
import java.util.ConcurrentModificationException;
import javax.annotation.Nonnull;
import net.openhft.collect.ShortCollection;
import net.openhft.collect.ShortCursor;
import net.openhft.collect.impl.CommonSetOps;
import net.openhft.collect.impl.CommonShortCollectionOps;
import net.openhft.collect.impl.InternalShortCollectionOps;
import net.openhft.collect.impl.hash.MutableShortQHashSetSO;
import net.openhft.collect.impl.hash.QHash;
import net.openhft.collect.impl.hash.SeparateKVShortQHash;
import net.openhft.collect.set.ShortSet;
import net.openhft.collect.set.hash.HashShortSet;

public class MutableQHashShortSetGO
extends MutableShortQHashSetSO
implements HashShortSet,
InternalShortCollectionOps {
    @Override
    final void copy(SeparateKVShortQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.copy(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    final void move(SeparateKVShortQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.move(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public int hashCode() {
        return this.setHashCode();
    }

    @Override
    public String toString() {
        return this.setToString();
    }

    @Override
    public boolean equals(Object obj) {
        return CommonSetOps.equals(this, obj);
    }

    public boolean containsAll(@Nonnull Collection<?> c) {
        return CommonShortCollectionOps.containsAll(this, c);
    }

    @Nonnull
    public ShortCursor cursor() {
        return this.setCursor();
    }

    public boolean add(Short e) {
        return this.add((short)e);
    }

    public boolean add(short key) {
        block24: {
            short removed = this.removedValue;
            short free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            } else if (key == removed) {
                removed = this.changeRemoved();
            }
            short[] keys = this.set;
            int capacity = keys.length;
            int index = QHash.SeparateKVShortKeyMixing.mix(key) % capacity;
            short cur = keys[index];
            if (cur != free) {
                int firstRemoved;
                if (cur == key) {
                    return false;
                }
                if (cur != removed) {
                    if (this.noRemoved()) {
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == free) {
                                index = bIndex;
                                break block24;
                            }
                            if (cur == key) {
                                return false;
                            }
                            int t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == free) {
                                index = fIndex;
                                break block24;
                            }
                            if (cur == key) {
                                return false;
                            }
                            step += 2;
                        }
                    }
                    firstRemoved = -1;
                } else {
                    firstRemoved = index;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    int t;
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == free) {
                        if (firstRemoved >= 0) break;
                        index = bIndex;
                        break block24;
                    }
                    if (cur == key) {
                        return false;
                    }
                    if (cur == removed && firstRemoved < 0) {
                        firstRemoved = bIndex;
                    }
                    if ((t = (fIndex += step) - capacity) >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == free) {
                        if (firstRemoved >= 0) break;
                        index = fIndex;
                        break block24;
                    }
                    if (cur == key) {
                        return false;
                    }
                    if (cur == removed && firstRemoved < 0) {
                        firstRemoved = fIndex;
                    }
                    step += 2;
                }
                this.incrementModCount();
                keys[firstRemoved] = key;
                this.postRemovedSlotInsertHook();
                return true;
            }
        }
        this.incrementModCount();
        keys[index] = key;
        this.postFreeSlotInsertHook();
        return true;
    }

    public boolean addAll(@Nonnull Collection<? extends Short> c) {
        return CommonShortCollectionOps.addAll(this, c);
    }

    public boolean remove(Object key) {
        return this.removeShort((Short)key);
    }

    @Override
    boolean justRemove(short key) {
        return this.removeShort(key);
    }

    public boolean removeShort(short key) {
        short removed;
        short free = this.freeValue;
        if (key != free && key != (removed = this.removedValue)) {
            short[] keys = this.set;
            int capacity = keys.length;
            int index = QHash.SeparateKVShortKeyMixing.mix(key) % capacity;
            short cur = keys[index];
            if (cur != key) {
                if (cur == free) {
                    return false;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == key) {
                        index = bIndex;
                        break;
                    }
                    if (cur == free) {
                        return false;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == key) {
                        index = fIndex;
                        break;
                    }
                    if (cur == free) {
                        return false;
                    }
                    step += 2;
                }
            }
            this.incrementModCount();
            keys[index] = removed;
            this.postRemoveHook();
            return true;
        }
        return false;
    }

    public boolean removeAll(@Nonnull Collection<?> c) {
        if (c instanceof ShortCollection) {
            InternalShortCollectionOps c2;
            if (c instanceof InternalShortCollectionOps && (c2 = (InternalShortCollectionOps)((Object)c)).size() < this.size()) {
                return c2.reverseRemoveAllFrom((ShortSet)this);
            }
            return this.removeAll((HashShortSet)this, (ShortCollection)c);
        }
        return this.removeAll((HashShortSet)this, c);
    }

    public boolean retainAll(@Nonnull Collection<?> c) {
        return this.retainAll(this, c);
    }
}

