/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import java.util.ConcurrentModificationException;
import javax.annotation.Nonnull;
import net.openhft.collect.impl.InternalObjCharMapOps;
import net.openhft.collect.impl.hash.MutableQHashSeparateKVObjKeyMap;
import net.openhft.collect.impl.hash.QHash;
import net.openhft.collect.impl.hash.SeparateKVObjCharQHash;
import net.openhft.collect.map.hash.HashObjCharMap;

public abstract class MutableQHashSeparateKVObjCharMapSO<K>
extends MutableQHashSeparateKVObjKeyMap<K>
implements HashObjCharMap<K>,
InternalObjCharMapOps<K>,
SeparateKVObjCharQHash {
    char[] values;

    void copy(SeparateKVObjCharQHash hash) {
        super.copy(hash);
        this.values = (char[])hash.valueArray().clone();
    }

    void move(SeparateKVObjCharQHash hash) {
        super.move(hash);
        this.values = hash.valueArray();
    }

    @Override
    @Nonnull
    public char[] valueArray() {
        return this.values;
    }

    int valueIndex(char value) {
        if (this.isEmpty()) {
            return -1;
        }
        int index = -1;
        int mc = this.modCount();
        Object[] keys = this.set;
        char[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == FREE || value != vals[i]) continue;
                index = i;
                break;
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == FREE || key == REMOVED || value != vals[i]) continue;
                index = i;
                break;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return index;
    }

    public boolean containsValue(char value) {
        return this.valueIndex(value) >= 0;
    }

    boolean removeValue(char value) {
        int index = this.valueIndex(value);
        if (index >= 0) {
            this.removeAt(index);
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.containsValue(((Character)value).charValue());
    }

    int insert(K key, char value) {
        if (key != null) {
            block31: {
                Object[] keys = this.set;
                int capacity = keys.length;
                int index = QHash.SeparateKVObjKeyMixing.mix(this.keyHashCode(key)) % capacity;
                Object cur = keys[index];
                if (cur == key) {
                    return index;
                }
                if (cur != FREE) {
                    int firstRemoved;
                    if (cur != REMOVED) {
                        if (this.keyEquals(key, cur)) {
                            return index;
                        }
                        if (this.noRemoved()) {
                            int bIndex = index;
                            int fIndex = index;
                            int step = 1;
                            while (true) {
                                if ((bIndex -= step) < 0) {
                                    bIndex += capacity;
                                }
                                if ((cur = keys[bIndex]) == key) {
                                    return bIndex;
                                }
                                if (cur == FREE) {
                                    index = bIndex;
                                    break block31;
                                }
                                if (this.keyEquals(key, cur)) {
                                    return bIndex;
                                }
                                int t = (fIndex += step) - capacity;
                                if (t >= 0) {
                                    fIndex = t;
                                }
                                if ((cur = keys[fIndex]) == key) {
                                    return fIndex;
                                }
                                if (cur == FREE) {
                                    index = fIndex;
                                    break block31;
                                }
                                if (this.keyEquals(key, cur)) {
                                    return fIndex;
                                }
                                step += 2;
                            }
                        }
                        firstRemoved = -1;
                    } else {
                        firstRemoved = index;
                    }
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        int t;
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if ((cur = keys[bIndex]) == key) {
                            return bIndex;
                        }
                        if (cur == FREE) {
                            if (firstRemoved >= 0) break;
                            index = bIndex;
                            break block31;
                        }
                        if (cur != REMOVED) {
                            if (this.keyEquals(key, cur)) {
                                return bIndex;
                            }
                        } else if (firstRemoved < 0) {
                            firstRemoved = bIndex;
                        }
                        if ((t = (fIndex += step) - capacity) >= 0) {
                            fIndex = t;
                        }
                        if ((cur = keys[fIndex]) == key) {
                            return fIndex;
                        }
                        if (cur == FREE) {
                            if (firstRemoved >= 0) break;
                            index = fIndex;
                            break block31;
                        }
                        if (cur != REMOVED) {
                            if (this.keyEquals(key, cur)) {
                                return fIndex;
                            }
                        } else if (firstRemoved < 0) {
                            firstRemoved = fIndex;
                        }
                        step += 2;
                    }
                    this.incrementModCount();
                    keys[firstRemoved] = key;
                    this.values[firstRemoved] = value;
                    this.postRemovedSlotInsertHook();
                    return -1;
                }
            }
            this.incrementModCount();
            keys[index] = key;
            this.values[index] = value;
            this.postFreeSlotInsertHook();
            return -1;
        }
        return this.insertNullKey(value);
    }

    int insertNullKey(char value) {
        block21: {
            Object[] keys = this.set;
            int capacity = keys.length;
            int index = 0;
            Object cur = keys[0];
            if (cur == null) {
                return index;
            }
            if (cur != FREE) {
                int firstRemoved;
                if (cur != REMOVED) {
                    if (this.noRemoved()) {
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == null) {
                                return bIndex;
                            }
                            if (cur == FREE) {
                                index = bIndex;
                                break block21;
                            }
                            int t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == null) {
                                return fIndex;
                            }
                            if (cur == FREE) {
                                index = fIndex;
                                break block21;
                            }
                            step += 2;
                        }
                    }
                    firstRemoved = -1;
                } else {
                    firstRemoved = index;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    int t;
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == null) {
                        return bIndex;
                    }
                    if (cur == FREE) {
                        if (firstRemoved >= 0) break;
                        index = bIndex;
                        break block21;
                    }
                    if (cur == REMOVED && firstRemoved < 0) {
                        firstRemoved = bIndex;
                    }
                    if ((t = (fIndex += step) - capacity) >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == null) {
                        return fIndex;
                    }
                    if (cur == FREE) {
                        if (firstRemoved >= 0) break;
                        index = fIndex;
                        break block21;
                    }
                    if (cur == REMOVED && firstRemoved < 0) {
                        firstRemoved = fIndex;
                    }
                    step += 2;
                }
                this.incrementModCount();
                keys[firstRemoved] = null;
                this.values[firstRemoved] = value;
                this.postRemovedSlotInsertHook();
                return -1;
            }
        }
        this.incrementModCount();
        keys[index] = null;
        this.values[index] = value;
        this.postFreeSlotInsertHook();
        return -1;
    }

    @Override
    void allocateArrays(int capacity) {
        super.allocateArrays(capacity);
        this.values = new char[capacity];
    }
}

