/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collect.impl.hash;

import java.util.ConcurrentModificationException;
import javax.annotation.Nonnull;
import net.openhft.collect.impl.InternalLongShortMapOps;
import net.openhft.collect.impl.hash.MutableQHashSeparateKVLongKeyMap;
import net.openhft.collect.impl.hash.QHash;
import net.openhft.collect.impl.hash.SeparateKVLongShortQHash;
import net.openhft.collect.map.hash.HashLongShortMap;

public abstract class MutableQHashSeparateKVLongShortMapSO
extends MutableQHashSeparateKVLongKeyMap
implements HashLongShortMap,
InternalLongShortMapOps,
SeparateKVLongShortQHash {
    short[] values;

    void copy(SeparateKVLongShortQHash hash) {
        super.copy(hash);
        this.values = (short[])hash.valueArray().clone();
    }

    void move(SeparateKVLongShortQHash hash) {
        super.move(hash);
        this.values = hash.valueArray();
    }

    @Override
    @Nonnull
    public short[] valueArray() {
        return this.values;
    }

    int valueIndex(short value) {
        if (this.isEmpty()) {
            return -1;
        }
        int index = -1;
        int mc = this.modCount();
        long free = this.freeValue;
        long removed = this.removedValue;
        long[] keys = this.set;
        short[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free || value != vals[i]) continue;
                index = i;
                break;
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free || key == removed || value != vals[i]) continue;
                index = i;
                break;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return index;
    }

    public boolean containsValue(short value) {
        return this.valueIndex(value) >= 0;
    }

    boolean removeValue(short value) {
        int index = this.valueIndex(value);
        if (index >= 0) {
            this.removeAt(index);
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.containsValue((Short)value);
    }

    int insert(long key, short value) {
        block24: {
            long removed = this.removedValue;
            long free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            } else if (key == removed) {
                removed = this.changeRemoved();
            }
            long[] keys = this.set;
            int capacity = keys.length;
            int index = QHash.SeparateKVLongKeyMixing.mix(key) % capacity;
            long cur = keys[index];
            if (cur == key) {
                return index;
            }
            if (cur != free) {
                int firstRemoved;
                if (cur != removed) {
                    if (this.noRemoved()) {
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == key) {
                                return bIndex;
                            }
                            if (cur == free) {
                                index = bIndex;
                                break block24;
                            }
                            int t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == key) {
                                return fIndex;
                            }
                            if (cur == free) {
                                index = fIndex;
                                break block24;
                            }
                            step += 2;
                        }
                    }
                    firstRemoved = -1;
                } else {
                    firstRemoved = index;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    int t;
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == key) {
                        return bIndex;
                    }
                    if (cur == free) {
                        if (firstRemoved >= 0) break;
                        index = bIndex;
                        break block24;
                    }
                    if (cur == removed && firstRemoved < 0) {
                        firstRemoved = bIndex;
                    }
                    if ((t = (fIndex += step) - capacity) >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == key) {
                        return fIndex;
                    }
                    if (cur == free) {
                        if (firstRemoved >= 0) break;
                        index = fIndex;
                        break block24;
                    }
                    if (cur == removed && firstRemoved < 0) {
                        firstRemoved = fIndex;
                    }
                    step += 2;
                }
                this.incrementModCount();
                keys[firstRemoved] = key;
                this.values[firstRemoved] = value;
                this.postRemovedSlotInsertHook();
                return -1;
            }
        }
        this.incrementModCount();
        keys[index] = key;
        this.values[index] = value;
        this.postFreeSlotInsertHook();
        return -1;
    }

    @Override
    void allocateArrays(int capacity) {
        super.allocateArrays(capacity);
        this.values = new short[capacity];
    }
}

